<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/fcdtbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="OMA">
		<DataArea>
			
			<!-- Determine which form of the cli was invoked.  This determines the page title. -->
			<xsl:choose>
				<xsl:when test="count(//UserInputError)>0">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="//UserInputError"/></xsl:attribute>
					</PageTitle>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="count(FluidCachedDisks/DCStorageObject)>0">
							
							<PageTitle>
								<xsl:attribute name="display">List of Fluid Cached Disks</xsl:attribute>
							</PageTitle>
						</xsl:when>
						<xsl:otherwise>
							<PageTitle>
								<xsl:attribute name="display">No Fluid Cache Disks found</xsl:attribute>
							</PageTitle>
						</xsl:otherwise>
					</xsl:choose>
					
						<xsl:apply-templates select="FluidCachedDisks"/>
					
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="FluidCachedDisks">
		<TableData>
			
                  <xsl:for-each select="DCStorageObject">    
			<Header>
				<xsl:call-template name="FluidCacheDiskTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</Header>
			
				
				<xsl:call-template name="FluidCacheDiskTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
	</xsl:template>
	
	

	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>