<!-- This is the XSL to render the Controller Information page.  The associated web plugin is the ControllerInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="ctrltbl.xsl"/>

	<xsl:template match="/OMA">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<DataArea>
			<script language="javascript">
				function newSelect(ControllerOID)
				{
					compid = "Controller"+ControllerOID;
					sid = "Properties"+ControllerOID;
					lid = "Information"+ControllerOID;
					parent.ct.select(compid, sid, lid);
				}
		
				function onExecute() 
				{
					var action = document.getElementById("GlobTasks").value;				
					if (action == "-")
					 { 
						alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
        }
        else if(action == '1')
        { // rescan
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ConfirmRescanWebPlugin&amp;Action=globalrescan&amp;help=stprin");
        }
        else if (action == '2')
        { // enable sts
            document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.StorageExecWebPlugin&amp;Action=enableSTS&amp;help=stprin");
        document.dataarea.submit();
        }
        else if (action == '4')
        { // disable sts
            document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.StorageExecWebPlugin&amp;Action=disableSTS&amp;help=stprin");
						document.dataarea.submit();
					}
        else if (action == '8')
        { // set hs protection policy
           
            document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SetHSProtectionPolicyWebplugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.StorageInfoWebPlugin!help=stprin&amp;help=hsppol");
						document.dataarea.submit();
		}
		else if (action == "16")
		{
		    //view physical disk firmware version report
			document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.HDDFirmwareVersionReportWebPlugin&amp;help=hddfirm&amp;ShowTitle=1&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.StorageInfoWebPlugin!help=stprin");                
		}
					
		}
			
			</script>
	
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.StorageInfoWebPlugin&amp;ID=<xsl:value-of select="ID"/>&amp;Name=<xsl:value-of select="Name"/>&amp;Action=blank&amp;help=stprin</xsl:attribute>
				</Data>
			</CustomButton>
			
			<xsl:choose>
				<xsl:when test="count(.//ArrayInfo//Controllers) != '0'">
					<ComboData ignoreJumpBar="true">
						<xsl:call-template name="StorageInfoTable">
							<xsl:with-param name="checkAdmin" select="$checkAdmin"/>
						</xsl:call-template>
						<xsl:call-template name="ControllerTable"/>
					</ComboData>
				</xsl:when>	
				<xsl:otherwise>
					<PromptText><xsl:value-of select="$strNoStorageController"/></PromptText>
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>

	<xsl:template name="StorageInfoTable">
		<xsl:param name="checkAdmin"/>
		<ListData columnspacing="true">
		        <xsl:variable name="stsMode">
		        	<xsl:value-of select="/OMA/STSMode/DCStorageObject/SmartThermalShutdownMode"/>
		        </xsl:variable>

			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strSubHeader1"/></xsl:attribute>
				<xsl:attribute name="status"><xsl:value-of select="/OMA/StorageInfo/DCStorageObject/TreeStatus"/></xsl:attribute>
			</SubHeader>
			<!--
					Following table is used to display Global Tasks. 
					STS mode is shown here
					For reference in ssobjdef.h:
					
					#define STORAGE_GLOBAL_RESCAN                      0x00000001
					#define STORAGE_ENABLE_SMART_THERMAL_SHUTDOWN      0x00000002
					#define STORAGE_DISABLE_SMART_THERMAL_SHUTDOWN     0x00000004				  
			-->
				  
			<xsl:variable name="MasterMask">
				<xsl:value-of select="/OMA/StorageInfo/DCStorageObject/MasterMethodMask"/>
			</xsl:variable>
			<xsl:variable name="CurrentMask">
				<xsl:value-of select="/OMA/StorageInfo/DCStorageObject/CurrentMethodMask"/>
			</xsl:variable>
			<!-- Check that the master method mask has the bits turned on for enable and disable STS. If yes, then show whether it's enabled or disabled. -->
			<xsl:if test="substring($MasterMask,30,1)='1' and substring($MasterMask,31,1)='1' ">
				<Data columnspacing="true" name="STS Mode" editable="false" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strSTSMode"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:if test="substring($CurrentMask,31,1)='1'"><xsl:value-of select="$strDisabled"/></xsl:if>
						<xsl:if test="substring($CurrentMask,30,1)='1'"><xsl:value-of select="$strEnabled"/></xsl:if>
					</xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:variable name="isEmpty">
				<xsl:call-template name="IsMasterMethodMaskEmpty">
					<xsl:with-param name="Mask">
						<xsl:value-of select="MasterMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="isCMMEmpty">
				<xsl:call-template name="IsCurrentMethodMaskEmpty">
					<xsl:with-param name="Mask">
						<xsl:value-of select="/OMA/StorageInfo/DCStorageObject/CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$checkAdmin='true'">				
				<xsl:choose>
					<!--check if current methods are available -->
				<xsl:when test="$isCMMEmpty='0'">
					<Data value="tasks" columnspacing="true" type="select" ignoreoncli="true" splcase="true">
						 <xsl:attribute name="width">width:230px</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strGT"/></xsl:attribute>
						<xsl:attribute name="name">GlobTasks</xsl:attribute>
						<Choice returnvalue="-" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
						</Choice>
						
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="/OMA/StorageInfo/DCStorageObject/CurrentMethodMask"/>
							<xsl:with-param name="templateName" select="15"/>
						</xsl:call-template>
						<Choice returnvalue="16">
							<xsl:attribute name="value"><xsl:value-of select="$strHDDFirmwareVersion"/></xsl:attribute>
						</Choice>
						<ExtraItem type="button">
							<!--xsl:attribute name="display"><xsl:value-of select="$strExecute"/></xsl:attribute-->
							 <!--xsl:attribute name="id"><xsl:value-of select="$strExecute"/><xsl:value-of select="position()"/></xsl:attribute-->
							 <xsl:attribute name="href">javascript:onExecute();</xsl:attribute>
							  <xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="tablebutton">true</xsl:attribute> 
						</ExtraItem>							
					</Data>		
				</xsl:when>
				<xsl:otherwise>
					<!-- current methodmask is empty -->
					<!-- make sure to keep this code even if Master Method Mask is empty. This is a usability requirement-->
					<Data value="tasks" columnspacing="true" type="select" ignoreoncli="true">
						<xsl:attribute name="display"><xsl:value-of select="$strGT"/></xsl:attribute>
						<xsl:attribute name="name">GlobTasks</xsl:attribute>
						<Choice returnvalue="" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
						</Choice>
					</Data>
				</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</ListData>
	</xsl:template>


	<!-- Template to display the controller object -->
	<xsl:template name="ControllerTable">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="(OMAUserRights = '7') or (OMAUserRights = '3')">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="ArrayInfo/Controllers[DCStorageObject/BusProtocol != '9']">
		<TableData columnspacing="true">
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strRAIDControllers"/></xsl:attribute>
			</SubHeader>
			<Header>
				<xsl:call-template name="ControllerTableHeader">
					<xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
					<xsl:with-param name="expanded">true</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:for-each select="ArrayInfo/Controllers/DCStorageObject[BusProtocol != '9']">
				<xsl:sort select="PCISlot"/>
				<xsl:call-template name="ControllerTableRows">
					<xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
					<xsl:with-param name="expanded">true</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
		</xsl:if>
		
		<xsl:if test="ArrayInfo/Controllers[DCStorageObject/BusProtocol = '9']">
		<TableData columnspacing="true">
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strPCIeSSD"/></xsl:attribute>
			</SubHeader>
			<Header>
				<xsl:call-template name="ControllerTableHeader">
					<xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
					<xsl:with-param name="expanded">true</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:for-each select="ArrayInfo/Controllers/DCStorageObject[BusProtocol = '9']">
				<xsl:sort select="PCISlot"/>
				<xsl:call-template name="ControllerTableRows">
					<xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
					<xsl:with-param name="expanded">true</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
		</xsl:if>
             
            <xsl:if test="ArrayInfo/Controllers/DCStorageObject[ObjType = '786']">
              

		<TableData columnspacing="true">
                 
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheComponent"/></xsl:attribute>
			</SubHeader>
			<Header>
            		<Data name="Status" editable="false" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
				</Data>
				
				<Data name="Name" editable="false" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
				</Data>
	                  
					<Data name="SlotID" editable="false" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strSlotID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSlotID"/></xsl:attribute>
					</Data>
				
		
				

			</Header>
                   <xsl:for-each select="ArrayInfo/Controllers/DCStorageObject[ObjType = '786']">
                    <xsl:variable name="ObjID">
		   		 <xsl:call-template name="ModNexus">
					<xsl:with-param name="nexus">
						<xsl:value-of select="Nexus"/>
					</xsl:with-param>
			       </xsl:call-template>
            	  </xsl:variable>

                  <Row>
                       <Data type="status" align="left">
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			    </Data>
			    <Data name="Name" editable="false" type="ustring" display="{Name}" link="true">
				<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
				<xsl:attribute name="href">javascript:newSelect('<xsl:value-of select="$ObjID"/>')</xsl:attribute>
       		    </Data>
                   
                     <Data>
				<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="PCISlot = '-1' or PCISlot = '2147483648' or PCISlot = '0' ">
								<xsl:value-of select="$strEmbedded"/>
							</xsl:when>
							
							<xsl:otherwise>
								<xsl:value-of select="$strNoSlot"/>
							</xsl:otherwise>
						</xsl:choose>
				</xsl:attribute>
			</Data>


                  </Row>
		 </xsl:for-each>
		</TableData>
		</xsl:if>

	</xsl:template>

</xsl:stylesheet>
