<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Controller Property  page.  The associated web plugin is the ChangeControllerWebPlugin.java -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:import href="Utils.xsl"/>
<xsl:variable name="GLOBAL_VAR_Action"><xsl:value-of select="/OMA/Action"/></xsl:variable>
<xsl:variable name="GLOBAL_VAR_EncryptionMode"><xsl:value-of select="/OMA/Controllers/DCStorageObject/SecurityMode"/></xsl:variable>
<xsl:variable name="GLOBAL_VAR_EncryptionKeyScenario"><xsl:call-template name="PageHeadings"></xsl:call-template></xsl:variable>
<xsl:variable name="GLOBAL_VAR_DKMServerConfiguredOrNot"><xsl:value-of select="//KMSConfigured"/></xsl:variable>
<xsl:variable name="GLOBAL_VAR_AttributeMask"><xsl:value-of select="/OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:variable>
<xsl:variable name="GLOBAL_VAR_ControllerDKMCapable">
    <xsl:choose>
        <xsl:when test="substring($GLOBAL_VAR_AttributeMask,3,1)='1'">1</xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<xsl:variable name="GLOBAL_VAR_NO_KEY_DKM_MODE">
    <xsl:choose>
        <xsl:when test="$GLOBAL_VAR_Action != 'DeleteOrChangeSecurityKey' and ($GLOBAL_VAR_EncryptionMode = '2' or $GLOBAL_VAR_EncryptionMode ='1')">1</xsl:when>
        <xsl:when test="$GLOBAL_VAR_Action = 'DeleteOrChangeSecurityKey' and $GLOBAL_VAR_EncryptionMode = '0'">1</xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>    
</xsl:variable>

<!-- check for new bits in attribute mask-->
<xsl:variable name="Var_IsDeleteSecurityKeyEnabled"><xsl:value-of select="/OMA/IsDeleteSecurityKeyEnabled"/></xsl:variable>
	<xsl:template match="OMA">
		<xsl:call-template name="scripts"/>
		<DataArea printable="false" email="false" Refresh="false" exportdata="false" onLoad="true" ignoreJumpBar="true">
              <!--xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
              <xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute-->
 		     <xsl:call-template name="SecurityKeyManagement"/>
                <BottomCustomButton>
		           <Data display="{$strApply}" formSubmit="true" href="javascript:submitChangeOrDeleteOrCreate()" id="submitbuttoncontent"/> 
	            </BottomCustomButton> 
				 <BottomCustomButton>
		           <Data formSubmit="true">
				   <xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				   <xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
		           </Data>
		      </BottomCustomButton>
             <xsl:call-template name="scripts"/> 
             <HiddenTable>
				<Data>
					<xsl:attribute name="name">SASAddress</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
                  <HiddenTable>
				<Data>
					<xsl:attribute name="name">LKMToDKMCurrentKeyIdentifier</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
		<HiddenTable>
				<Data>
					<xsl:attribute name="name">LKMToDKMCurrentPassphrase</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
		<HiddenTable>
				<Data>
					<xsl:attribute name="name">EncryptionKeyScenario</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
		<HiddenTable>
				<Data>
					<xsl:attribute name="name">NewEncryptionMode</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
			<HiddenTable>
				<Data>
					<xsl:attribute name="name">RekeyFlag</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
		</DataArea>
	</xsl:template>
      <xsl:template name="SecurityKeyManagement">
        <xsl:choose>
              <xsl:when test="$GLOBAL_VAR_NO_KEY_DKM_MODE = '1'">
                <PageTitle>
		            <xsl:attribute name="display"><!--xsl:value-of select="$strDeleteTitlePart1"/--><xsl:value-of select="$strInitiateDelTitlePart1"/><xsl:value-of select="/OMA/Controllers/@ControllerName"/><xsl:value-of select="$strDeleteTitlePart2"/></xsl:attribute>
	            </PageTitle>
              </xsl:when> 
              <xsl:when test="$GLOBAL_VAR_Action = 'DeleteOrChangeSecurityKey'">
                <PageTitle>
		            <xsl:attribute name="display"><xsl:value-of select="$strChangeDeleteTitlePart1"/><xsl:value-of select="/OMA/Controllers/@ControllerName"/><xsl:value-of select="$strChangeDeleteTitlePart2"/></xsl:attribute>
	            </PageTitle>
              </xsl:when>
              <xsl:otherwise>
                <PageTitle>
		            <xsl:attribute name="display"><xsl:value-of select="$strCreateTitlePart1"/><xsl:value-of select="/OMA/Controllers/@ControllerName"/><xsl:value-of select="$strCreateTitlePart2"/></xsl:attribute>
                </PageTitle>
              </xsl:otherwise>
              
        </xsl:choose>
		 <xsl:if test="$GLOBAL_VAR_ControllerDKMCapable='1' &amp;&amp; $GLOBAL_VAR_NO_KEY_DKM_MODE = '0'">
                   <xsl:call-template name="SecurityKeyManagementDKMSection"/> 
         </xsl:if>
		 <xsl:if test="$GLOBAL_VAR_ControllerDKMCapable='1' and $GLOBAL_VAR_EncryptionKeyScenario = '5' and $GLOBAL_VAR_EncryptionMode = '2'">
		          <xsl:call-template name="InitiateKeyDKMSection"/> 
		 </xsl:if>
        <xsl:call-template name="SecurityKeyManagementChangeOrDelete"/>
        <script language="javascript">
            var IsSecurityEnabledOnController='<xsl:value-of select="$GLOBAL_VAR_Action"/>';	
      
            function initializationRoutine()
	        {  
					
			       if('<xsl:value-of select="$GLOBAL_VAR_ControllerDKMCapable"/>' == '0')
				   {
				        if(document.getElementById("OperationDKM")!=null)
                               {
                                  document.getElementById("OperationDKM").disabled = true;

                                }
				   }
			
                    if('<xsl:value-of select="$GLOBAL_VAR_NO_KEY_DKM_MODE"/>' =='1')
                    {
                        if(document.getElementById("OperationDelete")!= null)
                         {                      
                              if('<xsl:value-of select="$Var_IsDeleteSecurityKeyEnabled"/>' == '1')
                              {
                                       document.getElementById("OperationDelete").disabled = false;
                              }  
			      else 
			      {
                                      document.getElementById("OperationDelete").disabled = true;
			      }	
                         }  
                       
                   } 
			 
                if(IsSecurityEnabledOnController== 'DeleteOrChangeSecurityKey' || IsSecurityEnabledOnController =='CreateSecurityKey')
                {     
                      if(document.getElementById("OperationChange")!=null)
                      {
                       document.getElementById("OperationChange").checked=false;
                      }
                      if(document.getElementById("Agreement")!=null)
                      {
                       document.getElementById("Agreement").disabled=true;
                       document.getElementById("Agreement").checked=false;   
                      } 
                      
                      if(document.getElementById("SecurityKeyIdentifier")!=null)
                      {
                      document.getElementById("SecurityKeyIdentifier").value ="";
                      document.getElementById("SecurityKeyIdentifier").disabled =true;
                      }

                      if( document.getElementById("Passphrase")!=null)
                      {
                       document.getElementById("Passphrase").value = "";
                       document.getElementById("Passphrase").disabled =true;
                      }
                      if(document.getElementById("ConfirmPassphrase")!= null)
                      {
                       document.getElementById("ConfirmPassphrase").value = "";
                       document.getElementById("ConfirmPassphrase").disabled =true;
                      } 
			    <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario != '3'">
                          if(document.getElementById("CurrentPassphrase")!=null)
                          { document.getElementById("CurrentPassphrase").value = "";
                          document.getElementById("CurrentPassphrase").disabled =true;
                           }
			    </xsl:if>
                      if(document.getElementById("AbsoluteFilePath")!=null)
                      {
                       document.getElementById("AbsoluteFilePath").value = "";
                       document.getElementById("AbsoluteFilePath").disabled =true;
                       document.getElementById("AbsoluteFilePath").checked =false; 
                       }
                      
                       if(document.getElementById("AbsoluteFilePathCheckBox")!=null)
                        {
                         document.getElementById("AbsoluteFilePathCheckBox").disabled =true;
                         }
                      
                }
                else
                {

                    document.getElementById("AbsoluteFilePath").disabled =true;

                }
                if(document.getElementById("OperationDelete")!= null)
                {                      
                      if('<xsl:value-of select="$Var_IsDeleteSecurityKeyEnabled"/>' == '1')
                      {
                               document.getElementById("OperationDelete").disabled = false;
                      }  
			          else 
			          {
                               document.getElementById("OperationDelete").disabled = true;
			          }	

                } 
                 <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario = '0'">
                               document.getElementById("Passphrase").value = "";
			             document.getElementById("Passphrase").disabled=true;
                               document.getElementById("ConfirmPassphrase").value = "";
			             document.getElementById("ConfirmPassphrase").disabled=true;
                               document.getElementById("AbsoluteFilePathCheckBox").disabled =true;
                   		 document.getElementById("AbsoluteFilePath").checked =false;
                               document.getElementById("Agreement").disabled=true;
      	                   document.getElementById("Agreement").checked=false;
	         	             document.getElementById("SecurityKeyIdentifier").value ="";
                  		 document.getElementById("SecurityKeyIdentifier").disabled =true;                       
			   </xsl:if> 
              
      		document.getElementById("dataarea").setAttribute( "autocomplete","off" );
 
            }     
                                
            function validatePassphrase()
            {
             
              var PassphraseGrammar=/^.*(?=.{8,32})(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[&amp;&lt;&gt;&quot;&apos;;:~`!@#$%^*_+=-?.,|\(\){}\\\/\[\]]).*$/;
              
              var SecurityKeyIdentifier=document.getElementById("SecurityKeyIdentifier").value;
              var Passphrase=document.getElementById("Passphrase").value;
              var ConfirmPassphrase=document.getElementById("ConfirmPassphrase").value;
			  var LKMToDKMCurrentKeyIdentifier = document.getElementById("LKMToDKMCurrentKeyIdentifier").value;
			  var LKMToDKMCurrentPassphrase = document.getElementById("LKMToDKMCurrentPassphrase").value;
			  
              if("<xsl:value-of select="//Passphrase"/>" == Passphrase &amp;&amp; Passphrase== ConfirmPassphrase)
              {
                 return true;
              }  
              if(((document.getElementById("OperationChange") != null) &amp;&amp; (document.getElementById("OperationChange").checked == true)) || ((document.getElementById("OperationCreate") != null) &amp;&amp; (document.getElementById("OperationCreate").checked == true)))
              {
                 if(SecurityKeyIdentifier.length == 0)
                  { 
                               alert("<xsl:value-of select="$strBlankSecurityKeyIdentifier"/>");
                               document.getElementById("SecurityKeyIdentifier").value = "";
			             document.getElementById("SecurityKeyIdentifier").focus();
                               return false; 
                  }
				 if(!ValidateFormat(SecurityKeyIdentifier))
                   {           
                               alert("<xsl:value-of select="$strSecurityKeyIDGuidelines"/>");
                               document.getElementById("SecurityKeyIdentifier").value = "";
			                   document.getElementById("SecurityKeyIdentifier").focus();
                               return false; 
                   }
				   
				   
                 if(!ValidateFormat(Passphrase) )
                  {    alert("<xsl:value-of select="$strPassphraseGuidelines"/>");
                       document.getElementById("Passphrase").value = "";
			     document.getElementById("Passphrase").focus();
                       document.getElementById("ConfirmPassphrase").value = "";
                       return false;
                   }
				   
				  		   
                  if(!ValidateFormat(ConfirmPassphrase) )
                  {    
 
					alert("<xsl:value-of select="$strConfirmPassphraseGuidelines"/>");
                       document.getElementById("Passphrase").value = "";
			     document.getElementById("Passphrase").focus();
                       document.getElementById("ConfirmPassphrase").value = "";
                       return false;
                   }                                              
                  
                  if( (Passphrase.length &lt; 8) &amp;&amp; (Passphrase.length &gt; 32) ) 
                  {      
                          if(Passphrase.length ==0)
                          {
                                alert("<xsl:value-of select="$strBlankPassphrase"/>");
                          }
                          else 
                          {
                                alert("<xsl:value-of select="$strLengthPassphrase"/>");
                          }
                         document.getElementById("Passphrase").value = "";
			       document.getElementById("Passphrase").focus();
                        
                         return false;
                  }
                  if(!(PassphraseGrammar.test(Passphrase)))
                  {       alert("<xsl:value-of select="$strPassphraseGuidelines"/>");
                          document.getElementById("Passphrase").value = "";
			              document.getElementById("Passphrase").focus();
                          document.getElementById("ConfirmPassphrase").value = "";
                          return false;
                  }
                  
                  if( (ConfirmPassphrase.length &lt; 8) &amp;&amp; (ConfirmPassphrase.length &gt; 32) )
                  {   
                         if(ConfirmPassphrase.length==0)
                         {
                                alert("<xsl:value-of select="$strBlankConfirmPassphrase"/>");
                         }
                         else
                         {
                               alert("<xsl:value-of select="$strLengthConfirmPassphrase"/>");
                         }
                         document.getElementById("ConfirmPassphrase").value = "";
	 	 	       document.getElementById("ConfirmPassphrase").focus();  
                         return false;
                  }
                  if( !(PassphraseGrammar.test(ConfirmPassphrase)))
                  {       alert("<xsl:value-of select="$strConfirmPassphraseGuidelines"/>");
                          document.getElementById("Passphrase").value = "";
			        document.getElementById("Passphrase").focus();
                          document.getElementById("ConfirmPassphrase").value = "";
			        document.getElementById("ConfirmPassphrase").focus();
                          
                          return false;
                  }
                 if( ConfirmPassphrase!=Passphrase) 
                  {       alert("<xsl:value-of select="$strPassphraseMismatch"/>");
                          document.getElementById("Passphrase").value = "";
			        document.getElementById("Passphrase").focus();
                          document.getElementById("ConfirmPassphrase").value = "";
  			        return false;
                  }
                 if(IsSecurityEnabledOnController != 'CreateSecurityKey') 
                   {
		         <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario != '3'">
                       var CurrentPassphrase=document.getElementById("CurrentPassphrase").value;
                       if( (CurrentPassphrase.length &lt; 8) &amp;&amp; (CurrentPassphrase.length &gt; 32) ) 
                       {       alert("<xsl:value-of select="$strLengthCurrentPassphrase"/>");
                               document.getElementById("Passphrase").value = "";
			             document.getElementById("Passphrase").focus();
                               return false;
                       }
                       if(!(PassphraseGrammar.test(CurrentPassphrase)) || !ValidateFormat(CurrentPassphrase)) 

                       {
						alert("<xsl:value-of select="$strCurrentPassphraseGuidelines"/>");
                                document.getElementById("CurrentPassphrase").value = "";
			              document.getElementById("CurrentPassphrase").focus();
                                return false;
                       }
			   </xsl:if> 	
                   }
			}
 
		     if((document.getElementById("OperationDKM") != null) &amp;&amp; (document.getElementById("OperationDKM").checked == true))
                 {
                 <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario='2'">				 
				  if((LKMToDKMCurrentKeyIdentifier.length == 0))
				  {            
				               alert("<xsl:value-of select="$strBlankSecurityKeyIdentifier"/>");
                               document.getElementById("LKMToDKMCurrentKeyIdentifier").value = "";
			                   document.getElementById("LKMToDKMCurrentKeyIdentifier").focus();
                               return false; 
				  }
				   if(!ValidateFormat(LKMToDKMCurrentKeyIdentifier))
                   {          
                               alert("<xsl:value-of select="$strSecurityKeyIDGuidelines"/>");
                               document.getElementById("LKMToDKMCurrentKeyIdentifier").value = "";
			                   document.getElementById("LKMToDKMCurrentKeyIdentifier").focus();
                               return false; 
                   }
                
                  if(!ValidateFormat(LKMToDKMCurrentPassphrase))
                  {    
				       alert("<xsl:value-of select="$strPassphraseGuidelines"/>");
                       document.getElementById("LKMToDKMCurrentPassphrase").value = "";
			           document.getElementById("LKMToDKMCurrentPassphrase").focus();
                       return false;
                   }
				  if( (LKMToDKMCurrentPassphrase.length &lt; 8) || (LKMToDKMCurrentPassphrase.length &gt; 32) ) 
                  {      
                          if(LKMToDKMCurrentPassphrase.length ==0)
                          {
                                alert("<xsl:value-of select="$strBlankPassphrase"/>");
                          }
                          else 
                          {
                                alert("<xsl:value-of select="$strLengthPassphrase"/>");
                          }
                         document.getElementById("LKMToDKMCurrentPassphrase").value = "";
			             document.getElementById("LKMToDKMCurrentPassphrase").focus();
                        
                         return false;
                  }				  
				   if(!(PassphraseGrammar.test(LKMToDKMCurrentPassphrase)))
                  {       
				          alert("<xsl:value-of select="$strPassphraseGuidelines"/>");
                          document.getElementById("LKMToDKMCurrentPassphrase").value = "";
			              document.getElementById("LKMToDKMCurrentPassphrase").focus();
                          return false;
                  }
                 </xsl:if>				  
				 } 
                 
               
              return true;   

            }
            function submitChangeOrDeleteOrCreate()
            {    
                  if((document.getElementById("OperationCreate")!= null &amp;&amp; document.getElementById("OperationCreate").checked == true)||(document.getElementById("OperationDKM")!= null &amp;&amp; document.getElementById("OperationDKM").checked == true) ||(document.getElementById("OperationDelete")!= null &amp;&amp; document.getElementById("OperationDelete").checked == true) || (document.getElementById("OperationChange")!= null &amp;&amp; document.getElementById("OperationChange").checked == true) || (document.getElementById("OperationInitiate")!= null &amp;&amp; document.getElementById("OperationInitiate").checked == true))
                  {     
                        
                  }
                  else
                  { 
                        alert("<xsl:value-of select="$strSelectOperation"/>");
                         return;
                   } 
                  if(IsSecurityEnabledOnController=='CreateSecurityKey' &amp;&amp; document.getElementById("OperationDelete")==null ){
                           submitCreateSecurityKey(); 
						   return;
						   }
                  if(document.getElementById("OperationDelete")!=null &amp;&amp; document.getElementById("OperationDelete").checked==true){
                           submitDeleteSecurityKey();
						   return;
						   }
                  if(document.getElementById("OperationChange")!=null &amp;&amp; document.getElementById("OperationChange").checked==true){
                           submitChangeSecurityKey();
						   return;
						   }
                  if(document.getElementById("OperationDKM")!=null &amp;&amp; document.getElementById("OperationDKM").checked==true){
				           submitChangeDKMSSecurityKey();
                           return;						   
						   }
				 if(document.getElementById("OperationInitiate")!=null &amp;&amp; document.getElementById("OperationInitiate").checked==true){
				           submitInitiateDKMSSecurityKey();
                           return;						   
						   }		   
 
            }
	    function submitCreateSecurityKey() 
	    {  
		    if(document.getElementById("OperationCreate")!=null &amp;&amp; document.getElementById("OperationCreate").checked==true)
			{ 
                if( validatePassphrase()== false)
                {   
                    return;
                }
                else
                {
				    if(validateAgreement()== false)
                    {  
                        return;
                    }
                    else if(validateFile()== false)
                    {
                        return;
                       
                    } 
				}
				
				document.getElementById("SASAddress").value ='<xsl:value-of select="//SasAddress "/>';
                document.getElementById("NewEncryptionMode").value = 1;
            }
			else
			{	
                document.getElementById("NewEncryptionMode").value = 2;
			}
			
			if(IsSecurityEnabledOnController!= 'CreateSecurityKey')
			{
				document.getElementById("RekeyFlag").value = 2;
			}
				 else
		    {
				   document.getElementById("RekeyFlag").value = 1;
		    }
			document.getElementById("EncryptionKeyScenario").value = '<xsl:value-of select="$GLOBAL_VAR_EncryptionKeyScenario"/>';
            document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;Action=1073741824&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/Controllers/@ControllerName"/>&amp;BackTo=<xsl:value-of select="/OMA/BackTo"/>");
            document.dataarea.submit();
	              
 	   }
       function submitChangeDKMSSecurityKey() 
	    {  
                
			                 
                <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario = '2'"> 
                  if( validatePassphrase()== false)
                  {   
                          return;
                  }
			    </xsl:if>
				var LKMIdentifier = document.getElementById("LKMToDKMCurrentKeyIdentifier").value;
			    var LKMPassphrase = document.getElementById("LKMToDKMCurrentPassphrase").value;
                document.getElementById("NewEncryptionMode").value = 2;				
				document.getElementById("EncryptionKeyScenario").value = '<xsl:value-of select="$GLOBAL_VAR_EncryptionKeyScenario"/>';
				if(IsSecurityEnabledOnController!= 'CreateSecurityKey')
				{
				   document.getElementById("RekeyFlag").value = 2;
				 }
				 else
				 {
				   document.getElementById("RekeyFlag").value = 1;
				 }
		      	document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;Action=1073741824&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/Controllers/@ControllerName"/>&amp;BackTo=<xsl:value-of select="/OMA/BackTo"/>&amp;LKMToDKMCurrentKeyIdentifier="+LKMIdentifier+"&amp;LKMToDKMCurrentPassphrase="+LKMPassphrase);
                document.dataarea.submit();
        }
          function submitDeleteSecurityKey() 
	    {    
                 if(confirm("<xsl:value-of select="$strPrmoptText4"/>") == false)
                 {
				   return;
				 }
				 document.getElementById("SASAddress").value ='<xsl:value-of select="//SasAddress"/>'; 
                 document.getElementById("RekeyFlag").value = 0;				 
                 document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;Action=1073741824&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;BackTo=<xsl:value-of select="/OMA/BackTo"/>");
                 document.dataarea.submit();
                              
 	   }

        function submitChangeSecurityKey() 
	    {    
            if( validatePassphrase()== false)
            {   
                return;
                }
			    if(validateAgreement()== false)
                {  
                          return;
                }
                else if(validateFile()== false)
                {
                               
                          return;
                       
                }
                
            if(confirm("<xsl:value-of select="$strPrmoptText1"/>") ==  true)
            {    
			    document.getElementById("SASAddress").value ='<xsl:value-of select="//SasAddress"/>';  
                document.getElementById("NewEncryptionMode").value = 1;
				document.getElementById("RekeyFlag").value = 2;
				document.getElementById("EncryptionKeyScenario").value = '<xsl:value-of select="$GLOBAL_VAR_EncryptionKeyScenario"/>';
                document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;Action=1073741824&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/Controllers/@ControllerName"/>&amp;BackTo=<xsl:value-of select="/OMA/BackTo"/>");
                document.dataarea.submit();
            }
            else
            {
                return;
            } 
                
        }    
           
        

         function validateAgreement()
         {
              if(document.getElementById("Agreement").checked == false)
               {  
                        alert("<xsl:value-of select="$strAgreementWarning"/>");
                        return false;
               } 
               else{  return true;}
               
        }
        function validateFile()
         {
               if( document.getElementById("AbsoluteFilePathCheckBox")!=null &amp;&amp; document.getElementById("AbsoluteFilePathCheckBox").checked ==false)
               {
                           return true;// no escrow
               } 

               var Filename = document.getElementById("AbsoluteFilePath").value;
               if(Filename=="" || Filename.length==0|| Filename==null)
               {
                  alert("<xsl:value-of select="$strFilePathStringEmpty"/>");
                  return false;
               }
               var indexextension = Filename.lastIndexOf(".");
               var FileExtension = Filename .substring(indexextension,Filename.length);
               
               if(FileExtension == ".xml" || FileExtension == ".XML")
               {  
                        
                        return true;
               } 
               alert("<xsl:value-of select="$strExtensionIsNotXml"/>");
             return false;
        }

        function OnOperationChangeSelected()
        {     var SecurityKeyIdValue = '<xsl:call-template name="ReplaceKey"><xsl:with-param name="KeyId" select="//SecurityKeyId"/></xsl:call-template>';
              document.getElementById("SecurityKeyIdentifier").value =SecurityKeyIdValue;
              document.getElementById("OperationDelete").checked=false;
              document.getElementById("Agreement").disabled=false;
              document.getElementById("Agreement").checked=false;
              document.getElementById("SecurityKeyIdentifier").disabled =false;
              document.getElementById("Passphrase").disabled =false;
              document.getElementById("ConfirmPassphrase").disabled =false;
	        <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario != '3'">
                  document.getElementById("CurrentPassphrase").disabled =false;
		  </xsl:if>
              document.getElementById("AbsoluteFilePath").disabled =true;
              document.getElementById("AbsoluteFilePathCheckBox").disabled =false;
              document.getElementById("AbsoluteFilePathCheckBox").checked =false;
              if(document.getElementById("OperationDKM") != null)
              {
               document.getElementById("OperationDKM").checked=false;
              }
             
              <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario='2'">
              document.getElementById("LKMToDKMCurrentKeyIdentifier").value = "";
              document.getElementById("LKMToDKMCurrentKeyIdentifier").disabled =true;
              document.getElementById("LKMToDKMCurrentPassphrase").value = "";
              document.getElementById("LKMToDKMCurrentPassphrase").disabled =true;
              </xsl:if>

              
        }
        
        function OnOperationDeleteSelected()
        {
               if('<xsl:value-of select="$GLOBAL_VAR_NO_KEY_DKM_MODE"/>' == '1')
                    {
                       return;
                    } 
              
 
              document.getElementById("SecurityKeyIdentifier").value ="";
              document.getElementById("OperationChange").checked=false;
              document.getElementById("Agreement").disabled=true;
              document.getElementById("Agreement").checked=false;
              document.getElementById("SecurityKeyIdentifier").value = "";
              document.getElementById("SecurityKeyIdentifier").disabled =true;
              document.getElementById("Passphrase").value = "";
              document.getElementById("Passphrase").disabled =true;
              document.getElementById("ConfirmPassphrase").value = "";
              document.getElementById("ConfirmPassphrase").disabled =true;
	        <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario != '3'">
                  document.getElementById("CurrentPassphrase").value = "";
                  document.getElementById("CurrentPassphrase").disabled =true;
              </xsl:if>
              document.getElementById("AbsoluteFilePath").value = "";
              document.getElementById("AbsoluteFilePath").disabled =true;
              document.getElementById("AbsoluteFilePathCheckBox").disabled =true;
              document.getElementById("AbsoluteFilePathCheckBox").checked =false;
              if(document.getElementById("OperationDKM") != null)
              {
               document.getElementById("OperationDKM").checked=false;
              }
              
              <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario='2'">
              document.getElementById("LKMToDKMCurrentKeyIdentifier").value = "";
              document.getElementById("LKMToDKMCurrentKeyIdentifier").disabled =true;
              document.getElementById("LKMToDKMCurrentPassphrase").value = "";
              document.getElementById("LKMToDKMCurrentPassphrase").disabled =true;
              </xsl:if>
              
        }
	
		function submitInitiateDKMSSecurityKey()
		{
		       	 document.getElementById("SASAddress").value ='<xsl:value-of select="//SasAddress"/>'; 
				 document.getElementById("NewEncryptionMode").value = 2;
				 document.getElementById("EncryptionKeyScenario").value = '<xsl:value-of select="$GLOBAL_VAR_EncryptionKeyScenario"/>';
		         document.getElementById("RekeyFlag").value = 4;
                 document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;Action=1073741824&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;BackTo=<xsl:value-of select="/OMA/BackTo"/>");
                 document.dataarea.submit();
		}
        function OnOperationCreteSelected()
		{
		      var SecurityKeyIdValue = '<xsl:call-template name="ReplaceKey"><xsl:with-param name="KeyId" select="//SecurityKeyId"/></xsl:call-template>';
              document.getElementById("SecurityKeyIdentifier").value =SecurityKeyIdValue;
              document.getElementById("Agreement").disabled=false;
              document.getElementById("Agreement").checked=false;
              document.getElementById("SecurityKeyIdentifier").disabled =false;
              document.getElementById("Passphrase").disabled =false;
              document.getElementById("ConfirmPassphrase").disabled =false;
              document.getElementById("AbsoluteFilePath").disabled =true;
              document.getElementById("AbsoluteFilePathCheckBox").disabled =false;
              document.getElementById("AbsoluteFilePathCheckBox").checked =false;
              if(document.getElementById("OperationDKM") != null)
              {
               document.getElementById("OperationDKM").checked=false;
              }
              <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario='2'">
              document.getElementById("LKMToDKMCurrentKeyIdentifier").value = "";
              document.getElementById("LKMToDKMCurrentKeyIdentifier").disabled =true;
              document.getElementById("LKMToDKMCurrentPassphrase").value = "";
              document.getElementById("LKMToDKMCurrentPassphrase").disabled =true;
              </xsl:if>


		}
        function OnPathCheckBoxSelected()
        {      
               if(document.getElementById("AbsoluteFilePath")!=null)
               {
                    document.getElementById("AbsoluteFilePath").value ="";
               }
              if(document.getElementById("AbsoluteFilePathCheckBox")!=null &amp;&amp; document.getElementById("AbsoluteFilePathCheckBox").checked == true)
               {
                 
                 document.getElementById("AbsoluteFilePath").disabled=false;
               }
               else
               {
                 
                 document.getElementById("AbsoluteFilePath").disabled=true;
               }
        }
         
        function showPopUp()
		{
		  var prompt = "<xsl:value-of select="$strPrmoptText2"/>";
		  alert(prompt);
	    }
        function OnOperationDKMSelected()
        {
		
		      var SecurityKeyIdValue = '<xsl:call-template name="ReplaceKey"><xsl:with-param name="KeyId" select="//SecurityKeyId"/></xsl:call-template>';
              document.getElementById("SecurityKeyIdentifier").value ="";
              
              document.getElementById("Agreement").disabled=true;
              document.getElementById("Agreement").checked=false;
              document.getElementById("SecurityKeyIdentifier").value = "";
              document.getElementById("SecurityKeyIdentifier").disabled =true;
              document.getElementById("Passphrase").value = "";
              document.getElementById("Passphrase").disabled =true;
			  if(document.getElementById("ConfirmPassphrase") != null)
			  {
                document.getElementById("ConfirmPassphrase").value = "";
                document.getElementById("ConfirmPassphrase").disabled =true;
			  }
			  if(document.getElementById("CurrentPassphrase") != null)
			  {
                 document.getElementById("CurrentPassphrase").value = "";
                 document.getElementById("CurrentPassphrase").disabled =true;
			  } 
              document.getElementById("AbsoluteFilePath").value = "";
              document.getElementById("AbsoluteFilePath").disabled =true;
              document.getElementById("AbsoluteFilePathCheckBox").disabled =true;
              document.getElementById("AbsoluteFilePathCheckBox").checked =false;
			  if(document.getElementById("OperationDelete") != null)
			  {
              document.getElementById("OperationDelete").checked=false;
			  }
			  if(document.getElementById("OperationCreate") != null)
			  {
			    document.getElementById("OperationCreate").checked=false;
			  }	
			  
			  if(document.getElementById("OperationChange") != null)
			  {
			    document.getElementById("OperationChange").checked=false;
              }
			  <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario='2'">
              document.getElementById("LKMToDKMCurrentKeyIdentifier").value = SecurityKeyIdValue;
              document.getElementById("LKMToDKMCurrentKeyIdentifier").disabled =true;
              document.getElementById("LKMToDKMCurrentPassphrase").value = "";
              document.getElementById("LKMToDKMCurrentPassphrase").disabled =false;
              </xsl:if>

        }
   </script>
	</xsl:template>
	<xsl:template name="InitiateKeyDKMSection">
	     <SummaryData ignoreJumpBar="true">
		    <TableData name="T1" ignoreJumpbar="true">
			      <Row>
                         <Data name="OperationInitiate" type="radio" state="0">
                            <xsl:attribute name="value"><xsl:value-of select="$strInitiateKeyExchange"/></xsl:attribute>
                         </Data>
    		     </Row>
			</TableData>
		 </SummaryData>
	</xsl:template>
      <xsl:template name="SecurityKeyManagementChangeOrDelete">
              <SummaryData ignoreJumpBar="true">
                <xsl:if test="$GLOBAL_VAR_NO_KEY_DKM_MODE = '0'">
	          <TableData name="T1" ignoreJumpbar="true">
			           <Header><Data></Data><Data></Data><Data></Data><Data></Data></Header>
                       <xsl:choose>
                            <xsl:when test="Action != 'CreateSecurityKey'">
			         <Row>
                                   <Data name="OperationChange" type="radio" handler="OnOperationChangeSelected()" event="onClick" state="0" width="40%" colspan="2">
                                      <xsl:attribute name="value">
                                       <xsl:choose>
                                         <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='0'"><xsl:value-of select="$strEnableLKM"/></xsl:when>
                                         <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='1'"><xsl:value-of select="$strEnableLKM"/></xsl:when>
                    <!--not applicable--><xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='2'"><xsl:value-of select="$strChangeLKM"/></xsl:when>
                    <!--not applicable--><xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='3'"><xsl:value-of select="$strSwitchToLKM"/></xsl:when>
		    <!--not applicable--><xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='4'"><xsl:value-of select="$strChangeLKM"/></xsl:when>
                                        </xsl:choose>
                                       </xsl:attribute>

                                   </Data>
				   <Data type="icon" align="left" value="/oma/images/information.gif" link="true" width="7%">
							         <xsl:attribute name="href">javascript:showPopUp()</xsl:attribute>
							       </Data>
                                   <Data maxlength="32" size="32" align="left" width="58%"/>
			                    </Row>
						<xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario != '3'">
					        <Row>
							<Data size="1%" align="left"/>
                                  		<Data><xsl:attribute name="value"><xsl:value-of select="$strLabelCurrentPassphrase"/></xsl:attribute></Data>
							<Data size="1%" align="left"/>
                                  		<Data name="CurrentPassphrase" type="password" maxlength="32" size="32" align="left"/>
                                	  </Row>
						</xsl:if>
					   </xsl:when>
                            <xsl:otherwise>
        		        <Row>
                                  <Data name="OperationCreate" type="radio" handler="OnOperationCreteSelected()" event="onClick" state="0" width="40%" colspan="2">
                                     <xsl:attribute name="value">
                                         <xsl:choose>
                                             <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='0'"><xsl:value-of select="$strEnableLKM"/></xsl:when>
                                             <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='1'"><xsl:value-of select="$strEnableLKM"/></xsl:when>
					               <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='2'"><xsl:value-of select="$strChangeLKM"/></xsl:when>
                                             <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='3'"><xsl:value-of select="$strSwitchToLKM"/></xsl:when>
					     <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='4'"><xsl:value-of select="$strChangeLKM"/></xsl:when>
                                         </xsl:choose>
                                     </xsl:attribute>
                                  </Data>
				<Data type="icon" align="left" value="/oma/images/information.gif" link="true" width="7%">
				         <xsl:attribute name="href">javascript:showPopUp()</xsl:attribute>
				</Data>
                                <Data maxlength="32" size="32" align="left" width="58%"/>
                          </Row>
                            </xsl:otherwise>
                        </xsl:choose>					 
                                <Row>
								   <Data size="1%" align="left"/>
                                   <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelNewSecurityKeyIdentifier"/></xsl:attribute></Data>
								   <Data size="1%" align="left"/>
                                   <Data name="SecurityKeyIdentifier" type="editbox" maxlength="32" size="37" align="left"/>
 		                        </Row>
                        
                                <Row>
								   <Data size="1%" align="left"/>
                                   <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelSuggestedPassphrase"/></xsl:attribute></Data>
								   <Data size="1%" align="left"/>
                                   <Data><xsl:attribute name="value"><xsl:value-of select="//Passphrase"/></xsl:attribute></Data>
                                </Row>
                        
                                <Row>
								   <Data size="1%" align="left"/>
                                   <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelNewPassphrase"/></xsl:attribute></Data>
								   <Data size="1%" align="left"/>
                                   <Data name="Passphrase" type="password" maxlength="32" size="32" align="left"/>
                                </Row>
                                <Row>
                                  <Data size="1%" align="left"/>
                                  <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelConfirmNewPassphrase"/></xsl:attribute></Data>
								  <Data size="1%" align="left"/>
                                  <Data name="ConfirmPassphrase" type="password" maxlength="32" size="32" align="left"/>
                                </Row>
                                <Row>
                                  <Data type="checkbox" colspan="3" handler="javascript:OnPathCheckBoxSelected()" event="onclick" state="0">
		   	                         <xsl:attribute name="name">AbsoluteFilePathCheckBox</xsl:attribute>
			                         <xsl:attribute name="value"><xsl:value-of select="$strAbsoluteFilePath"/></xsl:attribute>
                                     <xsl:attribute name="returnvalue"/>
                                  </Data>
								  <Data name="AbsoluteFilePath" type="editbox" maxlength="32" size="37" align="left"/>
                                </Row>
                                <Row>
                                  <Data type="checkbox" colspan="4">
		   	                          <xsl:attribute name="name">Agreement</xsl:attribute>
			                          <xsl:attribute name="value"><xsl:value-of select="$strPrmoptText3"/></xsl:attribute>
                                      <xsl:attribute name="returnvalue"/>
                                  </Data>
                                </Row>
                </TableData>
                </xsl:if>
                <xsl:if test="Action != 'CreateSecurityKey' or  $GLOBAL_VAR_NO_KEY_DKM_MODE = '1'">
             
                <TableData name="T3" ignoreJumpBar="true">
                     
                        <Row>
                         <Data name="OperationDelete" type="radio" handler="OnOperationDeleteSelected()" event="onClick" state="0">
                            <xsl:attribute name="value"><xsl:value-of select="$strLabelDeleteSecurityKey"/></xsl:attribute>
                         </Data>
    		            </Row>
                </TableData>
			</xsl:if>	
      </SummaryData>
</xsl:template>
<xsl:template name="SecurityKeyManagementDKMSection">
    <SummaryData ignoreJumpBar="true">
	  <TableData name="T4" ignoreJumpbar="true">
         <Row>
            <Data name="OperationDKM" type="radio" handler="OnOperationDKMSelected()" event="onClick" state="0" width="40%" colspan="2">
            <xsl:attribute name="value">
            <xsl:choose>
                <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='1'"><xsl:value-of select="$strEnableDKM"/></xsl:when>
	            <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='2'"><xsl:value-of select="$strSwitchToDKM"/></xsl:when>
		        <xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='3'"><xsl:value-of select="$strChangeDKM"/></xsl:when>
            </xsl:choose>
            </xsl:attribute>
            </Data>
		    <xsl:choose>
			<xsl:when test="$GLOBAL_VAR_EncryptionKeyScenario='2'">
		        <Data type="icon" align="left" value="/oma/images/information.gif" link="true" width="7%">
                       <xsl:attribute name="href">javascript:showPopUp()</xsl:attribute>
			    </Data>
			</xsl:when>
			<xsl:otherwise>
			    <Data type="icon" align="left" value="/oma/images/blank.gif" width="7%"></Data>
			</xsl:otherwise>
			</xsl:choose>
            <Data maxlength="32" size="32" align="left" width="78%"/>
	     </Row>
	     <Row>     
		    <Data size="1%" align="left"/>
			<Data>
			  <xsl:attribute name="value"><xsl:value-of select="$strDKMServer"/></xsl:attribute>
			</Data>
 <!-- Comment this for the time being till we get KMS configured tag -->
  			<!--Data size="1%" align="left"/>
			<Data name="DKMServer" align="left">
			   <xsl:attribute name="value">
			     <xsl:choose>
			       <xsl:when test="$GLOBAL_VAR_DKMServerConfiguredOrNot = '1'">
			          <xsl:value-of select="$strConfigured"/>
				   </xsl:when>
                   <xsl:otherwise>
				      <xsl:value-of select="$strNotConfigured"/>
                   </xsl:otherwise>
                 </xsl:choose>				 
			   </xsl:attribute>
			</Data-->
			<Data size="1%" align="left"/>
			<Data maxlength="32" size="32" align="left"/>
         </Row>
         <xsl:if test="$GLOBAL_VAR_EncryptionKeyScenario='2'">
		 <Row>
		     <Data size="1%" align="left"/>
             <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelLKMToDKMSecurityKeyIdentifier"/></xsl:attribute></Data>
		     <Data size="1%" align="left"/>
             <Data name="LKMToDKMCurrentKeyIdentifier" type="editbox" maxlength="32" size="37" align="left"/>
          </Row>
          <Row>
			 <Data size="1%" align="left"/>
	         <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelLKMToDKMCurrentPassphrase"/></xsl:attribute></Data>
		     <Data size="1%" align="left"/>
		     <Data name="LKMToDKMCurrentPassphrase" type="password" maxlength="32" size="32" align="left"/>
          </Row>
          </xsl:if>
      </TableData>
                	
      </SummaryData>
</xsl:template>



<xsl:template name="PageHeadings">
    <xsl:variable name="KeyPresent"><!-- KeyPresent =1,Key not present =0 --> 
       <xsl:choose>
           <xsl:when test="$GLOBAL_VAR_Action='CreateSecurityKey'">0</xsl:when>
           <xsl:otherwise>1</xsl:otherwise>
       </xsl:choose>
    </xsl:variable> 
    
    <xsl:variable name="Mode">  <!-- DKM=2,LKM=1, None=0 --> 
      <xsl:choose>
           <xsl:when test="$GLOBAL_VAR_EncryptionMode='1'">1</xsl:when><!-- LKM-->  
           <xsl:when test="$GLOBAL_VAR_EncryptionMode='2'">2</xsl:when><!--DKM--> 
           <xsl:otherwise>0</xsl:otherwise><!--none-->
      </xsl:choose>
    </xsl:variable> 
	
	<xsl:message> KeyPresent=[<xsl:value-of select="$KeyPresent"/>]</xsl:message>
	<xsl:message> Mode=[<xsl:value-of select="$Mode"/>]</xsl:message>
	<xsl:message> GLOBAL_VAR_ControllerDKMCapable=[<xsl:value-of select="$GLOBAL_VAR_ControllerDKMCapable"/>]</xsl:message>
    <xsl:choose>   
         <xsl:when test="$GLOBAL_VAR_ControllerDKMCapable='0' and $KeyPresent='0'">0</xsl:when> <!-- Enable LKM,No DKM --> 
         <xsl:when test="$GLOBAL_VAR_ControllerDKMCapable='0' and $KeyPresent='1'">4</xsl:when> <!-- Change LKM,No DKM --> 
         <xsl:when test="$Mode='0' and $KeyPresent='0' and $GLOBAL_VAR_ControllerDKMCapable='1'">1<!-- 1  Enable LKM,Enable DKM--></xsl:when>
         <xsl:when test="$Mode='1' and $KeyPresent='1' and $GLOBAL_VAR_ControllerDKMCapable='1'">2<!-- 2  Rekey LKM, Enable DKM--></xsl:when>
         <xsl:when test="$Mode='2' and $KeyPresent='1' and $GLOBAL_VAR_ControllerDKMCapable='1'">3<!-- 3  Rekey DKM, Enable LKM--></xsl:when>
		 <xsl:when test="$Mode='2' and $KeyPresent='0' and $GLOBAL_VAR_ControllerDKMCapable='1'">5<!-- 3  Rekey DKM, Enable LKM--></xsl:when>
    </xsl:choose>
</xsl:template>


</xsl:stylesheet>







