<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<xsl:key name="ADsForCandidate" match="//ArrayDisks" use="@CandidateName"/>
	<xsl:key name="ADsForChannel" match="//ArrayDisks" use="@EnclosureName"/>
	<!--main entry point into this XSL, this XSL is loaded three times by the webplugin containing this XSL /-->
	<xsl:template match="/">   
		<xsl:choose>
			<xsl:when test="//Table='Selection'">
				<!--the template below is applied the when the webplugin containing this XSL is loaded for the second time /-->
				<!--the template below renders the selection data in the selection table/-->
				<xsl:call-template name="SelectionData"/>
			</xsl:when>
			<xsl:when test="//Table='Result'">
				<!--the template below is applied the when the webplugin containing this XSL is loaded for the third time /-->
				<!--the template below renders the result data in the result table/-->
				<xsl:call-template name="ResultData"/>
			</xsl:when>
			<xsl:otherwise>
				<!--the template below is applied the when the webplugin containing this XSL is loaded for the first time /-->
				<!-- But wait! Must do some error checking. If there's a problem render error frame. -->
				<xsl:choose>
					<xsl:when test="/OMA/GetCapsResp/DCStorageObject">
						<xsl:choose>
							<xsl:when test="/OMA/GetCapsResp/DCStorageObject/MinDisksAdded &lt;=  /OMA/GetCapsResp/DCStorageObject/MaxDisksAdded">
								<!-- No errors, rendor main frame -->
								<xsl:call-template name="RenderMainFrame"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="RenderErrorFrame"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
                              <xsl:when test="//ManageSSC = '1'">
								<!-- No errors, rendor main frame -->
                                                <xsl:choose>
                                                   <xsl:when test="count(//ArrayDisks[@EnclosureName]//DCStorageObject) = 1 and  count(//ArrayDisks[@LDN]//DCStorageObject)= 1">  
								     <xsl:call-template name="RenderErrorFrame"/>
                                                   </xsl:when>
                                                   <xsl:otherwise>
						                 <xsl:call-template name="RenderMainFrame"/>
					                     </xsl:otherwise>
				                        </xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="RenderErrorFrame"/>
					</xsl:otherwise>
				</xsl:choose>	
			</xsl:otherwise>		
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="RenderErrorFrame">
		<!--Error page -->
		<DataArea validate="false" Refresh="false">
		
			<AlertMessage alert="true" status="4">
				<xsl:attribute name="display"><xsl:value-of select="//VirtualDisks/DCStorageObject/Name"/> <xsl:choose><xsl:when test="//ManageSSC = '1'"><xsl:value-of select="$strResizeErr"/></xsl:when><xsl:otherwise><xsl:value-of select="$strReconfigureErr"/></xsl:otherwise></xsl:choose> </xsl:attribute>
			</AlertMessage>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strNoReconfig"/></xsl:attribute>
			</SubHeader>

			<ListData>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason2"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason3"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason4"/></xsl:attribute>
				</Data>
			</ListData>
			
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=blank&amp;help=vdprin&amp;ManageSSC=<xsl:value-of select="//ManageSSC"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
	
	
	<xsl:template name="RenderMainFrame">
		<!--the code below is rendered first/-->
		<!--Contains code to render the Data Area minus the Selection and Result Table/-->
		<DataArea exportdata="false" printable="false" email="false">
			<!--xsl:attribute name="submit">javascript:submitReconfigureVD()</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strContinue"/></xsl:attribute-->
			
			<xsl:variable name="isAdaptec">
		   	<xsl:choose>					
			   	<xsl:when test="/OMA/GetCapsResp/DCStorageObject/ReConfigDiskDelFlag">1</xsl:when>
			   	<xsl:otherwise>0</xsl:otherwise>	   		   	
			   </xsl:choose>
		   </xsl:variable>
			
			<xsl:variable name="isVDOCEPossible">
		   	   <xsl:choose>					
			   	<xsl:when test="/OMA/GetCapsResp/DCStorageObject/IsVDOCEPossible">1</xsl:when>
			   	<xsl:otherwise>0</xsl:otherwise>	   		   	
			   </xsl:choose>
		      </xsl:variable>

			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
			</script>
	   
			<script language="javascript">			
			
				
			   function isValidNumDisks(num, numdisksinVD, expandcapacity)
			   {
			   	  // mindisk is the min amount of disk that you must add.
                                     var mindisk =0;
                                    <xsl:if test="//GetCapsResp/DCStorageObject/MinDisksAdded">
			   	     mindisk = <xsl:value-of select="//GetCapsResp/DCStorageObject/MinDisksAdded"/>;
                                    </xsl:if>

						// Checks if there are no disks at all in result table OR
						// if there are no additional disks added and you must add at least one disk
					  if( (num == 0) || ( ( (num - numdisksinVD) == 0) &amp;&amp; mindisk &gt; 0 &amp;&amp; !expandcapacity) )
					  {
					    	// Must select at least one disk
					    	alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strAddDisk"/>");					     
					  		return false;					  	
						}
						else
						{							
							
							// max disks possible in VD
                                                        var maxdisk =1;
                                                        <xsl:if test="//GetCapsResp/DCStorageObject/MaxDisksAdded">
							 maxdisk = <xsl:value-of select="//GetCapsResp/DCStorageObject/MaxDisksAdded"/>;				
							</xsl:if>
							var allowedmax = maxdisk - numdisksinVD;
							var newlyaddeddisks = num - numdisksinVD;
														
							// Check if selected disk is greater then the allowed
							if(newlyaddeddisks &gt; allowedmax)
							{
								alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strDiskAdded"/> " + newlyaddeddisks + "\n<xsl:value-of select="$strMaxAllowed"/> " + allowedmax);
								return false;
							}

						}
				     return true;			  
				}
				
				function submitReconfigureVD(expandcapacity)
				{
					var numDisks = frames["RESULT_TABLE"].getSelectedArrayDisksObjIDsArray().length;
					var IDList = frames["RESULT_TABLE"].getSelectedArrayDisksObjIDs();
                                        <xsl:if test="//ManageSSC = '1'">
                                            var OldIDList = new Array();
                                            var IDListArray = new Array();
                                             IDListArray= IDList.split(":");
                                             var MaxDisksAllowedInSSC = 32;
                                             if(IDListArray.length &gt; MaxDisksAllowedInSSC)
                                             {  
                                                alert("<xsl:value-of select="$strMaxAllowedSSC"/>"+MaxDisksAllowedInSSC );
                                                return;
                                             }
                                            var num =0;
                                            <xsl:for-each select="//ArrayDisks[@LDN]/DCStorageObject">
                                                OldIDList[num++] = '<xsl:value-of select="ObjID"/>'; 
                                            </xsl:for-each>
                                            
                                            var noPrevDisk=0;
                                            for( var i=0;i&lt;OldIDList.length;i++)
                                            {
                                              for(var j=0;j&lt;IDListArray.length;j++)
                                              {
                                                if(OldIDList[i]== IDListArray[j])
                                                {
                                                   noPrevDisk++;
                                                }
                                              }
                                            }  
                                            if ((OldIDList.length ==noPrevDisk ) &amp;&amp; (IDListArray.length==noPrevDisk))
                                            {
                                               alert("<xsl:value-of select="$strNoChange"/>");
                                              return;
                                            }
                                           if(noPrevDisk == 0)
                                           {
                                             alert("<xsl:value-of select="$strNoOldDisk"/>");
                                             return;
                                           }
                                        </xsl:if>
					var rulesVal = "";
					
                                        // number of disks in the VD minus DHS					
                                        var numdisksinVD = <xsl:value-of select="count(//ArrayDisks[@LDN]/DCStorageObject/AttributesMask[substring(.,24,1)='0'])" />;

					var isReallyAdaptec = "<xsl:value-of select="$isAdaptec"/>";
					var isReallyVDOCEPossible = "<xsl:value-of select="$isVDOCEPossible"/>";
					var numNewDisk = numDisks - numdisksinVD;
					<xsl:if test="//ManageSSC != '1'">
					if(isValidNumDisks(numDisks, numdisksinVD, expandcapacity))
					{				
						if((numNewDisk &gt; 0) || (isReallyAdaptec == 1))
                                    {
							if (expandcapacity)
							{
								//If disk is selected then expand capacity is not applicable
								alert("<xsl:value-of select="$strExpCapNotApplicable"/>");
								return;
							}
							else
							{	
                                                                //If adaptec or if disks were added.
                                                                rulesVal="4";
                                           }
        					}
                                    else
                                    {
							if (expandcapacity &amp;&amp; isReallyVDOCEPossible == 1)
							{
        							// no disks were added, and not adaptec, VDOCEP possible and user has clicked on it.
        							rulesVal="6";
							}
							else 
							{
        							// no disks were added, and not adaptec and user not clicked on VDOCE.
                                                                rulesVal="5"; 
                                                  
                                          }
                                        
        					 }
							
					      var PDsel = frames["SELECTION_TABLE"].getSelectedPDInfo(IDList);
        					if(frames["SELECTION_TABLE"].getPowerStateCount(IDList))
		        			{
                                                    alert("<xsl:value-of select="$strDataWarningLevel3"/>" + "\n" +PDsel);
					       }
                                            
                                            
                                     }
                                     else
                                     {
                                        return;
                                     }
                                     </xsl:if>    
                                     <xsl:choose>
                                                 <xsl:when test="//ManageSSC = '1'">
                                                     document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.SubmitReconfigureVDSummaryWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Length=<xsl:value-of select="/OMA/Length"/>&amp;IDList="+IDList+"&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;URL=<xsl:value-of select="//BackTo"/>&amp;ManageSSC=<xsl:value-of select="//ManageSSC"/>");        
                                                     document.dataarea.submit();
                                                </xsl:when>
                                                <xsl:otherwise>
                                                     document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDSizeWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VDName=<xsl:value-of select="//VirtualDisks/DCStorageObject/Name"/>&amp;VDiskName=<xsl:value-of select="//VDiskName"/>&amp;VDeviceName=<xsl:value-of select="//DeviceName"/>&amp;IDList="+IDList+"&amp;Rules="+rulesVal+"&amp;ExpandCapacity="+expandcapacity+"&amp;help=vdtkrcn2");
                                                </xsl:otherwise>
                                             </xsl:choose>
				}
			</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:choose><xsl:when test="//ManageSSC = '1'"><xsl:value-of select="$strResizeEC"/></xsl:when><xsl:otherwise><xsl:value-of select="$strReconfigure"/></xsl:otherwise></xsl:choose><xsl:value-of select="//VirtualDisks/DCStorageObject/Name"/><xsl:value-of select="$strSpace"/><xsl:if test="//ManageSSC!='1'"><xsl:value-of select="$strStep1"/></xsl:if></xsl:attribute>
			</PageTitle>
			
				<PromptText><xsl:choose><xsl:when test="//ManageSSC = '1'"><xsl:value-of select="$strSubTitleEC"/></xsl:when><xsl:otherwise><xsl:value-of select="$strSubTitleVD"/></xsl:otherwise></xsl:choose></PromptText>
				<xsl:if test="$isVDOCEPossible = 1 and //ManageSSC != '1'">
					<PromptText><xsl:value-of select="$strExpandCapacityDescription"/></PromptText>
				</xsl:if>
			
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;help=vdtkrcn1</xsl:attribute>
				</Data>
			</CustomButton>
			<BottomCustomButton>
				<Data formSubmit="true" id="submitbuttoncontent">
					<xsl:attribute name="name">contdbutton</xsl:attribute>
					<xsl:attribute name="href">javascript:submitReconfigureVD(false)</xsl:attribute>
					<xsl:attribute name="display"><xsl:choose><xsl:when test="//ManageSSC = '1'"><xsl:value-of select="$strFinish"/></xsl:when><xsl:otherwise><xsl:value-of select="$strContinue"/></xsl:otherwise></xsl:choose></xsl:attribute>
				</Data>
			</BottomCustomButton>

			
			<xsl:if test="$isVDOCEPossible = 1 and //ManageSSC != '1'">
				<BottomCustomButton>
					<Data formSubmit="true">
						<xsl:attribute name="name">expcapbutton</xsl:attribute>
						<xsl:attribute name="href">javascript:submitReconfigureVD(true)</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strExpandCapacity"/></xsl:attribute>
					</Data>
				</BottomCustomButton>
			</xsl:if>	
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=blank&amp;help=vdprin&amp;ManageSSC=<xsl:value-of select="//ManageSSC"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
			<SelectionDataUI>
				<SelectionTableUI id="SELECTION_TABLE" height="95%" width="90%">
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;Table=Selection&amp;ManageSSC=<xsl:value-of select="/OMA/ManageSSC"/></xsl:attribute>
				</SelectionTableUI>
				<ResultTableUI id="RESULT_TABLE" height="95%" width="90%">
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;Table=Result&amp;ManageSSC=<xsl:value-of select="/OMA/ManageSSC"/></xsl:attribute>
				</ResultTableUI>
			</SelectionDataUI>
		</DataArea>
	</xsl:template>
	<!--**************************************************************************Code for Selection Table/**************************************************************************************************************************-->
	<xsl:template name="SelectionData">	
		<!--the code below is rendered second/-->
		<DataArea printable="false" email="false" exportdata="false" onLoad="true" nographics="true">
		
			<xsl:variable name="isAdaptec">
		   	<xsl:choose>					
			   	<xsl:when test="/OMA/GetCapsResp/DCStorageObject/ReConfigDiskDelFlag">1</xsl:when>
			   	<xsl:otherwise>0</xsl:otherwise>	   		   	
			   </xsl:choose>
		   </xsl:variable>
               
		 
 
		   	
		   
			<script language="javascript">

			var JS_GLOBAL_MaxNumEnclosures = 4;

			<!--This routine is called when the page is first loaded-->			
			function initializationRoutine()
			{     
				<!--this function is called when the Selection table page is first loaded/-->
				hideSelectionTable();
				
				<!--get the first channel that has enclosure attached to it-->
				var channelNum = getDefaultChannelSelectionRadioButtonIndex();
				
				<!--show selection table with array disks attached to default channel identified-->
				if(channelNum!=-1)
					showSelectionTable(channelNum);
				
				<!--Below set the default channel selection radio button-->
				setDefaultChannelSelectionRadioButton();
				
				<!--Below disable the Channel radio buttons that do not contain ArrayDisks-->
				disableChannelSelectionRadioButtonsWithNoArrayDisks();
				
				CheckAndDisableAdisksOfVdisk();
			}
			<!--This function returns the index of the default channel selected from the array of channels-->
			function getDefaultChannelSelectionRadioButtonIndex()
			{
				var RadioArray = document.getElementsByName("Channel");
				for(var i=0;i&lt;RadioArray.length;i++)
				{			
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
						if(document.getElementById(elemName) != null)
						{
							return i;
						}
					}
				}
				return -1;<!--failure-->
			}
			
			<!--This function selects and sets the default channel-->
			function setDefaultChannelSelectionRadioButton()
			{
				var found=false;
				var RadioArray = document.getElementsByName("Channel");

				for(var i=0;i&lt;RadioArray.length;i++)
				{
					if(found == false)
					{
						for(var e=0;e&lt;RadioArray.length;e++)
						{							
							var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
							if(document.getElementById(elemName) != null)
							{							
								RadioArray[i].checked=true;
								found=true;
								break;
							}
						}
					}
					else
					{
						break;
					}
				}
			}
			<!--This function disables the channel radio buttons that do not have any array disks attached-->
			function disableChannelSelectionRadioButtonsWithNoArrayDisks()
			{
				var RadioArray = document.getElementsByName("Channel");
				var numTargets = 32;

				for(var i=0;i&lt;RadioArray.length;i++)
				{
					var ArrayDisks = 0;
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{     
                                   for(var k=0;k&lt;numTargets;k++)
                                    {
						var elemName="parentrow_"+"Sel"+i.toString()+e.toString()+k.toString();
						if(document.getElementById(elemName) != null)
						{
							ArrayDisks = 1;
						}
                                    }                                   
					}
					if (ArrayDisks == 0)
					{
						RadioArray[i].disabled=true;
					}
				}
			}
			<!--This function hides all the rows in the selection table-->
			function hideSelectionTable()
			{				
				var numChannels=4;
				var numTargets = 32;
				var elemName=""
				for(var i=0;i&lt;numChannels;i++)
				{
					if(document.getElementById("parentrow_"+"Sel"+i.toString())!=null)
					{
						document.getElementById("parentrow_"+"Sel"+i.toString()).style.display="none";
					}
					
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
					
						elemName = "parentrow_"+"Sel"+i.toString()+e.toString();
						if(document.getElementById(elemName) != null)
						{
							document.getElementById(elemName).style.display="none"
						}

 						for(var j=0;j&lt;numTargets;j++)
						{
							elemName = "parentrow_"+"Sel"+i.toString()+e.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none"
							}
						}						
					}	
				}
			}
			<!--This funtion displays all the rows associated with channel 'i'-->
			function showSelectionTable(i)
			{
				var numTargets=32;
				var elemName;
				for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
				{
					for(var j=0;j&lt;numTargets;j++)
					{					
						elemName="parentrow_"+"Sel"+i.toString()+e.toString()+j.toString();
						if(document.getElementById(elemName) != null)
						{
							document.getElementById("parentrow_"+"Sel"+i.toString()+e.toString()).style.display="";
							document.getElementById("parentrow_"+"Sel"+i.toString()+e.toString()+j.toString()).style.display="";
						}
					}
				}
			}
			<!--This function is a handler that is called in response to a channel selection-->
			function OnChannelSelected()
			{
				hideSelectionTable();
				var RadioArray = document.getElementsByName("Channel");
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					if(RadioArray [i].checked)
					{
						showSelectionTable(i);
						break;
					}
				}
			}
			<!--This function disables all array disk selection check boxes-->
			function disableAllCheckBoxes()
			{
				var numChannels=4;
				var numTargets = 32;
				var elemName="";
				for(var i=0;i&lt;numChannels;i++)
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						for(var j=0;j&lt;numTargets;j++)
						{
							elemName="Sel"+i.toString()+":"+e.toString()+":"+j.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).disabled=true;
							}
						}
					}
				}
			}
			<!--This function enables all array disk selection check boxes-->
			function enableAllCheckBoxes()
			{
				var numChannels=4;
				var numTargets = 32;
				var elemName="";
				for(var i=0;i&lt;numChannels;i++)
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						for(var j=0;j&lt;numTargets;j++)
						{
							elemName="Sel"+i.toString()+":"+e.toString()+":"+j.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).disabled=false;
							}
						}
					}
				}
			}
			
			<!--This function returns the count of selected array disks-->
			function GetSelectedArrayDisksCount()
			{
				var numChannels=4;
				var numTargets = 32;
				var count=0;
				var chkBxName="";
				for(var i=0;i&lt;numChannels;i++)
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						for(var j=0;j&lt;numTargets;j++)
						{
							chkBxName="Sel"+i.toString()+":"+e.toString()+":"+j.toString();
							if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).checked==true)
							{
								count=count+1;
							}
						}
					}
				}	
				return count;		
			}
			<!--This function checks and disables disks of vdisk automatically-->
			function CheckAndDisableAdisksOfVdisk()
			{

				var numChannels=4;
				var numTargets = 32;
				var chkBxName;
				
				var isReallyAdaptec = "<xsl:value-of select="$isAdaptec"/>";
                                var ManageSSC = "<xsl:value-of select="//ManageSSC"/>";
				
				for(var i=0;i&lt;numChannels;i++)
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						for(var j=0;j&lt;numTargets;j++)
						{
							chkBxName="adisk"+i.toString()+e.toString()+j.toString();
							if(document.getElementById(chkBxName) != null )
							{
								var str="Sel"+i.toString()+":"+e.toString()+ ":"+ j.toString();

								document.getElementById(str).checked=true;
								
								<!--
								if(isReallyAdaptec == 0)
								{	
                                                                
                                                                
                -->					        document.getElementById(str).disabled=true;
                                                                if(ManageSSC == 1)
                                                                {
                                                                   document.getElementById(str).disabled=false;
                                                                }
                                                              
								<!--}-->
							}
						}
					}
				}
			}
			<!--This function is an handler that is called whenever an array disk is selected in the selection table-->
			function OnArrayDiskSelected(channel,encl, target)
			{
				var chkBxName = "Sel" + channel+":"+encl+":"+target;
				parent.frames["RESULT_TABLE"].hideResultTable();
				parent.frames["RESULT_TABLE"].showResultTable();				
			}
			function getPowerStateCount(IDList)
			{
					var elemName="";
					var pdstateflag =false;
					var ObjIDArray = IDList.split(":");
					for(var i=0; i&lt;ObjIDArray.length; i++)
					{
						elemName = "PDPower"+ObjIDArray[i];
						if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).value == 1)
						{
						    pdstateflag = true;	
						}
					}

					return pdstateflag;
			}
			function getSelectedPDInfo(IDList)
			{  
				   var elemName = "";
				   var ObjIDArray = IDList.split(":");
				   var counter =0;
				   var resval="";
				   var displayString="";
				   var powerstate="";
				   for(var i=0; i&lt;ObjIDArray.length; i++)
					{
					   elemName = "OBJID"+ObjIDArray[i];
					   powerstate = "PDPower"+ObjIDArray[i];
					   if(document.getElementById(powerstate) != null &amp;&amp; document.getElementById(powerstate).value == 1)
					   {
					      resval = document.getElementById(elemName).value;
					      if(counter == 0)
					      {
							displayString = resval;
					      }
						  else
					      {
					    	displayString = displayString + ", "+resval;
					      }
					      counter++;
					  } 
					}
					return displayString;
    		}
				
		</script>
			
			<SelectionData>
				<SelectionTable>
					<Header>
						<xsl:for-each select="//Channels/DCStorageObject">
							<xsl:sort select="Channel" data-type="number" order="ascending"/>
							<xsl:call-template name="RenderChannelSelectionRadioButtons"/>
						</xsl:for-each>
					</Header>
					
					<xsl:for-each select="//ArrayDisks[@EnclosureName]">
						<xsl:if test="count(DCStorageObject)!=0 ">						
						 	<xsl:choose>
								<xsl:when test="DCStorageObject/EnclosureID"> <!-- SAS or SATA -->
									<xsl:message>reconfig: Sel<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/> targetid <xsl:value-of select="DCStorageObject/TargetID"/> enclosurename is - <xsl:value-of select="@EnclosureName"/> </xsl:message> 
									<xsl:call-template name="RenderSelectionTableParentRow">
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME">
											<xsl:call-template name="GetEnclosureDisplayName">
												<xsl:with-param name="EnclosureType" select="@EnclosureType"/>
                                                                        <xsl:with-param name="productid" select="@ProductID"/>
                                                                        
                                                                           
												<xsl:with-param name="Channel" select="DCStorageObject/Channel"/>
												<xsl:with-param name="EnclosureID" select="DCStorageObject/EnclosureID"/>
												<xsl:with-param name="SAS">True</xsl:with-param></xsl:call-template></xsl:with-param>
										<xsl:with-param name="RULES"><xsl:value-of select="//Rules"/></xsl:with-param>
										<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
										<xsl:with-param name="KEY_MATCH"><xsl:value-of select="@EnclosureName"/></xsl:with-param>
										<xsl:with-param name="DISPLAY_ZERO_FREESPACE_AD">1</xsl:with-param>
										<xsl:with-param name="HIDE_DHS">1</xsl:with-param>
										<xsl:with-param name="ALLDISKS">1</xsl:with-param>
									</xsl:call-template>								
								</xsl:when>
								<xsl:otherwise> <!-- non SAS -->
									<xsl:message>non sas</xsl:message>
									<xsl:call-template name="RenderSelectionTableParentRow">
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/>0</xsl:with-param>									
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME">
											<xsl:call-template name="GetEnclosureDisplayName">
												<xsl:with-param name="EnclosureType" select="@EnclosureType"/><xsl:with-param name="productid" select="@ProductID"/>
												<xsl:with-param name="Channel" select="DCStorageObject/Channel"/>
												<xsl:with-param name="EnclosureID">NULL</xsl:with-param>
												<xsl:with-param name="SAS">NULL</xsl:with-param></xsl:call-template></xsl:with-param>
										<xsl:with-param name="RULES"><xsl:value-of select="//Rules"/></xsl:with-param>
										<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
										<xsl:with-param name="KEY_MATCH"><xsl:value-of select="@EnclosureName"/></xsl:with-param>
										<xsl:with-param name="DISPLAY_ZERO_FREESPACE_AD">1</xsl:with-param>
										<xsl:with-param name="HIDE_DHS">1</xsl:with-param>
										<xsl:with-param name="ALLDISKS">1</xsl:with-param>
									</xsl:call-template>				
								</xsl:otherwise>		
							</xsl:choose>
						</xsl:if>
					</xsl:for-each>
				</SelectionTable>
			</SelectionData>
			<HiddenTable>
				<xsl:for-each select="//ArrayDisks/DCStorageObject">
					<xsl:call-template name="getArrayDiskObjIDs_HIDDEN_SELECTION_TABLE"/>
					<xsl:call-template name="getPowerStateForArrayDisks_HIDDEN_SELECTION_TABLE"/>
					<xsl:call-template name="getChTgtIDGivenObjIDForArrayDisks_HIDDEN_SELECTION_TABLE"/>
				</xsl:for-each>
				<xsl:for-each select="//ArrayDisks[@LDN]/DCStorageObject">
					<!-- test if this is a DHS, need to check here as well --> 
					<xsl:variable name="isDHS">
						<!-- check to see if current disk is DHS -->
						<xsl:call-template name="IsDedicatedHotSpare">
							<xsl:with-param name="AttributesMask">
								<xsl:value-of select="AttributesMask"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="$isDHS='0'">		
						<Data>						
							<xsl:attribute name="name">
								<xsl:choose>
									<xsl:when test="EnclosureID">adisk<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/>
									</xsl:when>
									<xsl:otherwise>adisk<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/>	
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<!--check return value -->
							<xsl:attribute name="returnvalue">
								<xsl:choose>
									<xsl:when test="EnclosureID">Sel<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:when>
									<xsl:otherwise>Sel<xsl:value-of select="Channel"/><xsl:text>:0:</xsl:text><xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>							
							</xsl:attribute>
					</Data>
					</xsl:if>
				</xsl:for-each>
			</HiddenTable>
		</DataArea>
	</xsl:template>
	<xsl:template name="getPowerStateForArrayDisks_HIDDEN_SELECTION_TABLE">
		<Data>
			<xsl:attribute name="name">PDPower<xsl:value-of select="ObjID"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="PDPowerState"/></xsl:attribute>
		</Data>
	</xsl:template>
	
	<xsl:template name="getChTgtIDGivenObjIDForArrayDisks_HIDDEN_SELECTION_TABLE">
		<Data>
			<xsl:attribute name="name">OBJID<xsl:value-of select="ObjID"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
		</Data>
	</xsl:template>
	
	<xsl:template name="getArrayDiskObjIDs_HIDDEN_SELECTION_TABLE">	
		<!-- test if this is a DHS --> 
		<xsl:variable name="isDHS">
			<!-- check to see if current disk is DHS -->
			<xsl:call-template name="IsDedicatedHotSpare">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="$isDHS='0'">		

			<!--This template creates a table that correlates ArrayDisk to their ObjIDs/-->
			<Data>
				<xsl:attribute name="name">
				<xsl:choose>
						<xsl:when test="EnclosureID">Sel<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
						<xsl:otherwise>Sel<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
					</xsl:choose>				
				</xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
			</Data>
		
		</xsl:if>
	</xsl:template>
	<xsl:template name="RenderChannelSelectionRadioButtons">
		<Data name="Channel" type="radio" handler="OnChannelSelected()" event="onclick" state="0">
			<xsl:attribute name="value"><xsl:value-of select="$strChannel"/> <xsl:value-of select="Channel"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Channel"/></xsl:attribute>
		</Data>
	</xsl:template>
	<!--**************************************************************************Code for Result Table/**************************************************************************************************************************-->
	<xsl:template name="ResultData">
		<!--the code below is rendered third/-->
		<DataArea printable="false" email="false" onLoad="true" exportdata="false" nographics="true">
			<xsl:variable name="isAdaptec">
	   		<xsl:choose>					
		   		<xsl:when test="/OMA/GetCapsResp/DCStorageObject/ReConfigDiskDelFlag">1</xsl:when>
			   	<xsl:otherwise>0</xsl:otherwise>	   		   	
			   </xsl:choose>
	  		 </xsl:variable>
			<script language="javascript">
			
				var JS_GLOBAL_MaxNumEnclosures = 4;
				
				function initializationRoutine()
				{
					showInitialResultTable();
				}
				
				function hideResultTable()
				{
					var numChannels=4;
					var numTargets = 32;
					var elemName=""
					
					for(var i=0;i&lt;numChannels;i++)
					{
						for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
						{
							for(var j=0;j&lt;numTargets;j++)
							{
								elemName = "parentrow_"+"Res"+i.toString()+e.toString()+j.toString();
								
								if(document.getElementById(elemName) != null)
								{
									document.getElementById("parentrow_"+"Res"+i.toString()+e.toString()).style.display="none"
									document.getElementById(elemName).style.display="none";
								}
							}
						}
					}
				}

				// Initial function to draw Result table. The drawResultTable below actually draws off the 
				// selection table which may not be completely drawn while this table is being drawn.
				// So this function is to stem off timing issues.
				function showInitialResultTable()
				{
					hideResultTable();
					var elemName="";
					var chkBxName="";
					var numChannels=4;
					var numTargets=32;
					var resval="";
					var counter=0;
					var isReallyAdaptec = "<xsl:value-of select="$isAdaptec"/>";
					
					for(var i=0;i&lt;numChannels;i++)
					{
						for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
						{
							for(var j=0;j&lt;numTargets;j++)
							{
								elemName="Sel"+i.toString()+":"+e.toString()+":"+j.toString();
														
								chkBxName="dsk"+i.toString()+e.toString()+j.toString();			

								
								if ((parent.frames["SELECTION_TABLE"].document.getElementById(elemName) != null &amp;&amp; parent.frames["SELECTION_TABLE"].document.getElementById(elemName).checked == true) || (document.getElementById(chkBxName) != null))
								{							
									document.getElementById("parentrow_"+"Res"+i.toString()+e.toString()).style.display="";
									document.getElementById("parentrow_Res"+i.toString()+e.toString()+j.toString()).style.display="";
									
									document.getElementById("Res"+i.toString()+":"+e.toString()+":"+j.toString()).checked = true;
									
									if ((document.getElementById("dsk"+i.toString()+e.toString()+j.toString()) != null) <!--&amp;&amp; (isReallyAdaptec == 0)-->)
									{
										document.getElementById("Res"+i.toString()+":"+e.toString()+":"+j.toString()).disabled=true;
									}
										
									
									counter=counter+1;
								}
							}
						}
					}

				}
				
				function showResultTable()
				{
					hideResultTable();
					var elemName="";
					var numChannels=4;
					var numTargets=32;
					var resval="";
					var counter=0;
					var isReallyAdaptec = "<xsl:value-of select="$isAdaptec"/>";
					
					for(var i=0;i&lt;numChannels;i++)
					{
						for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
						{
							for(var j=0;j&lt;numTargets;j++)
							{
								elemName="Sel"+i.toString()+":"+e.toString()+":"+j.toString();
								
								// chkbxname for extra check during initialization, because just
								// keying of Selection Table.checked may result in false when the table
								// isn't drawn fast enough.
								
								if (parent.frames["SELECTION_TABLE"].document.getElementById(elemName) != null &amp;&amp; parent.frames["SELECTION_TABLE"].document.getElementById(elemName).checked == true)
								{									
									document.getElementById("parentrow_"+"Res"+i.toString()+e.toString()).style.display="";
									document.getElementById("parentrow_Res"+i.toString()+e.toString()+j.toString()).style.display="";
									
									document.getElementById("Res"+i.toString()+":"+e.toString()+":"+j.toString()).checked = true;
									
									if ((document.getElementById("dsk"+i.toString()+e.toString()+j.toString()) != null) &amp;&amp; (isReallyAdaptec == 0))
									{
										document.getElementById("Res"+i.toString()+":"+e.toString()+":"+j.toString()).disabled=true;
									}									
									
									counter=counter+1;
								}
							}
						}
					}
				}
			
				function OnDelete(ChannelNum,Encl,TargetId)
				{

					parent.frames["SELECTION_TABLE"].document.getElementById("Sel"+ChannelNum+":"+Encl+":"+TargetId).checked =false;
					parent.frames["SELECTION_TABLE"].OnArrayDiskSelected(ChannelNum,Encl,TargetId);
					document.getElementById("Res"+ChannelNum+":"+Encl+":"+TargetId).checked = false;
					showResultTable();
				}
				function getSelectedArrayDisksAndSizeString()
				{
					alert("UI Error. Function should not be called.");
					var numChannels=4;
					var numTargets = 32;
					var elemName="";
					var reval="";
					for(var i=0;i&lt;numChannels;i++)
					{
						for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
						{
							for(var j=0;j&lt;numTargets;j++)
							{
								
								elemName = "parentrow_"+"Res"+i.toString()+e.toString()+j.toString();
								if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).style.display!="none")
								{
									
									reval +="&lt;ArrayDisks&gt;";
									reval +="&lt;Channel&gt;"+i.toString()+"&lt;/Channel&gt;";
									reval +="&lt;TargetID&gt;"+j.toString()+"&lt;/TargetID&gt;";
									reval +="&lt;Length&gt;"+document.getElementById("SIZE"+i.toString()+j.toString()).value+"&lt;/Length&gt;";
									reval +="&lt;/ArrayDisks&gt;";
									
								}
							}
						}
					}
					return reval;
					
				}
				function getSelectedArrayDisksObjIDsArray()
				{
					var ObjIDsArray = new Array();
					var numChannels=4;
					var numTargets=32;
					var elemName="";
					var index=0;
					
					for(var i=0;i&lt;numChannels;i++)
					{
						for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
						{
							for(var j=0;j&lt;numTargets;j++)
							{
								elemName = "parentrow_"+"Res"+i.toString()+e.toString()+j.toString();
								if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).style.display!="none")
								{
									elemName="OBJID"+i.toString()+e.toString()+j.toString();
									ObjIDsArray[index++]=document.getElementById(elemName).value;
								}
							}
						}
					}
					return ObjIDsArray;
				}
				function getSelectedArrayDisksObjIDs()
				{
					var elemName="";
					var numChannels=4;
					var numTargets=32;
					var resval="";
					var displayString="";
					var counter =0;
					
					for(var i=0;i&lt;numChannels;i++)
					{
						for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
						{
							for(var j=0;j&lt;numTargets;j++)
							{
								elemName = "parentrow_"+"Res"+i.toString()+e.toString()+j.toString();
								if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).style.display!="none")
								{
									elemName="OBJID"+i.toString()+e.toString()+j.toString();
									resval = document.getElementById(elemName).value;
									if(counter == 0)
									{
										displayString = resval;
									}
									else
									{
										displayString = displayString + ":"+resval;
									}
									counter++;
								}
							}
						}
					}
					return displayString;
				}
				<!--This function checks and disables disks of vdisk automatically-->
				function HideAdisksOfVdisk()
				{
					var numChannels=4;
					var numTargets = 32;
					for(var i=0;i&lt;numChannels;i++)
					{
						for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
						{
							for(var j=0;j&lt;numTargets;j++)
							{
								chkBxName="dsk"+i.toString()+e.toString()+j.toString();
								if(document.getElementById(chkBxName) != null )
								{
									document.getElementById("parentrow_Res"+i.toString()+e.toString()+j.toString()).style.display="none";
								}
							}
						}
					}
				}

			</script>
			<SelectionData>
				<SelectionTable>
					<Header>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strSelArray"/></xsl:attribute>
						</Data>
					</Header>
		
					<xsl:for-each select="//ArrayDisks[@EnclosureName]">
						<xsl:if test="count(DCStorageObject)!=0 ">
						
						 	<xsl:choose>
								<xsl:when test="DCStorageObject/EnclosureID"> <!-- SAS or SATA -->						
								
									<xsl:message> SAS: Res<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/> </xsl:message>

									<xsl:call-template name="RenderResultTableParentRow">
										<xsl:with-param name="PARENT_NAME">Res<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Res</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME">
											<xsl:call-template name="GetEnclosureDisplayName">
												<xsl:with-param name="EnclosureType" select="@EnclosureType"/>
                                                                        <xsl:with-param name="productid" select="@ProductID"/>
												<xsl:with-param name="Channel" select="DCStorageObject/Channel"/>
												<xsl:with-param name="EnclosureID" select="DCStorageObject/EnclosureID"/>
												<xsl:with-param name="SAS">True</xsl:with-param></xsl:call-template></xsl:with-param>
										<xsl:with-param name="RULES"><xsl:value-of select="//Rules"/></xsl:with-param>
										<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
										<xsl:with-param name="KEY_MATCH"><xsl:value-of select="@EnclosureName"/></xsl:with-param>
										<xsl:with-param name="DISPLAY_ZERO_FREESPACE_AD">1</xsl:with-param>
										<xsl:with-param name="HIDE_DHS">1</xsl:with-param>
										<xsl:with-param name="ALLDISKS">1</xsl:with-param>
									</xsl:call-template>
								</xsl:when>
									
								<xsl:otherwise> <!-- non SAS -->
								
									
							 		<xsl:message> NOTSAS: Res<xsl:value-of select="DCStorageObject/Channel"/></xsl:message>

									<xsl:call-template name="RenderResultTableParentRow">								

										<xsl:with-param name="PARENT_NAME">Res<xsl:value-of select="DCStorageObject/Channel"/>0</xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Res</xsl:with-param>										
										<xsl:with-param name="DISPLAY_NAME">
											<xsl:call-template name="GetEnclosureDisplayName">
												<xsl:with-param name="EnclosureType" select="@EnclosureType"/><xsl:with-param name="productid" select="@ProductID"/>
												<xsl:with-param name="Channel" select="DCStorageObject/Channel"/>
												<xsl:with-param name="EnclosureID">NULL</xsl:with-param>
												<xsl:with-param name="SAS">NULL</xsl:with-param></xsl:call-template></xsl:with-param>
										<xsl:with-param name="RULES"><xsl:value-of select="//Rules"/></xsl:with-param>
										<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
										<xsl:with-param name="KEY_MATCH"><xsl:value-of select="@EnclosureName"/></xsl:with-param>
										<xsl:with-param name="DISPLAY_ZERO_FREESPACE_AD">1</xsl:with-param>
										<xsl:with-param name="HIDE_DHS">1</xsl:with-param>
										<xsl:with-param name="ALLDISKS">1</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</xsl:for-each>
										
				</SelectionTable>
			</SelectionData>
			<HiddenTable>
				<xsl:apply-templates select="//ArrayDisks/DCStorageObject" mode="ObjIDsForArrayDisks_HIDDEN_TABLE"/>
				<xsl:for-each select="//ArrayDisks[@LDN]/DCStorageObject">				
					<!-- test if this is a DHS, need to check here as well --> 
					<xsl:variable name="isDHS">
						<!-- check to see if current disk is DHS -->
						<xsl:call-template name="IsDedicatedHotSpare">
							<xsl:with-param name="AttributesMask">
								<xsl:value-of select="AttributesMask"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="$isDHS='0'">						
						<Data>
							<xsl:attribute name="name">
								<xsl:choose>
									<xsl:when test="EnclosureID">dsk<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
									<xsl:otherwise>dsk<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>		
							</xsl:attribute>
							<xsl:attribute name="returnvalue">
								<xsl:choose>
									<xsl:when test="EnclosureID">Res<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when><xsl:otherwise>Res<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>		
							</xsl:attribute>
						</Data>
					</xsl:if>
				</xsl:for-each>
			</HiddenTable>
		</DataArea>
	</xsl:template>
	<xsl:template match="ArrayDisks/DCStorageObject" mode="ObjIDsForArrayDisks_HIDDEN_TABLE">
		<!--This template creates a table that correlates ArrayDisk to their ObjIDs/-->
		<Data>
			<xsl:attribute name="name">
				<xsl:choose>
					<xsl:when test="EnclosureID">OBJID<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
					<xsl:otherwise>OBJID<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
				</xsl:choose>		
			</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
		</Data>
	</xsl:template>
	
	<xsl:template name="GetEnclosureDisplayName">
		<xsl:param name="EnclosureType"/>
		<xsl:param name="Channel"/>
		<xsl:param name="EnclosureID"/>
		<xsl:param name="SAS"/>
		<xsl:choose>
			<xsl:when test="$EnclosureType=''"> <!-- no enclosures, direct attached disks -->
				<xsl:value-of select="$strChannel"/><xsl:value-of select="$Channel"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$SAS='True'">	 <!-- SAS/SATA disks in enclosure -->
						<xsl:call-template name="GetEnclosureType"><xsl:with-param name="type" select="$EnclosureType" /><xsl:with-param name="productid" select="@ProductID"/></xsl:call-template> (<xsl:value-of select="$Channel"/>:<xsl:value-of select="$EnclosureID"/>)			
					</xsl:when>
					<xsl:otherwise> <!-- SCSI disks in enclosure -->
						<xsl:call-template name="GetEnclosureType"><xsl:with-param name="type" select="$EnclosureType" /><xsl:with-param name="productid" select="@ProductID"/></xsl:call-template> (<xsl:value-of select="$strChannel"/><xsl:value-of select="$Channel"/>)
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>

