<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<!-- VIRTUAL DISK TABLE HEADER FOR PRIVIEW OF IMPORT -->
	<xsl:template name="ImportPreviewVDTableHeader">
		<xsl:param name="tasks"/>
		<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
		<Data name="Id" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
		<Data name="Status" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
		<Data name="Layout" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strLayout"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLayout"/></xsl:attribute>
		</Data>
		<Data name="Details" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strDetails"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDetails"/></xsl:attribute>
		</Data>
		<Data name="DedicatedHotSpare" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strDedicatedHotSpare"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDedicatedHotSpare"/></xsl:attribute>
		</Data>
	</xsl:template>
	<!-- VIRTUAL DISK TABLE ROWS -->
	<xsl:template name="ImportPreviewVDTableRows">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="tasks"/>
		<xsl:param name="caller"/>
		<xsl:call-template name="scripts"/>
		<xsl:variable name="vdiskname">
			<xsl:value-of select="Name"/>
		</xsl:variable>
		<xsl:variable name="vdiskid">
			<xsl:value-of select="$ObjID"/>
		</xsl:variable>

		<xsl:variable name="blink">
			<xsl:if test="substring(CurrentMethodMask,24,1)!='0'">true</xsl:if>
		</xsl:variable>

		<xsl:variable name="isCluster">
			<xsl:choose>
				<xsl:when test="substring(/OMA/VirtualDisks/@AttributesMask,32,1)!='0'">1</xsl:when>
			  <xsl:otherwise>0</xsl:otherwise>
		 </xsl:choose>
		</xsl:variable>

		<xsl:variable name="vdevname">
			<xsl:value-of select="DeviceName"/>
		</xsl:variable>
		<xsl:variable name="numbootpart">
			<xsl:choose>
				<xsl:when test="NumBootPart">
					<xsl:value-of select="NumBootPart"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="count(ParentVDID)= 0">
			<!-- Only display main virtual disks, not child VDisks -->
			<Row height="30px">
				<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
				<Data name="Test" editable="false" type="ustring" display="{LogicalDriveNum}" ignoreonweb="true">
					<xsl:attribute name="value"><xsl:value-of select="LogicalDriveNum"/></xsl:attribute>
				</Data>
				<Data type="status" align="center">
					<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
				</Data>
				<Data link="true" editable="false" type="ustring" display="{Name}">
					<xsl:attribute name="name"><xsl:value-of select="$strName"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ArrayWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="$ObjID"/>&amp;VirtualDiskName=<xsl:value-of select="Name"/>&amp;RaidLayout=<xsl:value-of select="Layout"/>&amp;LogicalDriveNumber=<xsl:value-of select="LogicalDriveNum"/>&amp;ForeignVDIDsList=<xsl:value-of select="ForeignVDIDsList"/>&amp;SpanLength=<xsl:value-of select="SpanLength"/>&amp;ForeignConfig=true&amp;BackTo=<xsl:value-of select="$caller"/>&amp;help=cntkpdfc</xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strState"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<!-- isEmpty var used for tasks menu option -->
				<xsl:variable name="isEmpty">
					<xsl:call-template name="IsCurrentMethodMaskEmpty">
						<xsl:with-param name="Mask">
							<xsl:value-of select="CurrentMethodMask"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strLayout"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:choose>
					<xsl:when test="IsSSC = '1'">
					 <xsl:attribute name="value"><xsl:value-of select="$strEnhCach"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
					  <xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strDetails"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetForeignErrorDetails"><xsl:with-param name="ErrorCode"><xsl:value-of select="ForeignReasonCode"/></xsl:with-param></xsl:call-template></xsl:attribute>
					<xsl:attribute name="tooltip"><xsl:value-of select="ProblemDescription"/></xsl:attribute>
				</Data>
                <xsl:variable name="ISForeignDHS"><xsl:value-of select="IsForeignDHS"/></xsl:variable>
				<xsl:choose>
				<xsl:when test="IsSSC = '1'">
				    <Data editable="false" type="ustring" display="Test">
					   <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
				    </Data>
				</xsl:when>
				<xsl:otherwise>
				    <Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strDedicatedHotSpare"/><xsl:value-of select="position()"/></xsl:attribute>
					    <xsl:attribute name="value">
                           <xsl:choose>
                                 <xsl:when test="$ISForeignDHS='1'"><xsl:value-of select="$strYes"/></xsl:when>
                                 <xsl:otherwise><xsl:value-of select="$strNo"/></xsl:otherwise> 
                            </xsl:choose>
                        </xsl:attribute>
				    </Data>
				</xsl:otherwise>
				</xsl:choose>
			</Row>
		</xsl:if>
		<!-- End if (VDLevel = 0) -->
	</xsl:template>

        <xsl:template name="IsThereDHS">
          <xsl:param name="ObjID"/>
          <xsl:for-each select="../../DedicatedHotSpares/ArrayDisks">
            <xsl:if test="@VirtualDiskID=$ObjID">
              <xsl:value-of select="$strYes"/>
            </xsl:if>
          </xsl:for-each>
          <xsl:value-of select="$strNo"/>
        </xsl:template>
</xsl:stylesheet>
