<!-- This is the XSL to render Set HotSpare Protection Policy.  The associated web plugin is SetHSPorectionPolicyWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:variable name="considerGHS" select="/OMA/ProtectionPolicies[2]/ProtectionEntry/DCStorageObject/ConsiderGHSInVDStatus"/>
	<xsl:variable name="PARAM_REGULAR_OrigURL"><xsl:value-of select="/OMA/BackTo"/></xsl:variable>

	<xsl:template match="OMA">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<DataArea validate="true" onLoad="true" exportdata="false">
			<xsl:if test="$checkAdmin='true'">
			     <xsl:attribute name="submit">javascript:submitPolicies();</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
			<!-- The call to the scripts template is needed to include the new common javascript function GetLocalUrl( ) for error handling -->
			<!-- This call must reside within the <DataArea> tag -->
			<xsl:call-template name="scripts"/>
			<script language="javascript">
			var MAXNUM_VALUE = 262144; //This is the highest value possible for RAID60
			var PrevSetRaidValues = "";
			var PrevSetAllValues = "";
			var Admin = '<xsl:value-of select="$checkAdmin"/>';

			function initializationRoutine()
			{
				// Write on load code here to populate the previous values.
				disableAllHSAndWarnLevels();

				// onLoad .. show the previously set policies	
				enableSetPolicies();				

				if (Admin != 'true')
				{
					disableAllCheckboxesforNonAdmin();
				}
			}

			function enableSetPolicies()
			{
				var chkname = "";
				var policyVal = "";
				var allHSCount = "<xsl:value-of select="ProtectionPolicies//DCStorageObject[Layout = '0']/HSCount"/>";
				var allWarnLevel = "<xsl:value-of select="ProtectionPolicies//DCStorageObject[Layout = '0']/WarningLevel"/>";

				if (allHSCount &gt; 0 &amp;&amp; allWarnLevel &gt; 0)
				{
					chkname = "raidlayout_0";
					document.getElementById(chkname).disabled = false;
					document.getElementById(chkname).checked = true;
					document.getElementById("hscount_0").disabled = false;
					document.getElementById("warninglevel_0").disabled = false;
					selectAndDisableIndRaidLevels(allHSCount, allWarnLevel);
					PrevSetRaidValues += "0:";	
					PrevSetAllValues += "0:"+allHSCount+":"+allWarnLevel+":";	
				}
				else
				{
					<xsl:for-each select="ProtectionPolicies//DCStorageObject[Layout and Layout != '0']">
						<xsl:if test="(HSCount != '' and HSCount &gt; 0) and (WarningLevel != '' and WarningLevel &gt; 0)">
							<xsl:if test="Layout and Layout != ''">
									chkname = "raidlayout_" + '<xsl:value-of select="Layout"/>';
									policyVal = '<xsl:value-of select="Layout"/>';
									PrevSetRaidValues += '<xsl:value-of select="Layout"/>' + ":";
									PrevSetAllValues += '<xsl:value-of select="Layout"/>' + ":" + <xsl:value-of select="HSCount"/> + ":" + <xsl:value-of select="WarningLevel"/> + ":";
							</xsl:if>

							document.getElementById(chkname).disabled = false;
							document.getElementById(chkname).checked = true;

							OnPolicySelected(policyVal);
						</xsl:if>
					</xsl:for-each>
				}

				<xsl:for-each select="ProtectionPolicies//DCStorageObject[not(Layout)]">
					<xsl:if test="(HSCount != '' and HSCount &gt; 0) and (WarningLevel != '' and WarningLevel &gt; 0)">
									chkname = "enableGHS";
									policyVal = '';
									PrevSetRaidValues += "ghs:";
									PrevSetAllValues += "ghs:" + <xsl:value-of select="HSCount"/> + ":" + <xsl:value-of select="WarningLevel"/> + ":";
									
							document.getElementById(chkname).disabled = false;
							document.getElementById(chkname).checked = true;
							document.getElementById("hscount_").disabled = false;
							document.getElementById("hscount_").checked = true;
							document.getElementById("warninglevel_").disabled = false;
							document.getElementById("warninglevel_").checked = true;

						</xsl:if>
					</xsl:for-each>

				if ('<xsl:value-of select="$considerGHS"/>' == 1)
				{
					PrevSetRaidValues += "cvs:";
					PrevSetAllValues += "cvs:";
					document.getElementById("considerghs").checked = true;
				}
			}

			function validate()
			{
				var alllevelsset = "no";
				var CurrentSetRaidValues = "";
				var CurrentSetAllValues = "";

				for(var i=2; i &lt;= MAXNUM_VALUE;)
                        {
					var chkname = "raidlayout_"+i;
					var hscount = "hscount_"+i;
					var warnlevel = "warninglevel_"+i;

					if (document.getElementById(chkname) != null &amp;&amp; document.getElementById(chkname).disabled == false &amp;&amp; document.getElementById(chkname).checked == true)
					{
						CurrentSetRaidValues += i +":";
						CurrentSetAllValues += i +":" + document.getElementById(hscount).value +":" + document.getElementById(warnlevel).value +":";
					}
					i = i * 2;
				}

				// For all raid levels
				if (document.getElementById("raidlayout_0").disabled == false &amp;&amp; document.getElementById("raidlayout_0").checked == true)
				{
					alllevelsset = "yes";
					CurrentSetRaidValues += "0:";
					CurrentSetAllValues += "0:" + document.getElementById(hscount).value +":" + document.getElementById(warnlevel).value +":";
					if (isValueAlreadySet('0'))
					{
						alllevelsset = "no";
					}
				}

				// For GHS
				if (document.getElementById("enableGHS").disabled == false &amp;&amp; document.getElementById("enableGHS").checked == true)
				{ 
					CurrentSetRaidValues += "ghs:";
					CurrentSetAllValues += "ghs:" + document.getElementById("hscount_").value +":" + document.getElementById("warninglevel_").value +":";
				}
				
				// For considerGHSinVDStatus
				if (document.getElementById("considerghs").checked == true)
				{
					if (document.getElementById("enableGHS").checked == false)
					{
						alert("<xsl:value-of select="$strConsiderGHSAloneErrorMsg"/>");
						return false;
					}
					CurrentSetRaidValues += "cvs:";
					CurrentSetAllValues += "cvs:";
				}

					if (alllevelsset == 'yes')
					{
						if (confirm ("<xsl:value-of select="$strAllRaidLevelSetMsg"/>") == false)
							return false;						
					}
					else
					{	
						var oldPolicyValid = false;
						var oldValueArray = PrevSetRaidValues.split(":");
						var newValueArray = CurrentSetRaidValues.split(":");
						for(var i = 0; i &lt; oldValueArray.length; i++)
                        		{
							oldPolicyValid = false;
							for(var j = 0; j &lt; newValueArray.length; j++)
                        			{
								if (oldValueArray[i] == newValueArray[j])
								{
									oldPolicyValid = true;
									break;
								}	
							}
							if (oldPolicyValid == false)
							{
								break;
							}
						}
						
						if (PrevSetAllValues == CurrentSetAllValues)
						{
							alert("<xsl:value-of select="$strNoChangeInValue"/>");
							return false;
						}
						
						if (oldPolicyValid == false)
						{
							if (confirm ("<xsl:value-of select="$strUnAssignPreviousPolicyMsg"/>") == false)
								return false;
						}
				}
				//In case of Chrome/Safari double form submission is not allowed 
				//And so just forming the form action URL as part of formSubmitActionURL method and so submitting the form in DataArea xsl formSubmit method 
				formSubmitActionURL();
				return true;
			}

			function OnPolicySelected(policyVal)
			{
				var chkname = "";
				if (policyVal != '')
				{
					chkname = "raidlayout_"+policyVal;
				}
				else
				{ 
					chkname = "enableGHS";
				}	
				var hscountname = "hscount_"+policyVal;
				var warnlevelname = "warninglevel_"+policyVal;

				if (document.getElementById(chkname) != null &amp;&amp; document.getElementById(chkname).disabled == false &amp;&amp; document.getElementById(chkname).checked == true)
				{
					document.getElementById(hscountname).disabled = false;
					document.getElementById(warnlevelname).disabled = false;
					if (policyVal == '0')
					{  
						disableOtherDHSPolicies();
						selectAndDisableIndRaidLevels(document.getElementById(hscountname).value, document.getElementById(warnlevelname).value);
					}
					else if (policyVal != '')
					{ 
						document.getElementById("raidlayout_0").disabled = true;
					}
				}
				else
				{
					document.getElementById(hscountname).disabled = true;
					document.getElementById(warnlevelname).disabled = true;
					if (policyVal == '0')
					{
						//deslectAndEnableIndRaidLevels();
						enableOtherDHSPolicies();
					}
					else if (policyVal != '' &amp;&amp; otherDHSPolicyCount() == 0)
					{ 
						document.getElementById("raidlayout_0").disabled = false;
					}
					else if(policyVal != '')
					{ 
					  document.getElementById("raidlayout_0").disabled = true;
					}
				}

			}

			function disableOtherDHSPolicies()
			{
				for(var i=2; i &lt;= MAXNUM_VALUE;)
                        {
					var chkname = "raidlayout_"+i;
					var hscountname = "hscount_"+i;
				    var warnlevelname = "warninglevel_"+i;
					if (document.getElementById(chkname) != null)
					{
						document.getElementById(chkname).disabled = true;
						document.getElementById(hscountname).disabled = true;
						document.getElementById(warnlevelname).disabled = true;
					}
					i = i * 2;
				}
			}

			function enableOtherDHSPolicies()
			{
				for(var i=2; i &lt;= MAXNUM_VALUE;)
                        {
					var chkname = "raidlayout_"+i;
					var hscountname = "hscount_"+i;
					var warnlevelname = "warninglevel_"+i;
					
					if (document.getElementById(chkname) != null)
					{
						document.getElementById(chkname).disabled = false;
						document.getElementById(hscountname).disabled = false;
						document.getElementById(warnlevelname).disabled = false;
					}
					i = i * 2;
				}
			}

			function selectAndDisableIndRaidLevels(hscount, warnlevel)
			{
				for(var i=2; i &lt;= MAXNUM_VALUE;)
                        {
					var chkname = "raidlayout_"+i;
					var hscountname = "hscount_"+i;
					var warnlevelname = "warninglevel_"+i;

					if (document.getElementById(chkname) != null)
					{
						document.getElementById(chkname).checked = true;
						document.getElementById(chkname).disabled = true;

						document.getElementById(hscountname).value = hscount;
						document.getElementById(warnlevelname).value = warnlevel;
					}
					i = i * 2;
				}
			}

			function deslectAndEnableIndRaidLevels()
			{
				var chkname = "";
				var hscountname = "";
				var warnlevelname = "";

				<xsl:for-each select="ProtectionPolicies//DCStorageObject[Layout != '0']">
					chkname = "raidlayout_" + '<xsl:value-of select="Layout"/>';
					hscountname = "hscount_" + '<xsl:value-of select="Layout"/>';
					warnlevelname = "warninglevel_" + '<xsl:value-of select="Layout"/>';

					document.getElementById(chkname).disabled = false;
					document.getElementById(chkname).checked = false;

					<xsl:choose>
						<xsl:when test="HSCount != '' and HSCount != 0">
							document.getElementById(hscountname).value = '<xsl:value-of select="HSCount"/>';
						</xsl:when>
						<xsl:otherwise>
							document.getElementById(hscountname).value = 1;
						</xsl:otherwise>
					</xsl:choose>
					document.getElementById(hscountname).disabled = true;
					
					<xsl:choose>
						<xsl:when test="WarningLevel != '' and WarningLevel != 0">
							document.getElementById(warnlevelname).value = '<xsl:value-of select="WarningLevel"/>';
						</xsl:when>
						<xsl:otherwise>
							document.getElementById(warnlevelname).value = 1;
						</xsl:otherwise>
					</xsl:choose>
					document.getElementById(warnlevelname).disabled = true;
				</xsl:for-each>

			}

			function otherDHSPolicyCount()
			{
				var count = 0;
				for(var i=2; i &lt;= MAXNUM_VALUE;)
                        {
					var chkname = "raidlayout_"+i;
				if (document.getElementById(chkname) != null &amp;&amp; document.getElementById(chkname).disabled == false &amp;&amp; document.getElementById(chkname).checked == true)
					{
						count += 1;
					}
					i = i * 2;
				}
				return count;
			}

			function disableAllHSAndWarnLevels()
			{
				for(var i=2; i &lt;= MAXNUM_VALUE;)
                        {
					var chkname = "raidlayout_"+i;
					var hscountname = "hscount_"+i;
					var warnlevelname = "warninglevel_"+i;

					if (document.getElementById(chkname) != null &amp;&amp; document.getElementById(chkname).disabled == false &amp;&amp; document.getElementById(chkname).checked == false)
					{
						document.getElementById(hscountname).disabled = true;
						document.getElementById(warnlevelname).disabled = true;
					}
					i = i * 2;
				}

				// For all raid levels
				if (document.getElementById("raidlayout_0").disabled == false &amp;&amp; document.getElementById("raidlayout_0").checked == false)
				{
					document.getElementById("hscount_0").disabled = true;
					document.getElementById("warninglevel_0").disabled = true;
				}

				// For GHS
				if (document.getElementById("enableGHS").disabled == false &amp;&amp; document.getElementById("enableGHS").checked == false)
				{
					document.getElementById("hscount_").disabled = true;
					document.getElementById("warninglevel_").disabled = true;
				}
			}

			function disableAllCheckboxesforNonAdmin()
			{
				for(var i=2; i &lt;= MAXNUM_VALUE;)
                        {
					var chkname = "raidlayout_"+i;
					var hscountname = "hscount_"+i;
					var warnlevelname = "warninglevel_"+i;

					if (document.getElementById(chkname) != null)
					{
						document.getElementById(chkname).disabled = true;
						document.getElementById(hscountname).disabled = true;
						document.getElementById(warnlevelname).disabled = true;
					}
					i = i * 2;
				}

				// For all raid levels
				if (document.getElementById("raidlayout_0") != null)
				{
					document.getElementById("raidlayout_0").disabled = true;
					document.getElementById("hscount_0").disabled = true;
					document.getElementById("warninglevel_0").disabled = true;
				}

				// For GHS
				if (document.getElementById("enableGHS") != null)
				{
					document.getElementById("enableGHS").disabled = true;
					document.getElementById("hscount_").disabled = true;
					document.getElementById("warninglevel_").disabled = true;
				}

				// For consider GHS
				if (document.getElementById("considerghs") != null)
				{
					document.getElementById("considerghs").disabled = true;
				}

			}

			function OnHSPChangeHandler(value)
			{
				if (value == '0')
				{
					var allhsvalue = document.getElementById("hscount_0").value;
					for(var i=2; i &lt;= MAXNUM_VALUE;)
                        	{
						var hscountname = "hscount_"+i;
						if (document.getElementById(hscountname) != null)
						{
							document.getElementById(hscountname).value = allhsvalue;
							document.getElementById(hscountname).disabled = true;											}
						i = i * 2;
					}

				}
			}

			function OnWarningChangeHandler(value)
			{
				if (value == '0')
				{
					var allwarnvalue = document.getElementById("warninglevel_0").value;
					for(var i=2; i &lt;= MAXNUM_VALUE;)
                        	{
						var warnlevelname = "warninglevel_"+i;
						if (document.getElementById(warnlevelname) != null)
						{
							document.getElementById(warnlevelname).value = allwarnvalue;
							document.getElementById(warnlevelname).disabled = true;										}
						i = i * 2;
					}

				}
			}

			//Here just forming the form action URL;  submitting the form is happenning in DataArea xsl formSubmit method 
			function formSubmitActionURL()
			{
				var origUrl = '<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>';
				
				var queryString = "";
				for(var i=2; i &lt;= MAXNUM_VALUE;)
                        {
					var chkname = "raidlayout_"+i;
					var hscountname = "hscount_"+i;
					var warnlevelname = "warninglevel_"+i;

					if (document.getElementById(chkname) != null &amp;&amp; document.getElementById(chkname).disabled == false &amp;&amp; document.getElementById(chkname).checked == true)
					{
						queryString += "&amp;DHSCount_" + i + "=" + document.getElementById(hscountname).value + "&amp;WarnLevel_" + i + "=" + document.getElementById(warnlevelname).value ;
					}
					else if (document.getElementById(chkname) != null &amp;&amp; document.getElementById(chkname).disabled == false &amp;&amp; document.getElementById(chkname).checked == false)
					{
					//	if (isValueAlreadySet(i))
					//	{
							queryString += "&amp;DHSCount_" + i + "=0&amp;WarnLevel_" + i + "=0" ;
					//	}	
					}

					i = i * 2;
				}

				// For all raid levels
				if (document.getElementById("raidlayout_0").disabled == false &amp;&amp; document.getElementById("raidlayout_0").checked == true)
				{
					queryString += "&amp;DHSCount_All=" + document.getElementById("hscount_0").value + "&amp;WarnLevel_All=" + document.getElementById("warninglevel_0").value ;
				}
				/*else if (document.getElementById("raidlayout_0").checked == false)
				{
					if (isValueAlreadySet('0'))
					{
						queryString += "&amp;DHSCount_All=0&amp;WarnLevel_All=0" ;
					}
				}*/

				// For GHS
				if (document.getElementById("enableGHS").disabled == false &amp;&amp; document.getElementById("enableGHS").checked == true)
				{
					queryString += "&amp;GHSCount=" + document.getElementById("hscount_").value + "&amp;GHSWarnLevel=" + document.getElementById("warninglevel_").value ;
				}
				else if (document.getElementById("enableGHS").disabled == false &amp;&amp; document.getElementById("enableGHS").checked == false)
				{
					if (isValueAlreadySet('ghs'))
					{
						queryString += "&amp;GHSCount=0&amp;GHSWarnLevel=0" ;
					}
				}

				// For consider ghs in VD state
				if (document.getElementById("considerghs").checked == true)
				{
					queryString += "&amp;ConsiderGHSinVDStatus=1";
				}
				else if (document.getElementById("considerghs").checked == false)
				{
					queryString += "&amp;ConsiderGHSinVDStatus=0";
				}
               
				document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.SubmitHSProtectionPolicyWebPlugin&amp;OrigURL=" + origUrl + queryString);				
				
			}

			function isValueAlreadySet(val)
			{
				var oldValueArray = PrevSetRaidValues.split(":");
				for(var j = 0; j &lt; oldValueArray.length; j++)
                        {
					if (oldValueArray[j] == val)
					{
						return true;
					}
				}
				return false;
			}	

			</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSetHSProtectionPolicy"/></xsl:attribute>
			</PageTitle>

			<PromptText><xsl:value-of select="$strPromptSetHSPPolicy"/></PromptText>
			
			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.SetHSProtectionPolicyWebplugin&amp;help=hsppol&amp;Refresh=true</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="/OMA/ProtectionPolicies[1]" mode="DHS"/>
			<xsl:apply-templates select="/OMA/ProtectionPolicies[2]" mode="GHS"/>
		</DataArea>
	</xsl:template>

	<!-- Template to display hotspare policy sections -->
	<xsl:template match="ProtectionPolicies" mode="DHS">
		<xsl:param name="tasks"/>
		<xsl:param name="checkAdmin"/>
		<SummaryData ignoreJumpBar="true">
			<TableData name="DHSTable" display="{$StrDHSPolicyTxt}">
				<xsl:variable name="showtasks">false</xsl:variable>
				<PromptText><xsl:value-of select="$StrDHSPolicyDescription"/></PromptText>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$StrDHSPolicyTxt"/></xsl:attribute>
				</SubHeader>

				<xsl:call-template name="HotSparePolicyHeaders">
					<xsl:with-param name="Type">1</xsl:with-param>
				</xsl:call-template> 

				<xsl:call-template name="HotSparePolicyRows">
					<xsl:with-param name="Type">1</xsl:with-param>
				</xsl:call-template>
			</TableData>
		</SummaryData>
	</xsl:template>

	<xsl:template name="HotSparePolicyHeaders">
		<xsl:param name="Type"/>
		<Header>
			<xsl:choose>
				<xsl:when test="$Type='1'">
					<Data align="left"><xsl:attribute name="value"><xsl:value-of select="$strRAIDLevels"/></xsl:attribute></Data>
				</xsl:when>
				<xsl:otherwise>
					<Data align="left"><xsl:attribute name="value"> </xsl:attribute></Data>
				</xsl:otherwise>
			</xsl:choose>
			<Data align="center"><xsl:attribute name="value"><xsl:value-of select="$strMinNumDisks"/></xsl:attribute></Data>
			<Data align="left"><xsl:attribute name="value"><xsl:value-of select="$strWarnLevel"/></xsl:attribute></Data>
		</Header>
	</xsl:template>

	<xsl:template name="HotSparePolicyRows">
		<xsl:param name="Type"/>
		<xsl:for-each select="ProtectionEntry/DCStorageObject">
			<Row>
				<xsl:choose>
					<xsl:when test="$Type='1'">
						<Data type="checkbox" align="left" event="onClick">
							<xsl:attribute name="name">raidlayout_<xsl:value-of select="Layout"/></xsl:attribute>
							<xsl:attribute name="handler">javascript:OnPolicySelected('<xsl:value-of select="Layout"/>')</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="Layout != '0'">
										<xsl:call-template name="GetRaidLayout">
											<xsl:with-param name="RaidType">
												<xsl:value-of select="Layout"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$strAllLevels"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data align="left" type="checkbox" name="enableGHS" event="onClick">
							<xsl:attribute name="value"><xsl:value-of select="$strEnableGHS"/></xsl:attribute>
							<xsl:attribute name="handler">javascript:OnPolicySelected('')</xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
				<Data align="center" type="select" event="onChange">
					<xsl:attribute name="name">hscount_<xsl:value-of select="Layout"/></xsl:attribute>
					<xsl:attribute name="handler">javascript:OnHSPChangeHandler('<xsl:value-of select="Layout"/>');</xsl:attribute>
					<xsl:if test="HSCount != '' and HSCount != 0">
						<Choice value="{HSCount}" returnvalue="{HSCount}"/>
					</xsl:if>
					<xsl:call-template name="RenderHotSpareListBox">
						<xsl:with-param name="initial" select="1"/>
						<xsl:with-param name="terminal" select="16"/>
						<xsl:with-param name="increment" select="1"/>
						<xsl:with-param name="currentVal" select="HSCount"/>
					</xsl:call-template>
				</Data>
				<Data align="left" type="select" event="onChange">
					<xsl:attribute name="name">warninglevel_<xsl:value-of select="Layout"/></xsl:attribute>
					<xsl:attribute name="handler">javascript:OnWarningChangeHandler('<xsl:value-of select="Layout"/>');</xsl:attribute>
					<xsl:if test="WarningLevel != '' and WarningLevel != 0">
						<Choice>
							<xsl:attribute name="value">
								<xsl:call-template name="GetWarningLevels">
									<xsl:with-param name="warnvalue" select="WarningLevel"/>
								</xsl:call-template>
							</xsl:attribute>
			                  	<xsl:attribute name="returnvalue"><xsl:value-of select="WarningLevel"/></xsl:attribute>
                           		</Choice>
					</xsl:if>
					<xsl:call-template name="RenderWarningLevelListBox">
						<xsl:with-param name="initial" select="1"/>
						<xsl:with-param name="terminal" select="3"/>
						<xsl:with-param name="currentVal" select="WarningLevel"/>
					</xsl:call-template>
				</Data>
            	</Row>
		</xsl:for-each>
	</xsl:template>

	<!-- Renders a list box to select number of minimum hotspare disks -->
	<xsl:template name="RenderHotSpareListBox">
		<xsl:param name="initial"/>
		<xsl:param name="terminal"/>
		<xsl:param name="increment"/>
		<xsl:param name="currentVal"/>
		<xsl:if test="$initial &lt;= $terminal">
			<xsl:if test="$initial != $currentVal">
				<Choice value="{$initial}" returnvalue="{$initial}"/>
			</xsl:if>
			<xsl:call-template name="RenderHotSpareListBox">
				<xsl:with-param name="initial" select="$initial+$increment"/>
				<xsl:with-param name="terminal" select="$terminal"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="currentVal" select="$currentVal"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- Renders a list box to select number of minimum hotspare disks -->
	<xsl:template name="RenderWarningLevelListBox">
		<xsl:param name="initial"/>
		<xsl:param name="terminal"/>
		<xsl:param name="currentVal"/>
		<xsl:if test="$initial &lt;= $terminal">
			<xsl:if test="$initial != $currentVal">
				<Choice>
					<xsl:attribute name="value">
						<xsl:call-template name="GetWarningLevels">
							<xsl:with-param name="warnvalue" select="$initial"/>
						</xsl:call-template>
					</xsl:attribute>
	                  	<xsl:attribute name="returnvalue"><xsl:value-of select="$initial"/></xsl:attribute>                  				</Choice>
			</xsl:if>
			<xsl:call-template name="RenderWarningLevelListBox">
				<xsl:with-param name="initial" select="$initial+1"/>
				<xsl:with-param name="terminal" select="$terminal"/>
				<xsl:with-param name="currentVal" select="$currentVal"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template match="ProtectionPolicies" mode="GHS">
		<xsl:param name="tasks"/>
		<xsl:param name="checkAdmin"/>
		<SummaryData>
			<TableData name="GHSTable" display="{$StrGHSPolicyTxt}">
				<xsl:variable name="showtasks">false</xsl:variable>
				<PromptText><xsl:value-of select="$StrGHSPolicyDescription"/></PromptText>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$StrGHSPolicyTxt"/></xsl:attribute>
				</SubHeader>
				<xsl:call-template name="HotSparePolicyHeaders">
					<xsl:with-param name="Type">2</xsl:with-param>
				</xsl:call-template>

				<xsl:call-template name="HotSparePolicyRows">
					<xsl:with-param name="Type">2</xsl:with-param>
				</xsl:call-template>

			</TableData>
			<TableData>
				<Row>
					<Data type="checkbox" align="left" name="considerghs">
						<xsl:attribute name="value"><xsl:value-of select="$strConsiderGHS"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
		</SummaryData>
	</xsl:template>
</xsl:stylesheet>
