<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	  <xsl:template name="CachePoolPropertiesTableInfo">
				<xsl:variable name="unknownStatus">1</xsl:variable>
                 <SubHeader><xsl:attribute name="display"><xsl:value-of select="$strCachePoolProperties"/></xsl:attribute></SubHeader>
		 <Data name="status" type="status" align="left">
		        <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			    <xsl:attribute name="value">
			         <xsl:choose>
                         <xsl:when test="//CachePoolProperties/DCStorageObject/ObjStatus">
								 <xsl:value-of select="//CachePoolProperties/DCStorageObject/ObjStatus"/>
					     </xsl:when>
		 	             <xsl:otherwise>
					             <xsl:value-of select="$unknownStatus"/>
     		 	         </xsl:otherwise>
                    </xsl:choose> 
			    </xsl:attribute>
		</Data>
		<Data type="CachePoolSize" align="left">
		        <xsl:attribute name="display"><xsl:value-of select="$strCachePoolSize"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="format-number(//CachePoolProperties/DCStorageObject/CachePoolSize div 1024, '0.00')"/> GiB</xsl:attribute>
                 </Data>
		 <Data name="CachePoolHighAvailablity" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strCachePoolHighAvailability"/></xsl:attribute>
			<xsl:attribute name="value">
                            <xsl:choose>
                                        <xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'False' and //CachePoolProperties/DCStorageObject/CacheStoreCount = '0'">
                                                <xsl:value-of select="$strCachePoolHighAvailabilityFalsePassThrough"/>
                                        </xsl:when>
                                        <xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'False'">
                                                <xsl:value-of select="$strCachePoolHighAvailabilityFalse"/>
                                        </xsl:when>
                                        <xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'True'">
                                                <xsl:value-of select="$strCachePoolHighAvailabilityTrue"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                                <xsl:value-of select="$strNotApplicable"/>
                                        </xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
		</Data>
             <Data type="CacheStoreCount" align="left">
		        <xsl:attribute name="display"><xsl:value-of select="$strCacheStoreCount"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="//CachePoolProperties/DCStorageObject/CacheStoreCount"/></xsl:attribute>
                 </Data>
   
          </xsl:template> 
          
          <xsl:template name="FluidCacheInfoTable">
		 <Data type="status" align="left">
		        <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
		</Data>
		<Data name="CachePoolLicenseState" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strCachePoolLicenseState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="CachePoolLicenseState"/></xsl:attribute>
		</Data>
               
	</xsl:template>
</xsl:stylesheet>

