<!-- This is the XSL to render the Controller Information page.  The associated web plugin is the ControllerInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="fluidcachetbl.xsl"/>
      	<xsl:import href="fcdtbl.xsl"/>
        <xsl:import href="adtbl.xsl"/>
       
       
	<xsl:variable name="GLOBAL_VAR_LOCALE"><xsl:value-of select="/OMA/Locale"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_CACHEPOOL">1</xsl:variable>
        <xsl:variable name="GLOBAL_VAR_FluidCacheLicenseState"><xsl:value-of select="//CachePoolLicenseState"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_FluidCacheConnectErrorID"><xsl:value-of select="/OMA/FluidCacheConnectErrorID"/></xsl:variable>
        <xsl:template match="OMA">
            <DataArea onLoad="true">
		<xsl:call-template name="scripts"/>
		<script language="javascript">
        	function initializationRoutine()
                {
                       
                        
		}
 		 function FluidCacheRresh()
                {
	 		  var RefreshUrl= document.URL + "&amp;RefreshFluidCache=true";
        		  document.location.href = top.gnv.appendVID(RefreshUrl);
			    
                            try 
                            {
                                if (parent.ct.g_bModal == false) 
                                 {
                                        parent.ct.g_bModal = true;
                                        parent.ct.location.href=top.gnv.appendVID('./ComponentTree?refresh=true');
                                 }
                             }
                            catch (e){}
                          
                          
     		 }  
             


               </script>
		<PageTitle>
                          <xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="/*/Controllers/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
        	</PageTitle>
        	<CustomButton>
			<Data name="Refresh">
                		<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.FluidCacheInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Return=true&amp;help=fldcach</xsl:attribute>
			</Data>
		</CustomButton>
		
                            <CustomButton align="left">
						<Data formSubmit="true">
							<xsl:attribute name="display"><xsl:value-of select="$strRefreshFluidCache"/></xsl:attribute>
							<xsl:attribute name="href">javascript:FluidCacheRresh()</xsl:attribute>
						</Data>
                            </CustomButton>
                 <xsl:choose>
                      
		
                     <xsl:when test="$GLOBAL_VAR_FluidCacheLicenseState = 'Unknown' or $GLOBAL_VAR_FluidCacheLicenseState = 'unknown'" >
                         
                         <!--SubHeader>
                             <xsl:attribute name="display"><xsl:value-of select="$strPCIeSSDDevices"/></xsl:attribute>
			</SubHeader-->

                         <AlertMessage>
                            <xsl:attribute name="display"><xsl:value-of select="$strFluidCacheNotConnectedError"/></xsl:attribute>
                            <xsl:attribute name="status">1</xsl:attribute>
                        </AlertMessage>
                        <AlertMessage>
                		<xsl:attribute name="display"><xsl:value-of select="$strErrorID243"/></xsl:attribute>
        			<xsl:attribute name="status">1</xsl:attribute>
                        </AlertMessage>
		
                     </xsl:when>
			   <xsl:when test="$GLOBAL_VAR_FluidCacheLicenseState = 'Not Licensed'" >
                         <AlertMessage>
                            <xsl:attribute name="display"><xsl:value-of select="$strFluidCacheNotLicensed"/></xsl:attribute>
                            <xsl:attribute name="status">1</xsl:attribute>
                        </AlertMessage>
		
                     </xsl:when>
	
                     <xsl:otherwise>
                         <xsl:apply-templates select="/*/Controllers/DCStorageObject"/>
                     </xsl:otherwise>
                 </xsl:choose>
		
            </DataArea>
        </xsl:template>
	<!-- Template to display the  objects -->
	<xsl:template match="Controllers/DCStorageObject">
		<ComboData ignoreJumpBar="true">
			<ListData columnspacing="true">
				<xsl:if test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de'))">
					  <xsl:attribute name="extended">true</xsl:attribute>
				</xsl:if>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strSubHeader1"/></xsl:attribute>
					<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
				</SubHeader>
				<xsl:call-template name="FluidCacheInfoTable"/>        
			</ListData>
                        <ListData columnspacing="true">
                                <xsl:call-template name="CachePoolPropertiesTableInfo"/>
                        </ListData>   
                               <xsl:if test="count(../../FluidCachedDisks/DCStorageObject)> 0 ">
                                <TableData columnspacing="true">
                                    <PromptText><xsl:value-of select="$strFluidCacheDiskInfoMessage"/></PromptText>
                                    <SubHeader>
                                        <xsl:attribute name="display"><xsl:value-of select="$strFluidCachedDisks"/></xsl:attribute>
                                    </SubHeader>
                                    <Header>
                                            <xsl:call-template name="FluidCacheDiskTableHeader"/>
						</Header>
                                     <xsl:for-each select="../../FluidCachedDisks/DCStorageObject">
                                              
						     <xsl:call-template name="FluidCacheDiskTableRows"/>
							
						
                                     </xsl:for-each>
                                </TableData>
                                </xsl:if>
  
                                <xsl:if test="count(../../ArrayDisks/DCStorageObject[PartOfCachePool = '1'])> 0 and $GLOBAL_VAR_CACHEPOOL = '1'">
                                <TableData columnspacing="true">
                                    
                                    <PromptText><xsl:value-of select="$strFluidCachePoolPCIeSSDsInfoMessage"/></PromptText>

                                    <SubHeader>
                                        <xsl:attribute name="display"><xsl:value-of select="$strFluidCachePoolPCIeSSDs"/></xsl:attribute>
                                    </SubHeader>
                                    

                                    <Header>
                                    
                                            <xsl:call-template name="ArrayDiskTableHeader">
						<xsl:with-param name="expanded">true</xsl:with-param>
						<xsl:with-param name="changestatus"><xsl:value-of select="/OMA/ChangeStatus"/></xsl:with-param>
					    </xsl:call-template>
				    </Header>
                                            <xsl:for-each select="../../ArrayDisks/DCStorageObject[PartOfCachePool = '1' or PartOfCachePool = '2' or PartOfCachePool = '3']">
                                                <xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:call-template name="ArrayDiskTableRows">
							<xsl:with-param name="expanded">true</xsl:with-param>
							<xsl:with-param name="changestatus"><xsl:value-of select="/OMA/ChangeStatus"/></xsl:with-param>
						</xsl:call-template>
                                            </xsl:for-each>
                                </TableData>
                                </xsl:if>
                                
                                
                        <!-- Add other objects here -->        
		</ComboData>
	</xsl:template>
</xsl:stylesheet>




