<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Fluid Cache Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="fcdtbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<xsl:variable name="HEALTH_STATUS_NON_CRITICAL">3</xsl:variable>	
			
		<script language="javascript">
      function reloadPage()
      {
          document.location.href = top.gnv.appendVID(document.URL);
      }

     
		
		</script>
	
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
            <xsl:variable name="GLOBAL_VAR_VD_Status">
		     <xsl:for-each select="//FluidCachedDisks/DCStorageObject">
			     <xsl:value-of select="TreeStatus"/>
			     <xsl:if test="position() != last()"><xsl:text>;</xsl:text></xsl:if>
		      </xsl:for-each>
	      </xsl:variable>
            <xsl:variable name="Page_component_status"><xsl:value-of select="$GLOBAL_VAR_VD_Status"/></xsl:variable>
            


              
		<DataArea onLoad="true">
			<xsl:call-template name="scripts"/>
			<script language="javascript">
				function initializationRoutine()
				{
					

				}
			</script>
			<PageTitle>
							
						
						<xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
                                     
					
 
			</PageTitle>
                  
                          <xsl:if test = "CacheStoreCount = '1' and count(FluidCachedDisks/DCStorageObject[CacheLunMode = '0'])> 0">
                                 <AlertMessage ignoreoncli="true">
                                            <xsl:attribute name="display"><xsl:value-of select="$strFluidCacheDisksWriteBackWarning"/></xsl:attribute>
                                            <xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>

                                 </AlertMessage>
                          </xsl:if>
                          <xsl:if test = "CacheStoreCount = '0' and count(FluidCachedDisks/DCStorageObject[CacheLunMode = '0' or CacheLunMode = '1'])> 0">
                                 <AlertMessage ignoreoncli="true">
                                            <xsl:attribute name="display"><xsl:value-of select="$strFluidCacheDisksPassWarning"/></xsl:attribute>
                                            <xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>

                                 </AlertMessage>
                          </xsl:if>
                 
                <CustomButton>
			
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.FCDInfoWebPlugin&amp;&amp;help=fldcdsk</xsl:attribute>
				</Data>
			</CustomButton>
			
			
			<xsl:call-template name="FluidCacheDiskTable">
				<xsl:with-param name="tasks">
					<xsl:value-of select="$checkAdmin"/>
				</xsl:with-param>
			</xsl:call-template>
		</DataArea>
	</xsl:template>
	
     <xsl:template name="FluidCacheDiskTable">
		<xsl:param name="tasks"/>
           <xsl:choose>
                      <xsl:when test="count(FluidCachedDisks/DCStorageObject)>0"> 
                           <xsl:if test="FluidCachedDisks/DCStorageObject/Progress">
	                         <HTMLData>
	                                  <script language="Javascript">
	                                  	<!--refresh page every 30secs when there is atleast one object with Progress associated with it -->
	                                          setTimeout("reloadPage()",30000);
	                                  </script>
	                         </HTMLData>
	                     </xsl:if>
                             <TableData columnspacing="true">
                                    
					      <SubHeader>
                                            <xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
                                     
					      </SubHeader>
                                    
                                     <PromptText><xsl:value-of select="$strFluidCacheDiskInfoMessage"/></PromptText> 
					      <Header>
                                          
						     <xsl:call-template name="FluidCacheDiskTableHeader">
							<xsl:with-param name="tasks"><xsl:value-of select="$tasks"/></xsl:with-param>
             					</xsl:call-template>
					      </Header>
                                        
                                 <xsl:for-each select="FluidCachedDisks/DCStorageObject">
  						     <xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
                                     		<xsl:call-template name="FluidCacheDiskTableRows">
									<xsl:with-param name="tasks"><xsl:value-of select="$tasks"/></xsl:with-param>
                                                      <xsl:with-param name="caller">">./DataArea?plugin=com.dell.sm.webplugins.FCDInfoWebPlugin!help=fldcdsk</xsl:with-param>
							     </xsl:call-template>
						 </xsl:for-each>
                              </TableData>
                         
                      </xsl:when>
                      <xsl:otherwise>
					<AlertMessage ignoreoncli="true">
				 		<xsl:attribute name="display"><xsl:value-of select="$strNoFluidCacheDisks"/></xsl:attribute>
					</AlertMessage>
				</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>

