<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template name="getDSAScripts">
		<!-- This template is a list of javascript functions specific to DSA. -->
		 
		<!-- The following javascript functions are used to simplify using the DSA javascript 
		caching mechanism which is used in OMSS Lite to cache the values entered by the user 
		in the create VD wizard pages.
		-->
		 
		<!-- 
		This parameter is the name of the page which is being cached. It is used as a hash key in 
		the DSA cache table. 
		-->
		<xsl:param name="PARAM_Screen_Name"/>
		
		<!-- This parameter is the URL of the previous page. -->
		<xsl:param name="PARAM_Prev_Page_URL"/>
		
		<!-- This parameter is the URL of the next page. -->
		<xsl:param name="PARAM_Next_Page_URL"/>
		
		<!-- This parameter is the URL to execute when we want to exit the create VD wizard. -->
		<xsl:param name="PARAM_Exit_Wizard_URL"/>

		<!--
		This function empties any existing cached values for the current page and then saves
		the latest values by calling the DSA caching function. It is invoked by the previous, 
		next and exit wizard functions below. It can also be called standalone in any custom
		javascript function.
		-->
		function cachePageInDSA() {
			<!-- Get latest GUI state -->
			var initialData = cacheGUIDataOnBack ();
			var pagename = replaceString ('<xsl:value-of select="$PARAM_Screen_Name"/>' , ' ' , '-' , false);

			<!-- Clear cache for page if it already exists -->
			if (gnavObj.collection.exists (pagename)){
				gnavObj.collection.remove (pagename);
			}

			<!-- Cache the current state of the page -->
			if (initialData != null){
				gnavObj.collection.add (pagename, initialData);
			}
		}
		
		<!--
		This function caches the latest values and then invokes the DSA function to go to the specified
		previous page URL.
		-->
		function goToPreviousPageInDSA() {
			cachePageInDSA();
			goToPreviousPage("<xsl:value-of select="$PARAM_Prev_Page_URL"/>");
		}
		
		<!--
		This function caches the latest values and then executes the next page URL.
		If validation is needed, a custom javascript function should be used.
		-->
		function goToNextPageInDSA() {
			cachePageInDSA();
			
			document.dataarea.action = top.getFrame("OMA_gnv").appendDataAreaVID("<xsl:value-of select="$PARAM_Next_Page_URL"/>");
			document.dataarea.submit();
		}
		
		<!--
		This function caches the latest values and then calls the exit wizard URL.
		-->
		function exitWizardInDSA() {
			cachePageInDSA();
			document.dataarea.action = top.getFrame("OMA_gnv").appendDataAreaVID("<xsl:value-of select="$PARAM_Exit_Wizard_URL"/>");
			document.dataarea.submit();
		}
	</xsl:template>
</xsl:stylesheet>
