<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<!-- Declare Global variables and parameters-->
	<xsl:variable name="GLOBAL_PARAM_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="GLOBAL_PARAM_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Length"><xsl:value-of select="/OMA/Length"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_IDList"><xsl:value-of select="/OMA/IDList"/></xsl:variable>
    <xsl:variable name="GLOBAL_PARAM_SecureFlag"><xsl:value-of select="/OMA/SecureFlag"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_VdPIEnabled"><xsl:value-of select="/OMA/VdPIEnabled"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_UseMaxSize"><xsl:value-of select="/OMA/UseMaxSize"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_GetCapsMinLength"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/MinimumLength"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_GetCapsMaxLength"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/Length"/></xsl:variable>
        <xsl:variable name="GLOBAL_PARAM_Oslimit"><xsl:value-of select="//Controllers//DCStorageObject/MaxOsLimitForLogicalDriveSize"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_SpanLengthList"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/SpanLengthList"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_SpanDepth"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/SpanDepth"/></xsl:variable>

      <xsl:variable name="GLOBAL_PARAM_ShowMultipleRAIDLevelWarn">
		<xsl:if test="//CapsArrayDisksInfo/DCStorageObject/Layout">
			<xsl:for-each select="//CapsArrayDisksInfo/DCStorageObject[Layout != 0 and Layout != $GLOBAL_PARAM_Layout]">
				<xsl:sort select="Channel" data-type="number" order="ascending"/>
				<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
				<xsl:sort select="TargetID" data-type="number" order="ascending"/>
				<xsl:if test="Layout != 0 and Layout != $GLOBAL_PARAM_Layout">
                                        <xsl:if test="position() != 1"> <xsl:text>, </xsl:text></xsl:if>
					<xsl:choose>
						<xsl:when test="EnclosureID">
							<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
						</xsl:otherwise>
					</xsl:choose>
				        
				</xsl:if> 

			</xsl:for-each>
		</xsl:if>
	</xsl:variable>

	<xsl:variable name="GLOBAL_VAR_SpanLength">
		<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_Layout"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/SpanLength"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
    </xsl:variable>
    <!-- Usability#17) Default selections not apparent to the user in Express Wizard -->
    <xsl:variable name="GLOBAL_VAR_DefaultReadPolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultReadPolicy"/>
    </xsl:variable>
    <xsl:variable name="decimalreadpolicy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultReadPolicy"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_DefaultWritePolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultWritePolicy"/>
    </xsl:variable>
    <xsl:variable name="decimalwritepolicy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultWritePolicy"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="GLOBAL_VAR_DefaultStripeSize">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultStripeSize"/>
    </xsl:variable>
    <xsl:variable name="decimalstripesize">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultStripeSize"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_DefaultCachePolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultCachePolicy"/>
    </xsl:variable>
    <xsl:variable name="decimalcachepolicy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultCachePolicy"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_DefaultDiskCachePolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultDiskCachePolicy"/>
    </xsl:variable>
    <xsl:variable name="decimaldiskcachepolicy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultDiskCachePolicy"/>
      </xsl:call-template>
    </xsl:variable>
    <!--End of variable declaration for Usability #17-->
    
	<xsl:variable name="GLOBAL_VAR_ControllerAttributesMask"><xsl:value-of select="/OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ReturnUrlHREFValue">
		<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_Rules='1'">./DSASwitch</xsl:when>
			<!-- %26 is escape character for &-->
			<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_OrigURL"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Screen_Name">cvdesum_<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/>_<xsl:value-of select="$GLOBAL_PARAM_Layout"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Prev_Page_URL">./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedRaidLayoutSelectionWebPlugin&amp;OrigURL=<xsl:value-of select="$GLOBAL_PARAM_OrigURL"/>&amp;ControllerOID=<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$GLOBAL_PARAM_ControllerName"/>&amp;Rules=<xsl:value-of select="$GLOBAL_PARAM_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$GLOBAL_PARAM_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$GLOBAL_PARAM_OutputFileName"/>&amp;Layout=<xsl:value-of select="$GLOBAL_PARAM_Layout"/>&amp;&amp;Minosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Maxosdrivesize"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$GLOBAL_PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$GLOBAL_PARAM_IsAnyAdiskForeign"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Next_Page_URL">./SubmitForm?plugin=com.dell.sm.webplugins.SubmitCreateVDExpressSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="$GLOBAL_PARAM_OrigURL"/>&amp;ControllerOID=<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$GLOBAL_PARAM_ControllerName"/>&amp;Layout=<xsl:value-of select="$GLOBAL_PARAM_Layout"/>&amp;ReadPolicy=<xsl:value-of select="$decimalreadpolicy"/>&amp;WritePolicy=<xsl:value-of select="$decimalwritepolicy"/>&amp;CachePolicy=<xsl:value-of select="$decimalcachepolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$decimaldiskcachepolicy"/>&amp;IDList=<xsl:value-of select="$GLOBAL_PARAM_IDList"/>&amp;SecureFlag=<xsl:value-of select="$GLOBAL_PARAM_SecureFlag"/>&amp;VdPIEnabled=<xsl:value-of select="$GLOBAL_PARAM_VdPIEnabled"/>&amp;FILE=<xsl:value-of select="//FILE"/>&amp;Rules=<xsl:value-of select="$GLOBAL_PARAM_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$GLOBAL_PARAM_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$GLOBAL_PARAM_OutputFileName"/>&amp;URL=<xsl:value-of select="$GLOBAL_VAR_ReturnUrlHREFValue"/>&amp;Force=1&amp;SpanLength=<xsl:value-of select="$GLOBAL_VAR_SpanLength"/>&amp;UseMaxSize=<xsl:value-of select="$GLOBAL_PARAM_UseMaxSize"/>&amp;Minosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Maxosdrivesize"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$GLOBAL_PARAM_ClearForeignConfigEnable"/>&amp;SpanLengthList=<xsl:value-of select="$GLOBAL_VAR_SpanLengthList"/>&amp;SpanDepth=<xsl:value-of select="$GLOBAL_VAR_SpanDepth"/>&amp;ForeignAdiskFound=<xsl:value-of select="$GLOBAL_PARAM_IsAnyAdiskForeign"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_Rules='1'">./DSASwitch?exitRAID=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($GLOBAL_PARAM_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_EnhanceDHSMask" select="/OMA/Controllers/DCStorageObject/AttributesMask"/>
	<!--main entry point into this XSL-->
	<xsl:template match="/OMA">
		<DataArea onLoad="true" nosubmitfordsa="true" validate="true" printable="false" exportdata="false" email="false" ignoreJumpBar="true">
			<xsl:attribute name="submitdisplay">
				<xsl:choose>
					<xsl:when test="$GLOBAL_PARAM_Rules='1'"><xsl:value-of select="$strContinueCVDES"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strFinishCVDES"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>

			<!--Devendra 7/20/06: CR12532-->
			<xsl:if test="$GLOBAL_PARAM_Rules != '1'">
				<!-- OMSS invokes all URLs directly using canceltarget, backpagetarget and submit. -->
				<xsl:attribute name="cancel">true</xsl:attribute>
				<xsl:attribute name="canceltarget"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
				<xsl:attribute name="canceldisplay"><xsl:value-of select="$strCancelCVDES"/></xsl:attribute>
				<xsl:attribute name="backpagetarget"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:attribute>
				<xsl:attribute name="submit"></xsl:attribute>
			</xsl:if>

			<!--Devendra 7/20/06: CR12532-->
			<xsl:if test="$GLOBAL_PARAM_Rules = '1'">
				<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
				<!-- In DSA mode, we want to enable the DSA caching mechanism so storeonback and screenname are defined. -->
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
				
				<!--
				OMSS Lite uses the DSA caching javascript functions to go back, forward or exit.
				
				Buttons are used for DSA instead of canceltarget and submit since those attributes don't
				let us execute custom javascript actions. They only allow you to specify URLs. Backpagetarget
				does allow javascript functions.
				-->
				<xsl:attribute name="backpagetarget">javascript:goToPreviousPageInDSA();</xsl:attribute>
				<BottomCustomButton>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strContinueCVDES"/></xsl:attribute>
						<xsl:attribute name="href">javascript:submitCreateVDExpressSummary();</xsl:attribute>
						<!-- DF111388 : Prevent DSA from disabling buttons on submit. We will do it ourselves if validation returns true. -->
						<xsl:attribute name="disablerestrictmulcall">true</xsl:attribute>
					</Data>
				</BottomCustomButton>
				<BottomCustomButton>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDES"/></xsl:attribute>
						<xsl:attribute name="href">javascript:exitWizardInDSA();</xsl:attribute>
					</Data>
				</BottomCustomButton>
			</xsl:if>

			<xsl:variable name="warnDHSMsg">
				<xsl:choose>
					<xsl:when test="($GLOBAL_PARAM_Layout != '2') and (substring($GLOBAL_VAR_ControllerAttributesMask,5,1) != '1') and (count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject) != 0)">yes</xsl:when>
					<xsl:otherwise>no</xsl:otherwise>
				</xsl:choose>				
			</xsl:variable>
            
			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:if test="$GLOBAL_PARAM_Rules='1'">
					<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Prev_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Next_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</script>

			<script language="javascript">
                                                     var JS_GLOBAL_MaxNumChannels=2;
				var JS_GLOBAL_MaxNumEnclosures = 4;
				var JS_GLOBAL_MaxNumTargets=32;
				var JS_GLOBAL_LayoutValue=<xsl:value-of select="$GLOBAL_PARAM_Layout"/>;
                                                      var ArrayDisks_Counter = 0;
                var enhanceDHSMask = "<xsl:value-of select="substring($GLOBAL_VAR_EnhanceDHSMask,10,1)"/>";                      
				function initializationRoutine() { 
                    
                                                                   hideSelectionTable();
                                                                  <!-- DSA uses different function to append VID -->
					var rules = "<xsl:value-of select="$GLOBAL_PARAM_Rules"/>";
					if (rules == "1")
					{
						top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
					}
                                                var minSizeInGB ="<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMinLength div (1024*1024*1024)),'###0.00')"/>";
						var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
						setValueForMinField(minSizeInGB );
						setValueForMaxField(maxSizeInGB );
						setInputVDSizeValue(maxSizeInGB );
						enableInputVDSizeField();  
				
                                                                 <!--get the first channel that has enclosure attached to it-->
				  var channelNum = getDefaultChannelSelectionRadioButtonIndex();
				  <!--show selection table with array disks attached to default channel identified-->
                                                                 if(channelNum!=-1)
                                                                 {  
                                                                             showSelectionTable(channelNum);
                                          
                                                                  }     
                                                                 <!--Below set the default channel selection radio button-->
                                                                 setDefaultChannelSelectionRadioButton();
				       
                                                                 <!--Below disable the Channel radio buttons that do not contain ArrayDisks-->
                                                                 disableChannelSelectionRadioButtonsWithNoArrayDisks();
                                }
                                
                                function ValidateInputs()
                                {
                                
                                   if(IsInputSizeForVDSpecified()==false)
					{
						HandleInputSizeNotSpecifiedError();
						RestoreInputSizeFieldToMaxValueInAdvWizard();
						return false;
					}
					if(IsInputSizeForVDNaN()==true)
					{
						HandleInputSizeNotANumberError();
						RestoreInputSizeFieldToMaxValueInAdvWizard();
						return false;
					}
					if(IsInputSizeForVDWithinRangeForAdvanced()==false)
					{
						HandleInputSizeRangeErrorForAdvanced();
						return false;
					}
                                       
					if( isValidNameValue(getInputVDNameValue())==false)
					{
						RestoreInputNameFieldToBlank();
						return false;
					}
					if ( HandleInputSizeGreaterThanOsLimitAdvanced() == false )
					{
						return false;
					}
					return true;
                                }
                                 function isValidNameValue(text)
			        {
				var validchars = /^[a-zA-Z0-9_ -]*$/;
				if( validchars.test(text))
				{

					// cannot start or end with a space.
					if(/^ /.test(text) || / $/.test(text))
					{
					   alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strStartSpace"/>");
					   return false
					}

					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidString"/>");
				return false;
			       }
                                function IsInputSizeForVDWithinRangeForAdvanced()
				{
					//var layoutValue = '<xsl:value-of select="$GLOBAL_PARAM_Layout"/>';
					
					var sizeValue=getInputVDSizeValue();
					<!--var minSizeInBytes  = '<xsl:value-of select="//ExpressResults//DCStorageObject/MinimumLength"/>';
					var maxSizeInBytes = '<xsl:value-of select="//ExpressResults//DCStorageObject/Length"/>';-->
					//var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					//var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					<!--var maxSizeInGB = FormatNumber(maxSizeInBytes/(1024*1024*1024),2,"true");
					var minSizeInGB = FormatNumber(minSizeInBytes/(1024*1024*1024),2,"true");-->
					var minSizeInGB ="<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMinLength div (1024*1024*1024)),'###0.00')"/>";
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					
					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var minSizeInGBDecFormat = parseFloat(ConvertToDecValString(minSizeInGB));
					var maxSizeInGBDecFormat = parseFloat(ConvertToDecValString(maxSizeInGB));
					
                                       
					<!--if(minSizeInBytes == maxSizeInBytes || maxSizeInGBDecFormat  == sizeValueDecFormat )
					{
                                                document.getElementById("VDSize").value = maxSizeInBytes; // parseInt(sizeValueDecFormat *1024*1024*1024);
						return true;
					}
					else -->
					
					if( minSizeInGBDecFormat &lt;= sizeValueDecFormat  &amp;&amp; sizeValueDecFormat  &lt;= maxSizeInGBDecFormat )
					{
						//document.getElementById("VDSize").value = parseInt(sizeValueDecFormat *1024*1024*1024);
					
						
                                                return true;
					}
					else
					{
						return false;
					}
				}
                                function RestoreInputSizeFieldToMaxValueInAdvWizard()
				{
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					document.getElementById(getElementNameForVDSize()).value=maxSizeInGB ;
				}
                                
                                function HandleInputSizeRangeErrorForAdvanced()
				{
					var alertInvalidSizeMsg = "<xsl:value-of select="$strInvalidSizeCVDASS"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + alertInvalidSizeMsg);
					<!-- Next reset value of size field to max size value-->
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					document.getElementById(getElementNameForVDSize()).value=maxSizeInGB ;
				}
                                
                                function HandleInputSizeGreaterThanOsLimitAdvanced()
				{
					var sizeValue = getInputVDSizeValue();
					var osLimitValueinGB = "<xsl:value-of select="format-number($GLOBAL_PARAM_Oslimit div (1024*1024*1024), '###0.00')"/>";
					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var osLimitValueDecFormat = parseFloat(ConvertToDecValString(osLimitValueinGB));

					if ( sizeValueDecFormat &gt; osLimitValueDecFormat)
					{
						<!-- This means that the virtual disk size is greater than the os limit-->
						if (confirm ("<xsl:value-of select="$strOsLimitWarn"/>"))
						{
							return true;
						}
						else
						{
							return false;
						}
					}
					else
					{
						return true; 
					}
				}
				function validate()
				{
					var rules = "<xsl:value-of select="$GLOBAL_PARAM_Rules"/>";
					var dsaWarnMsg = "<xsl:value-of select="$strDSAWarnVdisksWillBeLostCVDES"/>";
					<!-- AS: DF54548: Update pop-up mesg to indicate clearing the foreign configuration    -->
					var frgnFlag="<xsl:value-of select="$GLOBAL_PARAM_ClearForeignConfigEnable"/>";
					var frgnconfigWarnMsg = "<xsl:value-of select="$strDSAWarnVdisksFrgnDriveWillBeLostCVDES"/>";
                                        
                                        if(ValidateInputs()==false)
                                        {     	
                                            var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
							  document.getElementById(getElementNameForVDSize()).value=maxSizeInGB ;

							 return false;
                                         }
					if (frgnFlag=="1")
					{
						if(rules=="1" &amp;&amp; !confirm(frgnconfigWarnMsg))
							return false;
					}
					else 
					{
						if(rules=="1" &amp;&amp; !confirm(dsaWarnMsg))
							return false;
					}
					<!-- :Chethan 06/10/04 Fixed defect DFCT 129664: We are already displaying a pop-up message saying all the existing
					virtual disks will be deleted. We don't need an additional pop-up message-->
					<!--var isRaidIM = "<xsl:call-template name="IsRaidIntegratedMirror"><xsl:with-param name="AttributesMask" select="$GLOBAL_VAR_ControllerAttributesMask"/></xsl:call-template>";
					var msg = "<xsl:value-of select="$strConfirmMsgForIMCreation"/>";
					if(isRaidIM==1 &amp;&amp; !confirm(msg)) if PERC 4 IM controller and user says no to reboot, return false
						return false;-->
                                        
					document.dataarea.action = top.gnv.appendVID("<xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/>" + "&amp;VDSize="+getVDSize());
                       if ('<xsl:value-of select="$warnDHSMsg"/>' == 'yes')
                       {
					      if ((enhanceDHSMask == '1'  &amp;&amp; getHSDIDList() == '') || (enhanceDHSMask != '1' &amp;&amp; (document.getElementById("HSDIDList") == null || document.getElementById("HSDIDList").checked == false)))
					      {
						   return confirm("<xsl:value-of select="$strDHSNotAssignMsg"/>");
					      } 
                       }
                    
					
					if( rules!="1") {
						disableButtons("submit","back" ,"cancel");
					} else {
						<!-- DF111388 : Disable buttons when validation is successful. -->
						setDisableFlag();
						disableSubmitButton()
					}

        return true;
        }
        function submitCreateVDExpressSummary() 
        {
              cachePageInDSA();
               
                if (validate()) 
                 { 
                         document.getElementById("IMIDList").value =
                         document.getElementById("CreateSecureVD").value = 
		         
                         document.dataarea.action = top.gnv.appendVID("<xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/>");
 			 document.dataarea.submit();
                 }
	}
	
	
	function getVDSize() {
		var vdSize;
		var layoutValue = '<xsl:value-of select="$GLOBAL_PARAM_Layout"/>';
					
		var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
		var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
				
		var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";			
		var sizeValueDecFormat = parseFloat(ConvertToDecValString(getInputVDSizeValue()));			
		var maxSizeInGBDecFormat = parseFloat(ConvertToDecValString(maxSizeInGB));
				   
		if(minSizeInBytes == maxSizeInBytes || maxSizeInGBDecFormat  == sizeValueDecFormat )
		{
			vdSize = maxSizeInBytes; 				
		}else{
			vdSize = parseInt(sizeValueDecFormat *1024*1024*1024);
		}
		
		return vdSize;
	}	
                            
        function getHSDIDList() {
                                
             var selectedHSDIDList = "";
             var counter =0;
             var resval="";
             for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
	     {
		 for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
		 {
			for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
			{
                              var elemName="Sel"+i.toString()+k.toString()+j.toString();
                              if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).checked == true)
                              {
                                  resval = document.getElementById(elemName).value;
                                  if(counter == 0)
	                          {
                                      selectedHSDIDList = resval;
				  }
                                  else
				  {
                                      selectedHSDIDList = selectedHSDIDList + ":"+resval;
			          }
				  counter++;
                               }
                          }
                   }
                }
                document.getElementById("HSDIDList").value = selectedHSDIDList;
                return selectedHSDIDList;
            }                   
       
			        <!--This function is a handler that is called in response to a channel selection-->
			        function OnChannelSelected()
			        {
                                        hideSelectionTable();
				        var RadioArray = document.getElementsByName("ChannelButton");
				        for(var i=0;i&lt;RadioArray.length;i++)
				        {
					     if(RadioArray [i].checked)
					     {
						showSelectionTable(i);
						break;
					      }
				        }
			        }
			
                
                                <!--This function hides all the rows in the selection table-->
				function hideSelectionTable()
				{
					var elemName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						if(document.getElementById("parentrow_"+"Sel"+i.toString())!=null)
						{
							document.getElementById("parentrow_"+"Sel"+i.toString()).style.display="none";
						}
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							elemName = "parentrow_"+"Sel"+i.toString()+k.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none";
							}
							for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
							{
								elemName = "parentrow_"+"Sel"+i.toString()+k.toString()+j.toString();
								if(document.getElementById(elemName) != null)
								{
									document.getElementById(elemName).style.display="none";
								}
							}
						 }
					}
				}
              
                                <!--This funtion displays all the rows associated with channel 'i'-->
				function showSelectionTable(i)
				{
					for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					{
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{
							elemName="parentrow_"+"Sel"+i.toString()+k.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById("parentrow_"+"Sel"+i.toString()+k.toString()).style.display="";
								document.getElementById("parentrow_"+"Sel"+i.toString()+k.toString()+j.toString()).style.display="";
							}
						}
					}
				}
                                
			        <!--This function returns the index of the default channel selected from the array of channels-->
			        function getDefaultChannelSelectionRadioButtonIndex()
			        {
				        var RadioArray = document.getElementsByName("ChannelButton");
				        for(var i=0;i&lt;RadioArray.length;i++)
				        {			
					      for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					      {
						var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
						    if(document.getElementById(elemName) != null)
						    {
							return i;
						    }
					      }
				        }
				         return -1;<!--failure-->
			        }
                   
         			<!--This function selects and sets the default channel-->
			        function setDefaultChannelSelectionRadioButton()
			        {
				        var found=false;
				        var RadioArray = document.getElementsByName("ChannelButton");
				        for(var i=0;i&lt;RadioArray.length;i++)
				        {
					      if(found == false)
					      {
						for(var e=0;e&lt;RadioArray.length;e++)
						{							
							var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
							if(document.getElementById(elemName) != null)
							{							
								RadioArray[i].checked=true;
								found=true;
								break;
							}
						}
					     }
				        }
			        }

			        <!--This function disables the channel radio buttons that do not have any array disks attached-->
			        function disableChannelSelectionRadioButtonsWithNoArrayDisks()
			        {
  				        var RadioArray = document.getElementsByName("ChannelButton");
					for(var i=0;i&lt;RadioArray.length;i++)
				        {
					    var ArrayDisks = 0;
					    for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					    {     
						var elemName="parentrow_Sel"+i.toString()+e.toString();
                                                if(document.getElementById(elemName) != null)
						{     
							ArrayDisks = 1;
						}
					    }
                                      
					    if (ArrayDisks == 0)
					    {
				                RadioArray[i].disabled=true;
					    }
				        }
			        }

                                function OnArrayDiskSelected(channel,encl,target)
			        {
                                        var chkBxName = "Sel"+channel.toString()+encl.toString()+target.toString();
                                        var JS_MaxNumberArrayDisks = 16;
                                        if(document.getElementById(chkBxName).checked==true)
                                        {
                                            ArrayDisks_Counter++;
                                            if(ArrayDisks_Counter == JS_MaxNumberArrayDisks)
                                            {
                                              disableUnselectedCheckBoxes();
                                            }
                                        }
                                        else
                                        {     
                                              ArrayDisks_Counter--;
                                              enableAllCheckBoxes();
                                        }
		                }   
                                
                                <!--This function disable all checkboxes that are not checked-->
				function disableUnselectedCheckBoxes()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
							{
								if( isArrayDiskSelected(i.toString(), k.toString(), j.toString()) == false )
								{
									disableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
								}
							}
						}
					}
				}
                                
                                <!-- This function returns true if the given single array disk selection check box is checked, 
                                     else returns false-->
				function isArrayDiskSelected(channel, enclosureId, targetId)
				{
					var elemName="Sel"+channel.toString()+enclosureId.toString()+targetId.toString();
					if(document.getElementById(elemName) != null)
					{
						return document.getElementById(elemName).checked;
					}
					return false;
				}
                                
                                <!--This function disables a single array disk selection check box-->
				function disableArrayDiskCheckBox(channel, enclosureId, targetId)
				{
					var elemName="Sel"+channel.toString()+enclosureId.toString()+targetId.toString();
					if(document.getElementById(elemName) != null)
					{
						document.getElementById(elemName).disabled=true;
					}
				}
                                
                                <!--This function enables all array disk selection check boxes-->
				function enableAllCheckBoxes()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
							{
								enableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
							}
						}
					}
				}
                                
                                <!--This function enables a single array disk selection check box-->
				function enableArrayDiskCheckBox(channel, enclosureId, targetId)
				{
					var elemName="Sel"+channel.toString()+enclosureId.toString()+targetId.toString();
					if(document.getElementById(elemName) != null)
					{
						document.getElementById(elemName).disabled=false;
					}
				}
				
			</script>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartCVDES"/><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/><xsl:value-of select="$strTitleMainEndCVDES"/></xsl:attribute>
			</PageTitle>
			<TableData name="T1" display="{$strVDAttribTableCVDES}">
				<SubHeader><xsl:attribute name="display"><xsl:value-of select="$strVDAttribPromptTextCVDES"/></xsl:attribute></SubHeader>
				<Header><Data value="{$strAttributeCVDES}" width="400"/><Data value="{$strValueCVDES}"/></Header>
                                <Row>
					<Data value="{$strNameCVDES}" name="Name"/>
					
                                        <Data name="VDName" type="editbox" colspan="1"  maxlength="15" returnvalue="0"/>
				</Row>
                                <Row>
					<Data value="{$strSizeCVDES}" name="Size"/>
					<Data name="VDSize" type="editbox" colspan="1" maxlength="7" returnvalue="0">
						<xsl:attribute name="unit"><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute></Data>
				</Row>
                                
                                <Row>
					<Data name="Min" value="{$strMinSizeZeroCVDU}" />
					<Data name="Max" value="{$strMaxSizeZeroCVDU}" />
				</Row>
				<Row>
					<Data value="{$strTypeCVDES}" name="RaidLevel"/>
					<Data name="RaidLevelValue">
						<xsl:attribute name="value">
							<!--The Template in Utils.xsl is called below/-->
							<xsl:call-template name="GetRaidLayout">
								<xsl:with-param name="RaidType">
									<xsl:value-of select="Layout"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>
				
                        <xsl:if test="/OMA/SecureFlag = '1' ">
                        <Row>
					<Data value="{$strSecuredVirtualDisk}" name="SecureVD"/>
					<Data name="SecureVDValue">
                                 <xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
                              </Data>
				</Row>
                 </xsl:if>
				<xsl:if test="/OMA/VdPIEnabled = '1' ">
                        <Row>
					<Data value="{$strT10PICapable}" name="T10PIInformation"/>
					<Data name="VdPIEnabledValue">
                                 <xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
                              </Data>
				</Row>
                        </xsl:if>
				
				<Row>
					<Data value="{$strType}" name="Protocol"/>
					<Data name="ProtocolValue">
						<xsl:attribute name="value">
							<!--The Template in Utils.xsl is called below/-->
							<xsl:call-template name="GetBusProtocol">
								<xsl:with-param name="Bus">
									<xsl:value-of select="//CapsArrayDisksInfo/DCStorageObject/BusProtocol"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>
				
				
				
				
        <!-- Usability Report#17-->
        <!-- show StripeSize if either: it has not been specified (previous behavior) or it was sent by getcaps as value 0. -->
	      <xsl:if test="not (/OMA/ExpressResults/DCStorageObject/StripeSize) or /OMA/ExpressResults/DCStorageObject/StripeSize != '0'">
        <Row>
          <Data value="{$strStripeSize}" name="StripeSize"/>
          <Data name="StripeSize">
            <xsl:attribute name="value">
              <!--The Template in Utils.xsl is called below/-->
              <xsl:call-template name="GetStripeSize">
                <xsl:with-param name="stripesize">
                  <xsl:value-of select="$decimalstripesize"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:attribute>
          </Data>
        </Row>
	      </xsl:if>
        <Row>
          <Data value="{$strReadCache}" name="ReadPolicy"/>
          <Data name="ReadPolicy">
            <xsl:attribute name="value">

            <xsl:choose>
               <xsl:when test="/OMA/ExpressResults/DCStorageObject/ReadPolicy != ''">
                    <!--The Template in Utils.xsl is called below/-->
                    <xsl:call-template name="GetReadPolicy">
                      <xsl:with-param name="readpolicy">
                        <xsl:value-of select="/OMA/ExpressResults/DCStorageObject/ReadPolicy"/>
                      </xsl:with-param>
                    </xsl:call-template>
               </xsl:when>
               <xsl:otherwise>
              <!--The Template in Utils.xsl is called below/-->
              <xsl:call-template name="GetReadPolicy">
                <xsl:with-param name="readpolicy">
                  <xsl:value-of select="$decimalreadpolicy"/>
                </xsl:with-param>
              </xsl:call-template>
               </xsl:otherwise>
            </xsl:choose>

            </xsl:attribute>
          </Data>
        </Row>
        <Row>
          <Data value="{$strWriteCache}" name="WritePolicy"/>
          <Data name="WritePolicy">
            <xsl:attribute name="value">

            <xsl:choose>
               <xsl:when test="/OMA/ExpressResults/DCStorageObject/WritePolicy != ''">
                    <!--The Template in Utils.xsl is called below/-->
                    <xsl:call-template name="GetWritePolicy">
                      <xsl:with-param name="writepolicy">
                        <xsl:value-of select="/OMA/ExpressResults/DCStorageObject/WritePolicy"/>
                      </xsl:with-param>
                    </xsl:call-template>
               </xsl:when>
               <xsl:otherwise>
              <!--The Template in Utils.xsl is called below/-->
              <xsl:call-template name="GetWritePolicy">
                <xsl:with-param name="writepolicy">
                  <xsl:value-of select="$decimalwritepolicy"/>
                </xsl:with-param>
              </xsl:call-template>
               </xsl:otherwise>
            </xsl:choose>

            </xsl:attribute>
          </Data>
        </Row>
        <xsl:if test = "$GLOBAL_VAR_DefaultCachePolicy!=''" >
          <Row>
            <Data value="{$strCachePolicy}" name="CachePolicy"/>
            <Data name="CachePolicy">
              <xsl:attribute name="value">
                <xsl:call-template name="GetCachePolicy">
                  <xsl:with-param name="cachepolicy">
                    <xsl:value-of select="$decimalcachepolicy"/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
            </Data>
          </Row>
        </xsl:if>
        <xsl:if test = "$GLOBAL_VAR_DefaultDiskCachePolicy!=''" >
          <Row>
            <Data value="{$strDiskCachePolicy}" name="DiskCachePolicy"/>
            <Data name="DiskCachePolicy">
              <xsl:attribute name="value">
                <xsl:call-template name="GetDiskCachePolicy">
                  <xsl:with-param name="DiskCachePolicy">
                    <xsl:value-of select="$decimaldiskcachepolicy"/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
            </Data>
          </Row>
        </xsl:if>

        <!--end of usability CR #17-->
      </TableData>
			<TableData name="T2" display="{$strArrayDiskTableCVDES}">
				<SubHeader><xsl:attribute name="display"><xsl:value-of select="$strADSelectedPromptTextCVDES"/></xsl:attribute></SubHeader>
				<Header><Data value="{$strArrayDiskCVDES}" width="400"/><Data value="{$strFreeSpaceCVDES}"/><Data/></Header>
				<xsl:for-each select="//CapsArrayDisksInfo/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					<xsl:call-template name="RenderSelectedArrayDiskRow"/>
				</xsl:for-each>
			</TableData>
			
			<xsl:if test="$GLOBAL_PARAM_ShowMultipleRAIDLevelWarn != ''">	
				<AlertMessage status="3">
		    			<xsl:attribute name="display"><xsl:value-of select="$strDataWarningLevel6"/><xsl:value-of select="$GLOBAL_PARAM_ShowMultipleRAIDLevelWarn"/></xsl:attribute>
				</AlertMessage>
			</xsl:if>
			
			<!-- CR69634 : Hotspare selection in Create VD -->
            <xsl:if test="$GLOBAL_PARAM_Layout != '2'">
			<xsl:choose>
			<xsl:when test="//DHSAvailDisks">
                     <xsl:choose>
			         <xsl:when test="substring($GLOBAL_VAR_EnhanceDHSMask,10,1)='1'">
                           <SelectionData multitable="false" image="none">
		                            <SubHeader><xsl:attribute name="display"><xsl:value-of select="$strHSAssignHotspareCVDES"/></xsl:attribute></SubHeader>
			                        <xsl:if test="/OMA/ExpressResults/DCStorageObject/HSCountViolated and /OMA/ExpressResults/DCStorageObject/HSCountViolated != 0">
				                           <PromptText alert="true"><xsl:value-of select="$strCVDPolicyMsg"/><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/HSCountViolated"/></PromptText>
			                        </xsl:if>
                            <SelectionTable>
                                <Header>
                                    <xsl:value-of select="$strHSAssignHotspareCVDES"/>
                                       	<xsl:for-each select="Channels/DCStorageObject">
						                        <xsl:call-template name="RenderChannelSelectionRadioButtons"/>
					                    </xsl:for-each>
				                </Header>
                                <!-- The list of available disks for dhs is divided by channel, so each channel will have a <DHSAvailDisks ChannelName=" " EnclosureName=" "> tag -->
				                <xsl:for-each select="DHSAvailDisks/ArrayDisks">
								   <xsl:choose>
						             <xsl:when test="DCStorageObject/EnclosureID">
                                        <xsl:call-template name="RenderAvailArrayDisksRow">
							    <!-- To render each channel's disks, we need to pass in some parameters
				                              These are used to give each row, etc a correct title to be used by the
				                              javascript when querying for the elements.  The KEY is used to sort
				                              the disks by channel for the radio buttons -->
							       <xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
							       <xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
							       <xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of  select="@EnclosureType"/></xsl:with-param>
                                   <xsl:with-param name="productid"><xsl:value-of  select="@ProductID"/></xsl:with-param></xsl:call-template>(<xsl:value-of  select="@ChannelName"/>)</xsl:otherwise></xsl:choose></xsl:with-param>
					             </xsl:call-template>
								 </xsl:when>
						        <xsl:otherwise>
						        <!-- Not SAS: use channel and 0 -->
									<xsl:call-template name="RenderAvailArrayDisksRow">
										<!-- To render each channel's disks, we need to pass in some parameters
				                              These are used to give each row, etc a correct title to be used by the
				                              javascript when querying for the elements.  The KEY is used to sort
				                              the disks by channel for the radio buttons -->
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/>0</xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of  select="@ProductID"/></xsl:with-param></xsl:call-template></xsl:otherwise></xsl:choose></xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							    </xsl:choose>					
                                </xsl:for-each>          
                            </SelectionTable>
                        </SelectionData>
                    </xsl:when>
                    <xsl:otherwise>
                      <!-- Use for the NON SAS Controllers -->
                      <TableData name="T3" display="{$strHSDiskTableCVDES}">
				             <SubHeader><xsl:attribute name="display"><xsl:value-of select="$strHSAssignHotspareCVDES"/></xsl:attribute></SubHeader>
				             <xsl:choose>
					            <xsl:when test="//DHSAvailDisks">
						         <Header>
							        <Data value="{$strArrayDiskCVDES}" width="400"/>
							        <Data value="{$strFreeSpaceCVDES}"/>
									<Data></Data>
						         </Header>
						         <xsl:for-each select="//DHSAvailDisks/ArrayDisks/DCStorageObject">
							                <xsl:sort select="FreeSpace" data-type="number" order="ascending"/>
							                <xsl:sort select="Channel" data-type="number" order="ascending"/>
							                <xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
							                <xsl:sort select="TargetID" data-type="number" order="ascending"/>
							                <xsl:if test="position() = 1">
								                <xsl:call-template name="RenderSelectedArrayDiskRow">
									             <xsl:with-param name="WithCheckbox">1</xsl:with-param>
								                </xsl:call-template>
							                </xsl:if>
						         </xsl:for-each>
					            </xsl:when>
				             </xsl:choose> 
			           </TableData>
                      </xsl:otherwise>
                     </xsl:choose>
               </xsl:when>
		       <xsl:otherwise>
			               	<AlertMessage>
							    <xsl:attribute name="display"><xsl:value-of select="$strHSNoneAvailable"/></xsl:attribute>
							</AlertMessage>
		       </xsl:otherwise>
		       </xsl:choose>
			  </xsl:if> 
			
		<HiddenTable>
		          <Data>
			          <xsl:attribute name="name">HSDIDList</xsl:attribute>
			          <xsl:attribute name="returnvalue"></xsl:attribute>
		          </Data>
		</HiddenTable>
                 <HiddenTable>
				<Data>
					<xsl:attribute name="name">SecureVD</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/SecureVD"/></xsl:attribute>
				</Data>
			</HiddenTable>
                   
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">AdvancedWizard</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/AdvancedWizard"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                  <HiddenTable>
				<Data>
					<xsl:attribute name="name">ExpressWizard</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/ExpressWizard"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                  <HiddenTable>
				<Data>
					<xsl:attribute name="name">MediaType</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/MediaType"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                     <HiddenTable>
				<Data>
					<xsl:attribute name="name">BusProtocol</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/BusProtocol"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                   
                   
                <HiddenTable>
				<!--This creates a hidden table that maps a "raid layout type" to the "max size possible" for that layout/-->
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMaxSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMinSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMaxSizeInGBForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMinSizeInGBForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				
			</HiddenTable>
                
		</DataArea>
	</xsl:template>
        
    	<xsl:template name="RenderAvailArrayDisksRow">
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<!-- The Row is the enclosure -->
		<Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<Data value="{$DISPLAY_NAME}"/>
			</ColumnData>
			<!-- The children rows are the individual disks -->
			<ChildrenRows>
				<!-- For each disk that matches the channel we're trying to display -->
				<xsl:for-each select="DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					<xsl:call-template name="RenderArrayDiskSelection">
						<xsl:with-param name="ArrayDiskSpace">
							<xsl:value-of select="Length"/>
						</xsl:with-param>
						<xsl:with-param name="PrefixName">
							<xsl:value-of select="$CHILD_NAME_PREFIX"/>
						</xsl:with-param>
						
					</xsl:call-template>
                                 </xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
        
	<!-- This dispays the each disk under the enclosure row                -->
	<xsl:template name="RenderArrayDiskSelection">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		
		<Row>
			<xsl:variable name="enclNum">
				<xsl:choose>
					<xsl:when test="EnclosureID"><xsl:value-of select="EnclosureID"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:value-of select="TargetID"/></xsl:attribute>
			<SelectDataItem>
			    <!--xsl:if test="PDPowerState != ''">
			    <Data type="icon" name="PowerState" columnspacing="true" align="center">
					<xsl:attribute name="value"><xsl:call-template name="GetPowerStatusIcon"><xsl:with-param name="powerstatus"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					<xsl:attribute name="alt"><xsl:call-template name="GetPowerStatusToolTip"><xsl:with-param name="psicon"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
			   </xsl:if-->
    			<Data type="checkbox" width="150" columnspacing="true">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:text/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!-- Different name depending on SAS or SATA -->
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="EnclosureID">
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:attribute>

					<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="$enclNum"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data columnspacing="true">
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00 GB')"/></xsl:attribute>
				</Data>
			</ColumnData>
                                        <ColumnData>
				<Data columnspacing="true" width="150" align="center">
					<xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
				</Data>
		               </ColumnData>
		</Row>
	</xsl:template>
	
	<!-- This dispays the channel radio buttons on the top of the table  -->
	<xsl:template name="RenderChannelSelectionRadioButtons">
		<Data name="ChannelButton" type="radio" state="0" event="onclick" handler="OnChannelSelected()">
			<xsl:attribute name="value"><xsl:value-of select="$strChannel"/><xsl:value-of select="Channel"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Channel"/></xsl:attribute>
		</Data>
	</xsl:template>
        
	<xsl:template name="RenderSelectedArrayDiskRow">
		<xsl:param name="WithCheckbox">0</xsl:param>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="AdiskTitle">
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
			<xsl:choose>
				<xsl:when test="$WithCheckbox='1'">
					<Data editable="true" type="checkbox" align="left" name="HSDIDList">
						<xsl:attribute name="returnvalue">
							<xsl:choose>
								<xsl:when test="$GLOBAL_PARAM_Rules='1'">
									<!-- Send hotspare disk nexus in case of OMSS-Lite -->
									<xsl:value-of select="$AdiskTitle"/>
								</xsl:when>
								<xsl:otherwise>
									<!-- Send hotspare disk OID in case of OMSS -->
									<xsl:value-of select="ObjID"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDES"/>&#160;<xsl:value-of select="$AdiskTitle"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$AdiskTitle"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<Data>
				<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<!--In DSA mode size of array disk is capacity of array disk-->
						<xsl:when test="$GLOBAL_PARAM_Rules='1'"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="format-number((ContiguousFree div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
            <Data columnspacing="true" width="150" align="center">
                        <xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
            </Data>
		</Row>
	</xsl:template>
</xsl:stylesheet>
