<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- CHANNEL TABLE HEADER -->
	<xsl:template name="ChannelTableHeader">
		<xsl:param name="tasks"/>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Data name="Name" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
		<Data name="Status" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
        <xsl:if test="//BusProtocol != '9' or $dynamicView = 'false'"> 
			<Data name="ChanType" editable="false" type="ustring" align="left">
				<xsl:attribute name="display"><xsl:value-of select="$strChanType"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strChanType"/></xsl:attribute>
			</Data>
        </xsl:if>  
		<xsl:if test="//Termination or $dynamicView = 'false'">
			<Data name="Termination" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strTermination"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strTermination"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//SCSIRate or $dynamicView = 'false'">
			<Data name="SCSIRate" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strSCSIRate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSCSIRate"/></xsl:attribute>
			</Data>
		</xsl:if>
           
            <xsl:if test="BusProtocol != '9' or $dynamicView = 'false'">
		<xsl:if test="$tasks='true'">
			<Data name="Delete" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strTasks"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strTasks"/></xsl:attribute>
			</Data>
			<!-- The Rows have one extra row for the execute button.  Including a blank <Data> tag here keeps the line that underlines the headers continuous -->
			<Data name="exbut" editable="false" type="ustring" ignoreoncli="true">
				<xsl:attribute name="display"><!--XLATESTART-->Execute<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><!--XLATESTART--><!--XLATESTOP--></xsl:attribute>
			</Data>
		</xsl:if>
           </xsl:if>
	</xsl:template>
	<!-- CHANNEL DISK TABLE ROWS -->
	<xsl:template name="ChannelTableRows">
		<xsl:param name="tasks"/>
		<xsl:param name="ObjID">
		<xsl:call-template name="ModNexus">
			<xsl:with-param name="nexus">
				<xsl:value-of select="Nexus"/>
			</xsl:with-param>
		</xsl:call-template>
        	</xsl:param>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Row>
			<Data name="Test" editable="false" type="ustring" display="Test" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="Channel"/></xsl:attribute>
			</Data>
			<Data type="status" align="center">
				<xsl:attribute name="value"><xsl:choose><xsl:when test="substring(AttributesMask,26,1)='1' and ( substring(AttributesMask,24,1)='1' or  substring(AttributesMask,25,1)='1')">3</xsl:when><xsl:otherwise><xsl:value-of select="ObjStatus"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</Data>
			<Data name="Test" editable="false" type="ustring" display="Test" align="left">
				<!--xsl:attribute name="value"><xsl:value-of select="$strChannel"/><xsl:value-of select="Channel"/></xsl:attribute-->
				<xsl:attribute name="value"><xsl:choose><xsl:when test="substring(AttributesMask,26,1)='1'and AttributesMask != ''"><xsl:value-of select="$strLogicalConnector"/></xsl:when><xsl:when test="BusProtocol = '9'"><xsl:value-of select="$strPCIeSSDExpander"/><xsl:value-of select="Channel"/></xsl:when><xsl:otherwise><xsl:value-of select="$strChannel"/><xsl:value-of select="Channel"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</Data>
			<Data name="Test" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
           <xsl:if test="BusProtocol != '9' or $dynamicView = 'false'"> 
			<Data name="Test" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value">
					<xsl:call-template name="GetConnectorType">
						<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
						<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
		  </Data>
                  </xsl:if>
			<xsl:if test="Termination or $dynamicView = 'false'">
				<xsl:choose>
					<xsl:when test="Termination">
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:call-template name="GetTerminationType"><xsl:with-param name="termination"><xsl:value-of select="Termination"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:when test="$SASorSATA='1'">
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="SCSIRate or $dynamicView = 'false'">
				<xsl:choose>
					<xsl:when test="SCSIRate">
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:call-template name="GetSCSIRateUnknown"><xsl:with-param name="Rate"><xsl:value-of select="SCSIRate"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:when test="$SASorSATA='1'">
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>					
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
                  <xsl:if test="BusProtocol != '9' or $dynamicView = 'false'">
			<xsl:if test="$tasks='true'">
				<Data name="ChannelTasks" display="Tasks" type="select" splcase="true">
					<xsl:call-template name="for-loop-list-box">
						<xsl:with-param name="Mask" select="MasterMethodMask"/>
						<xsl:with-param name="templateName" select="7"/>
					</xsl:call-template>
				<ExtraItem type="button">
							 <xsl:attribute name="href">javascript:onExecute(\"<xsl:value-of select="Channel"/>\",\"<xsl:value-of select="$ObjID"/>\");</xsl:attribute>							
							 <xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="tablebutton">true</xsl:attribute> 
							<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
				</ExtraItem>
				</Data>
			</xsl:if>
                 </xsl:if>
		</Row>
	</xsl:template>
	<xsl:template name="ChannelList">
		<xsl:param name="tasks"/>
		<xsl:param name="ObjID">
		<xsl:call-template name="ModNexus">
			<xsl:with-param name="nexus">
				<xsl:value-of select="Nexus"/>
			</xsl:with-param>
		</xsl:call-template>
        	</xsl:param>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Data name="ID" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="Channel"/></xsl:attribute>
		</Data>
		<Data type="status" align="left">
		        <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:choose><xsl:when test="substring(AttributesMask,26,1)='1' and ( substring(AttributesMask,24,1)='1' or  substring(AttributesMask,25,1)='1')">3</xsl:when><xsl:otherwise><xsl:value-of select="ObjStatus"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</Data>
		<Data name="Name" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:choose><xsl:when test="substring(AttributesMask,26,1)='1'and AttributesMask != ''"><xsl:value-of select="$strLogicalConnector"/></xsl:when><xsl:when test="BusProtocol = '9'"><xsl:value-of select="$strPCIeSSDExpander"/><xsl:value-of select="Channel"/></xsl:when><xsl:otherwise><xsl:value-of select="$strChannel"/><xsl:value-of select="Channel"/></xsl:otherwise></xsl:choose></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
		</Data>
            <xsl:if test="BusProtocol != '9'">   
		<Data name="ChanType" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strChanType"/></xsl:attribute>
			<xsl:attribute name="value">
				<xsl:call-template name="GetConnectorType">
					<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
					<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</Data>
           </xsl:if>
		<xsl:if test="//Termination or $dynamicView = 'false'">
			<Data name="Termination" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strTermination"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="Termination">
						<xsl:attribute name="value"><xsl:call-template name="GetTerminationType"><xsl:with-param name="termination"><xsl:value-of select="Termination"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</xsl:when>
					<xsl:when test="$SASorSATA='1'">
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>					
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="//SCSIRate or $dynamicView = 'false'">
			<Data name="SCSIRate " editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strSCSIRate"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="SCSIRate">
						<xsl:attribute name="value"><xsl:call-template name="GetSCSIRateUnknown"><xsl:with-param name="Rate"><xsl:value-of select="SCSIRate"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" editable="false" type="ustring" display="Test">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<!-- isEmpty var used for hiding tasks menu option -->
		<xsl:variable name="isEmpty">
			<xsl:call-template name="IsCurrentMethodMaskEmpty">
				<xsl:with-param name="Mask">
					<xsl:value-of select="CurrentMethodMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
             <xsl:if test="BusProtocol != '9'">
		<xsl:if test="$tasks='true'">
			<xsl:choose>
				<!--check to see if methods even exist -->
				<xsl:when test="$isEmpty='0'">
					<!-- currentmethod mask isn't empty -->
					<Data name="Chtasks" value="Chtasks" type="select" ignoreoncli="true" splcase="true">
						<xsl:attribute name="display"><xsl:value-of select="$strChannelTasks"/></xsl:attribute>
						<Choice returnvalue="-" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
						</Choice>
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="MasterMethodMask"/>
							<xsl:with-param name="templateName" select="7"/>
						</xsl:call-template>
					
				<ExtraItem type="button">
							 <xsl:attribute name="href">javascript:onExecute(\"<xsl:value-of select="Channel"/>\",\"<xsl:value-of select="$ObjID"/>\");</xsl:attribute>							
							 <xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="tablebutton">true</xsl:attribute> 
							<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
				</ExtraItem>
				</Data>
				</xsl:when>
				<xsl:otherwise>
					<!-- current methodmask is empty -->
					<Data value="tasks" type="select" boxwidth="width:400px">
						<xsl:attribute name="display"><xsl:value-of select="$strChannelTasks"/></xsl:attribute>
						<xsl:attribute name="name">Chtasks<xsl:value-of select="ObjID"/></xsl:attribute>
						<Choice returnvalue="" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
						</Choice>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
       </xsl:if>
	</xsl:template>
	
	<xsl:template name="GetConnectorType">
		<xsl:param name="BusProtocol"/>
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="$BusProtocol=1"> <!-- scsi -->
				<xsl:choose>
					<xsl:when test="substring(AttributesMask,23,1)='0'"><xsl:value-of select="$strRAIDChannel"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strSCSIChannel"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$BusProtocol=7"> <!-- sata -->
				<xsl:value-of select="$strSATARAID"/>
			</xsl:when>
			<xsl:when test="$BusProtocol=2"> <!-- ide -->
				<xsl:value-of select="$strIDERAID"/>
			</xsl:when>
                        <xsl:when test="$BusProtocol=9"> <!-- ide -->
				<xsl:value-of select="$strNonRAID"/>
			</xsl:when>  
			<xsl:when test="$BusProtocol=8">	 <!-- sas -->		
				<xsl:choose>
					<xsl:when test="substring(AttributesMask,23,1)='0'">
						<xsl:value-of select="$strSASRAID"/>
					</xsl:when>
					<xsl:otherwise> 
						<xsl:value-of select="$strSASNonRAID"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
			   <xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
		
	<xsl:template name="PathHealthTable">
		<Row>
			<Data type="status" align="right">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,28,1)='1'">4</xsl:when>
						<xsl:when test="substring(AttributesMask,27,1)='1' or substring(AttributesMask,24,1)='1'">2</xsl:when>
						<xsl:when test="substring(AttributesMask,25,1)='1'">3</xsl:when>
						<xsl:otherwise>2</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Connector0" editable="false" type="ustring" display="Connector0" align="left">
				<xsl:attribute name="value"><xsl:value-of select="$strConnector0"/></xsl:attribute>
			</Data>
			<Data name="State1" editable="false" type="ustring" display="State1" align="left">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,28,1)='1'"><xsl:value-of select="$strDisconnected"/></xsl:when>
						<xsl:when test="substring(AttributesMask,27,1)='1' or substring(AttributesMask,24,1)='1'"><xsl:value-of select="$strAvailable"/></xsl:when>
						<xsl:when test="substring(AttributesMask,25,1)='1'"><xsl:value-of select="$strDegraded"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strAvailable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data type="status" align="right">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,27,1)='1'">4</xsl:when>
						<xsl:when test="substring(AttributesMask,28,1)='1' or substring(AttributesMask,25,1)='1'">2</xsl:when>
						<xsl:when test="substring(AttributesMask,24,1)='1'">3</xsl:when>
						<xsl:otherwise>2</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Connector1" editable="false" type="ustring" display="Connector1" align="left">
				<xsl:attribute name="value"><xsl:value-of select="$strConnector1"/></xsl:attribute>
			</Data>
			<Data name="State2" editable="false" type="ustring" display="State2" align="left">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,27,1)='1'"><xsl:value-of select="$strDisconnected"/></xsl:when>
						<xsl:when test="substring(AttributesMask,28,1)='1' or substring(AttributesMask,25,1)='1'"><xsl:value-of select="$strAvailable"/></xsl:when>
						<xsl:when test="substring(AttributesMask,24,1)='1'"><xsl:value-of select="$strDegraded"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strAvailable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
</xsl:stylesheet>

