<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:include href="btrytbl.xsl"/>
	<xsl:include href="Utils.xsl"/>
	 <xsl:variable name="GLOBAL_VAR_LOCALE"><xsl:value-of select="/OMA/Locale"/></xsl:variable>
	<xsl:template match="OMA">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<DataArea backpagetarget="./DataArea?plugin=com.dell.sm.webplugins.ControllerWebPlugin">
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle2Part1"/><xsl:value-of select="Batteries/@ControllerName"/><xsl:value-of select="$strTitle2Part2"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.BattInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;BatteryOID=<xsl:value-of select="/OMA/BatteryOID"/>&amp;Action=none&amp;help=battery</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:call-template name="Battery">
				<xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
			</xsl:call-template>
		</DataArea>
	</xsl:template>
	<xsl:template name="Battery">
		<xsl:param name="tasks"/>
		<ComboData>
		<ListData >
			<xsl:variable name="showtasks"><xsl:value-of select="$tasks"/></xsl:variable>
			<xsl:choose>
						<xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de'))">
							  <xsl:attribute name="extended">true</xsl:attribute>
							 
						</xsl:when>
		        </xsl:choose>
			<xsl:for-each select="Batteries/DCStorageObject">
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
				<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			</SubHeader> 

			<xsl:call-template name="BatteryList">
				<xsl:with-param name="tasks" select="$showtasks"/>
			</xsl:call-template>	
			</xsl:for-each>
		</ListData>
		</ComboData>
		<script language="javascript">
      function onExecute(oid) {
      var BatteryTasks = "BatteryTasks" + oid;
      var action = document.getElementById(BatteryTasks).value;

      // Actions
      // 1 - recondition battery
      // 2 - start learn cycle
      // 4 - delay learn cycle
      if (action =="1" || action == "2") {
          document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.BatteryExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;BatteryOID=" + oid + "&amp;Action="+action + "&amp;help=battery");
      document.dataarea.submit();
      } else if (action == "4") {
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SetBatteryDelayLearnWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="Batteries/@ControllerName"/>&amp;BatteryOID="+ oid +"&amp;Action="+action+"&amp;help=bttkdlc");
				} else {
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
				}
			}
		</script>
	</xsl:template>
</xsl:stylesheet>
