<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
   	<xsl:template name="PartitionOrVD">
		<xsl:param name="BackendObjType"/>
		<xsl:choose>
			<xsl:when test="$BackendObjType ='791'">
				<xsl:value-of select="$strPartitionType"/>
			</xsl:when>
			<xsl:when test="$BackendObjType ='773'">
				<xsl:value-of select="$strVirtualDisk"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotAvailable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
      <xsl:template name="GetFluidCacheState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strActive"/>
			</xsl:when>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:when test="$state='8'">
				<xsl:value-of select="$strRemoving"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
      <xsl:template name="GetFluidCacheDeviceState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='0'">
				<xsl:value-of select="$strNotEnabled"/>
			</xsl:when>
			
                  <xsl:when test="$state='1'">
				<xsl:value-of select="$strActive"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:when test="$state='3'">
				<xsl:value-of select="$strRemoving"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
      <xsl:template name="GetFluidCacheWriteMode">
		<xsl:param name="WriteMode"/>
		<xsl:choose>
			<xsl:when test="$WriteMode='1'">
				<xsl:value-of select="$strWriteThrough"/>
			</xsl:when>
			<xsl:when test="$WriteMode='0'">
				<xsl:value-of select="$strWriteBack"/>
			</xsl:when>
			<xsl:when test="$WriteMode='2'">
				<xsl:value-of select="$strPassThrough"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

   	<xsl:template name="GetRaidLayout">
		<xsl:param name="RaidType"/>
		<xsl:choose>
			<xsl:when test="$RaidType='1'">
				<xsl:value-of select="$strRAIDC"/>
			</xsl:when>
			<xsl:when test="$RaidType='2'">
				<xsl:value-of select="$strRAID0"/>
			</xsl:when>
			<xsl:when test="$RaidType='4'">
				<xsl:value-of select="$strRAID1"/>
			</xsl:when>
			<xsl:when test="$RaidType='64'">
				<xsl:value-of select="$strRAID5"/>
			</xsl:when>
				<xsl:when test="$RaidType='128'">
				<xsl:value-of select="$strRAID6"/>
			</xsl:when>
			<xsl:when test="$RaidType='512' or $RaidType='524288'">
				<xsl:value-of select="$strRAID10"/>
			</xsl:when>
			<xsl:when test="$RaidType='1024'">
				<xsl:value-of select="$strRAID30"/>
			</xsl:when>
			<xsl:when test="$RaidType='2048'">
				<xsl:value-of select="$strRAID50"/>
			</xsl:when>
			<xsl:when test="$RaidType='262144'">
				<xsl:value-of select="$strRAID60"/>
			</xsl:when>
			<xsl:when test="$RaidType='4096'">
				<xsl:value-of select="$strRAID1C"/>
			</xsl:when>
			<xsl:when test="$RaidType='8192'">
				<xsl:value-of select="$strRAID5C"/>
			</xsl:when>
			<xsl:when test="$RaidType='16384'">
				<xsl:value-of select="$strNonRAID"/>
			</xsl:when>
			<xsl:when test="$RaidType='32768'">
				<xsl:value-of select="$strVolume"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetCLIRaidLayoutValue">
		<xsl:param name="RaidType"/>
		<xsl:choose>
			<xsl:when test="$RaidType='1'">
				<!--XLATESTART-->c<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='2'">
				<!--XLATESTART-->r0<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='4'">
				<!--XLATESTART-->r1<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='64'">
				<!--XLATESTART-->r5<!--XLATESTOP-->
			</xsl:when>
      <xsl:when test="$RaidType='128'">
        <!--XLATESTART-->r6<!--XLATESTOP-->
      </xsl:when>
      <xsl:when test="$RaidType='512' or $RaidType='524288'">
				<!--XLATESTART-->r10<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='1024'">
				<!--XLATESTART-->r30<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='2048'">
				<!--XLATESTART-->r50<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='4096'">
				<!--XLATESTART-->r1c<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='8192'">
				<!--XLATESTART-->r5c<!--XLATESTOP-->
			</xsl:when>
      <xsl:when test="$RaidType='262144'">
        <!--XLATESTART-->r60<!--XLATESTOP-->
      </xsl:when>
      <xsl:otherwise>
				<!--XLATESTART-->UnKnown<!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetRaidLayoutValue">
		<xsl:param name="RaidDescription"/>
		<xsl:choose>
			<xsl:when test="$RaidDescription='Concatenated'">1</xsl:when>
			<xsl:when test="$RaidDescription='RAID-0'">2</xsl:when>
			<xsl:when test="$RaidDescription='RAID-1'">4</xsl:when>
			<xsl:when test="$RaidDescription='RAID-5'">64</xsl:when>
			<xsl:when test="$RaidDescription='RAID-6'">128</xsl:when>
			<xsl:when test="$RaidDescription='RAID-10'">512</xsl:when>
			<xsl:when test="$RaidDescription='RAID-30'">1024</xsl:when>
			<xsl:when test="$RaidDescription='RAID-50'">2048</xsl:when>
			<xsl:when test="$RaidDescription='RAID-60'">262144</xsl:when>
			<xsl:when test="$RaidDescription='RAID-1-Concatenated'">4096</xsl:when>
			<xsl:when test="$RaidDescription='RAID-5-Concatenated'">8192</xsl:when>
			<xsl:otherwise>-1</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetSpareInfoForArrayDisk">
		<xsl:param name="AttribsMask"/>
		<xsl:choose>
			<xsl:when test="$AttribsMask='0'">
				<xsl:value-of select="$strNo"/>
			</xsl:when>
			<xsl:when test="$AttribsMask='128'">
				<xsl:value-of select="$strGlobalHS"/>
			</xsl:when>
			<xsl:when test="$AttribsMask='256'">
				<xsl:value-of select="$strDedHS"/>
			</xsl:when>
			<xsl:when test="substring($AttribsMask,25,1)='1'">
				<xsl:value-of select="$strGlobalHS"/>
			</xsl:when>
			<xsl:when test="substring($AttribsMask,24,1)='1'">
				<xsl:value-of select="$strDedHS"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNo"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
       	<xsl:template name="GetReadPolicyMask">
		<xsl:param name="readpolicy"/>
		<xsl:choose>
			<xsl:when test="$readpolicy='4'">00000000000000000000000000000100</xsl:when>
			<xsl:when test="$readpolicy='16'">00000000000000000000000000010000</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetReadPolicy">
		<xsl:param name="readpolicy"/>
		<xsl:choose>
			<xsl:when test="$readpolicy='1'">
				<xsl:value-of select="$strReadCEnabled"/>
			</xsl:when>
			<xsl:when test="$readpolicy='2'">
				<xsl:value-of select="$strReadCDisabled"/>
			</xsl:when>
			<xsl:when test="$readpolicy='4'">
				<xsl:value-of select="$strReadAhead"/>
			</xsl:when>
			<xsl:when test="$readpolicy='8'">
				<xsl:value-of select="$strAdapReadAhead"/>
			</xsl:when>
			<xsl:when test="$readpolicy='16'">
				<xsl:value-of select="$strNoReadAhead"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        <xsl:template name="GetWritePolicyMask">
	<xsl:param name="writepolicy"/>
		<xsl:choose>
			<xsl:when test="$writepolicy='4'">00000000000000000000000000000100</xsl:when>
			<xsl:when test="$writepolicy='8'">00000000000000000000000000001000</xsl:when>
			<xsl:when test="$writepolicy='32'">00000000000000000000000000100000</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetWritePolicy">
		<xsl:param name="writepolicy"/>
		<xsl:choose>
			<xsl:when test="$writepolicy='1'">
				<xsl:value-of select="$strWriteCEnabled"/>
			</xsl:when>
			<xsl:when test="$writepolicy='2'">
				<xsl:value-of select="$strWriteCDisabled"/>
			</xsl:when>
			<xsl:when test="$writepolicy='4'">
				<xsl:value-of select="$strWriteBack"/>
			</xsl:when>
			<xsl:when test="$writepolicy='8'">
				<xsl:value-of select="$strWriteThrough"/>
			</xsl:when>
			<xsl:when test="$writepolicy='16'">
				<xsl:value-of select="$strWriteAlways"/>
			</xsl:when>
			<xsl:when test="$writepolicy='32'">
				<xsl:value-of select="$strForceWriteBack"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetCachePolicy">
		<xsl:param name="cachepolicy"/>
		<xsl:choose>
			<xsl:when test="$cachepolicy='1'">
				<xsl:value-of select="$strDirectIO"/>
			</xsl:when>
			<xsl:when test="$cachepolicy='2'">
				<xsl:value-of select="$strCacheIO"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="GetDiskCachePolicy">
		<xsl:param name="DiskCachePolicy"/>
		<xsl:choose>
			<xsl:when test="$DiskCachePolicy='1'">
				<xsl:value-of select="$strEnabled"/>
			</xsl:when>
			<xsl:when test="$DiskCachePolicy='2'">
				<xsl:value-of select="$strDisabled"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetWarningLevels">
		<xsl:param name="warnvalue"/>
		<xsl:choose>
			<!--xsl:when test="$warnvalue='0'"></xsl:when-->
			<xsl:when test="$warnvalue='1'">
				<xsl:value-of select="$strInformational"/>
			</xsl:when>
			<xsl:when test="$warnvalue='2'">
				<xsl:value-of select="$strWarning"/>
			</xsl:when>
			<xsl:when test="$warnvalue='3'">
				<xsl:value-of select="$strCritical"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
        
        <xsl:template name="GetConsiderGHS">
		<xsl:param name="ghsvalue"/>
		<xsl:choose>
			<!--xsl:when test="$warnvalue='0'"></xsl:when-->
			<xsl:when test="$ghsvalue='0'">
				<xsl:value-of select="$strNo"/>
			</xsl:when>
			<xsl:when test="$ghsvalue='1'">
				<xsl:value-of select="$strYes"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetStripeSize">
		<xsl:param name="stripesize"/>
		<xsl:choose>
			<xsl:when test="$stripesize='0'">
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:when>
			<xsl:when test="$stripesize='1'">
				<xsl:value-of select="$str512B"/>
			</xsl:when>
			<xsl:when test="$stripesize='2'">
				<xsl:value-of select="$str1KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='4'">
				<xsl:value-of select="$str2KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='8'">
				<xsl:value-of select="$str4KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='16'">
				<xsl:value-of select="$str8KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='32'">
				<xsl:value-of select="$str16KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='64'">
				<xsl:value-of select="$str32KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='128'">
				<xsl:value-of select="$str64KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='256'">
				<xsl:value-of select="$str128KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='512'">
				<xsl:value-of select="$str256KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='1024'">
				<xsl:value-of select="$str512KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='2048'">
				<xsl:value-of select="$str1MB"/>
			</xsl:when>
			<xsl:when test="$stripesize='4096'">
				<xsl:value-of select="$str2MB"/>
			</xsl:when>
			<xsl:when test="$stripesize='8192'">
				<xsl:value-of select="$str4MB"/>
			</xsl:when>
			<xsl:when test="$stripesize='16384'">
				<xsl:value-of select="$str8MB"/>
			</xsl:when>
			<xsl:when test="$stripesize='32768'">
				<xsl:value-of select="$str16MB"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetEnclosureType">
		<xsl:param name="type"/>
		<xsl:param name="productid"/>
		<xsl:choose>
			<xsl:when test="$type='1'">
				<!-- GEM318 PB - Show the string Backplane only -->
				<xsl:value-of select="$strBackPlane"/>
			</xsl:when>
			<xsl:when test="$type='2'">
				<xsl:value-of select="$strBackPlane"/>
			</xsl:when>
			<xsl:when test="$type='3'">
				<xsl:value-of select="$strHendrix8"/>
			</xsl:when>
			<xsl:when test="$type='4'">
				<xsl:value-of select="$strHendrix12"/>
			</xsl:when>
			<xsl:when test="$type='5'">
				<xsl:value-of select="$strZappa"/>
			</xsl:when>
			<xsl:when test="$type='6'">
				<xsl:value-of select="$strCandy"/>
			</xsl:when>
			<xsl:when test="$type='7'">
				<xsl:choose>
					<xsl:when test="$productid != ''">
						<xsl:value-of select="$productid"/>
			                </xsl:when>
					<xsl:otherwise>
				                <xsl:value-of select="ProductID"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetEnclosureConfig">
		<xsl:param name="config"/>
		<xsl:choose>
			<xsl:when test="$config='1'">
				<xsl:value-of select="$strJoined"/>
			</xsl:when>
			<xsl:when test="$config='2'">
				<xsl:value-of select="$strSplit"/>
			</xsl:when>
			<xsl:when test="$config='3'">
				<xsl:value-of select="$strClustered"/>
			</xsl:when>
			<xsl:when test="$config='4'">
				<xsl:value-of select="$strUnified"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- EMM type, Zappa only -->
	<xsl:template name="GetEMMType">
		<xsl:param name="emmtype"/>
		<xsl:choose>
			<xsl:when test="$emmtype='Expander'">
				<xsl:value-of select="$strscsicontroller"/>
			</xsl:when>
			<xsl:when test="$emmtype='Terminator'">
				<xsl:value-of select="$strscsiterminator"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetFanSpeed">
		<xsl:param name="speed"/>
		<xsl:choose>
			<xsl:when test="$speed='1'">
				<xsl:value-of select="$strStopped"/>
			</xsl:when>
			<xsl:when test="$speed='2'">
				<xsl:value-of select="$strSlow"/>
			</xsl:when>
			<xsl:when test="$speed='3'">
				<xsl:value-of select="$strMedium"/>
			</xsl:when>
			<xsl:when test="$speed='4'">
				<xsl:value-of select="$strFast"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DecimalSep">
		<xsl:param name="Size"/>
		<xsl:variable name="formatval">
			<xsl:value-of select="format-number(($Size div (1024*1024*1024)),'#,##0.00')"/>
		</xsl:variable>
		<xsl:variable name="univdecsep">
			<xsl:choose>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.;,</xsl:when>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,;.</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<!--It is important that the statement below be in one single line, else it will mess the formating in GUI, the decimal operator will not show up-->
		<xsl:variable name="localdecsep"><!--XLATESTART-->.;,<!--XLATESTOP--></xsl:variable>
		<xsl:value-of select="translate($formatval,$univdecsep,$localdecsep)"/>
	</xsl:template>
      <xsl:template name="GetBusProtocolProperty">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strSAS"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strSATA"/>
			</xsl:when>
                  <xsl:when test="$MethodValue='512'">
				<xsl:value-of select="$strPCIe"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        <xsl:template name="GetMediaTypeProperty">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strHDD"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strSSD"/>
			</xsl:when>
                 	<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="GetBusProtocol">
	<xsl:param name="Bus"/>
	<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="$Bus=1">
				<xsl:value-of select="$strSCSI"/>
			</xsl:when>
			<xsl:when test="$Bus=2">
				<xsl:value-of select="$strIDE"/>
			</xsl:when>
			<xsl:when test="$Bus=7">
				<xsl:value-of select="$strSATA"/><xsl:if test="substring($AttributesMask,14,1) = '1'"><xsl:text> (</xsl:text><xsl:value-of select="$strExternal"/><xsl:text>) </xsl:text></xsl:if>
			</xsl:when>
			<xsl:when test="$Bus=8">
				<xsl:value-of select="$strSAS"/>
			</xsl:when>
                  <xsl:when test="$Bus=9">
				<xsl:value-of select="$strPCIe"/>
			</xsl:when>

                        <xsl:when test="$Bus=15">
				<xsl:value-of select="$strSASandSATA"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        
	<xsl:template name="GetTerminationType">
		<xsl:param name="termination"/>
		<xsl:choose>
			<xsl:when test="$termination='1'">
				<xsl:value-of select="$strWideTerm"/>
			</xsl:when>
			<xsl:when test="$termination='2'">
				<xsl:value-of select="$strNarrowTerm"/>
			</xsl:when>
			<xsl:when test="$termination='3'">
				<xsl:value-of select="$strNoTerm"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="imagedesc">
		<xsl:if test="ObjStatus='0'">
			<xsl:value-of select="$strOther"/>
		</xsl:if>
		<xsl:if test="ObjStatus='1'">
			<xsl:value-of select="$strUnknown"/>
		</xsl:if>
		<xsl:if test="ObjStatus='2'">
			<xsl:value-of select="$strOK"/>
		</xsl:if>
		<xsl:if test="ObjStatus='3'">
			<xsl:value-of select="$strNonCritical"/>
		</xsl:if>
		<xsl:if test="ObjStatus='4'">
			<xsl:value-of select="$strCritical"/>
		</xsl:if>
		<xsl:if test="ObjStatus='5'">
			<xsl:value-of select="$strNonRecoverable"/>
		</xsl:if>
	</xsl:template>
	<!--xsl:template name="GetPowerStatusIcon">
		<xsl:param name="powerstatus"/>
		<xsl:if test="$powerstatus='0'">/sm/images/spun_up.gif</xsl:if>
		<xsl:if test="$powerstatus='255'">/sm/images/transition.gif</xsl:if>
		<xsl:if test="$powerstatus='1'">/sm/images/spun_down.gif</xsl:if>
		<xsl:if test="$powerstatus=''">/oma/images/blank.gif</xsl:if>
	</xsl:template-->
	<xsl:template name="GetPowerStatus">
		<xsl:param name="psicon"/>
		<xsl:if test="$psicon='0'"><xsl:value-of select="$strSpunup"/></xsl:if>
		<xsl:if test="$psicon='255'"><xsl:value-of select="$strTransistion"/></xsl:if>
		<xsl:if test="$psicon='1'"><xsl:value-of select="$strSpundown"/></xsl:if>
		<xsl:if test="$psicon=''"><xsl:value-of select="$strNotApplicable"/></xsl:if>
	</xsl:template>
	<xsl:template name="nullpossible">
		<xsl:param name="field"/>
		<xsl:if test="$field='(null)'">
			<xsl:value-of select="$strNA"/>
		</xsl:if>
		<xsl:if test="$field!='(null)'">
			<xsl:value-of select="$field"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="GetState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='1'">
				<xsl:value-of select="$strReady"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strOnline"/>
			</xsl:when>
			<xsl:when test="$state='8'">
				<xsl:value-of select="$strOffline"/>
			</xsl:when>
			<xsl:when test="$state='16'">
				<xsl:value-of select="$strNotInstalledState"/>
			</xsl:when>
			<xsl:when test="$state='32'">
				<xsl:value-of select="$strDegraded"/>
			</xsl:when>
			<xsl:when test="$state='64'">
				<xsl:value-of select="$strRecovering"/>
			</xsl:when>
			<xsl:when test="$state='128'">
				<xsl:value-of select="$strIOErrorState"/>
			</xsl:when>
			<xsl:when test="$state='256'">
				<xsl:value-of select="$strInactiveState"/>
			</xsl:when>
			<xsl:when test="$state='512'">
				<xsl:value-of select="$strPowerLowState"/>
			</xsl:when>
			<xsl:when test="$state='1024'">
				<xsl:value-of select="$strRemoved"/>
			</xsl:when>
			<xsl:when test="$state='2048'">
				<xsl:value-of select="$strReconditioning"/>
			</xsl:when>
			<xsl:when test="$state='4096'">
				<xsl:value-of select="$strNonRAID"/>
			</xsl:when>
			<xsl:when test="$state='8192'">
				<xsl:value-of select="$strNotReady"/>
			</xsl:when>
			<xsl:when test="$state='16384'">
				<xsl:value-of select="$strResyncing"/>
			</xsl:when>
			<xsl:when test="$state='16388'">
				<xsl:value-of select="$strOnlineResync"/>
			</xsl:when>
			<xsl:when test="$state='32768'">
				<xsl:value-of select="$strRegen"/>
			</xsl:when>
			<xsl:when test="$state='32772'">
				<xsl:value-of select="$strOnlineRegen"/>
			</xsl:when>
			<xsl:when test="$state='65536'">
				<xsl:value-of select="$strFailing"/>
			</xsl:when>
			<xsl:when test="$state='131072'">
				<xsl:value-of select="$strFailedRedundancy"/>
			</xsl:when>
			<xsl:when test="$state='262144'">
				<xsl:value-of select="$strFailedRedFailed"/>
			</xsl:when>
			<xsl:when test="$state='524288'">
				<xsl:value-of select="$strFailingRedundancy"/>
			</xsl:when>
			<xsl:when test="$state='1048576'">
				<xsl:value-of select="$strMissing"/>
			</xsl:when>
			<xsl:when test="$state='2097152'">
				<xsl:value-of select="$strPDCopyback"/>
			</xsl:when>
			<xsl:when test="$state='4194304'">
				<xsl:value-of select="$strSpinDown"/>
			</xsl:when>
			<xsl:when test="$state='8388608'">
				<xsl:value-of select="$strRebuilding"/>
			</xsl:when>
			<xsl:when test="$state='16777216'">
				<xsl:value-of select="$strNoMedia"/>
			</xsl:when>
			<xsl:when test="$state='33554432'">
				<xsl:value-of select="$strFormatting"/>
			</xsl:when>
			<xsl:when test="$state='67108864'">
				<xsl:value-of select="$strBlinking"/>
			</xsl:when>
			<xsl:when test="$state='134217728'">
				<xsl:value-of select="$strDiags"/>
			</xsl:when>
			<xsl:when test="$state='33587204'">
				<xsl:value-of select="$strOnlineRegenFormat"/>
			</xsl:when>
			<xsl:when test="$state='268435456'">
				<xsl:value-of select="$strInitializing"/>
			</xsl:when>
			<xsl:when test="$state='2147483648'">
				<xsl:value-of select="$strReconstructing"/>
			</xsl:when>
			<xsl:when test="$state='4294967296'">
				<xsl:value-of select="$strRescanning"/>
			</xsl:when>
			<!--xsl:when test="$state='549755813888'">
				<xsl:value-of select="$strNotReady"/>
			</xsl:when-->
			<xsl:when test="$state='17179869184'">
				<xsl:value-of select="$strInitializing"/>
			</xsl:when>
			<xsl:when test="$state='274877906944'">
				<xsl:value-of select="$strForeignState"/>
			</xsl:when>
			<xsl:when test="$state='549755813888'">
				<xsl:value-of select="$strClearState"/>
			</xsl:when>
			<xsl:when test="$state='1099511627776'">
				<xsl:value-of select="$strUnsupportedState"/>
			</xsl:when>

			<xsl:when test="$state='549755813892'">
				<xsl:value-of select="$strOnlineUnreadable"/>
			</xsl:when>
			<xsl:when test="$state='536870912'">
				<xsl:value-of select="$strRescanning"/>
			</xsl:when>
			<xsl:when test="$state='1073741824'">
				<xsl:value-of select="$strRefresh"/>
			</xsl:when>
			<xsl:when test="$state='2147483648'">
				<xsl:value-of select="$strRelayout"/>
			</xsl:when>
			<xsl:when test="$state='8589934592'">
				<xsl:value-of select="$strSmartAlert"/>
			</xsl:when>
			<xsl:when test="$state='1152921504606846976'">
				<xsl:value-of select="$strMinWarnState"/>
			</xsl:when>
			<xsl:when test="$state='2305843009213693952'">
				<xsl:value-of select="$strMinFailureState"/>
			</xsl:when>
			<xsl:when test="$state='4611686018427387904'">
				<xsl:value-of select="$strMaxWarnState"/>
			</xsl:when>
			<xsl:when test="$state='9223372036854775808'">
				<xsl:value-of select="$strMaxFailureState"/>
			</xsl:when>
			<xsl:when test="$state='34359738368'">
				<xsl:value-of select="$strBGIInitState"/>
			</xsl:when>
			<xsl:when test="$state='68719476736'">
				<xsl:value-of select="$strPauseFormat"/>
			</xsl:when>
			<xsl:when test="$state='137438953472'">
				<xsl:value-of select="$strPauseResynch"/>
			</xsl:when>
			<xsl:when test="$state='281474976710656'">
				<xsl:value-of select="$strLearning"/>
			</xsl:when>
			<xsl:when test="$state='562949953421312'">
				<xsl:value-of select="$strPowerLowState"/> <!-- battery specific -->
			</xsl:when>
			<xsl:when test="$state='1048576'">
				<xsl:value-of select="$strMissing"/>
			</xsl:when>
			<xsl:when test="$state='1125899906842624'">
				<xsl:value-of select="$strCharging"/>
			</xsl:when>
			<xsl:when test="$state='2251799813685248'">
				<xsl:value-of select="$strPermanentlyDegraded"/>
			</xsl:when>
			<xsl:when test="$state='4503599627370496'">
				<xsl:value-of select="$strIncompatible"/>
			</xsl:when>
      <xsl:when test="$state='9007199254740992'">
        <xsl:value-of select="$strDegradedRedundancy"/>
      </xsl:when>
      		<xsl:when test="$state='18014398509481984'">
        			<xsl:value-of select="$strCommunicationLost"/>
      		</xsl:when>
                  <xsl:when test="$state='36028797018963968'">
				<xsl:value-of select="$strPCIeSSDDevicesStatus"/>
			</xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--manipulation for AttributesMask-->
	<xsl:template name="IsClustered">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,32,1='1')">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsBatteryPresent">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,31,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsBusIDE">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,30,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsRLDSupported">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,29,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsInUseByVD">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,28,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsPartitionsAllowed">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,27,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsChannelRedundant">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,26,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsGlobalHotSpare">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,25,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsDedicatedHotSpare">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,24,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsObjectNonRaid">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,23,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
	<xsl:template name="IsDiskInEnclosure">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,22,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
	<xsl:template name="SmartAlertDetected">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,21,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
	<xsl:template name="IsNonDellDriveDetected">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,20,1)='1'">0</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>	
  	<xsl:template name="IsCreateVDSupported">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,26,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
       <xsl:template name="IsRaidIntegratedMirror">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,20,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
	<xsl:template name="CanVDBlink">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,24,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CanADBlink">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,32,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsMasterMethodMaskEmpty">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="$Mask='00000000000000000000000000000000'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Added by NL for CurrentMethodMask -->
	<xsl:template name="IsCurrentMethodMaskEmpty">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="$Mask='00000000000000000000000000000000'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="IsWriteCacheEnabled">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,27,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsSASorSATA">
		<xsl:param name="BusProtocol"/>
		<xsl:choose>
			<xsl:when test="$BusProtocol=7">1</xsl:when>
			<xsl:when test="$BusProtocol=8">1</xsl:when>
                        <xsl:when test="$BusProtocol=9">1</xsl:when> 
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--needed to add this to translate 'unknown' coming from lower layers for scsi rate -->
	<xsl:template name="GetSCSIRateUnknown">
		<xsl:param name="Rate"/>
		<xsl:choose>
			<xsl:when test="$Rate='Unknown'"><xsl:value-of select="$strUnknown"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$Rate"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
      <xsl:template name="GetControllerMethods1">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			 <xsl:when test="$MethodValue='1'">
			     <xsl:value-of select="$strManageSSC"/>
			     <xsl:value-of select="$strEllipse"/>
                  </xsl:when>	
		  <xsl:when test="$MethodValue='2'">
			     <xsl:value-of select="$strConvertRAIDCapable"/>
			     <xsl:value-of select="$strEllipse"/>
                  </xsl:when>	
			 <xsl:when test="$MethodValue='4'">
			     <xsl:value-of select="$strConvertNonRAID"/>
			     <xsl:value-of select="$strEllipse"/>
                  </xsl:when>	
            </xsl:choose>
	</xsl:template>
	<!--  CurrentMethodMask for Controller-->
	<xsl:template name="GetControllerMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strRescan"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strFlush"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strEnableAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strDisableAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16'">
				<xsl:value-of select="$strQuietAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32'">
				<xsl:value-of select="$strSetRebuildRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='64'">
				<xsl:value-of select="$strCreateVD"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strResetConfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strExportLog"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='512'">
				<xsl:value-of select="$strPauseIO"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1024'">
				<xsl:value-of select="$strResumeIO"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2048'">
				<xsl:value-of select="$strTestAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8192'">
				<xsl:value-of select="$strSetBGIRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16384'">
				<xsl:value-of select="$strSetCheckConRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32768'">
				<xsl:value-of select="$strSetPatReadRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='65536'">
				<xsl:value-of select="$strSetReconstructRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='131072'">
				<xsl:value-of select="$strOccupancySlotReport"/>
			</xsl:when>
			<!--xsl:when test="$MethodValue='262144'">
				<xsl:value-of select="$strDisableCluster"/>
			</xsl:when>
			<xsl:when test="$MethodValue='524288'">
				<xsl:value-of select="$strDumpEvents"/>
			</xsl:when-->
			<xsl:when test="$MethodValue='1048576'">
				<xsl:value-of select="$strSetPatReadMode"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2097152'">
				<xsl:value-of select="$strStartPatRead"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4194304'">
				<xsl:value-of select="$strStopPatRead"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8388608'">
				<xsl:value-of select="$strClearForeignConfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16777216'">
				<xsl:value-of select="$strImportForeignConfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='33554432'">
				<xsl:value-of select="$strForcedImportForeignConfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                  <xsl:when test="$MethodValue='67108864'"> <!--Revert-->
				<xsl:value-of select="$strChangeControllerProperties"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='536870912'">
				<xsl:value-of select="$strForeignConfigOperations"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                  <xsl:when test="$MethodValue='268435456'">
				<xsl:value-of select="$strPinnedCache"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                  <xsl:when test="$MethodValue='1073741824'">
				<xsl:value-of select="$strManageSecurityKey"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2147483648'">
			    <xsl:value-of select="$strDimmerSwitch"/>
				<xsl:value-of select="$strEllipse"/>
                  </xsl:when>	
                 


			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetControllerAlarm">
		<xsl:param name="MethodValue"/>
		<xsl:if test="string-length($MethodValue) = 32">
			<!--problem w/ screen not displaying; making sure mask comes back as bit values-->
			<xsl:choose>
				<xsl:when test="substring($MethodValue,30,1)='0' and substring($MethodValue,29,1)='0' and substring($MethodValue,28,1)='0' ">
					<!--if the masks are never set; then assume alarm function is not applicable-->
					<xsl:value-of select="$strNotApplicable"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="substring($MethodValue,30,1)='0'">
							<xsl:value-of select="$strEnabled"/>
						</xsl:when>
						<xsl:when test="substring($MethodValue,29,1)='0'">
							<xsl:value-of select="$strDisabled"/>
						</xsl:when>
						<xsl:when test="substring($MethodValue,28,1)='0'">
							<xsl:value-of select="$strQuiet"/>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- ENCLOSURE ALARM STATE -->
	<xsl:template name="GetEnclosureAlarm">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state = 0">
				<xsl:value-of select="$strDisabled"/>
			</xsl:when>
			<xsl:when test="$state = 1">
				<xsl:value-of select="$strEnabled"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetBatteryMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strRechargeBattery"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
			    <xsl:value-of select="$strStartLearn"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
			    <xsl:value-of select="$strDelayLearn"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetChannelMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strRescan"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strPauseIO"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strResumeIO"/>
			</xsl:when>
			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetEnclosureMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strEnableAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strDisableAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strSetTagData"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strSetTempData"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='64'">
				<xsl:value-of select="$strBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strSetAllTempData"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strUnBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='512'">
			    <xsl:value-of select="$strOccupancySlotReport"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetVirtualDiskMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strReconfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strFormat"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strCancelFormat"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strRecover"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16'">
				<xsl:value-of select="$strDelete"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32'">
				<xsl:value-of select="$strCheckConsistency"/>
			</xsl:when>
			<xsl:when test="$MethodValue='64'">
				<xsl:value-of select="$strInitialize"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strConfigDedHS"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='512'">
				<xsl:value-of select="$strUnBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1024'">
				<xsl:value-of select="$strRename"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2048'">
				<xsl:value-of select="$strCancelCheckConsistency"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4096'">
				<xsl:value-of select="$strCancelInit"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8192'">
				<xsl:value-of select="$strSplitMirror"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16384'">
				<xsl:value-of select="$strUnMirror"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32768'">
				<xsl:value-of select="$strCancelRebuild"/>
			</xsl:when>
			<xsl:when test="$MethodValue='65536'">
				<xsl:value-of select="$strPauseCheckConsistency"/>
			</xsl:when>
			<xsl:when test="$MethodValue='131072'">
				<xsl:value-of select="$strResumeCheckConsistency"/>
			</xsl:when>
			<xsl:when test="$MethodValue='262144'">
				<xsl:value-of select="$strCancelReconfig"/>
			</xsl:when>
			<xsl:when test="$MethodValue='524288'">
				<xsl:value-of select="$strChangePolicy"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1048576'">
				<xsl:value-of select="$strCancelBGI"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4194304'">
				<xsl:value-of select="$strSlowInitialize"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8388608'">
				<xsl:value-of select="$strFastInitialize"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16777216'">
				<xsl:value-of select="$strReplaceMemberDisk"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                        <xsl:when test="$MethodValue='134217728'">
				<xsl:value-of select="$strSecureVirtualDisk"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='67108864'">
				<xsl:value-of select="$strClearVDBadBlocks"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                  <xsl:when test="$MethodValue='268435456'">
				<xsl:value-of select="$strResizeSSC"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                        <xsl:when test="$MethodValue='536870912'">
				<xsl:value-of select="$strPartitionEnableFluidCache"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1073741824'">
				<xsl:value-of select="$strPartitionDisableFluidCache"/>
			</xsl:when>
   			<xsl:when test="$MethodValue='2147483648'">
				<xsl:value-of select="$strReactivate"/>
			</xsl:when>
			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetStorageMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strGlobalRescan"/><xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strEnableSTS"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strDisableSTS"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strSetHSProtectionPolicy"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
        <xsl:template name="GetVDPartitions">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='536870912'">
				<xsl:value-of select="$strPartitionEnableFluidCache"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1073741824'">
				<xsl:value-of select="$strPartitionDisableFluidCache"/>
			</xsl:when>
                  <xsl:when test="$MethodValue= '2147483648'">
				<xsl:value-of select="$strReactivate"/>
			</xsl:when>

		</xsl:choose>
	</xsl:template>
      <xsl:template name="GetFluidCacheDisksMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strDisableWithDicard"/>
			</xsl:when>
			<!--xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strReactivate"/>
			</xsl:when-->
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetArrayDiskMethods">
		<xsl:param name="MethodValue"/>
            <xsl:param name="BusProtocol"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strUnBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strDiags"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strCancelDiags"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16'">
				<xsl:value-of select="$strAssignGlobalHS"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32'">
				<xsl:value-of select="$strUnassignGlobalHS"/>
			</xsl:when>
			<xsl:when test="$MethodValue='64'">
				<xsl:value-of select="$strOnline"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strOffline"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strPreparetoRemove"/>
			</xsl:when>
			<xsl:when test="$MethodValue='512'">
				<xsl:value-of select="$strFormat"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1024'">
				<xsl:value-of select="$strRebuild"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2048'">
				<xsl:value-of select="$strCancelRebuild"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4096'">
				<xsl:value-of select="$strInitialize"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8192'">
				<xsl:value-of select="$strVerify"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16384'">
				<xsl:value-of select="$strCancelVerify"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32768'">
				<xsl:value-of select="$strRemoveDeadDisks"/>
			</xsl:when>
			<xsl:when test="$MethodValue='65536'">
				<xsl:value-of select="$strAdiskClear"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='131072'">
				<xsl:value-of select="$strAdiskCancelClear"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='524288'">
				<xsl:value-of select="$strCancelCopyback"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                  <xsl:when test="$MethodValue='2097152'">
                        <xsl:choose>
                        <xsl:when test="BusProtocol = '9'">
				<xsl:choose>
			           <xsl:when test="(IsDeviceNVME and IsDeviceNVME = '1')">
				        <xsl:value-of select="$strCryptographicErase"/>
			           </xsl:when>
			           <xsl:otherwise>
				        <xsl:value-of select="$strFullInitialization"/>
			           </xsl:otherwise>
			       </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                             <xsl:value-of select="$strEraseASecureDisk"/>
                        </xsl:otherwise>
                       </xsl:choose>
			</xsl:when>
             <xsl:when test="$MethodValue='4194304'">
			     <xsl:value-of select="$strConvertNonRAID"/>
             </xsl:when>
        	 <xsl:when test="$MethodValue='8388608'">
			     <xsl:value-of select="$strConvertRAIDCapable"/>
             </xsl:when>
            <xsl:when test="$MethodValue='33554432'">
                <xsl:value-of select="$strDisableWriteCache"/>
            </xsl:when>
            <xsl:when test="$MethodValue='16777216'">
                <xsl:value-of select="$strEnableWriteCache"/>
            </xsl:when>
            <xsl:when test="$MethodValue='67108864'">
                <xsl:value-of select="$strExportLog"/>
            </xsl:when>
                        <xsl:when test="$MethodValue='134217728'">
                            <xsl:value-of select="$strAddPDToCachePool"/>
                        </xsl:when>
                        <xsl:when test="$MethodValue='268435456'">
                            <xsl:value-of select="$strRemovePDFromCachePool"/>
                        </xsl:when>
				<xsl:when test="$MethodValue='536870912'">
                            <xsl:value-of select="$strReactivate"/>
                        </xsl:when>
      
      <!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>
        <!--6.0 changes-->
        <xsl:template name="GetControllerProperty">
	         <xsl:param name="PropertyMode"/>
			    
	            <xsl:choose>			
		       <xsl:when test="$PropertyMode='4096' or $PropertyMode='32768' or  $PropertyMode='4' or  $PropertyMode='1073741824' or $PropertyMode='32' or $PropertyMode='128' or  $PropertyMode='512' or $PropertyMode='2048'">
			   <xsl:message><xsl:value-of select="$PropertyMode"/></xsl:message>
			    <xsl:value-of select="$strEnabled"/>
		       </xsl:when>
                   <xsl:when test="$PropertyMode='1'">
			    <xsl:value-of select="$strDetected"/>
		       </xsl:when>
                   <xsl:when test="$PropertyMode='2'">
			    <xsl:value-of select="$strClear"/>
		       </xsl:when>
                   <xsl:when test="$PropertyMode='262144'">
			    <xsl:value-of select="$strAuto"/>
		       </xsl:when>

		       <xsl:when test="$PropertyMode='1048576' or $PropertyMode='131072' or $PropertyMode='524288' or  $PropertyMode='8' or  $PropertyMode='536870912' or $PropertyMode='16' or $PropertyMode='64' or $PropertyMode='256' or $PropertyMode='1024'">
			     <xsl:value-of select="$strDisabled"/>
		       </xsl:when>
		 </xsl:choose>
        </xsl:template>
         
      <!--6.0 changes-->
      <!-- Bharath Changes 6.0 for cli-->
      

  
  <!--Romoved multiple templates each of which was used for one seperate property.Same can be achived by single Template as functionality is same--> 
   <!-- Bharath Changes 6.0 for cli-->
       <xsl:template name="CLIGetAbortCConError">
    <xsl:param name="state"/>
    <xsl:choose>
      <xsl:when test="$state='1'">
        <xsl:value-of select="$strEnabled"/>
      </xsl:when>
      <xsl:when test="$state='0'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$state"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="CLIGetCopyback">
    <xsl:param name="state"/>
    <xsl:choose>
      <xsl:when test="$state='0'">
        <xsl:value-of select="$strEnabled"/>
      </xsl:when>
      <xsl:when test="$state='1'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$state"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="CLIGetSmarter">
    <xsl:param name="state"/>
    <xsl:choose>
      <xsl:when test="$state='1'">
        <xsl:value-of select="$strEnabled"/>
      </xsl:when>
      <xsl:when test="$state='0'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$state"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="CLIGetLoadbalance">
    <xsl:param name="state"/>
    <xsl:choose>
      <xsl:when test="$state='0'">
        <xsl:value-of select="$strAuto"/>
      </xsl:when>
      <xsl:when test="$state='1'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$state"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
 <xsl:template name="CLIGetMultiPathview">
    <xsl:param name="AttributesMask"/>
    <xsl:param name="ChangeControllerPropertyMask"/>
    <xsl:choose>
         <xsl:when test="substring($AttributesMask,26,1)='1'">
                <xsl:choose> 
                   <xsl:when test="substring($ChangeControllerPropertyMask,32,1)='1'"><xsl:value-of select="$strDetected"/></xsl:when>
                   <xsl:when test="substring($ChangeControllerPropertyMask,31,1)='0'"><xsl:value-of select="$strCleared"/></xsl:when>
                   <xsl:otherwise> <xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
                </xsl:choose>
         </xsl:when>
         <xsl:otherwise>
                   <xsl:value-of select="$strNotApplicable"/>
         </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<!--BharathChanges-->


      <xsl:template name="ConvertBinaryToDecimal">
		<xsl:param name="BinaryStr"/>
		<xsl:param name="DecValue" select="0"/>
		<xsl:param name="BitVal" select="1"/>
		<xsl:param name="increment" select="-1"/>
		<xsl:param name="i" select="32"/>
		<xsl:param name="testValue" select="1"/>
		<xsl:if test="$i >= $testValue">
			<xsl:call-template name="ConvertBinaryToDecimal">
				<xsl:with-param name="BinaryStr" select="$BinaryStr"/>
				<xsl:with-param name="DecValue">
					<xsl:choose>
						<xsl:when test="substring($BinaryStr,$i,1)='1'">
							<xsl:value-of select="$DecValue+$BitVal"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$DecValue"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="BitVal" select="$BitVal*2"/>
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="testValue" select="$testValue"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$i = '0'">
			<xsl:value-of select="$DecValue"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="for-loop-list-box">
		<xsl:param name="Mask"/>
		<xsl:param name="Default"/>
		<xsl:param name="currPolicy"/>
		<xsl:param name="BitValue" select="1"/>
		<xsl:param name="i" select="32"/>
		<xsl:param name="increment" select="-1"/>
		<xsl:param name="testValue" select="1"/>
		<xsl:param name="templateName"/>
            <xsl:param name="BusProtocol"/>
            <xsl:param name="AdditionalCurrentMethodMask" select="0"/>
		<xsl:if test="$i >= $testValue">
			<xsl:if test="substring($Mask,$i,1)='1' ">
                          
				<xsl:choose>
					<xsl:when test="$templateName='1'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetStripeSize"><xsl:with-param name="stripesize" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='2'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetReadPolicy"><xsl:with-param name="readpolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							<xsl:if test="$BitValue = $Default">
									<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='3'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetWritePolicy"><xsl:with-param name="writepolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							<xsl:if test="$BitValue = $Default">
									<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='4'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetCachePolicy"><xsl:with-param name="cachepolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='5'">
                                <xsl:choose>
                                   <xsl:when test="$AdditionalCurrentMethodMask ='1'">
                               			  <Choice>
								     		 <xsl:attribute name="value"><xsl:call-template name="GetControllerMethods1"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
								     		 <xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue + 2147483648"/></xsl:attribute>
                                                  </Choice>
                                   </xsl:when>
                                   <xsl:otherwise>
                                       <xsl:choose>
                                      		 <xsl:when test="substring($Mask,6,1)='1'">
                                        			  <xsl:if test="$BitValue != '4096'and $BitValue != '32'and $BitValue != '8192'and $BitValue != '16384'and $BitValue != '65536' and $BitValue != '134217728' and $BitValue != '131072'">
									  <!--do not show change scsi id in GUI CTRL PROPS-->
						        			<Choice>
								     		 <xsl:attribute name="value"><xsl:call-template name="GetControllerMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
								     		 <xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
                                                            </Choice>
						                   </xsl:if>
                                                 </xsl:when>
                                            <xsl:when test="substring($Mask,6,1)='0'">
						           <xsl:if test="$BitValue != '4096' and $BitValue != '134217728' and $BitValue != '131072'">
							      <!--do not show change scsi id in GUI-->
							      <Choice>
								    <xsl:attribute name="value"><xsl:call-template name="GetControllerMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
								    <xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							      </Choice>
						          </xsl:if>
                                          </xsl:when>
                                      </xsl:choose>

                                   </xsl:otherwise>
                                 </xsl:choose>  
					</xsl:when>
					<xsl:when test="$templateName='6'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetBatteryMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='7'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetChannelMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='8'">
						<!--Bit 16 corresponds to Encl_power_down which has no corresponding task -->
						<xsl:if test="$BitValue != '16' and $BitValue != '512'">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetEnclosureMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='9'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetVirtualDiskMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='10'">
                                            <xsl:if test="$BitValue != '1048576'">
                          			<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetArrayDiskMethods"><xsl:with-param name="MethodValue" select="$BitValue"/><xsl:with-param name="BusProtocol" select="$BusProtocol"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
                                            </xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='11'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='12'">
						<xsl:if test="$BitValue != $currPolicy">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetReadPolicy"><xsl:with-param name="readpolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='13'">
						<xsl:if test="$BitValue != $currPolicy">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetWritePolicy"><xsl:with-param name="writepolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='14'">
						<xsl:if test="$BitValue != $currPolicy">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetCachePolicy"><xsl:with-param name="cachepolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='15'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetStorageMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
                    <xsl:when test="$templateName='16'">
                        <xsl:if test="substring($Mask,17,1)='1' and $BitValue = '32768'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">131072</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,17,1)='0' and $BitValue='131072'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">32768</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>  
                    </xsl:when>
                    <xsl:when test="$templateName='17'">
                        <xsl:if test="substring($Mask,14,1)='1' and $BitValue = '262144'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">524288</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,14,1)='0' and $BitValue='524288'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">262144</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when>
                    <xsl:when test="$templateName='18'">
                        <xsl:if test="substring($Mask,30,1)='1' and $BitValue = '4'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">8</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,30,1)='0' and $BitValue='8'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">4</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when>
                    <xsl:when test="$templateName='19'">
                        <xsl:if test="substring($Mask,20,1)='1' and $BitValue = '4096'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">1048576</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,20,1)='0' and $BitValue='1048576'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">4096</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when>
                    <xsl:when test="$templateName='20'">
						<xsl:if test="$BitValue != $currPolicy">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetDiskCachePolicy"><xsl:with-param name="DiskCachePolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
								<xsl:if test="$BitValue = '2' and //OMA/BusProtocol = '8'">
									<xsl:attribute name="default">true</xsl:attribute>
								</xsl:if>
							</Choice>
						</xsl:if>
					</xsl:when>
                    <xsl:when test="$templateName='21'">
                        <xsl:if test="substring($Mask,32,1)='1' and $BitValue = '1'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">2</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,32,1)='0' and $BitValue='2'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">1</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when>
				    <xsl:when test="$templateName='22'">
						<xsl:if test="$BitValue != $currPolicy">
						    <Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetWarningLevels"><xsl:with-param name="warnvalue" select="WarningLevel"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
					    </xsl:if>
					</xsl:when>
                    <xsl:when test="$templateName='23'">
                        <xsl:if test="substring($Mask,2,1)='1' and $BitValue = '1073741824'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">536870912</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,2,1)='0' and $BitValue='536870912'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">1073741824</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when>
				    <xsl:when test="$templateName='23'">
                        <xsl:if test="substring($Mask,2,1)='1' and $BitValue = '1073741824'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">536870912</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,2,1)='0' and $BitValue='536870912'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">1073741824</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when>
					<xsl:when test="$templateName='24'">
                        <xsl:if test="substring($Mask,27,1)='1' and $BitValue = '32'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">16</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,27,1)='0' and $BitValue='16'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">32</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when> 
					<xsl:when test="$templateName='25'">
                        <xsl:if test="substring($Mask,25,1)='1' and $BitValue = '128'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">64</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,25,1)='0' and $BitValue='64'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">128</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when> 
					<xsl:when test="$templateName='26'">
                        <xsl:if test="substring($Mask,23,1)='1' and $BitValue = '512'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">256</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,23,1)='0' and $BitValue='256'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">512</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when> 
					<xsl:when test="$templateName='27'">
                        <xsl:if test="substring($Mask,21,1)='1' and $BitValue = '2048'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">1024</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">2</xsl:attribute>
                            </Choice>
                        </xsl:if>
                        <xsl:if test="substring($Mask,21,1)='0' and $BitValue='1024'">
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">2048</xsl:with-param></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue">1</xsl:attribute>
                            </Choice>
                        </xsl:if>
                    </xsl:when> 
                    <xsl:when test="$templateName='28'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetVDPartitions"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
		   </xsl:when>
		    <xsl:when test="$templateName='29'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetFluidCacheDisksMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
		   </xsl:when>
 	 
                   <xsl:when test="$templateName='28'">
                             <xsl:message> inside utils cvdutilsPROTOCOLMask=[<xsl:value-of select="$Mask"/>]</xsl:message>
                              <xsl:message> inside utils BitValue=[<xsl:value-of select="$BitValue"/>]</xsl:message>


                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetBusProtocolProperty"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
		                        <xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>

                            </Choice>
                       
                        
                   </xsl:when> 

                  <xsl:when test="$templateName='29'">
                      
                            <Choice>
                                <xsl:attribute name="value"><xsl:call-template name="GetMediaTypeProperty"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
		                    <xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>

                            </Choice>
                       
                   </xsl:when> 
 
  				</xsl:choose>
			</xsl:if>
			<xsl:call-template name="for-loop-list-box">
				<xsl:with-param name="Mask" select="$Mask"/>
				<xsl:with-param name="Default" select="$Default"/>
				<xsl:with-param name="currPolicy" select="$currPolicy"/>
				<xsl:with-param name="BitValue" select="$BitValue*2"/>
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="testValue" select="$testValue"/>
				<xsl:with-param name="templateName" select="$templateName"/>
                        <xsl:with-param name="AdditionalCurrentMethodMask" select="$AdditionalCurrentMethodMask"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

    <xsl:template name="ReplaceKey">
	<xsl:param name="KeyId"/>
	<xsl:if test="contains($KeyId, '&#92;')">
		<xsl:value-of select="translate($KeyId, '&#92;','&#95;')"/>
	</xsl:if>
	<xsl:if test="not(contains($KeyId, '&#92;'))">
		<xsl:value-of select="$KeyId"/>
	</xsl:if>

    </xsl:template>

    <xsl:template name="ModNexus">
	<xsl:param name="nexus"/>
<!--uncomment the following to use nexus .....
		<xsl:value-of select="ObjID"/>
-->
	<xsl:if test="contains($nexus, '&#92;')">
		<xsl:value-of select="translate($nexus, '&#92;','&#46;')"/>
	</xsl:if>
	<xsl:if test="not(contains($nexus, '&#92;'))">
		<xsl:message>not <xsl:value-of select="$nexus"/></xsl:message>
		<xsl:value-of select="$nexus"/>
	</xsl:if>

    </xsl:template>
	<xsl:template name="errorhandling">
		<script language="javascript">
			function SetBackToButtonLink() {
		 		// Set the BackToLink for error handling
		 		var url = "";
		 		url += document.location;

        if (url != null &amp;&amp; url.indexOf("DataArea") != -1)
        {
            var split_url = url.split("DataArea");
            url = "/DataArea" + split_url[1];
        }
        else if (url != null &amp;&amp; url.indexOf("SubmitForm") != -1)
        {
            var split_url = url.split("SubmitForm");
            url = "/SubmitForm" + split_url[1];
        }

				var link = document.getElementById("BackToLink");
				if(link != null) {
					link.value = url;
				}
			}
		</script>
	</xsl:template>
	<xsl:template name="scripts">
	<!--xsl:template match="/"-->
		<script language="javascript">
             function ValidateFormat(ExpressionArray)
             { 
                var CharacterRange= /^([0-9]|[a-z]|[A-Z]|&amp;|&lt;|&gt;|&quot;|&apos;|\`|;|:|\(|\)|\~|\!|\@|\#|\$|\%|\^|\*|_|\+|\=|-|\?|\.|\,|\||}|{|\]|\[|\|\/|\\)$/;
                var spacetest = /^[\s]$/;  
                var length= ExpressionArray.length;
             
                  for ( var i =0; i&lt;length ; i++)
                  {
                     if(CharacterRange.test(ExpressionArray.charAt(i)) &amp;&amp; (i==length-1))
                      {  
                          return true;      
                      }
                      if(spacetest.test(ExpressionArray.charAt(i))) 
                      {  
                          return false;
                      }                
                  }
                 return false;
              }
                
            function ReplaceAll(Source,stringToFind,stringToReplace)
                {   
                       
                        for(var i=0; i&lt;Source.length;i++)
                        {
                            if(Source[i]== stringToFind)
                            {
                                    Source=Source.replace(stringToFind,stringToReplace);
                            }                 
                        }
                        return Source;
                 }
		    function GetLocalUrl() {
				// Need to retrieve the URL for the current page to pass to the web plugin.  This is needed for
				// the error handling which will bring the user back to this page if an error has occured.
				var url = "";
				url += document.location;

				// The URL needs to be passed into the web plugin, but passing an entire URL with &amp; in it as a parameter confuses
				// the calling URL.  Tokenize this and replace the &amp; with !!.  The error.xsl will reverse this back to a callable URL.  Also
				// strip off the https://hostname:port/ piece of the URL.  Originally, I tokenized off of the prot # 1311, but since this could
				// change, it's better to tokenize off of the word "servlet", then just add that back in.
      
        if (url != null &amp;&amp; url.indexOf("DataArea") != -1)
        {
            var split_url = url.split("DataArea");
            url = "./DataArea" + split_url[1];
        }
        else if (url != null &amp;&amp; url.indexOf("SubmitForm") != -1)
        {
            var split_url = url.split("SubmitForm");
            url = "./SubmitForm" + split_url[1];
        }
      
				split_url = url.split("&amp;");
				var end_count = split_url.length;
				var new_url = "";
				for(count=0; count &lt; end_count-1; count++)
				{
					new_url += split_url[count] + "!";
				}
				new_url += split_url[end_count-1];
				return new_url;
		    }

		    function UnMungeURL(url)
		    {
					// The HREF URL passed in has !! in place of the &amp;.  this was need to be able to pass it to the web plugin.
					// Reverse this and replace the !! with &amp; here.
					var split_url = url.split("!");
					var end_count = split_url.length;
					var href = "";
					for(count=0; count &lt; end_count-1; count++)
					{
						href += split_url[count] + "&amp;";
				 	}
					href += split_url[end_count-1];
					return href;
			 }

		   // Checks to make sure that text only contains alphanumeric and space, dash and underscores.
		   // Also name cannot begin or end with a space.
		   function isValidName(text)
			 {
				var validchars = /^[a-zA-Z0-9_ -]*$/;
				if( validchars.test(text))
				{

					// cannot start or end with a space.
					if(/^ /.test(text) || / $/.test(text))
					{
					   alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strStartSpace"/>");
					   return false
					}

					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidString"/>");
				return false;
			}

		   // Checks to make sure that text only contains alphanumeric and space, dash and underscores.
		   function isValidNameWithSpace(text)
			 {
				var validchars = /^[a-zA-Z0-9_ -]*$/;
				if( validchars.test(text))
				{
					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidString"/>");
				return false;
			}

		   // Checks to make sure that text only contains alphanumeric and  dash and underscores.  NO SPACE
		   function isValidNameNoSpace(text)
			 {
			  	var validchars = /^[a-zA-Z0-9_-]*$/;
				if( validchars.test(text))
				{
					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidStringNoSpace"/>");
      return false;
      }

      //Removes the leading zeros example: for 009 give it as 9
      function removeLeadingZeros(inputval)
      {
        while (inputval.charAt(0)=='0')
        {
          inputval = inputval.substring(1, inputval.length);
        }
        if (inputval == '')
        {
          inputval = 0;
        }
        return inputval;
      }

    </script>
	</xsl:template>

	<!--bitwise and operator-->
	<xsl:template name="bitAnd">
		<xsl:param name="num1" />
		<xsl:param name="num2" />
		<xsl:param name="result" select="0"/>
		<xsl:param name="pow2" select="1"/>

		<xsl:choose>
			<xsl:when test="$num1 &lt; 1 or $num2 &lt; 1">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:when test="$num1 mod 2 and $num2 mod 2">
				<xsl:call-template name="bitAnd">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="floor($num2 div 2)"/>
					<xsl:with-param name="result" select="$result+$pow2"/>
					<xsl:with-param name="pow2" select="$pow2*2"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="bitAnd">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="floor($num2 div 2)"/>
					<xsl:with-param name="result" select="$result"/>
					<xsl:with-param name="pow2" select="$pow2*2"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called only when ClusterMode tag is available in the controller xml-->
	<xsl:template name="GetClusterMode">
		<xsl:param name="mode"/>
		<xsl:choose>
			<!--check if Cluster Allowed bit (0x00000004) is ON -->
			<xsl:when test="substring($mode,30,1)='1'">
				<xsl:choose>
					<!--check if Cluster Enabled bit (0x00000002) is ON-->
					<xsl:when test="substring($mode,31,1)='1'">
						<xsl:choose>
							<!--check if Cluster Active bit (0x00000001) is ON-->
							<xsl:when test="substring($mode,32,1)='1'">
								<xsl:value-of select="$strActive"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strEnabled"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!--Cluster Enabled bit is Off-->
					<xsl:otherwise>
						<xsl:value-of select="$strDisabled"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!--Cluster Allowed bit is disabled-->
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called only when PatrolReadMode tag is available in the controller xml-->
	<xsl:template name="GetPatrolReadMode">
		<xsl:param name="mode"/>
		<xsl:choose>
			<!--Patrol Read Enabled bit (0x00000001) is ON-->
			<xsl:when test="substring($mode,32,1)='1'">
				<xsl:choose>
					<!--check if Patrol Read Auto bit (0x00000002) is ON-->
					<xsl:when test="substring($mode,31,1)='1'">
						<xsl:value-of select="$strAuto"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$strManual"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!--Patrol Read Enabled bit is disabled-->
			<xsl:otherwise>
				<xsl:value-of select="$strDisabled"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called only when PatrolReadState tag is available in the controller xml-->
	<xsl:template name="GetPatrolReadState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='1'">
				<xsl:value-of select="$strStopped"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strReady"/>
			</xsl:when>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strActive"/>
			</xsl:when>
			<xsl:when test="$state='8'">
				<xsl:value-of select="$strAborted"/>
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called only when AlarmState tag is available in the controller xml-->
	<xsl:template name="GetAlarmState">
		<xsl:param name="state"/>
		<xsl:choose>
			<!--Alarm State Present bit (0x00000002) is On-->
			<xsl:when test="substring($state,31,1)='1'">
				<xsl:choose>
					<!--check if Alarm State Enabled bit (0x00000001) is ON-->
					<xsl:when test="substring($state,32,1)='1'">
						<xsl:value-of select="$strEnabled"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$strDisabled"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!--Alarm State Present bit is Off-->
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!--This template gets called for battery capacity state in the battery xsl
		 Capacity state = Failed/Ready/Unknown
	-->
	<xsl:template name="getBtryCapacityState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strUnknown"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strReady"/>
			</xsl:when>
			<xsl:when test="$state='1'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called for learn state in the battery xsl
       Learn state =  Failed/Active/Timed Out/Requested/Idle
	-->
	<xsl:template name="getBtryLearnState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='1'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strActive"/>
			</xsl:when>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strTimedOut"/>
			</xsl:when>
			<xsl:when test="$state='8'">
				<xsl:value-of select="$strRequested"/>
			</xsl:when>
			<xsl:when test="$state='16'">
				<xsl:value-of select="$strIdle"/>
			</xsl:when>
			<xsl:when test="$state='32'">
				<xsl:value-of select="$strDue"/>
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- This template is called by the battery reporting to convert hours into days.
	     It shows the singular or plural form of days and hours.
	     The empty <xsl:text> </xsl:text> are to put in whitespaces so the output is
	      not all run in together.
	  -->
	<xsl:template name="formatHoursToDays">
		<xsl:param name="time"/>
		<xsl:choose>
			<xsl:when test="$time &gt; 24 ">
					<xsl:value-of select="floor($time div 24)"/><xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="floor($time div 24)=1">
							<xsl:value-of select="$strDay"/>
						</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$strDays"/>
					</xsl:otherwise>
					</xsl:choose>

					<xsl:text> </xsl:text><xsl:value-of select="$time mod 24"/><xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="($time mod 24)=1">
							<xsl:value-of select="$strHour"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$strHours"/>
						</xsl:otherwise>
					</xsl:choose>
			</xsl:when>

			<xsl:otherwise>
					<xsl:value-of select="$time"/><xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="$time=1">
							<xsl:value-of select="$strHour"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$strHours"/>
						</xsl:otherwise>
					</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetLearnMode">
		<xsl:param name="learnMode"/>
		<xsl:choose>
			<xsl:when test="$learnMode=1">
				<xsl:value-of select="$strAuto"/>
			</xsl:when>
			<xsl:when test="$learnMode=2">
				<xsl:value-of select="$strWarn"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

        <!--
        This template should be called to get the Back Page link.
        XML should contain BackTo tag under OMA for this template to give
        correct value. In webplugin to add the BackTo tag in XML it is required
        to call CreateReturnLink(..) method should be called inside
        public String getXMLStringFromWebPlugin(HttpServletRequest req) and also
        Method BackToLink should be called at the end eg.
                    sXML += backToLink("",req);

        -->
        <xsl:template name="BackPage" match="OMA">
          <xsl:param name="defaultBackPage">
          </xsl:param>
          <xsl:choose>
            <xsl:when test="BackTo and BackTo!=''">
              <xsl:value-of select="BackTo"/>
            </xsl:when>

            <xsl:otherwise><xsl:value-of select="$defaultBackPage"/></xsl:otherwise>
          </xsl:choose>
        </xsl:template>
        
        <xsl:template name="ReturnPage">
          <xsl:param name="defaultBackPage">./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=stprhl</xsl:param>
          <xsl:param name="BackTo">
          </xsl:param>
          <xsl:choose>
            <xsl:when test="BackTo and BackTo='/'"><xsl:value-of select="$defaultBackPage"/></xsl:when>
            <xsl:when test="BackTo and BackTo!=''"><xsl:value-of select="translate($BackTo,'!','&amp;')"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$defaultBackPage"/></xsl:otherwise>
          </xsl:choose>
        </xsl:template>
        
        
        <xsl:template name="GetForeignErrorDetails">
          <xsl:param name="ErrorCode"/>
		<xsl:choose>
			<xsl:when test="$ErrorCode='2249'">
				<xsl:value-of select="$strExceedMaxVDLimit"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2250'">
				<xsl:value-of select="$strUnsupportedRAIDLevel"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2251'">
				<xsl:value-of select="$strMissingSpan"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2252'">
				<xsl:value-of select="$strMissingPD"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2253'">
				<xsl:value-of select="$strStalePD"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2254'">
				<xsl:value-of select="$strOrphanDrive"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2255'">
				<xsl:value-of select="$strIncompatiblePD"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2256'">
				<xsl:value-of select="$strPartialForeignVD"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='0'">
				<!-- Do not display anything -->
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
        </xsl:template>
                <xsl:template name="SortThreeVariables">
	            <xsl:param name="a"/>
	            <xsl:param name="b"/>
	            <xsl:param name="c" select="0"/>
			<xsl:choose>
				<xsl:when test="($a &gt; $b) and ($a &gt; $c)">
					<xsl:value-of select="$a"/>
				</xsl:when>
				<xsl:when test="($b &gt;= $c)">
					<xsl:value-of select="$b"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$c"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:template>
	        <xsl:template name="DiskGroup">
	            <xsl:param name="BusProtocol" select="0"/>
	            <xsl:param name="MediaType"/>
	            <xsl:param name="MixofMediaProtocolinVD"/>
	            <xsl:param name="ArrayDiskCountSCSISSD" select="0"/>
	            <xsl:param name="ArrayDiskCountSCSIHDD" select="0"/>
	            <xsl:param name="ArrayDiskCountSATASSD" select="0"/>
	            <xsl:param name="ArrayDiskCountSATAHDD" select="0"/>
	            <xsl:param name="ArrayDiskCountSASSSD" select="0"/>
	            <xsl:param name="ArrayDiskCountSASHDD" select="0"/>
	            <xsl:param name="ArrayDiskCountSSD" select="0"/>
	            <xsl:param name="ArrayDiskCountSATA" select="0"/>
	            <xsl:param name="ArrayDiskCountSAS" select="0"/>
	            <xsl:param name="ArrayDiskCountSATAHDD_SSD" select="0"/>
	            <xsl:param name="ArrayDiskCountSASHDD_SSD" select="0"/>
	            <xsl:param name="MIN_DRIVES_FOR_SELECTED_LAYOUT" select="0"/>
                  <xsl:message> BusProtocol=[<xsl:value-of select="$BusProtocol"/>]</xsl:message>
                  <xsl:message> MediaType=[<xsl:value-of select="$MediaType"/>]</xsl:message>
                  <xsl:message> MixofMediaProtocolinVD=[<xsl:value-of select="$MixofMediaProtocolinVD"/>]</xsl:message>
                  

                    <xsl:variable name="GLOBAL_VAR_SCSI">1</xsl:variable>
	            <xsl:variable name="GLOBAL_VAR_SCSIHDD">0</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_SCSISSD">0</xsl:variable>
	            <xsl:variable name="GLOBAL_VAR_ATA">2</xsl:variable>  
	            <xsl:variable name="GLOBAL_VAR_SATA">7</xsl:variable>
	            <xsl:variable name="GLOBAL_VAR_SAS">8</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_SATASSD">3</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_SATAHDD">4</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_SASSSD">5</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_SASHDD">6</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_SSD">9</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_HDD">10</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_SATAHDDandSSD">11</xsl:variable>
                    <xsl:variable name="GLOBAL_VAR_SASHDDandSSD">12</xsl:variable>
                    <xsl:variable name="SCSI"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SCSI"/></xsl:call-template></xsl:variable>
	            <xsl:variable name="SCSIHDD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SCSIHDD"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="SCSISSD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SCSISSD"/></xsl:call-template></xsl:variable>
	            <xsl:variable name="ATA"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_ATA"/></xsl:call-template></xsl:variable>
	            <xsl:variable name="SATA"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SATA"/></xsl:call-template></xsl:variable>
	            <xsl:variable name="SAS"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SAS"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="SATASSD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SATASSD"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="SATAHDD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SATAHDD"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="SASSSD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SASSSD"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="SASHDD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SASHDD"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="SSD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SSD"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="HDD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_HDD"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="SATAHDDandSSD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SATAHDDandSSD"/></xsl:call-template></xsl:variable>
                    <xsl:variable name="SASHDDandSSD"><xsl:call-template name="PowerofTwo"><xsl:with-param name="num2" select="$GLOBAL_VAR_SASHDDandSSD"/></xsl:call-template></xsl:variable>
                     
                    <xsl:choose>
	            <xsl:when test="$BusProtocol='384' and $MediaType='3' and $MixofMediaProtocolinVD='0'"><!--1 SASSSD, SATASSD,SASHHD,SATAHDD- -SASHDD x=0 y=0 SSDHDD SASSATA-->
	                     <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD"/></xsl:when><!--SASSSD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD+$SASHDD"/></xsl:when><!--SASHDD,SASSSD-->
	                    <!--4 -->     <xsl:when test="$ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--5 -->     <xsl:when test="$ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SATAHDD"/></xsl:when><!--SASHDD,SATAHDD-->
	                    <!--6 -->     <xsl:when test="$ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD + $SATAHDD"/></xsl:when><!--SASSSD,SATAHDD-->
	                    <!--7 -->     <xsl:when test="$ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD + $SASHDD + $SATAHDD"/></xsl:when><!--SASHDD,SASSSD,SATAHDD-->
	                    <!--8 -->     <xsl:when test="$ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATASSD"/></xsl:when><!--SATASSD-->
	                    <!--9 -->     <xsl:when test="$ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SATASSD"/></xsl:when><!-- SASHDD,SATASSD-->
	                    <!--10 -->    <xsl:when test="$ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD + $SATASSD"/></xsl:when><!--SASSSD,SATASSD-->
	                    <!--11 -->    <xsl:when test="$ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SASSSD + $SATASSD"/></xsl:when><!--SASHDD,SASSSD,SATASSD-->
	                    <!--12 -->    <xsl:when test="$ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD + $SATASSD"/></xsl:when><!--SATAHDD,SATASSD-->
	                    <!--13 -->    <xsl:when test="$ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SATAHDD + $SATASSD "/></xsl:when><!--SASHDD,SATAHDD,SATASSD-->
	                    <!--14 -->    <xsl:when test="$ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD + $SATAHDD + $SATASSD"/></xsl:when><!--SASSSD,SATAHDD,SATASSD-->
	                    <!--15 -->    <xsl:when test="$ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD +$SASSSD + $SATAHDD + $SATASSD"/></xsl:when><!--SASHDD,SASSSD,SATAHDD,SATASSD-->
	                     </xsl:choose>
	            </xsl:when>         
	            <xsl:when test="$BusProtocol='384' and $MediaType='3' and $MixofMediaProtocolinVD='1'"><!--2 SSD SASHDD,SATAHDD- - x=0 y=1 SSDHDD SASSATA-->
	                    <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD + $SASHDD"/></xsl:when><!--SATAHDD,SASHDD-->
	                    <!--4 -->     <xsl:when test="$ArrayDiskCountSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SSD"/></xsl:when><!-- SSD-->
	                    <!--5 -->     <xsl:when test="$ArrayDiskCountSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SSD + $SATAHDD"/></xsl:when><!--SSD,SATAHDD-->
	                    <!--6 -->     <xsl:when test="$ArrayDiskCountSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SSD + $SASHDD"/></xsl:when><!--SSD,SASHDD-->
	                    <!--7 -->     <xsl:when test="$ArrayDiskCountSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SSD + $SASHDD +$SATAHDD"/></xsl:when><!--SSD,SASHDD,SATAHDD-->
	                    </xsl:choose>
	            </xsl:when>         
	            <xsl:when test="$BusProtocol='384' and $MediaType='3' and $MixofMediaProtocolinVD='2'"><!--3 SAS, SATA,SATAHDD, SASHDD- - x=1 y=0 SASHDD SASSATA -->
	            <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSATA &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSATA &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSATA &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SAS"/></xsl:when><!--SAS-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSATA &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SAS"/></xsl:when><!--SAS,SASHDD not possible-->
	                    <!--4 -->     <xsl:when test="$ArrayDiskCountSATA &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--5 -->     <xsl:when test="$ArrayDiskCountSATA &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SATAHDD"/></xsl:when><!--SASHDD,SATAHDD-->
	                    <!--6 -->     <xsl:when test="$ArrayDiskCountSATA &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SAS + $SATAHDD"/></xsl:when><!--SAS,SATAHDD-->
	                    <!--7 -->     <xsl:when test="$ArrayDiskCountSATA &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SAS + $SATAHDD"/></xsl:when><!--SAS,SASHDD,SATAHDD not possible-->
	                    <!--10 -->    <xsl:when test="$ArrayDiskCountSATA &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SAS + $SATA"/></xsl:when><!--SAS,SATA-->
	                    <!--11 -->    <xsl:when test="$ArrayDiskCountSATA &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SAS + $SATA"/></xsl:when><!--SAS,SATA,SASHDD not possible-->
	                    <!--12 -->    <xsl:when test="$ArrayDiskCountSATA &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATA"/></xsl:when><!--SATA,SATAHDD-->
	                    <!--13 -->    <xsl:when test="$ArrayDiskCountSATA &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATA + $SASHDD"/></xsl:when><!--SATA,SASHDD,SATAHDD-->
	                    <!--14 -->    <xsl:when test="$ArrayDiskCountSATA &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SAS + $SATA"/></xsl:when><!--SATAHDD,SAS,SATA not possible-->
	                    <!--15 -->    <xsl:when test="$ArrayDiskCountSATA &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSAS &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SAS + $SATA"/></xsl:when><!--SATAHDD,SASHDD,SAS,SATA -->
	                     </xsl:choose>
	            </xsl:when>
	            <xsl:when test="$BusProtocol='384' and $MediaType='3' and $MixofMediaProtocolinVD='3'"><!--4 SASHDD&SSDmix,SATAHDD&SSDmix x=1 y=1 SSDHDD SASSATA-->
	               <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASHDD_SSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD_SSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASHDD_SSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD_SSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDDandSSD"/></xsl:when><!--SATAHDD-SSD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASHDD_SSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD_SSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDDandSSD"/></xsl:when><!--SASHDD-SSD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASHDD_SSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD_SSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDDandSSD + $SATAHDDandSSD"/></xsl:when><!--SASHDD_SSD,SATAHDD-SSD-->
	               </xsl:choose>
	            </xsl:when>
	            <xsl:when test="$BusProtocol='384' and $MediaType='2' and $MixofMediaProtocolinVD='0'"><!-- 5 SASSSD,SATASSD - x=0 y=0 SSD SASSATA -->
	            <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATASSD"/></xsl:when><!--SATASSD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD"/></xsl:when><!--SASSSD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD + $SATASSD"/></xsl:when><!--SASSSD,SATASSD-->
	               </xsl:choose>
	            </xsl:when>   
	            <xsl:when test="$BusProtocol='384' and $MediaType='2' and $MixofMediaProtocolinVD='1'">512</xsl:when><!--6  SSD - - x=0,y=1 SSD SASSATA --><!--SSD-->
	            <xsl:when test="$BusProtocol='384' and $MediaType='2' and $MixofMediaProtocolinVD='2'"><!--7 SASSSD,SATASSD - - x=1,y=0 SSD SASSATA -->
	             <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATASSD"/></xsl:when><!--SATASSD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD"/></xsl:when><!--SASSSD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD + $SATASSD"/></xsl:when><!--SASSSD,SATASSD-->
	               </xsl:choose>
	            </xsl:when>   
	            <xsl:when test="$BusProtocol='384' and $MediaType='2' and $MixofMediaProtocolinVD='3'"><xsl:value-of select="$SSD"/></xsl:when><!--8 SSD - - x=1,y=1 SSD SASSATA --><!--SSD-->
	            <xsl:when test="$BusProtocol='384' and $MediaType='1' and $MixofMediaProtocolinVD='0'"><!--9 SASHDD,SATAHDD, - - x=0 y=0 HDD SASSATA -->
	             <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SATAHDD"/></xsl:when><!--SASHDD,SASHDD-->
	               </xsl:choose>
	             </xsl:when>  
	            <xsl:when test="$BusProtocol='384' and $MediaType='1' and $MixofMediaProtocolinVD='1'"><!--10 SASHDD,SATAHDD, - - x=0 y=1 HDD SASSATA -->
	            <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SATAHDD"/></xsl:when><!--SASHDD,SATAHDD-->
	               </xsl:choose>
	            </xsl:when>
	            <xsl:when test="$BusProtocol='384' and $MediaType='1' and $MixofMediaProtocolinVD='2'"><!--11 SASHDD,SATAHDD, - - x=1 y=1 HDD SASSATA -->
	            <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SATAHDD"/></xsl:when><!--SATAHDD,SASHDD-->
	               </xsl:choose>
	            </xsl:when>   
	            <xsl:when test="$BusProtocol='256' and $MediaType='3' and $MixofMediaProtocolinVD='0'"><!--13 SASHDD,SASSSD, - - x=1 y=0 -->
	               <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD"/></xsl:when><!--SASSSD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SASSSD"/></xsl:when><!--SASHDD,SASSSD-->
	               </xsl:choose>
	            </xsl:when>
	            <xsl:when test="$BusProtocol='384' and $MediaType='1' and $MixofMediaProtocolinVD='3'"><!--12 SASSD,SASHDD, - - x=0 y=0 SSDHDD SAS -->
	               <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SATAHDD"/></xsl:when><!--SASHDD,SATAHDD-->
	                </xsl:choose>
	            </xsl:when>   
	            <xsl:when test="$BusProtocol='256' and $MediaType='3' and $MixofMediaProtocolinVD='1'"><!--14 SASSSD,SASHDD, - - x=0 y=1 SSDHDD SAS -->
	            <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSASSSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD"/></xsl:when><!--SASHDD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD"/></xsl:when><!--SASSSD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSASSSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSASHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASHDD + $SASSSD"/></xsl:when><!--SASSSD,SASHDD-->
	               </xsl:choose>
	            </xsl:when>   
	            <xsl:when test="$BusProtocol='256' and $MediaType='3' and $MixofMediaProtocolinVD='2'"><xsl:value-of select="$SAS"/></xsl:when><!--15 SAS, - - x=1 y=0 SSDHDD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='3' and $MixofMediaProtocolinVD='3'"><xsl:value-of select="$SAS"/></xsl:when><!--16 SAS - - x=1 y=1 SSDHDD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='2' and $MixofMediaProtocolinVD='0'"><xsl:value-of select="$SASSSD"/></xsl:when><!--17 SASSSD - - x=0 y=0 SSD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='2' and $MixofMediaProtocolinVD='1'"><xsl:value-of select="$SASSSD"/></xsl:when><!--18 SASSSD - - x=0 y=1 SSD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='2' and $MixofMediaProtocolinVD='2'"><xsl:value-of select="$SASSSD"/></xsl:when><!--19 SASSSD - - x=1 y=0 SSD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='2' and $MixofMediaProtocolinVD='3'"><xsl:value-of select="$SASSSD"/></xsl:when><!--20 SASSSD - - x=1 y=1 SSD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='1' and $MixofMediaProtocolinVD='0'"><xsl:value-of select="$SASHDD"/></xsl:when><!--21 SASHHD - - x=0 y=0 HDD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='1' and $MixofMediaProtocolinVD='1'"><xsl:value-of select="$SASHDD"/></xsl:when><!--22 SASHHD - - x=0 y=1 HHD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='1' and $MixofMediaProtocolinVD='2'"><xsl:value-of select="$SASHDD"/></xsl:when><!--23 SASHHD - - x=1 y=0 HHD SAS -->
	            <xsl:when test="$BusProtocol='256' and $MediaType='1' and $MixofMediaProtocolinVD='3'"><xsl:value-of select="$SASHDD"/></xsl:when><!--24 SASHHD - - x=1 y=1 HHD SAS -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='3' and $MixofMediaProtocolinVD='0'"><!--25 SATAHHD,SATASSD - - x=0 y=0 SSDHDD SATA -->
	                <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATASSD"/></xsl:when><!--SATASSD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATASSD + $SATAHDD"/></xsl:when><!--SATASSD,SATAHDD-->
	               </xsl:choose>
	            </xsl:when>   
	            <xsl:when test="$BusProtocol='128' and $MediaType='3' and $MixofMediaProtocolinVD='1'"><!--26 SATAHHD,SATASSD - - x=0 y=1 SSDHDD SATA -->
	               <xsl:choose>
	                    <!--0 -->     <xsl:when test="$ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT">0</xsl:when>
	                    <!--1 -->     <xsl:when test="$ArrayDiskCountSATAHDD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATASSD"/></xsl:when><!--SATASSD-->
	                    <!--2 -->     <xsl:when test="$ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &lt; $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when><!--SATAHDD-->
	                    <!--3 -->     <xsl:when test="$ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT and $ArrayDiskCountSATASSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SASSSD + $SATAHDD"/></xsl:when><!--SATASSd,SATAHDD-->
	               </xsl:choose>
	            </xsl:when>   
	            <xsl:when test="$BusProtocol='128' and $MediaType='3' and $MixofMediaProtocolinVD='2'"><xsl:value-of select="$SATA"/></xsl:when><!--27 SATA - - x=1 y=0 SSDHDD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='3' and $MixofMediaProtocolinVD='3'"><xsl:value-of select="$SATA"/></xsl:when><!--28 SATA - - x=1 y=1 SSDHDD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='2' and $MixofMediaProtocolinVD='0'"><xsl:value-of select="$SATASSD"/></xsl:when><!--29 SATASSD - - x=0 y=0 SSD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='2' and $MixofMediaProtocolinVD='1'"><xsl:value-of select="$SATASSD"/></xsl:when><!--30 SATASSD - - x=0 y=1 SSD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='2' and $MixofMediaProtocolinVD='2'"><xsl:value-of select="$SATASSD"/></xsl:when><!--31 SATASSD - - x=1 y=0 SSD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='2' and $MixofMediaProtocolinVD='3'"><xsl:value-of select="$SATASSD"/></xsl:when><!--32 SATASSD - - x=1 y=1 SSD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='1' and $MixofMediaProtocolinVD='0'"><xsl:value-of select="$SATAHDD"/></xsl:when><!--33 SATAHHD - - x=0 y=0 HDD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='1' and $MixofMediaProtocolinVD='1'"><xsl:value-of select="$SATAHDD"/></xsl:when><!--34 SATAHHD - - x=0 y=1 HDD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='1' and $MixofMediaProtocolinVD='2'"><xsl:value-of select="$SATAHDD"/></xsl:when><!--35 SATAHHD - - x=1 y=0 HDD SATA -->
	            <xsl:when test="$BusProtocol='128' and $MediaType='1' and $MixofMediaProtocolinVD='3'"><xsl:value-of select="$SATAHDD"/></xsl:when><!--36 SATAHHD - - x=1 y=1 HDD SATA -->  
	            <xsl:when test="$BusProtocol='0'"><!--SCSI case-->
                        <xsl:choose>
                            <xsl:when test="$ArrayDiskCountSCSIHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SCSIHDD"/></xsl:when>
                            <xsl:when test="$ArrayDiskCountSCSISSD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SCSISSD"/></xsl:when>
                            <xsl:when test="$ArrayDiskCountSATAHDD &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$SATAHDD"/></xsl:when>
                            <xsl:otherwise>0</xsl:otherwise>
                        </xsl:choose><!--37 SCSIHHD - -HDD SCSI -->  
                    </xsl:when>    
	            <xsl:otherwise><xsl:value-of select="$BusProtocol"/></xsl:otherwise><!-- To retain the previous behavious if firmware is not updated-->
	            </xsl:choose>
	      </xsl:template>
	      <xsl:template name="GetMediaType">
	      <xsl:param name="MediaType"/>
	          <xsl:choose>
	                  <xsl:when test="$MediaType='2'"><xsl:value-of select="$strSSD"/></xsl:when>
	                  <xsl:when test="$MediaType='1'"><xsl:value-of select="$strHDD"/></xsl:when>
                                    <xsl:when test="$MediaType='3'"><xsl:value-of select="$strSSDandHDD"/></xsl:when>
                                    <xsl:when test="$MediaType='4'"><xsl:value-of select="$strTapeMedia"/></xsl:when>                                    
	                  <xsl:otherwise><xsl:value-of select="$strNotAvailable"/></xsl:otherwise>
	          </xsl:choose>
     </xsl:template>
	   <xsl:template name="GetSectorSize">
	      <xsl:param name="SectorSize"/>
	          <xsl:choose>
	                  <xsl:when test="$SectorSize='4096'"><xsl:value-of select="$str4K"/></xsl:when>
	                  <xsl:when test="$SectorSize='512'"><xsl:value-of select="$str512"/></xsl:when>
                      <xsl:when test="$SectorSize='4068'"><xsl:value-of select="$strSectorTypeMixed"/></xsl:when>
                                                          
	                  <xsl:otherwise><xsl:value-of select="$strNotAvailable"/></xsl:otherwise>
	          </xsl:choose>
     </xsl:template>
	 <!--Uncomment this when required for PI feature-->
	   <!--xsl:template name="GetPIData">
	      <xsl:param name="PICapable"/>
	          <xsl:choose>
	                  <xsl:when test="$PICapable='1'"><xsl:value-of select="$strYes"/></xsl:when>
	                  <xsl:when test="$PICapable='0'"><xsl:value-of select="$strNo"/></xsl:when>
                                                       
	                  <xsl:otherwise><xsl:value-of select="$strNotAvailable"/></xsl:otherwise>
	          </xsl:choose>
     </xsl:template-->
     <xsl:template name="PhysicalDiskDescription">
            <xsl:param name="BusProtocol"/>
            <xsl:param name="MediaType"/>
            <xsl:choose>
                <xsl:when test="$BusProtocol='8' and MediaType='1'"><xsl:value-of select="$strSASHDD"/></xsl:when>
                <xsl:when test="$BusProtocol='8' and MediaType='2'"><xsl:value-of select="$strSASSSD"/></xsl:when>
                <xsl:when test="$BusProtocol='7' and MediaType='1'"><xsl:value-of select="$strSATAHDD"/></xsl:when>
                <xsl:when test="$BusProtocol='7' and MediaType='2'"><xsl:value-of select="$strSATASSD"/></xsl:when>
                <xsl:when test="$BusProtocol='1' and MediaType='1'"><xsl:value-of select="$strSCSIHDD"/></xsl:when>
                <xsl:when test="$BusProtocol='1' and MediaType='2'"><xsl:value-of select="$strSCSIHDD"/></xsl:when>

            </xsl:choose>
            </xsl:template>
<xsl:template name="PowerofTwo">
		<xsl:param name="num1" select="2"/>
		<xsl:param name="num2"/>
		<xsl:param name="result" select="1"/>
		<xsl:choose>
			<xsl:when test="$num2=0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="PowerofTwo">
					<xsl:with-param name="num1" select="$num1"/>
					<xsl:with-param name="num2" select="$num2 - 1"/>
					<xsl:with-param name="result" select="$result * $num1"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


        <xsl:template name="GetHSPolicyViolationStatus">
          <xsl:param name="ViolationCode"/>
		<xsl:choose>
			<xsl:when test="$ViolationCode = '0'">
				<xsl:value-of select="$strNo"/>
			</xsl:when>
			<xsl:when test="$ViolationCode = '1'">
				<xsl:value-of select="$strYes"/>
			</xsl:when>
			<xsl:when test="$ViolationCode = '2'">
				<xsl:value-of select="$strNotAssigned"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>	
			</xsl:otherwise>
		</xsl:choose>
        </xsl:template>
      <xsl:template name="IsDeleteSecurityKeyPossible">
          <xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,7,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
        </xsl:template>
       <xsl:template name="IsDiskEncryptionCapable">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,18,1)='1'">
				<xsl:value-of select="$strYes"/>
			</xsl:when>
			<xsl:when test="substring($Mask,18,1)='0'">
				<xsl:value-of select="$strNo"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
      <xsl:template name="IsDiskSecured">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,17,1)='1'">
				<xsl:value-of select="$strYes"/>
			</xsl:when>
			<xsl:when test="substring($Mask,17,1)='0' and substring($Mask,18,1)='1'">
				<xsl:value-of select="$strNo"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
      <xsl:template name="IsVirtualDiskSecured">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,32,1)='1'">
				<xsl:value-of select="$strYes"/>
			</xsl:when>
			<xsl:when test="substring($Mask,32,1)='0'">
				<xsl:value-of select="$strNo"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        <xsl:template name="IsVDBadBlocksDetected">
          <xsl:param name="badBlock"/>
		<xsl:choose>
			<xsl:when test="$badBlock = '1'">
				<xsl:value-of select="$strYes"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNo"/>	
			</xsl:otherwise>
		</xsl:choose>
        </xsl:template>
  <xsl:template name="IsCoulmnApplicable">
     	<xsl:param name="ObjectRef"/>
     	<xsl:param name="BitPosition"/>
         <xsl:for-each select="$ObjectRef">
               <xsl:choose>
                   <xsl:when test="substring(AttributesMask,$BitPosition,1)='1'">1</xsl:when>
                   <xsl:otherwise>0</xsl:otherwise>
               </xsl:choose>
        </xsl:for-each>
     </xsl:template>
     <xsl:template name="IsVDResizePossible">
	     <xsl:param name="resizepossible"/>
		    <xsl:choose>
			  <xsl:when test="$resizepossible = '1'">
				<xsl:value-of select="$strYes"/>
			  </xsl:when>
			  <xsl:otherwise>
				<xsl:value-of select="$strNo"/>	
			  </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template> 

	<xsl:template name="GetResultDetails">
          	<xsl:param name="ErrorCode"/>
		<xsl:choose>
			<xsl:when test="$ErrorCode='1'">
				<xsl:value-of select="$strPassed"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
      </xsl:template>

    <xsl:template name="GetExpressServiceCode">
	  <xsl:param name="ServiceTag"/>
	  <xsl:param name="NewServiceTagLength" select="string-length($ServiceTag)"/>
	  <xsl:param name="OverallSum" select="0"/>

          <!--xsl:message>[GetExp - ServiceTag=<xsl:value-of select="($ServiceTag)"/>]</xsl:message>  
          <xsl:message>[GetExp - NewServiceTagLength=<xsl:value-of select="($NewServiceTagLength)"/>]</xsl:message-->  

	  <xsl:variable name="ServiceTagLength" select="string-length($ServiceTag)"/>
          <xsl:choose>
	      <xsl:when test="$NewServiceTagLength != 0">	
                <xsl:variable name="GetBase36ValuesVar"><xsl:call-template name="GetBase36Values"><xsl:with-param name="ServiceTag" select="$ServiceTag"/><xsl:with-param name="ServiceTagLength" select="$ServiceTagLength"/><xsl:with-param name="NewServiceTagLength" select="$NewServiceTagLength"/></xsl:call-template></xsl:variable>

                <xsl:call-template name="GetExpressServiceCode"><xsl:with-param name="ServiceTag" select="$ServiceTag"/><xsl:with-param name="NewServiceTagLength" select="($NewServiceTagLength - 1)"/><xsl:with-param name="OverallSum" select="($OverallSum + $GetBase36ValuesVar)"/></xsl:call-template>

            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="format-number(($OverallSum),'####')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="GetBase36Values">
	  <xsl:param name="ServiceTag"/>
	  <xsl:param name="ServiceTagLength"></xsl:param>
	  <xsl:param name="NewServiceTagLength"></xsl:param>

        <!--xsl:message>[GetBase36 - ServiceTagLength=<xsl:value-of select="($ServiceTagLength)"/>]</xsl:message>  
        <xsl:message>[GetBase36 - NewServiceTagLength=<xsl:value-of select="($NewServiceTagLength)"/>]</xsl:message-->  

	  <xsl:variable name="ServiceTagChar" select="substring($ServiceTag,$NewServiceTagLength,1)"/>

        <!--xsl:message>[GetBase36 - ServiceTagChar=<xsl:value-of select="($ServiceTagChar)"/>]</xsl:message-->  

        <xsl:variable name="Get36PowerVar"><xsl:call-template name="Get36Power"><xsl:with-param name="Power" select="($ServiceTagLength - $NewServiceTagLength)"/></xsl:call-template></xsl:variable>	

        <!--xsl:message>[Power Value=<xsl:value-of select="($Get36PowerVar)"/>]</xsl:message-->  

        <xsl:choose>
	      <xsl:when test="string(number($ServiceTagChar)) != 'NaN'">
	          <xsl:value-of select="($ServiceTagChar * $Get36PowerVar)"/>        	
	      </xsl:when>
	      <xsl:otherwise>
                <xsl:variable name="GetCharVaueVar"><xsl:call-template name="GetCharVaue"><xsl:with-param name="InComingChar" select="translate($ServiceTagChar, 'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/></xsl:call-template></xsl:variable>
		    <xsl:value-of select="($GetCharVaueVar * $Get36PowerVar)"/>        	
	      </xsl:otherwise>
	  </xsl:choose>
    </xsl:template>

    <xsl:template name="Get36Power">
	  <xsl:param name="Power"/>
	  <xsl:param name="ProductValue" select="1"/>
        <xsl:choose>
            <xsl:when test="$Power != 0">
                <xsl:call-template name="Get36Power"><xsl:with-param name="Power" select="($Power - 1)"/><xsl:with-param name="ProductValue" select="($ProductValue * 36)"/></xsl:call-template>            
            </xsl:when>
            <xsl:otherwise>
		    <xsl:value-of select="$ProductValue"/>	
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="GetCharVaue">
	  <xsl:param name="Chars">A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,</xsl:param><!-- do not remove last trailing comma -->
	  <xsl:param name="CharValue">10</xsl:param>
	  <xsl:param name="InComingChar"/>	
        <xsl:choose>
	      <xsl:when test="$InComingChar = substring-before($Chars,',')">
		    <xsl:value-of select="$CharValue"/>
	      </xsl:when>
	      <xsl:otherwise>
		    <xsl:call-template name="GetCharVaue">
		        <xsl:with-param name="Chars" select="substring-after($Chars,',')"/>
		        <xsl:with-param name="CharValue" select="$CharValue + 1"/>
		        <xsl:with-param name="InComingChar" select="$InComingChar"/>
		    </xsl:call-template>	  
	      </xsl:otherwise>
        </xsl:choose>		
    </xsl:template>

  <xsl:template name="GetDiskWriteCache">
    <xsl:param name="DiskWriteCache"/>
    <xsl:choose>
      <xsl:when test="$DiskWriteCache='1'">
        <xsl:value-of select="$strEnabled"/>
      </xsl:when>
      <xsl:when test="$DiskWriteCache='0'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="PCIeSSDDevicesStatusDesc">
		<xsl:param name="PCIeSSDDeviceWriteStatus"/>
		<xsl:choose>
			<xsl:when test="$PCIeSSDDeviceWriteStatus &gt; '99' ">
				<xsl:value-of select="$strPCIeSSDDevicesStatusDesc1"/>
			</xsl:when>
			<xsl:when test="$PCIeSSDDeviceWriteStatus &lt; 100">
				<xsl:value-of select="$strPCIeSSDDevicesStatusDesc2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
    <!--Added template to assign mirror id's in case of Perc9 Controller with Raid 10+IM scenario-->
    <xsl:template name="SetMirrorIDonIM">
        <xsl:param name="ObjID"/>
        <xsl:for-each select="//ArrayDisks/PassThruResponse/DCStorageObject/ObjID">
            <xsl:variable name="LoopObjID"><xsl:value-of select="."/></xsl:variable>
            <xsl:choose>
                <xsl:when test="$LoopObjID = $ObjID">
                    <xsl:value-of select="floor((position()-1) div 2)"/>
                </xsl:when>
                <xsl:otherwise><!-- Keeping empty return as safeguard if backend data is not received properly, otherwise this section is not reachable in any scenario --></xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>