<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
 <xsl:output method="xml" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<Summary>
			<Section name="Storage Services">
				<xsl:attribute name="display">Storage Controller Firmware</xsl:attribute>
				<xsl:apply-templates/>
 			</Section>
		</Summary>
	</xsl:template>	

	<xsl:template match="DCStorageObject">
		<ListData>
			<xsl:attribute name="display"></xsl:attribute>			
			<Data columnspacing="true" name="ControllerName" editable="false" type="ustring">
				<xsl:attribute name="display">Name</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
			</Data>
			<Data columnspacing="true" name="Version" editable="false" type="ustring">
				<xsl:attribute name="display">Version</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="FirmwareVer">
							<xsl:value-of select="FirmwareVer"/>
						</xsl:when>
						<xsl:otherwise>N/A</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
<!--			<Data columnspacing="true" name="Updateable" editable="false" type="ustring">
				<xsl:attribute name="display">Updateable</xsl:attribute>
				<xsl:attribute name="value">N/A</xsl:attribute>
			</Data>
-->	
  </ListData>
	</xsl:template>


</xsl:stylesheet>
