<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/temptbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="OMA">
		<DataArea>
			<PageTitle>
				<xsl:if test="count(TemperatureProbes/DCStorageObject)='0'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="TemperatureProbes/@EnclosureId"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="count(TemperatureProbes/DCStorageObject) > '1'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:value-of select="TemperatureProbes/@EnclosureId"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="count(TemperatureProbes/DCStorageObject)='1'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle3"/><xsl:value-of select="TemperatureProbes/DCStorageObject/Index"/> in Enclosure <xsl:value-of select="TemperatureProbes/@EnclosureId"/></xsl:attribute>
				</xsl:if>
			</PageTitle>
			<xsl:choose>
				<xsl:when test="count(TemperatureProbes/DCStorageObject)!=0">
					<TableData>
                            <xsl:call-template name="TempTableHeader"/>
                            <xsl:for-each select="TemperatureProbes/DCStorageObject">
								<xsl:sort select="Index" data-type="number" order="ascending"/>
                                <xsl:call-template name="TempTableRows"/>
                            </xsl:for-each>
					</TableData>
				</xsl:when>
			</xsl:choose>				
		</DataArea>
	</xsl:template>
	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>


