<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/fclnctbl.xsl"/>
     	<xsl:include href="../common/fcdtbl.xsl"/>
        <xsl:include href="../common/adtbl.xsl"/>
        <xsl:include href="../en/globals.xsl"/>
  	
  <xsl:template match="/">
		<DataArea>
                           <xsl:choose>
						<xsl:when test="//FluidCacheProperties/DCStorageObject[CachePoolLicenseState = 'Not Licensed' or not(CachePoolLicenseState) ] ">
                                          <ListData type="custom">
                                                     <SubHeader>
                                                         <xsl:attribute name="display">Instructions: <xsl:call-template name="NewLine"/><xsl:value-of select="$strFluidCacheNotLicensed"/><xsl:call-template name="NewLine"/>Or <xsl:value-of select="$strFluidCacheNotConnectedError"/>

                                                         </xsl:attribute>
                                                      </SubHeader>                                                                
                                               </ListData>
                                    </xsl:when>

                                   <xsl:when test="//FluidCacheProperties/DCStorageObject[CachePoolLicenseState != 'Unknown'] ">
                                          <PageTitle>
                                                  <xsl:attribute name="display">
                                                            <xsl:value-of select="'Fluid Cache Properties'"/>
                                                   </xsl:attribute>
                                           </PageTitle>
                                            <xsl:call-template name ="CachePoolProperties"/>
                                            <ListData type="custom">
                                                   <SubHeader display="License Details"/>
                                                            <xsl:call-template name ="LicenseView"/> 
                                             </ListData>
                                    </xsl:when>
                                    <xsl:otherwise>
                                              <ListData type="custom">
                                                     <SubHeader>
                                                         <xsl:attribute name="display">Instructions: <xsl:call-template name="NewLine"/><xsl:value-of select="$strFluidCacheNotConnectedError"/><xsl:call-template name="NewLine"/>Or <xsl:value-of select="$strFluidCacheNotLicensed"/>
                                                         </xsl:attribute>
                                                      </SubHeader>                                                                
                                               </ListData> 
                                     </xsl:otherwise>
                             </xsl:choose> 
                                                	

                              <xsl:if test="count(OMA/ArrayDisks/DCStorageObject[PartOfCachePool = '1'])> 0 and /OMA/FluidCacheProperties/DCStorageObject[CachePoolLicenseState != 'Unknown']">
                                    <TableData columnspacing="true">
                                        <SubHeader>
                                            <xsl:attribute name="display"><xsl:value-of select="$strFluidCachePoolPCIeSSDs"/></xsl:attribute>
                                        </SubHeader>
                                        <Header>
                                            <xsl:call-template name="ArrayDiskTableHeader">
                                                <xsl:with-param name="GLOBAL_VAR_CACHEPOOL">1</xsl:with-param>
                                            </xsl:call-template>
   				        </Header>
                                        <xsl:for-each select="OMA/ArrayDisks/DCStorageObject[PartOfCachePool = '1' or PartOfCachePool = '2' or PartOfCachePool = '3']">
                                                <xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
							<xsl:call-template name="ArrayDiskTableRows">
									<xsl:with-param name="GLOBAL_VAR_CACHEPOOL">1</xsl:with-param>
                                                         </xsl:call-template>   
					</xsl:for-each>
                                    </TableData>
                                </xsl:if>
                                
                                 <xsl:if test="count(OMA/FluidCachedDisks/DCStorageObject)> 0 ">
                                	<TableData columnspacing="true">
                                                <SubHeader>
            	                           		 <xsl:attribute name="display"><xsl:value-of select="$strFluidCachedDisks"/></xsl:attribute>
      	                             		</SubHeader>
                                    		<Header>
                                            		<xsl:call-template name="FluidCacheDiskTableHeader"/>
						</Header>
                                     		<xsl:for-each select="OMA/FluidCachedDisks/DCStorageObject">
                              	                	<xsl:call-template name="FluidCacheDiskTableRows"/>
					         </xsl:for-each>
                                	</TableData>
                                </xsl:if>
   
						
     
      
    </DataArea>
</xsl:template>  
<xsl:template name="CachePoolProperties">
     <TableData>
           <Header><xsl:call-template name="FluidCachePropertiesHeader"/></Header>
           <xsl:call-template name="FluidCachePropertiesRows"/>
     </TableData>
</xsl:template>

<xsl:template match="OMAUserRights"/>
  <xsl:template match="*"/>
  <xsl:template name="FluidCachePropertiesHeader">
  <Data name="Status" editable="false" type="">
        <xsl:attribute name="display">
              <xsl:value-of select="$strStatus"/>
        </xsl:attribute>
        <xsl:attribute name="value">
              <xsl:value-of select="$strStatus"/>
        </xsl:attribute>
  </Data>
  
  <Data name="Name" editable="false" type="ustring">
        <xsl:attribute name="display">
              <xsl:value-of select="$strName"/>
        </xsl:attribute>
        <xsl:attribute name="value">
               <xsl:value-of select="$strName"/>
        </xsl:attribute>
   </Data>
   <Data name="CachePoolHighAvailability" editable="false" type="">
        <xsl:attribute name="display">
            <xsl:value-of select="$strCachePoolHighAvailability"/>
        </xsl:attribute>
        <xsl:attribute name="value">
            <xsl:value-of select="$strCachePoolHighAvailability"/>
        </xsl:attribute>
   </Data>
  </xsl:template>  
  
  <xsl:template name="FluidCachePropertiesRows">
    <Row>
          <Data type="status" align="center">
                <xsl:attribute name="value"><xsl:value-of select="//FluidCacheProperties/DCStorageObject/ObjStatus"/></xsl:attribute>
           </Data>
           <Data type="ustring" align="center">
                <xsl:attribute name="value"><xsl:value-of select="//FluidCacheProperties/DCStorageObject/Name"/></xsl:attribute>
            </Data>
            <Data type="ustring" align="center">
                <xsl:attribute name="value">
                     <xsl:choose>

					<xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'False' and //CachePoolProperties/DCStorageObject/CacheStoreCount = '0'">
                                                <xsl:value-of select="$strCachePoolHighAvailabilityFalsePassThrough"/>
                                        </xsl:when>
		
                             <xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'False'">
                                           <xsl:value-of select="$strCachePoolHighAvailabilityFalse"/>
                              </xsl:when>
                              <xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'True'">
                                            <xsl:value-of select="$strCachePoolHighAvailabilityTrue"/>
                              </xsl:when>
                              <xsl:otherwise>
                                            <xsl:value-of select="$strNotApplicable"/>
                              </xsl:otherwise>
                       </xsl:choose>
                 </xsl:attribute>
            </Data>
    </Row>
  </xsl:template>
<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>
	
</xsl:stylesheet>


