<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:include href="../common/Utils.xsl"/>
    <xsl:include href="../common/btrytbl.xsl"/>
    <xsl:include href="../en/globals.xsl"/>
    <xsl:template match="/">
		<DataArea>
		<xsl:variable name="slotNum">
			<xsl:choose>
				<xsl:when test="//Batteries/@PCISlotNo = '-1' or //Batteries/@PCISlotNo = '2147483648' or //Batteries/@PCISlotNo = '0' ">
					<xsl:value-of select="$strEmbedded"/>
				</xsl:when>
				<xsl:when test="//Batteries/@PCISlotNo = '2147483649'">
				<xsl:value-of select="'Not Available'"/>
				</xsl:when>
				<xsl:otherwise>Slot <xsl:value-of select="//Batteries/@PCISlotNo"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
			<!-- Determine which form of the cli was invoked.  This determines the page title. -->
			<xsl:choose>
				<xsl:when test="/*/Batteries/@System='true'">
					<!-- The command: omreport storage vdisk   was called -->
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strRptBtryTitle1"/></xsl:attribute>
					</PageTitle>
					<!--					<xsl:apply-templates select="/*/Batteries"/> -->
				</xsl:when>
				<!-- end of when test="count(/*/Batteries)=1" -->
				<xsl:otherwise>
					<!-- A controller was provided on the command.  Figure out which version of the command was called -->
					<xsl:choose>
						<xsl:when test="count(/*/Batteries/DCStorageObject)=1">
							<!-- The command: omreport storage battery controller=id battery=id  was called -->
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strRptBtryTitle2"/><xsl:value-of select="/*/Batteries/DCStorageObject/BatteryID"/> on Controller <xsl:value-of select="//Batteries/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
							</PageTitle>
						</xsl:when>
						<xsl:when test="count(/*/Batteries/DCStorageObject)>0">
							<!-- The command: omreport storage battery controller=id was called  for a controller with batteries-->
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strRptBtryTitle3"/><xsl:value-of select="//Batteries/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
							</PageTitle>
						</xsl:when>
						<xsl:otherwise>
							<!-- The command: omreport storage battery controller=id  was called for a controller with no batteries-->
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strRptBtryTitle4"/></xsl:attribute>
							</PageTitle>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="/*/Batteries"/>
		</DataArea>
	</xsl:template>
	<xsl:template match="Batteries">
		<xsl:variable name="slotNum">
			<xsl:choose>
				<xsl:when test="@PCISlotNo = '-1' or @PCISlotNo = '2147483648' or @PCISlotNo = '0' ">
					<xsl:value-of select="$strEmbedded"/>
				</xsl:when>
				<xsl:when test="@PCISlotNo = '2147483649'">
				<xsl:value-of select="'Not Available'"/>
				</xsl:when>
				<xsl:otherwise><xsl:value-of select="@PCISlotNo"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<TableData>
			<SubHeader>
				<xsl:attribute name="display">Controller <xsl:value-of select="@ControllerName"/> (Slot <xsl:value-of select="$slotNum"/>)</xsl:attribute>
			</SubHeader>
			<Header>
				<xsl:call-template name="BatteryTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:for-each select="DCStorageObject">
				<xsl:call-template name="BatteryTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
		<xsl:if test="count(DCStorageObject)=0">
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strRptBtryTitle4"/></xsl:attribute>
			</PageTitle>
		</xsl:if>
	</xsl:template>
    <xsl:template match="OMAUserRights"/>
    <xsl:template match="*"/>
</xsl:stylesheet>
