<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/adtbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="/">
		<DataArea>
		<xsl:variable name="slotNum">
			<xsl:choose>
				<xsl:when test="/*//ArrayDisks/@PCISlotNo = '-1' or /*//ArrayDisks/@PCISlotNo = '2147483648' or /*//ArrayDisks/@PCISlotNo = '0' ">
					<xsl:value-of select="$strEmbedded"/>
				</xsl:when>
				<xsl:when test="/*//ArrayDisks/@PCISlotNo = '2147483649'">
				<xsl:value-of select="'Not Available'"/>
				</xsl:when>
				<xsl:otherwise>Slot <xsl:value-of select="/*//ArrayDisks/@PCISlotNo"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
                <xsl:variable name="GLOBAL_VAR_TAPE_LIBRARIES">
                        <xsl:choose>
                              <xsl:when test="/*//ArrayDisks//MediaType = '4'">true</xsl:when>
                              <xsl:otherwise>false</xsl:otherwise>
                        </xsl:choose> 
                </xsl:variable>



			<!-- Determine which form of the cli was invoked.  This determines the page title. -->
			<xsl:choose>
				<xsl:when test="count(//UserInputError)>0">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="//UserInputError"/></xsl:attribute>
					</PageTitle>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="/OMA/SMStatus ='99'">
              <xsl:choose>                
                <xsl:when test="/*//ArrayDisks/@ChannelName!=''">
                  <PageTitle>
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strTitle8"/><xsl:value-of select="/*//ArrayDisks/@ChannelName"/> of Controller <xsl:value-of select="/*/ArrayDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)
                  </xsl:attribute>
                  </PageTitle>
                </xsl:when>
                  <xsl:otherwise>
                    <PageTitle>
                    <xsl:attribute name="display">
                      <xsl:value-of select="$strTitle7"/><xsl:value-of select="/*//ArrayDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)
                    </xsl:attribute>
                    </PageTitle>
                  </xsl:otherwise>
                  
              </xsl:choose>							
						</xsl:when>
						<xsl:when test="/*//ArrayDisks/@ControllerName!=''">
							<!-- Controller Name should ALWAYS be provided, but this is just a check for completeness -->
							<xsl:choose>
								<xsl:when test="/*//ArrayDisks/@VirtualDiskName!=''">
									<!-- Display the title for the command 'omreport storage <adisks> <controller=id> [vdisk=id]' -->
									<PageTitle>
										<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:value-of select="/*//ArrayDisks/@VirtualDiskName"/></xsl:attribute>
									</PageTitle>
								</xsl:when>
								<xsl:when test="/*//ArrayDisks/@ArrayDiskName!=''">
									<!-- Display the title for the command 'omreport storage <adisks> <controller=id> [adisk=id]' -->
									<PageTitle>
										<xsl:attribute name="display"><xsl:value-of select="/*//ArrayDisks/@ArrayDiskName"/><xsl:value-of select="$strTitle3"/><xsl:value-of select="/*/ArrayDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
									</PageTitle>
								</xsl:when>
								<xsl:when test="/*//ArrayDisks/@ChannelName!=''">
									<!-- Display the title for the command 'omreport storage <adisks> <controller=id> [channel=id]' -->
									<PageTitle>
										<xsl:choose>
											<xsl:when test="/*//ArrayDisks//MediaType = '4'">
												<xsl:attribute name="display"><xsl:value-of select="$strTitle8"/><xsl:value-of select="/*//ArrayDisks/@ChannelName"/> of Controller <xsl:value-of select="/*/ArrayDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="display"><xsl:value-of select="$strTitle4"/><xsl:value-of select="/*//ArrayDisks/@ChannelName"/> of Controller <xsl:value-of select="/*/ArrayDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										
									</PageTitle>
								</xsl:when>
                                                                <xsl:when test="$GLOBAL_VAR_TAPE_LIBRARIES = 'true'">
									<!-- Display the title for the command 'omreport storage <adisks> <controller=id> [channel=id]' -->
									<PageTitle>
										<xsl:attribute name="display"><xsl:value-of select="$strTitle7"/><xsl:value-of select="/*//ArrayDisks/@ChannelName"/> <xsl:value-of select="/*/ArrayDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
									</PageTitle>
								</xsl:when>
								
								<xsl:otherwise>
									<!-- Display the title for the command 'omreport storage <adisks> <controller=id>' -->
									<PageTitle>
										<xsl:attribute name="display"><xsl:value-of select="$strTitle5"/><xsl:value-of select="/*//ArrayDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
									</PageTitle>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<!-- Should never get here. -->
							<PageTitle>
								<xsl:attribute name="value"><xsl:value-of select="$strTitle6"/></xsl:attribute>
							</PageTitle>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
				         <xsl:when test="count(//Span)>0">
									<SubHeader>
				                         <xsl:attribute name="display">Controller <xsl:value-of select="//ArrayDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
			                        </SubHeader>
						          <xsl:apply-templates select="/*/Span"/>
						 </xsl:when>
				         <xsl:otherwise>
						       <xsl:apply-templates select="/*/ArrayDisks"/>
                         </xsl:otherwise>
 		          </xsl:choose>				  
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>

	<xsl:template match="ArrayDisks">
		<xsl:param name="SpanNumber"/>
		<xsl:variable name="slotNum">
			<xsl:choose>
				<xsl:when test="/*/ArrayDisks/@PCISlotNo = '-1' or /*/ArrayDisks/@PCISlotNo = '2147483648' or /*/ArrayDisks/@PCISlotNo = '0' ">
					<xsl:value-of select="$strEmbedded"/>
				</xsl:when>
				<xsl:when test="/*/ArrayDisks/@PCISlotNo = '2147483649'">
					<xsl:value-of select="'Not Available'"/>
				</xsl:when>
				<xsl:otherwise>Slot <xsl:value-of select="/*/ArrayDisks/@PCISlotNo"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="TapeLibraries">
			<xsl:choose>
				
				<xsl:when test="/*/ArrayDisks/DCStorageObject/MediaType = '4'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<TableData>
			<xsl:choose>	
				<xsl:when test="$SpanNumber != ''">
					<SubHeader>
						<xsl:attribute name="display">Span <xsl:value-of select="$SpanNumber"/></xsl:attribute>
					</SubHeader>
				</xsl:when>
				<xsl:otherwise>
					<SubHeader>
						<xsl:attribute name="display">Controller <xsl:value-of select="@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
					</SubHeader>
				</xsl:otherwise>
			</xsl:choose>
			<Header>
				<xsl:call-template name="ArrayDiskTableHeader">
					<xsl:with-param name="VAR_TAPE_LIBRARIES"><xsl:value-of select="$TapeLibraries"/></xsl:with-param>
					<xsl:with-param name="tasks">false</xsl:with-param>
					<xsl:with-param name="expanded">true</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:choose>
				<xsl:when test="DCStorageObject/EnclosureID">
					<xsl:for-each select="DCStorageObject">
					    <!--xsl:sort select="MirrorSetID" data-type="number" order="ascending"/-->
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:call-template name="ArrayDiskTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
							<xsl:with-param name="VAR_TAPE_LIBRARIES"><xsl:value-of select="$TapeLibraries"/></xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="DCStorageObject">
					    <!--xsl:sort select="MirrorSetID" data-type="number" order="ascending"/-->
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:call-template name="ArrayDiskTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
							<xsl:with-param name="VAR_TAPE_LIBRARIES"><xsl:value-of select="$TapeLibraries"/></xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</TableData>
		<xsl:choose>		
		<xsl:when test="count(DCStorageObject)=0 and /OMA/SMStatus='-1'">
			<PageTitle>
				<xsl:attribute name="display">No Physical Disks found</xsl:attribute>
			</PageTitle>
		</xsl:when>
		<xsl:when test="count(DCStorageObject)=0 and /OMA/SMStatus='99'">
			<PageTitle>
				<xsl:attribute name="display">No Tape Drive found</xsl:attribute>
			</PageTitle>
		</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="Span">
		<xsl:apply-templates select="ArrayDisks">
			<xsl:with-param name="SpanNumber" select="@SpanNumber"/>
		</xsl:apply-templates>
	</xsl:template>
	
	<xsl:template match="OMAUserRights"/>
    <xsl:template match="*"/>
</xsl:stylesheet>
