#!/bin/sh
###############################################################################
#
#          Dell Inc. PROPRIETARY INFORMATION
# This software is supplied under the terms of a license agreement or
# nondisclosure agreement with Dell Inc. and may not
# be copied or disclosed except in accordance with the terms of that
# agreement.
#
# Copyright (c) 2000-2009 Dell Inc. All Rights Reserved.
#
#   This script uninstalls all the installed Systems Management
#   rpm packages from the system
#
###############################################################################

# global variables
DELL_OPENMANAGE_PREFIX="srvadmin"
WSMAN_PKGS=""

function Usage
{
echo "Usage: ${0} [OPTION]"
echo "Server Administrator Custom Uninstall Utility."
echo "This Utility will run in the interactive mode if no option"
echo "is given and runs silently if a valid option is given."
echo " "
echo "Option: "
echo "  [-f, --force]  do not prompt before uninstall"
echo "  [-h, --help]   Displays this help text."
echo " "
    exit 1
}

###############################################################################
#
#  Script execution begins here with the invocation
#  of Main function
#
###############################################################################
# check for root privileges
if [ ${UID} != 0 ]; then
    echo "Uninstall requires root privileges"
    exit 1
fi

INTERACTIVE=1
if [ $# -gt 0 ]; then
    if [ "${1}" == "-f" -o "${1}" == "--force" ]; then
        INTERACTIVE=0
    elif [ "${1}" == "-h" -o "${1}" == "--help" ]; then
        Usage
    else
        echo "Invalid option '${1}', please see the usage below"
        echo " "
        Usage
    fi
fi

if [ -x /usr/bin/vmware ]; then
    /usr/bin/vmware -v | grep "VMware ESX 4.0.*" >/dev/null 2>&1
    if [ $? == 0 ]; then
        WSMAN_PKGS=`rpm -qa | grep wsman`
    else
      /usr/bin/vmware -v | grep "VMware ESX 4.1.*" >/dev/null 2>&1
      if [ $? == 0 ]; then
        WSMAN_PKGS=`rpm -qa | grep wsman`
       fi
    fi
fi

# check for forced uninstall
if [ ${INTERACTIVE} == 1 ];
then
    echo "Uninstall will remove the following RPMs:"
    rpm -qa | egrep "^$DELL_OPENMANAGE_PREFIX|^instsvc" 
    [ -n "$WSMAN_PKGS" ] && echo "$WSMAN_PKGS"
    echo "Are you sure you want to uninstall?"
    read -p "   Press ('y' for yes | 'Enter' to exit): " RESP
    if ! echo "${RESP}" | grep -iq "^\s*y\s*$" ; then
        echo "Aborting uninstall on user input."
        exit 1
    fi
fi

# remove srvadmin-omilcore last, as other rpms use scripts from it
# not required on newer RPM versions, as Requires(postun) takes care of this. RHEL4
# is the only RPM version that needs it.
OM_RPMS=$(rpm -qa | egrep "^$DELL_OPENMANAGE_PREFIX|^instsvc")
if [ -n "$OM_RPMS" ]; then
    [ -x /opt/dell/srvadmin/sbin/srvadmin-services.sh ] && 
         /opt/dell/srvadmin/sbin/srvadmin-services.sh stop
    # exclude omilcore and hapi here; they are uninstalled later.
    OM_RPMS=$(rpm -qa | egrep "^$DELL_OPENMANAGE_PREFIX|^instsvc" | grep -v omilcore | grep -v hapi | grep -v srvadmin-storelib-libpci | grep -v srvadmin-storelib-sysfs | grep -v srvadmin-sysfsutils | grep -v srvadmin-racadm4 | grep -v srvadmin-racsvc )
    if [ -n "$OM_RPMS" ]; then
        rpm -e $OM_RPMS
        if [ $? -ne 0 ]; then
           rpm -e --allmatches --noscripts $OM_RPMS
        fi
    fi

    for PKG_NAME in srvadmin-storelib-libpci srvadmin-storelib-sysfs srvadmin-hapi srvadmin-sysfsutils srvadmin-racsvc srvadmin-racadm4 srvadmin-omilcore
    do
       OM_RPMS=$(rpm -qa | grep $PKG_NAME)
       if [ -n "$OM_RPMS" ]; then
           rpm -e $OM_RPMS
           if [ $? -ne 0 ]; then
              rpm -e --allmatches --noscripts $OM_RPMS
           fi
       fi
    done
fi

CLEANED_WSMAN_LIST=""
for WSMAN_PKG in $WSMAN_PKGS
do
   FILE_LIST=$(rpm -ql $WSMAN_PKG)
   echo $FILE_LIST | grep "opt/dell/srvadmin" >/dev/null 2>&1

   if [ $? == 0 ]
   then
     CLEANED_WSMAN_LIST="${CLEANED_WSMAN_LIST} ${WSMAN_PKG}"
   fi
done

WSMAN_PKGS=$CLEANED_WSMAN_LIST

if [ -n "$WSMAN_PKGS" ]; then
    rpm -e $WSMAN_PKGS --test >/dev/null 2>&1
    if [ $? == 0 ] ; then
       rpm -e $WSMAN_PKGS
    fi
fi

OM_RPMS=$(rpm -qa | egrep "^$DELL_OPENMANAGE_PREFIX")
if [ -z "$OM_RPMS" ]; then
    rm -f /etc/omreg.cfg
    rm -f /etc/delloma.d
    rm -f /etc/init.d/dsm_sa_ipmi  >/dev/null 2>&1
    find /opt/dell/srvadmin -type d -depth -exec rmdir {} \; >/dev/null  2>&1 ||:
fi
