#!/bin/sh

#fixup omreg
cat /opt/dell/srvadmin/etc/omreg.d/*.cfg > /opt/dell/srvadmin/etc/omreg.cfg 2>/dev/null ||:

##########################################
# Perform Data Engine configuration
##########################################
source /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh
DCECFG=$(GetRegVal /opt/dell/srvadmin/etc/omreg.cfg OMDataEngine.configtool)

if [ -z "$DCECFG" ]; then
    # data engine not installed (not really possible)
    echo "Could not register data engine components because data engine not installed."
    exit 1
fi

CLIREGUTIL=/opt/dell/srvadmin/lib64/srvadmin-omacore/cli_ini_modifier.sh
PLATFORMID=$(GetSysId)

$CLIREGUTIL /opt/dell/srvadmin/lib64/srvadmin-omacore/omacore.ini add ${PLATFORMID}

# Register cm snmp mib with the Data Engine
${DCECFG} command=addmpialias update=TRUE startuptype=automatic \
    aliasname=dellcm  \
    pathfname=/opt/dell/srvadmin/lib64/openmanage/libinvmib.so
    dispatchfn=DELLCM_SMMIBImplementerDispatch  \
    displayname="Inventory Collector SNMP MIB Implementor"

${DCECFG} command=addepialias startuptype=automatic \
    aliasname=omaep \
    displayname="OMSA Event Plugin Implementer" \
    dispatchfn=OMAEP_SMEventImplementerDispatch \
    pathfname=/opt/dell/srvadmin/lib64/openmanage/libomaep.so

InstallInitScript dsm_om_shrsvc

exit 0
