<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">


	<!-- Declare Global variables and parameters-->
	<xsl:variable name="GLOBAL_VAR_GetCapsSMStatus"><xsl:value-of select="/OMA/GetCapsResultStatus"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_IsAnyAdiskUninited"><xsl:value-of select="/OMA/UninitedAdiskFound"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>

	<xsl:variable name="GLOBAL_VAR_ExitWizardHREFValue">
		<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_Rules='1'">./DSASwitch?exitRAID=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($GLOBAL_PARAM_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<!--main entry point into this XSL,  /-->
	<xsl:template match="/">
		<!--Following situations need to be handled before launcing the express wizard-->
		<!--Situation One: GetCaps returns null because there is no array disk available with FreeSpace-->
		<!--Situation Two: GetCaps returns null because "Length" property for array disk is zero.
			This happens on Adaptec controllers, when controller mode is changed from RAID to SCSI to RAID.
			The array disks needs to be inited from BIOS before it can be used as part of Virtual Disk-->
		<!--Situation Three: GetCaps returns non-null but some array disks on controller have "Length" property value as zero.
			This happens on Adaptec controllers, when controller mode is changed from RAID to SCSI to RAID.
			The user may not have inited all the arraydisks from the BIOS-->

		<!--First check if there are any arraydisks with foreign configuration or unsupported arraydisks-->
		<!--Then check if there are any uninitialized arraydisks-->
		<!-- A value of zero indicates no uninitialized array disk were found. A nonzero value indicates that uninited disks were found-->
		<xsl:choose>
			<!-- 10/26/05: RS - Fix for DF30295 to handle Getcaps error when all drives are in foreign state or unsupported -->
			<xsl:when test="$GLOBAL_PARAM_Rules = '1' and $GLOBAL_VAR_GetCapsSMStatus !='0'">
				<xsl:call-template name="HandleDSAGetCapsFailureError"/>
			</xsl:when>
			<xsl:when test="$GLOBAL_VAR_IsAnyAdiskUninited ='1' and $GLOBAL_PARAM_Rules = '1'">
				<xsl:call-template name="HandleUninitedAdisks"/>
			</xsl:when>
			<xsl:when test="$GLOBAL_PARAM_Rules != '1' and $GLOBAL_VAR_GetCapsSMStatus !='0' ">
					<!-- The current situation should never occur for DSA. DSA makes sure free disks are available before launching the wizard.-->
					<xsl:call-template name="HandleGetCapsFailureError"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="HandleUninitedAdisks">
		<DataArea exportdata="false" printable="false" email="false" ignoreJumpBar="false">
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strReboot"/></xsl:attribute>
					<!-- Ashesh: DF64814 => DSA - xml error generated when reboot button is clicked in dsa error screen -->
					<!-- DSA changed webplugins for every page to a single webplugin which will do specific tasks assigned -->
					<xsl:attribute name="href">./DataArea?plugin=com.dell.cdu.webplugins.CDUParentWebPlugin&amp;component=sysreboot</xsl:attribute>
				</Data>
			</BottomCustomButton>
			<PageTitle status="4"><xsl:attribute name="display"><xsl:value-of select="$strPageTitleUnInitDisk"/><xsl:text>&#160;</xsl:text><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/></xsl:attribute></PageTitle>
			<SubHeader display="{$strPossibleReasons}"/>
			<ListData>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strControllerModeChange"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strPhysicalDisksMoved"/></xsl:attribute>
				</Data>
				<Data value=""/>
				<Data value="{$strInitDrivesFromBios}" colspan="6" align="left"/>
			</ListData>
		</DataArea>
	</xsl:template>

	<!-- 10/26/05: RS - Fix for DF30295 to handle Getcaps error when all drives are in foreign state or unsupported -->
	<xsl:template name="HandleDSAGetCapsFailureError">
		<DataArea exportdata="false" printable="false" email="false" ignoreJumpBar="false">
			<script language="javascript">
        function backToDSAPageUnSupportError()
        {
          var url = "./SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin";
          document.getElementById("dataarea").action = top.getFrame("OMA_gnv").appendDataAreaVID(url);
          document.getElementById("dataarea").submit();
          return true;
        }
      </script>
			<BottomCustomButton>
				<Data display="{$strBackButtonDisplayOnError}" formSubmit="true" href="javascript:backToDSAPageUnSupportError()"/>
			</BottomCustomButton>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strReboot"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.cdu.webplugins.CDUParentWebPlugin&amp;component=sysreboot</xsl:attribute>
				</Data>
			</BottomCustomButton>
			<PageTitle status="4"><xsl:attribute name="display"><xsl:value-of select="$strTitle1UnableToLaunchWizard"/> -<xsl:text>&#160;</xsl:text><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/></xsl:attribute></PageTitle>
			<SubHeader display="{$strTitle2UnableToLaunchWizard}"/>
			<ListData>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strFreeDisksUnavailable"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMinDrivesForRAID"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strArrayDisksUnsupported"/></xsl:attribute>
				</Data>
				<Data value=""/>
				<Data value="{$strSelectDifferentController}" colspan="6" align="left"/>
				<Data value="{$strORMessage}" colspan="6" align="left"/>
				<Data value="{$strAddPhysicalDrives}" colspan="6" align="left"/>
				<Data value="{$strORMessage}" colspan="6" align="left"/>
				<Data value="{$strRemoveUnsupportedDrives}" colspan="6" align="left"/>
			</ListData>
		</DataArea>
	</xsl:template>

	<xsl:template name="HandleGetCapsFailureError">
    <xsl:choose>
      <xsl:when test="$GLOBAL_VAR_GetCapsSMStatus = '2288'">
        <DataArea exportdata="false" printable="false" email="false">
          <AlertMessage alert="true" status="4">
            <xsl:attribute name="display"><xsl:value-of select="$strTitle1UnableToLaunchWizard"/><xsl:text> </xsl:text><xsl:value-of select="$strPreservedCacheErrorMessage"/></xsl:attribute>
          </AlertMessage>
			    <BottomCustomButton>
				    <Data formSubmit="true" display="{$strPrevPage}" href="{$GLOBAL_VAR_ExitWizardHREFValue}"/>
			    </BottomCustomButton>
		    </DataArea>
      </xsl:when>
      <xsl:otherwise>
        <DataArea exportdata="false" printable="false" email="false">
			    <AlertMessage display="{$strTitle1UnableToLaunchWizard}" alert="true" status="4"/>
			    <SubHeader display="{$strTitle2UnableToLaunchWizard}"></SubHeader>
			    <ListData>
				    <Data>
					    <xsl:attribute name="display">-</xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strFreeDisksUnavailable"/></xsl:attribute>
				    </Data>
				    <Data>
					    <xsl:attribute name="display">-</xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strInitializedDisksUnavailable"/></xsl:attribute>
				    </Data>
				    <Data>
					    <xsl:attribute name="display">-</xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strNoEnclosureAvailable"/></xsl:attribute>
				    </Data>
				    <Data>
					    <xsl:attribute name="display">-</xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strMaxVDsReached"/></xsl:attribute>
				    </Data>
				    <Data>
					    <xsl:attribute name="display">-</xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strControllerBusy"/></xsl:attribute>
				    </Data>
				    <Data>
					    <xsl:attribute name="display">-</xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strControllerRescanInProgress"/></xsl:attribute>
				    </Data>
			    </ListData>
			    <BottomCustomButton>
				    <Data formSubmit="true" display="{$strPrevPage}" href="{$GLOBAL_VAR_ExitWizardHREFValue}"/>
			    </BottomCustomButton>
		    </DataArea>
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
</xsl:stylesheet>
