<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	
        
        <xsl:template name="VirtualDiskPartitionTableHeader">
		<xsl:param name="tasks"/>
		<!-- tasks should be either 'true' or 'false' to indicate whether to display the drop-down menu of tasks-->
		<xsl:call-template name="scripts"/>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
             <xsl:variable name="GLOBAL_VAR_LOCALE"><xsl:value-of select="/OMA/Locale"/></xsl:variable>
             <Data name="Status" columnspacing="true" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
                <Data name="Name" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strPartitionPathName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPartitionPathName"/></xsl:attribute>
		</Data>
                <Data name="State" columnspacing="true" editable="false" type="ustring" align="left">
		         <xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
		         <xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
                </Data>
                <xsl:if test="$tasks = 'true'">
				<Data name="taskslist" columnspacing="true" editable="false" type="ustring" ignoreoncli="true">
				    <xsl:attribute name="noborderright">true</xsl:attribute>
                                    <xsl:attribute name="display"><xsl:value-of select="$strTasks"/></xsl:attribute>
 				    <xsl:attribute name="value"><xsl:value-of select="$strTasks"/></xsl:attribute>
				</Data>
				<Data name="exbut" columnspacing="true" editable="false" type="ustring" ignoreoncli="true">
					<xsl:attribute name="display"><!--XLATESTART-->Execute<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART--><!--XLATESTOP--></xsl:attribute>
				</Data>
                </xsl:if>
                <Data name="Size" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strSize"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSize"/></xsl:attribute>
		</Data>
		<Data name="FluidCacheState" columnspacing="true" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheEnabled"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strFluidCacheEnabled"/></xsl:attribute>
		</Data>
                 <HiddenTable>
			<Data >
			<xsl:attribute name="name">BackTo</xsl:attribute>
			<xsl:attribute name="returnvalue"></xsl:attribute>
			</Data>
                </HiddenTable>
        </xsl:template>
        
	<xsl:template name="VirtualDiskPartitionTableRows">  
		<xsl:param name="tasks"/>
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>	
                <xsl:param name="DeviceName"><xsl:value-of select="PartitionPath"/></xsl:param>	
		<xsl:call-template name="scripts"/>
            <xsl:variable name="GLOBAL_VAR_LOCALE"><xsl:value-of select="/OMA/Locale"/></xsl:variable>  
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
                <xsl:variable name="isEmpty">
				<xsl:call-template name="IsCurrentMethodMaskEmpty">
					<xsl:with-param name="Mask">
						<xsl:value-of select="CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
		</xsl:variable>
		<Row height="30px">
                    
			<Data type="status" columnspacing="true" align="center">
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			</Data>
			<Data name="Name" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:value-of select="PartitionPath"/></xsl:attribute>
			</Data>
                        <Data name="State" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
                        <xsl:if test="$tasks='true'">
				<xsl:choose>
					<xsl:when test="$isEmpty='0'">
						<Data value="tasks" columnspacing="true" display="Partition Tasks" type="select" ignoreoncli="true">
							<xsl:attribute name="display"><xsl:value-of select="$strVDPartionTasks"/></xsl:attribute>
							<xsl:attribute name="name">PartitionTasks<xsl:value-of select="$ObjID"/></xsl:attribute>
	                                                <xsl:attribute name="noborderright">true</xsl:attribute>
                                                        <xsl:choose>
                                                                <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de')) or (starts-with($GLOBAL_VAR_LOCALE, 'ja'))">
                                                                       <xsl:attribute name="width">width:300px</xsl:attribute>
                                                                 </xsl:when>
                                                                <xsl:otherwise>
                                                                   <xsl:attribute name="width">width:180px</xsl:attribute>
                                                                </xsl:otherwise>
                                                         </xsl:choose>	
                                                         <Choice returnvalue="-" default="true">
                                                                  <xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
                                                         </Choice>
                                                          <xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="CurrentMethodMask"/>
								<xsl:with-param name="templateName" select="28"/>
                                                          </xsl:call-template>
							
						</Data>
						<Data type="button">
							<xsl:attribute name="display"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="id"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="href">javascript:onExecute(\"<xsl:value-of select="$ObjID"/>\",\"<xsl:value-of select="$DeviceName"/>\");</xsl:attribute>
							 <xsl:attribute name="tablebutton">true</xsl:attribute>
						</Data>	
                                        </xsl:when>
					<xsl:otherwise>
						<Data value="tasks" columnspacing="true" type="select" ignoreoncli="true" noborderright="true">
							<xsl:attribute name="display"><xsl:value-of select="$strVDPartionTasks"/></xsl:attribute>
							<xsl:attribute name="name">PartitionTasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<xsl:choose>
                                                                <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de')) or (starts-with($GLOBAL_VAR_LOCALE, 'ja'))">
                                                                        <xsl:attribute name="width">width:300px</xsl:attribute>
                                                                </xsl:when>
                                                                 <xsl:otherwise>
                                                                       <xsl:attribute name="width">width:180px</xsl:attribute>
                                                                 </xsl:otherwise>
                                                        </xsl:choose>	
							<Choice returnvalue="" default="true">
								<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
							</Choice>
						</Data>
						<Data type="ustring" columnspacing="true" name="execute" link="false">
							<xsl:attribute name="value"></xsl:attribute>
						</Data>
						
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
                        
			
			<xsl:if test="//PartitionSize or $dynamicView = 'false' ">
				<!-- Check to see if ANY of the objects have the XML tag.  If so, then the header will be displayed, so populate the value here -->
				<xsl:choose>
					<!-- The column will be displayed so check to see if THIS object has the XML tag. -->
					<xsl:when test="PartitionSize">
						<!-- The tag exists, so display the value -->
						<xsl:choose>
							<xsl:when test="/OMA/@cli='true'">
								<!-- CLI Versions of the length data (displays bytes as well as GB)  -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="PartitionSize"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="PartitionSize"/> bytes)</xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<!-- Web Versions of the length data (ONLY displays GB) -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="PartitionSize"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
                        <xsl:if test="//PartOfCachePool or /OMA/@cli = 'true'"> <!-- RNA -->
                               <Data editable="false" type="ustring" align="center">
                                         <xsl:attribute name="name"><xsl:value-of select="$strFluidCacheEnabled"/><xsl:value-of select="position()"/></xsl:attribute>
  							<xsl:attribute name="value"><xsl:choose><xsl:when test="PartOfCachePool"><xsl:call-template name="GetFluidCacheDeviceState"><xsl:with-param name="state"><xsl:value-of select="PartOfCachePool"/></xsl:with-param></xsl:call-template></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
		
            	                  </Data>
                  
			</xsl:if>
			
		</Row>
             
		<script language="javascript">
			function onExecute(VDPartitionOID,DeviceName) 
                        {
                                 var PartitionTask = "PartitionTasks" + VDPartitionOID;
                                 var Action = document.getElementById(PartitionTask).value;
                                 
                                 var ControllerName= '<xsl:value-of select="/OMA/ControllerName"/>';
                                 var ControllerOID='<xsl:value-of select="/OMA/ControllerOID"/>';
                                 var VirtualDiskName = '<xsl:value-of select="/OMA/VirtualDiskName"/>';
                                 var VirtualDiskOID = '<xsl:value-of select="/OMA/VirtualDiskOID"/>';
                                 var BackTo='<xsl:value-of select="/OMA/BackTo"/>';
                                 var CallingFromVDPartitionPage = "true";
                                 
                                 // Add Common Parameters here
                                 var Parameters = "&amp;ControllerName="+ControllerName+"&amp;ControllerOID="+ControllerOID+"&amp;VirtualDiskName="+VirtualDiskName+"&amp;VirtualDiskOID="+VirtualDiskOID+"&amp;VDPartitionOID=" + VDPartitionOID + "&amp;Action="+Action+"&amp;DeviceName="+DeviceName+"&amp;CallingFromVDPartitionPage="+CallingFromVDPartitionPage;//+"&amp;BackTo="+BackTo;
                                 
                                // Action Code
                                if(Action == "-") 
                                 { 
                                        alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
                                 }      
                                 else if(Action == '536870912')
                                 {    
                                      document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.VDPartitionTasksWebPlugin"+Parameters+"&amp;help=fecvdpt");
                                 }
                                 else if(Action == '1073741824') 
                                 {      if(confirm("<xsl:value-of select="$strAreYouSureDisableCacheonVDPartition"/>"))
                                        {
                                          document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.VDPartitionExecuteActionWebPlugin"+Parameters+"&amp;help=fecvdpt&amp;Refresh=True");
                                          document.dataarea.submit();
                                        }
                                 }
                                 else if(Action == '2147483648')
                                 {    
                                      document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.VDPartitionExecuteActionWebPlugin"+Parameters+"&amp;help=fecvdpt&amp;Refresh=True");
                                      document.dataarea.submit();

                                 }

                        }
		</script>
	</xsl:template>
</xsl:stylesheet>




