<!-- This is the XSL to render the Array Disks belonging to a Virtual Disk page.  The associated web plugin is the ArrayWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="vdparttbl.xsl"/>
	
        <xsl:template match="OMA">
		<script language="javascript">
		        
			var foreignconfig = '<xsl:value-of select="/OMA/ForeignConfig"/>';
                 
			function reloadPage()
      			{
                            var RefreshURL = document.URL;
                            var FluidCacheRefresh= '<xsl:value-of select="//FluidCacheSuccess"/>';
                                 RefreshURL =RefreshURL.replace("FluidCacheSuccess="+FluidCacheRefresh,"");
          			document.location.href = top.gnv.appendVID(RefreshURL+"&amp;Refresh=true");
      			}                        
    		</script>
		
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="VirtualDiskName"/><xsl:value-of select="$strTitle1Part2"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">javascript:reloadPage();</xsl:attribute>
				</Data>
			</CustomButton>
                  <xsl:choose>
		                  <xsl:when test= "/OMA/FluidCacheSuccess = '536870912'">
                                            
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strEnableFluidCacheonPartitionSuccess"/></xsl:attribute>
                                                                     <xsl:attribute name="status">2</xsl:attribute>

                                                             </AlertMessage>
                                                    
                     		</xsl:when>
					<xsl:when test= "/OMA/FluidCacheSuccess = '1073741824'">
                                            
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strDisableFluidCacheonPartitionSuccess"/></xsl:attribute>
                                                                     <xsl:attribute name="status">2</xsl:attribute>

                                                             </AlertMessage>
                                                    
                     		</xsl:when>
					<xsl:when test= "/OMA/FluidCacheSuccess = '2147483648'">
                                            
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strReactivatePartitionSuccess"/></xsl:attribute>
                                                                     <xsl:attribute name="status">2</xsl:attribute>

                                                             </AlertMessage>
                                                    
                     		</xsl:when>

                   </xsl:choose>
			<xsl:call-template name="Table">
					<xsl:with-param name="Display">
                                                <xsl:value-of select="$strPartitionsTable"/>
                                	</xsl:with-param>
                        </xsl:call-template>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
					<xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
                        	</Data>
			</BottomCustomButton>
                        
		</DataArea>
	</xsl:template>
	   
	<xsl:template name="Table">
		<xsl:param name="Display"/>
                <xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>	
		<xsl:choose>
			<xsl:when test="Partitions/DCStorageObject">
				<TableData name="{$Display}" display="{$Display}" columnspacing="true">
		                <xsl:variable name="showtasks">false</xsl:variable>
                                 <SubHeader display="{$Display}"/>
					<Header>
						<xsl:call-template name="VirtualDiskPartitionTableHeader">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$checkAdmin"/>
							</xsl:with-param>
                                                        
                            			</xsl:call-template>
					</Header>
					<xsl:for-each select="Partitions/DCStorageObject">
							<xsl:call-template name="VirtualDiskPartitionTableRows">
								<xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
								<xsl:with-param name="expanded">true</xsl:with-param>
							</xsl:call-template>
					</xsl:for-each>
					</TableData>
				</xsl:when>
				<xsl:otherwise>
						<AlertMessage>
							<xsl:attribute name="display"><xsl:value-of select="$strNoPartitions"/></xsl:attribute>
						</AlertMessage>	
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
