<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Enclosure Set Tag Data page.  The associated web plugin is the SetEnclosureTagDataWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:import href="Utils.xsl"/>
    <xsl:template match="OMA">
		<xsl:variable name="MaxAssetTagLength">
			<xsl:choose>
				<xsl:when test="/OMA/Enclosures/DCStorageObject/MaxAssetTagLength">
					<!-- If max asset tag length is defined, use it -->
					<xsl:value-of select="/OMA/Enclosures/DCStorageObject/MaxAssetTagLength"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="10"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
				
		<xsl:variable name="MaxAssetNameLength">
			<xsl:choose>
				<xsl:when test="/OMA/Enclosures/DCStorageObject/MaxAssetNameLength">
					<!-- If max asset tag length is defined, use it -->
					<xsl:value-of select="/OMA/Enclosures/DCStorageObject/MaxAssetNameLength"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="32"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
				
        <DataArea validate="true" email="false" export="false" exportdata="false" printable="false">
		
				<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.EnclosureExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;EnclosureOID=<xsl:value-of select="EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;Action=4</xsl:attribute>
				<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApply"/></xsl:attribute>
				
				<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.sm.webplugins.EnclosureInfoWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="Name"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;help=enprin</xsl:attribute>
				
				<xsl:call-template name="scripts"/>
		
            <PageTitle>
                <xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="/*/Enclosures/@ControllerName"/><xsl:value-of select="$strTitle1Part2"/></xsl:attribute>
            </PageTitle>
            <CustomButton>
                <Data name="Refresh">
                    <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
                    <xsl:attribute name="href"></xsl:attribute>
                    <xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
                </Data>
            </CustomButton>
            <ComboData>
                <ListData>
                    <SubHeader>
                        <xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
                        <xsl:attribute name="status"><xsl:value-of select="Enclosures/DCStorageObject/ObjStatus"/></xsl:attribute>
                    </SubHeader>
                    <Data name="Name" editable="false" type="ustring">
                        <xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="Enclosures/DCStorageObject/EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of select="Enclosures/DCStorageObject/ProductID"/></xsl:with-param></xsl:call-template></xsl:attribute>
                    </Data>
                    <Data name="Channel" editable="false" type="ustring">
                        <xsl:attribute name="display"><xsl:value-of select="normalize-space($strChannel)"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="Enclosures/DCStorageObject/Channel"/></xsl:attribute>
                    </Data>
					<xsl:if test="Enclosures/DCStorageObject/TargetID ">
                    <Data name="TargetID" editable="false" type="ustring">
                        <xsl:attribute name="display"><xsl:value-of select="$strTargetID"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="Enclosures/DCStorageObject/TargetID"/></xsl:attribute>
                    </Data>
					</xsl:if>
					<xsl:if test="Enclosures/DCStorageObject/ServiceTag ">                    
						<xsl:choose>
							<xsl:when test="normalize-space(ServiceTag)">
								<Data name="ServiceTag" editable="false" type="ustring">
									<xsl:attribute name="display"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="Enclosures/DCStorageObject/ServiceTag"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data name="ServiceTag" editable="false" type="usting">
									<xsl:attribute name="display"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>					
					</xsl:if>
					<xsl:if test="Enclosures/DCStorageObject/AssetTag ">
                    <Data name="AssetTag" editable="false" type="ustring">
                        <xsl:attribute name="display"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="Enclosures/DCStorageObject/AssetTag"/></xsl:attribute>
                    </Data>
					</xsl:if>
					<xsl:if test="Enclosures/DCStorageObject/AssetName ">
                    <Data name="AssetName" editable="false" type="ustring">
                        <xsl:attribute name="display"><xsl:value-of select="$strAssetName"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="Enclosures/DCStorageObject/AssetName"/></xsl:attribute>
                    </Data>
					</xsl:if>
                </ListData>
                <TableData>
                    <SubHeader>
                        <xsl:attribute name="display"><xsl:value-of select="$strSubHeader2"/></xsl:attribute>
                    </SubHeader>
                    <Row>
                        <Data name="NewAssetTag" editable="false" type="ustring" align="left">
                            <xsl:attribute name="display"><xsl:value-of select="$strNewTag"/></xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="$strNewTag"/></xsl:attribute>
                        </Data>
                        <Data name="AssetTagData" editable="true" type="editbox" align="left">
                            <xsl:attribute name="display"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="/OMA/Enclosures/DCStorageObject/AssetTag"/>
											 </xsl:attribute>
							<xsl:attribute name="maxlength">
								<xsl:value-of select="$MaxAssetTagLength"/>
							</xsl:attribute>
                        </Data>
                        <Data name="NewAssetName" editable="false" type="ustring" align="left">
                            <xsl:attribute name="display"><xsl:value-of select="$strNewName"/></xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="$strNewName"/></xsl:attribute>
                        </Data>
                        <Data name="AssetNameData" editable="true" type="editbox" align="left">
                            <xsl:attribute name="display"><xsl:value-of select="$strAssetName"/></xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="/OMA/Enclosures/DCStorageObject/AssetName"/>
											</xsl:attribute>
							<xsl:attribute name="maxlength">
								<xsl:value-of select="$MaxAssetNameLength"/>
							</xsl:attribute>
                        </Data>
                    </Row>
                </TableData>
            </ComboData>

		       <HiddenTable>	
	         		<Data name="ChangeAssetTag" type="hidden">
							<xsl:attribute name="value">false</xsl:attribute>
						</Data>
		       		<Data name="ChangeAssetName" type="hidden">
							<xsl:attribute name="value">false</xsl:attribute>
						</Data>
   				</HiddenTable>
   				
            <script language="javascript">
					function validate() 
					{				
						var oldAssetTag =	'<xsl:value-of select="/OMA/Enclosures/DCStorageObject/AssetTag"/>';		
						var oldAssetName = '<xsl:value-of select="/OMA/Enclosures/DCStorageObject/AssetName"/>';
						var AssetTag    = document.getElementById("AssetTagData").value;
						var AssetName = document.getElementById("AssetNameData").value;
						
						if((oldAssetTag == AssetTag) &amp;&amp; (oldAssetName == AssetName))
						{
							alert("<xsl:value-of select="$strSame"/>");
							return false;
						}
						
						if(oldAssetTag != AssetTag)
						{
							if (AssetTag.length > <xsl:value-of select="$MaxAssetTagLength"/>) 
							{
								alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strAlert2"/>" + 
									"<xsl:value-of select="$MaxAssetTagLength"/>" + "<xsl:value-of select="$strAlert4"/>");
								return false;
							}
							if(AssetTag.length &lt; 1)
							{
								alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strNameBlank"/>");	   	   	 
						   		return false;
							}
							else if( ! isValidNameNoSpace(AssetTag) ) 
							{
								return false;
							}
							document.getElementById("ChangeAssetTag").value = "true";
						}
						
						if(oldAssetName != AssetName)
						{
							if (AssetName.length > <xsl:value-of select="$MaxAssetNameLength"/>) 
							{
								alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strAlert3"/>" +
									"<xsl:value-of select="$MaxAssetNameLength"/>" + "<xsl:value-of select="$strAlert4"/>");
              document.location.href = top.gnv.appendVID(document.location.href);
              return false;
              }
              if(AssetName.length &lt; 1)
							{
								alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strNameBlank"/>");	   	   	 
						   		return false;
							}
							else if( ! isValidNameNoSpace(AssetName) ) 
							{
								return false;
							}
							
							document.getElementById("ChangeAssetName").value = "true";
						}
						
						disableButtons("submit","back" ,"");						
						return true;
					}
		
			</script>
        </DataArea>
    </xsl:template>
</xsl:stylesheet>
