<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<!-- The adtbl.xsl is used to display a table of array and hard disks with their associated properties. -->
	<!-- This should be used by all webpages which are required to display a table of arrayand hard disks.  -->
	<!-- Having this code in a common file allows for a central location to make updates and add new  -->
	<!-- new fields for array disks which will then be displayed by all web pages as well as the CLI. -->
	<!-- This file is broken down into two main xsl templates.  The TABLE HEADER and the TABLE ROWS. -->
	<!-- Array DISK TABLE HEADER -->


	<xsl:template name="PhysicalDiskFwVerTableHeader">
		<xsl:call-template name="scripts"/>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>

          <xsl:if test="//CurrentPN or /OMA/@cli = 'true'">

	    		<Data name="Name" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
			</Data>
          </xsl:if>
            <xsl:if test="//ProductID or /OMA/@cli = 'true'">

		 <Data name="ModelNumber" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strModelNumber"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strModelNumber"/></xsl:attribute>
		</Data>
          </xsl:if>

          <xsl:if test="//Revision  or /OMA/@cli = 'true'">
			<Data name="CurrentFirmware" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strFW"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strFW"/></xsl:attribute>
			</Data>
            </xsl:if>
            <xsl:if test="//RevisionAvailable   or /OMA/@cli = 'true'">
	
			<Data name="AvailableFirmware" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strLatestFW"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strLatestFW"/></xsl:attribute>
			</Data>
	     </xsl:if>
	    <xsl:if test="//Nautils   or /OMA/@cli = 'true'">
      		<Data name="Nautils" columnspacing="true" editable="false" type="ustring" align="center">
	      	  <xsl:attribute name="display"><xsl:value-of select="$strDup"/></xsl:attribute>
	      	  <xsl:attribute name="value"><xsl:value-of select="$strDup"/></xsl:attribute>
		      </Data>
	    </xsl:if>

           <xsl:if test="//Nautils_efi   or /OMA/@cli = 'true'">
			<Data name="Nautils_efi" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strNautilsEfi"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strNautilsEfi"/></xsl:attribute>
			</Data>
      	</xsl:if>

            <xsl:if test="//Nautils_dos or /OMA/@cli = 'true'">
			<Data name="Nautils_dos" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strNautilsDos"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strNautilsDos"/></xsl:attribute>
			</Data>
		</xsl:if>

            <xsl:if test="//Dup_Reboot_Req or /OMA/@cli = 'true'">

		<Data name="Dup_Reboot_Req" columnspacing="true" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strDupRebootReq"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDupRebootReq"/></xsl:attribute>
		</Data>
            </xsl:if>


            <xsl:if test="//Dup or /OMA/@cli = 'true'">

            <Data name="Dup_Dup" columnspacing="true" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strDup"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDup"/></xsl:attribute>
		</Data>
           </xsl:if>

          <xsl:if test="//CurrentPN or /OMA/@cli = 'true'">
   
		<Data name="Dup_CurrentPN" columnspacing="true" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strPartNumber"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPartNumber"/></xsl:attribute>
		</Data>

         </xsl:if>

    </xsl:template>
	<!-- ARRAY DISK TABLE ROWS -->
	<xsl:template name="PhysicalDiskFwVerTableRows">  
       <xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
                
		<xsl:call-template name="scripts"/>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
              to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="IsSASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol">
					<xsl:value-of select="BusProtocol"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="IsDiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="ADID">
			<xsl:choose>
				<xsl:when test="$IsDiskInEnclosure='1'">
					<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="NODUP">
		      <xsl:value-of select="Dup"/>
		</xsl:variable>
		<xsl:variable name="NAUTILS_EFI">
		      <xsl:value-of select="Nautils_efi"/>
		</xsl:variable>
		<xsl:variable name="NAUTILS">
		      <xsl:value-of select="Nautils"/>
		</xsl:variable>
		<Row height="30px">
			<Data name="Name" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
				<xsl:choose>
					<!-- check for ad vs hd -->
					<xsl:when test="$nonRaid = '1' ">
						<xsl:attribute name="value"><xsl:value-of select="$strHDName"/><!--xsl:value-of select="$ADID"/--><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strADName"/><!--xsl:value-of select="$ADID"/--><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			<xsl:if test="//ProductID  or /OMA/@cli = 'true'">
			  <xsl:choose>
			 	<xsl:when test="ProductID">
					<Data name="ModelNumber" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="ProductID"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="ModelNumber" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
 			  </xsl:choose>
     		</xsl:if>
			<xsl:if test="//Revision  or /OMA/@cli = 'true'">
			  <xsl:choose>
			 	<xsl:when test="Revision">
					<Data name="CurrentFirmware" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="Revision"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="CurrentFirmware" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
 			  </xsl:choose>
     		</xsl:if>
			<xsl:if test="//RevisionAvailable   or /OMA/@cli = 'true'">
			  <xsl:choose>
			 	<xsl:when test="RevisionAvailable">
					<Data name="AvailableFirmware" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="RevisionAvailable"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="AvailableFirmware" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
 			  </xsl:choose>
     		</xsl:if>
		    <xsl:if test="//Nautils   or /OMA/@cli = 'true'">
			  <xsl:choose>
			 	<xsl:when test="Nautils">
					<Data name="Nautils" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="Nautils"/></xsl:attribute>
						 
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="Nautils" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
 			  </xsl:choose>
     		</xsl:if>	
			<xsl:if test="//Nautils_efi   or /OMA/@cli = 'true'">
			  <xsl:choose>
			 	<xsl:when test="Nautils_efi">
					<Data name="Nautils_efi" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="Nautils_efi"/></xsl:attribute>
						
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="Nautils_efi" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
 			  </xsl:choose>
     		</xsl:if>
			<xsl:if test="//Nautils_dos   or /OMA/@cli = 'true'">
			  <xsl:choose>
			 	<xsl:when test="Nautils_dos">
					<Data name="Nautils_dos" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="Nautils_dos"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="Nautils_dos" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
 			  </xsl:choose>
     		</xsl:if>
		    <xsl:if test="//Dup_Reboot_Req  or /OMA/@cli = 'true'">
			  <xsl:choose>
			 	<xsl:when test="Dup_Reboot_Req ">
					<Data name="Dup_Reboot_Req " type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="Dup_Reboot_Req "/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="Dup_Reboot_Req " type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
 			  </xsl:choose>
     		</xsl:if>	
             <xsl:if test="//Dup or /OMA/@cli = 'true'">
			  
					<Data name="Dup_Dup" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="Dup"/></xsl:attribute>
					</Data>
				
     		</xsl:if>	
            <xsl:if test="//CurrentPN or /OMA/@cli = 'true'">
			  
					<Data name="CurrentPN" type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="CurrentPN"/></xsl:attribute>
					</Data>
				
     		</xsl:if>	

	    </Row>
 	</xsl:template>
</xsl:stylesheet>




