<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:variable name="GLOBAL_VAR_WriteBack">wb</xsl:variable>
    <xsl:variable name="GLOBAL_VAR_WriteThrough">wt</xsl:variable>
    <xsl:variable name="GLOBAL_VAR_HighAvailabilityModeDiskCount"><xsl:value-of select="/OMA/CacheStoreCount"/></xsl:variable>
    <xsl:variable name="GLOBAL_VAR_HighAvailabilityMode"><xsl:value-of select="/OMA/CachePoolISHA"/></xsl:variable>
    <xsl:variable name="HEALTH_STATUS_NON_CRITICAL">3</xsl:variable>	
	
	<xsl:template match="OMA">
      
	<xsl:call-template name="scripts"/>
     
		<DataArea  printable="false" email="false" validate="true" Refresh="false" export="false" exportdata="false" onLoad="true">
                	<BottomCustomButton>
                                      <Data display="{$strApply}" formSubmit="true" href="javascript:ExecuteTask()" id="submitbuttoncontent"/> 
                        </BottomCustomButton>
                        <PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="//DeviceName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>
                  
                   <xsl:if test = "$GLOBAL_VAR_HighAvailabilityModeDiskCount = '1' or $GLOBAL_VAR_HighAvailabilityModeDiskCount = '0'">
                                
                                <AlertMessage ignoreoncli="true">
                                    <xsl:attribute name="display"> 
                                            <xsl:choose>
                                                <xsl:when test="$GLOBAL_VAR_HighAvailabilityModeDiskCount = '1'"><xsl:value-of select="$strFluidCacheDisksWriteBackWarning"/></xsl:when>
                                                <xsl:when test="$GLOBAL_VAR_HighAvailabilityModeDiskCount = '0'"><xsl:value-of select="$strFluidCacheDisksPassWarning"/></xsl:when>
                                            </xsl:choose>
                                    </xsl:attribute>
                                     <xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>
                                </AlertMessage>
                  </xsl:if>
                  

                        <TableData>
                                <Row>
                                        <Data><xsl:attribute name="value"><xsl:value-of select="$strPartitionWriteMode"/></xsl:attribute></Data>
                                        <Data name="PartitionWriteMode" type="select" handler="javascript:onSelectWriteMode()" event="onChange">
                                               
                                               <Choice>
                                                    <xsl:attribute name="value"><xsl:value-of select="$strWriteThrough"/></xsl:attribute>
                                                    <xsl:attribute name="returnvalue"><xsl:value-of select="$GLOBAL_VAR_WriteThrough"/></xsl:attribute>
                                               </Choice>
                                               <Choice>
                                                    <xsl:attribute name="value"><xsl:value-of select="$strWriteBack"/></xsl:attribute>
                                                    <xsl:attribute name="returnvalue"><xsl:value-of select="$GLOBAL_VAR_WriteBack"/></xsl:attribute>
                                               </Choice>
                                        </Data>
                                </Row>
                        </TableData> 
        <script language="javascript">
		function initializationRoutine()
		{       var HighAvailabilityModeCount = "<xsl:value-of select="$GLOBAL_VAR_HighAvailabilityModeDiskCount"/>"; <!-- variables contains cache store-->
                    var HighAvailabilityMode = "<xsl:value-of select="$GLOBAL_VAR_HighAvailabilityMode"/>"; <!-- variables contains cache store-->
			  var elemName = "PartitionWriteMode";
			  var dropdown=document.getElementById(elemName);
  			  var len = dropdown.length;
			
                  if(HighAvailabilityModeCount &gt; 1 &amp;&amp; HighAvailabilityMode == 'True')
                  {
                          for(var i=0;i&lt;len;i++)
				  {   
					if(dropdown.options[i].value == '<xsl:value-of select="$GLOBAL_VAR_WriteBack"/>')
					{     
						dropdown.options[i].selected = true;
						break;
					}
				  }
  
                  }
                  else
                  {

                           for(var i=0;i&lt;len;i++)
				  {   

					if(dropdown.options[i].value == '<xsl:value-of select="$GLOBAL_VAR_WriteThrough"/>')
					{   
						dropdown.options[i].selected = true;
						
					}
                              
				  }


                  }        
			
			return;
		}
            function onSelectWriteMode()
            {
			var HighAvailabilityMode = "<xsl:value-of select="$GLOBAL_VAR_HighAvailabilityModeDiskCount"/>"; <!-- variables contains cache store count -->
                        var elemName = "PartitionWriteMode";
			var dropdown=document.getElementById(elemName);
			var len = dropdown.length;
			
                  if(HighAvailabilityMode &lt; 2)
                  {
                          for(var i=0;i&lt;len;i++)
				  {   
					if(dropdown.options[i].selected == true &amp;&amp; dropdown.options[i].value == '<xsl:value-of select="$GLOBAL_VAR_WriteBack"/>')
					{     
                                        
                                                 
                                                if(HighAvailabilityMode == 1)
                                                {
                                                    alert("<xsl:value-of select="$strFluidCacheDisksWriteBackWarning"/>");
                                                }
                                                else if(HighAvailabilityMode == 0)
                                                {
                                                    alert("<xsl:value-of select="$strFluidCacheDisksPassWarning"/>");
                                                }
						break;
					}
				  }
  
                  }



  		}
	   	function ExecuteTask() 
        	{
                   PartitionWriteMode = document.dataarea.PartitionWriteMode.value;
                   var ControllerName= "<xsl:value-of select="/OMA/ControllerName"/>";
                   var ControllerOID= "<xsl:value-of select="/OMA/ControllerOID"/>";
                   var VirtualDiskName = "<xsl:value-of select="/OMA/VirtualDiskName"/>";
                   var VirtualDiskOID = "<xsl:value-of select="/OMA/VirtualDiskOID"/>";
                   //  var BackTo = "<xsl:value-of select="/OMA/BackTo"/>";
                   var VDPartitionOID = "<xsl:value-of select="/OMA/VDPartitionOID"/>";
                   var Action='<xsl:value-of select="/OMA/Action"/>';
                   var DeviceName = "<xsl:value-of select="/OMA/DeviceName"/>";
                   var CallingFromVDPartitionPage = "<xsl:value-of select="/OMA/CallingFromVDPartitionPage"/>";

                   var Parameters = "&amp;ControllerName="+ControllerName+"&amp;ControllerOID="+ControllerOID+"&amp;VirtualDiskName="+VirtualDiskName+"&amp;VirtualDiskOID="+VirtualDiskOID+"&amp;VDPartitionOID=" + VDPartitionOID + "&amp;Action="+Action+"&amp;WriteMode="+PartitionWriteMode+"&amp;DeviceName="+DeviceName+"&amp;CallingFromVDPartitionPage="+CallingFromVDPartitionPage;
                          
                     //Make Return true as return page is different
                   document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.VDPartitionExecuteActionWebPlugin"+Parameters+"&amp;help=vdmgmt&amp;Return=True");
                   document.dataarea.submit();
                 	
		}
	</script>
                       
		</DataArea>
	</xsl:template>
	
</xsl:stylesheet>

