<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	
	<xsl:variable name="VAR_AuthenticationFailed"><xsl:value-of select="/OMA/SEDErrorCode"/></xsl:variable>	
      <xsl:variable name="VAR_SecurityKeyPresent"><xsl:value-of select="/OMA/SecurityKeyPresent"/></xsl:variable>	

	<xsl:template match="OMA">
	
 		<DataArea onLoad="true" exportdata="false" email="false" printable="false" validate="true">
             <xsl:if test="count(/OMA/LockedDrives/DCStorageObject[not(UnlockForeignDKMStatus)]) &gt; 0">
             <xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Action=536870912&amp;help=cntkclfc&amp;Refresh=true</xsl:attribute>
			 <xsl:attribute name="submitdisplay"><xsl:value-of select="$strUnlock"/></xsl:attribute>
             </xsl:if> 
             <xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
             <xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
                	<xsl:call-template name="scripts"/>
			<script language="javascript">
				function initializationRoutine()
				{
					               <xsl:for-each select="/OMA/LockedDrives/DCStorageObject">
                                    var KeyIdName= '<xsl:call-template name="ReplaceKey"><xsl:with-param name="KeyId" select="SecurityKeyId"/></xsl:call-template>';
                                    var PassphraseFieldName= "Passphrase_"+KeyIdName;
                                   
                                    if(document.getElementById(PassphraseFieldName)!=null &amp;&amp; document.getElementById(PassphraseFieldName).disabled==false)
                                    {  
				                          document.getElementById(PassphraseFieldName).disabled=true;
                                          document.getElementById(PassphraseFieldName).value="";
                                    }
                                   </xsl:for-each>
                                    if('<xsl:value-of select="$VAR_SecurityKeyPresent"/>'=='0')
                                   {  
                                     var RadioArray = document.getElementsByName("SecurityKeyId");
                                     
				                     var len = RadioArray.length;
                                     for(var i=0;i&lt;len;i++)
				                     { 
                                            RadioArray[i].disabled=true;
                                     }
                                   }
                                   
                                   
				}
                        function OnKeyIDSelected()
                        {  
                               
                              var elemName = "SecurityKeyId";
					var RadioArray = document.getElementsByName(elemName);
					var len = RadioArray.length;
                              
 					for(var i=0;i&lt;len;i++)
					{    var PassphraseFieldName= "Passphrase_"+RadioArray[i].value; 
                                              if(document.getElementById(PassphraseFieldName)!=null)
                                              {
						if(RadioArray[i].checked == false)
						{
                                                    document.getElementById(PassphraseFieldName).disabled=true;
                                                    document.getElementById(PassphraseFieldName).value="";

						}
                                               else
                                               {
                                               
                                                
                                                 document.getElementById(PassphraseFieldName).disabled=false;
                                                
                                       
                                              }
                                     }  
					}
                             
                        }
 
                        function validate()
                        {   
							if(!Submitcontinue())
								return false;
								
						return true;
						            
                        } 
						  function Submitcontinue()
                        {     var KeyId="";
                              var Passphrase="";
                              var PassphraseGrammar=/^.*(?=.{8,32})(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[&amp;&lt;&gt;&quot;&apos;;:~`!@#$%^*_+=-?.,|\(\){}\\\/\[\]]).*$/;
                              <xsl:for-each select="/OMA/LockedDrives/DCStorageObject">
                                    var KeyIdName= '<xsl:call-template name="ReplaceKey"><xsl:with-param name="KeyId" select="SecurityKeyId"/></xsl:call-template>';
                                    var PassphraseFieldName= "Passphrase_"+KeyIdName;

                                    if(document.getElementById(PassphraseFieldName)!=null &amp;&amp; document.getElementById(PassphraseFieldName).disabled==false)
                                    {  
						   	KeyId =KeyIdName;
                                       	Passphrase =document.getElementById(PassphraseFieldName).value;
                                     }
                                     
                                 
                             </xsl:for-each>
                             if(Passphrase.length==0)
                             {
                                        alert("<xsl:value-of select="$strNoPassphraseEntered"/>"); 
                                        return false; 
                             }
                            if( !(PassphraseGrammar.test(Passphrase)) || !ValidateFormat(Passphrase))
                             {     alert("<xsl:value-of select="$strReadPassphraseGuidelines"/>");
                                   document.getElementById("Passphrase_"+KeyId).value = "";
			                 document.getElementById("Passphrase_"+KeyId).focus();
                                  
                                   return false;
                              }


                                    document.getElementById("SecurityKeyId").value=KeyId;
                                    document.getElementById("Passphrase").value=Passphrase;
                                return true;
                                 

                        } 
                        function SkipToImportPreview()
                        { 
				          var origurl = GetLocalUrl(); //Current url of page
                          if(confirm("<xsl:value-of select="$strSkipSEDPassphraseEntry"/>"))
                               { 
                                 document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Action=536870912&amp;help=cntkclfc&amp;Refresh=true");
                                 //document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Action=536870912&amp;help=cntkclfc&amp;BackTo="+origurl+"&amp;KeyIDCount="+count);
                                 //document.dataarea.submit();
                               } 
                               else
                               {
							     return;
							   } 

                        }   
                        function ContinueToImportPreview()
                        { 
				          var origurl = GetLocalUrl(); //Current url of page
                          if(confirm("<xsl:value-of select="$strContinueSEDPassphraseEntry"/>"))
                               { 
							     document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Action=536870912&amp;help=cntkclfc&amp;Refresh=true");
                                 //document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Action=536870912&amp;help=cntkclfc&amp;BackTo="+origurl+"&amp;KeyIDCount="+count);
                                 //document.dataarea.submit();
                               } 
                               else
                               {
							     return;
							   } 

                        }						
		
			</script>

		  	 <PageTitle>
                <xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
           
			  </PageTitle>
        <xsl:for-each select="/OMA/LockedDrives/DCStorageObject[UnlockForeignDKMStatus or UnlockForeignDKMStatus != '']">
		   <xsl:if test="UnlockForeignDKMStatus='1'">
            <AlertMessage>
			    <xsl:choose>
				 <xsl:when test="count(/OMA/LockedDrives/DCStorageObject[not(UnlockForeignDKMStatus)]) &gt; 0">
				    <xsl:attribute name="display"><xsl:value-of select="$strDKMTextMessage1"/></xsl:attribute>
				 </xsl:when>
				 <xsl:otherwise>
                    <xsl:attribute name="display"><xsl:value-of select="$strDKMTextMessage2"/></xsl:attribute>
			     </xsl:otherwise>
               </xsl:choose>				 
            </AlertMessage>
          </xsl:if>
          <xsl:if test="UnlockForeignDKMStatus='2'">
            <!--PromptText alert="false">
              <xsl:value-of select="$strDKMFailureTextMessage"/>
            </PromptText-->
			<AlertMessage status="2">
			   <xsl:attribute name="display"><xsl:value-of select="$strDKMFailureTextMessage"/></xsl:attribute>
			</AlertMessage>
          </xsl:if>
		  <xsl:if test="UnlockForeignDKMStatus = '3'">
            <!--PromptText alert="false">
              <xsl:value-of select="$strDKMFailureTextMessage2"/>
            </PromptText-->
			<AlertMessage status="2">
			   <xsl:attribute name="display"><xsl:value-of select="$strDKMFailureTextMessage2"/></xsl:attribute>
			</AlertMessage>
          </xsl:if>
		  <xsl:if test="UnlockForeignDKMStatus = '5'">
            <!--PromptText alert="false">
              <xsl:value-of select="$strDKMLockedTextMessage"/>
            </PromptText-->
			<AlertMessage status="2">
			   <xsl:attribute name="display"><xsl:value-of select="$strDKMLockedTextMessage"/></xsl:attribute>
			</AlertMessage>
          </xsl:if>
		  <xsl:if test="UnlockForeignDKMStatus = '6'">
            <!--PromptText alert="false">
              <xsl:value-of select="$strNoSecurityKey"/>
            </PromptText-->
			 <AlertMessage>
			   <xsl:attribute name="display"><xsl:value-of select="$strNoSecurityKey"/></xsl:attribute>
			</AlertMessage>
          </xsl:if>
        </xsl:for-each>
  
            <BottomCustomButton>
				<Data formSubmit="true">
				      <xsl:choose>
				      <xsl:when test="count(/OMA/LockedDrives/DCStorageObject[not(UnlockForeignDKMStatus)]) &gt; 0">
                        	<xsl:attribute name="display"><xsl:value-of select="$strSkip"/></xsl:attribute>
							 <xsl:attribute name="href">javascript:SkipToImportPreview()</xsl:attribute>
					  </xsl:when>
                      <xsl:otherwise>
					         <xsl:attribute name="display"><xsl:value-of select="$strContinue"/></xsl:attribute>
							  <xsl:attribute name="href">javascript:ContinueToImportPreview()</xsl:attribute>
                      </xsl:otherwise>	
                      </xsl:choose>					  
                             
                  	</Data>
			</BottomCustomButton>
            <xsl:if test="count(/OMA/LockedDrives/DCStorageObject[not(UnlockForeignDKMStatus)]) &gt; 0)">
			      <xsl:if test="$VAR_SecurityKeyPresent='1' or $VAR_AuthenticationFailed != ''">
                    <PromptText alert="false">
                      <xsl:value-of select="$strTextMessage"/>
                    </PromptText>
                  </xsl:if>

              	<TableData name="T" columnspacing="true">
                  				  
                
                  <xsl:if test="$VAR_SecurityKeyPresent='0'">
                    <PromptText alert="false">
                      <xsl:value-of select="$strGuideTextMessage"/>
                    </PromptText>
                  </xsl:if>

                  <xsl:if test="$VAR_AuthenticationFailed != ''">
                    <PromptText alert="true">
                      <xsl:value-of select="$strTextMessageAlert"/>
                    </PromptText>
                  </xsl:if>
				  
                       <Header>
                 		<xsl:call-template name="SecurityKeyIdentifiersHeader"/>
			          	</Header>
				   <xsl:for-each select="/OMA/LockedDrives/DCStorageObject[not(UnlockForeignDKMStatus)]">	
                   		<xsl:call-template name="SecurityKeyIdentifiersRows"/>
			 	   </xsl:for-each>

              	</TableData>
            </xsl:if>
             	<HiddenTable>
				<Data>
					<xsl:attribute name="name">SecurityKeyId</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
	      	</HiddenTable>
            	<HiddenTable>
				<Data>
					<xsl:attribute name="name">Passphrase</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
	      	</HiddenTable>
  		</DataArea>
	</xsl:template>

	<xsl:template name="SecurityKeyIdentifiersHeader">
		<Data name="Id" editable="false" type="ustring" >
			<xsl:attribute name="display"><xsl:value-of select="$strLabelSecurityKeyIdentifier"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLabelSecurityKeyIdentifier"/></xsl:attribute>
		</Data>
		<Data name="Status" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strLockedPhysicalDisks"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLockedPhysicalDisks"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strBlankPassphrase"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strBlankPassphrase"/></xsl:attribute>
		</Data>
	</xsl:template>	

	<xsl:template name="SecurityKeyIdentifiersRows">
		<Row>  
                  <Data name="SecurityKeyId" type="radio" event="onclick" handler="OnKeyIDSelected()">
                  	<xsl:attribute name="value"><xsl:call-template name="ReplaceKey"><xsl:with-param name="KeyId" select="SecurityKeyId"/></xsl:call-template></xsl:attribute>
                        <xsl:attribute name="returnvalue"><xsl:call-template name="ReplaceKey"><xsl:with-param name="KeyId" select="SecurityKeyId"/></xsl:call-template></xsl:attribute>
  	    	      </Data>
		    	<Data editable="false" type="ustring">
				<xsl:attribute name="value"><xsl:value-of select="DIDList"/></xsl:attribute>
		    	</Data>
		    	<Data type="password" maxlength="32" size="32" align="left">
                  	<xsl:attribute name="name">Passphrase_<xsl:call-template name="ReplaceKey"><xsl:with-param name="KeyId" select="SecurityKeyId"/></xsl:call-template></xsl:attribute>
                	</Data>
         	</Row>
	</xsl:template>
</xsl:stylesheet>	


