<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Enclosure Information page.  The associated web plugin is the EnclosureInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:include href="emmtbl.xsl"/>
	<xsl:include href="Utils.xsl"/>
	<xsl:template match="OMA">
		<DataArea backpagetarget="./DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin">
			<PageTitle>
				<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="Name"/><xsl:value-of select="$strTitle1Part2"/></xsl:attribute>
			</PageTitle>

			<xsl:variable name="displayEMMWarn">
				<xsl:for-each select="EMM/DCStorageObject">
					<xsl:choose>
						<xsl:when test="ObjState = '32' and ObjStatus = '3'">yes,</xsl:when>
						<xsl:otherwise>no,</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:variable>

			<xsl:if test="not(contains($displayEMMWarn, 'no'))">
				<!--PromptText alert="true">
					<xsl:value-of select="$strFWMismatchMsg"/>
				</PromptText-->	
				<AlertMessage>
				  <xsl:attribute name="display"><xsl:value-of select="$strFWMismatchMsg"/></xsl:attribute>
				</AlertMessage>
			</xsl:if>

			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.EMMInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;EnclosureOID=<xsl:value-of select="EnclosureOID"/>&amp;help=emmprin</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:call-template name="EMMTable"/>
		</DataArea>
	</xsl:template>
	<xsl:template name="EMMTable">
		<!-- DISPLAY THE EMM INFORMATION IN A TABLE FORMAT-->
		<TableData columnspacing="true">
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/></xsl:attribute>
			</SubHeader>
			<xsl:choose>
				<xsl:when test="count(EMM/DCStorageObject)>0">
					<Header>
						<xsl:call-template name="EMMTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="EMM/DCStorageObject">
						<xsl:sort select="Index" data-type="number" order="ascending"/>
						<xsl:call-template name="EMMTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
			</xsl:choose>
		</TableData>
	</xsl:template>
</xsl:stylesheet>
