<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:import href="Utils.xsl"/>
<xsl:output method="xml"/>
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">

<DataArea exportdata="false" onLoad="true">
       <xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
       <xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/OrigURL"/></xsl:call-template></xsl:attribute>
	   
	    <xsl:call-template name="scripts"/>
		<script language="javascript">
		   function initializationRoutine()
	        { 
		        document.getElementById("ClientCertificateSettings").checked=false;
			  document.getElementById("ServerCertificateSettings").checked=true;
		   }
		   function OnCreareSelfSignedSelected()
		   {  
		      if(document.getElementById("CreateSelfSigned").checked == true)
			  { 
			    document.getElementById("ClientUploadCertificate").checked=false;
                      document.getElementById("ViewClientCertificate").checked=false;

		      }
		   }
               function OnClientuploadSelected()
		   {  
		      if(document.getElementById("ClientUploadCertificate").checked == true)
			  {
			    document.getElementById("CreateSelfSigned").checked=false;
                      document.getElementById("ViewClientCertificate").checked=false;
			  }
		   }

		   function ViewClientSelected()
		   {  
		      if(document.getElementById("ViewClientCertificate").checked == true)
			  {
			    document.getElementById("CreateSelfSigned").checked=false;
                      document.getElementById("ClientUploadCertificate").checked=false;
 
			  }
		   }
		   
		   function SubmitSelection()
		   {
		    	 
		     if(document.getElementById("CreateSelfSigned").checked == true)
			 {
			   document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CreateSelfSignedCertificateSettingsWebPlugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			 }
                   if(document.getElementById("ClientUploadCertificate").checked == true)
			 {
			   document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.UploadCertificateSettingsWebPlugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			 }
                   if(document.getElementById("ViewClientCertificate").checked == true)
			 {
			   document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ViewCertificateSettingsWebPlugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			 }

  
		   }
		   
		</script>
	   <PageTitle>
               <xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/></xsl:attribute>
       </PageTitle>
	   <BottomCustomButton>
			<Data formSubmit="true" display="{$strContinue}" href="javascript:SubmitSelection() "/>
		</BottomCustomButton>
	   <xsl:call-template name="CertificateOptionRows"/>
</DataArea>
        
</xsl:template>
 <xsl:template name="CertificateOptionRows">
    <TableData name="T4" ignoreJumpbar="true">
	   <Header>
	      <Data name="Options" editable="false" type="ustring" align="left">
				   <xsl:attribute name="value"><xsl:value-of select="$strOptions"/></xsl:attribute>
		  </Data>
	   </Header>
		<Row>  
           <Data name="CreateSelfSigned" type="radio" event="onclick" handler="OnCreareSelfSignedSelected()" state="0">
             	<xsl:attribute name="value"><xsl:value-of select="$strCreateSelfSigned"/></xsl:attribute>
				<xsl:attribute name="returnvalue"/>
  	       </Data>
	    </Row>
		<Row>  
           <Data name="ClientUploadCertificate" type="radio" event="onclick" handler="OnClientuploadSelected()" state="0">
             	<xsl:attribute name="value"><xsl:value-of select="$strClientUploadCertificate"/></xsl:attribute>
				<xsl:attribute name="returnvalue"/>
  	       </Data>
	    </Row>
          <Row>
          <Data name="ViewClientCertificate" type="radio" event="onclick" handler="ViewClientSelected()" state="0">
             	<xsl:attribute name="value"><xsl:value-of select="$strViewClientCertificate"/></xsl:attribute>
				<xsl:attribute name="returnvalue"/>
  	       </Data>
	   </Row>

	</TableData>
 </xsl:template>
</xsl:stylesheet>

