<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<!--main entry point into this XSL-->

	<!-- Declare a bunch of Global variables and params-->
	<xsl:variable name="GLOBAL_VAR_PercVersion">
		<xsl:choose>
			  <xsl:when test="substring(//Controllers/DCStorageObject/AttributesMask1,24,1)='1'">9</xsl:when>
			  <xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_SpanLengthList"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/SpanLengthList"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_SpanDepth"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/SpanDepth"/></xsl:variable>
	<xsl:variable name="VdPIEnabled"><xsl:value-of select="/OMA/VdPIEnabled"/></xsl:variable>
	
	<xsl:variable name="GLOBAL_VAR_IsVdiskNameFieldAllowedForSelectedLayout">
		<xsl:call-template name="bitAnd">
			<xsl:with-param name="num1">
				<xsl:choose>
					<xsl:when test="not(//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask)">
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="//Controllers//DCStorageObject/RAIDLevelsMask"/></xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="num2" select="$PARAM_PREV_Layout"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ReturnUrlHREFValue">
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules='1'">./DSASwitch</xsl:when>
			<!-- %26 is escape character for &-->
			<xsl:otherwise><xsl:value-of select="/OMA/OrigURL"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_GetCapsSMStatus">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/SMStatus"><xsl:value-of select="/OMA/ExpressResults/SMStatus"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="PARAM_DSA_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_DSARaidModeAndDiskCheck">
		<xsl:choose>
			<xsl:when test="/OMA/DSARaidModeAndDiskCheck">
				<xsl:value-of select="/OMA/DSARaidModeAndDiskCheck"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        
	<xsl:variable name="GLOBAL_VAR_ProtocolVal">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/BusProtocolMask">
				<xsl:value-of select="/OMA/ExpressResults/DCStorageObject/BusProtocolMask"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        
	<xsl:variable name="PARAM_DSA_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="PARAM_DSA_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_FILE"><xsl:value-of select="/OMA/FILE"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
    <xsl:variable name="GLOBAL_VAR_RaidLevelsMask"><xsl:value-of select="//Controllers//DCStorageObject/RAIDLevelsMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_DefaultReadPolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultReadPolicy"/>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_Decimal_Read_Policy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultReadPolicy"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_DefaultWritePolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultWritePolicy"/>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_Decimal_Write_Policy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultWritePolicy"/>
      </xsl:call-template>
    </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ReadPolicyMask">
              <xsl:choose>
			<xsl:when test="/OMA/ExpressResults/PassThruResponse/DCStorageObject/ReadPolicy != ''">
      		           <xsl:call-template name="GetReadPolicyMask">
		             <xsl:with-param name="readpolicy"><xsl:value-of select="/OMA/ExpressResults/PassThruResponse/DCStorageObject/ReadPolicy"/></xsl:with-param>
                           </xsl:call-template>  
			</xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="//Controllers//DCStorageObject/ReadPolicyMask"/>
                        </xsl:otherwise>
              </xsl:choose>
        </xsl:variable>
	<xsl:variable name="GLOBAL_VAR_WritePolicyMask">
             <xsl:choose>
	 	  <xsl:when test="/OMA/ExpressResults/PassThruResponse/DCStorageObject/WritePolicy != ''">
     		       <xsl:call-template name="GetWritePolicyMask">
			   <xsl:with-param name="writepolicy"><xsl:value-of select="/OMA/ExpressResults/PassThruResponse/DCStorageObject/WritePolicy"/></xsl:with-param>
                       </xsl:call-template>  
 		  </xsl:when>
                  <xsl:otherwise>
                          <xsl:value-of select="//Controllers//DCStorageObject/WritePolicyMask"/>
                  </xsl:otherwise>
              </xsl:choose>
          </xsl:variable>
  	  <xsl:variable name="GLOBAL_VAR_CachePolicyMask"><xsl:value-of select="//Controllers//DCStorageObject/CachePolicyMask"/></xsl:variable>
          <xsl:variable name="GLOBAL_VAR_DiskCachePolicyMask"><xsl:value-of select="//Controllers//DCStorageObject/DiskCachePolicyMask"/></xsl:variable>
          <xsl:variable name="GLOBAL_PARAM_CntrlAttributesMask" select="/OMA/Controllers/DCStorageObject/AttributesMask"/> 
          <xsl:variable name="GLOBAL_VAR_IsStripeSizeFieldAllowedForSelectedLayout">
		<!-- fix for DFCT 117335-->
		<xsl:call-template name="bitAnd">
			<xsl:with-param name="num1">
				<xsl:choose>
					<xsl:when test="not(//Controllers//DCStorageObject/StripeSizeForRaidLevelMask)">
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="//Controllers//DCStorageObject/StripeSizeForRaidLevelMask"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="num2" select="$PARAM_PREV_Layout"/>
		</xsl:call-template>	
	</xsl:variable>
        <xsl:variable name="GLOBAL_VAR_MaxVirtualDiskNameLength"><xsl:value-of select="//Controllers//DCStorageObject/MaxNameLength"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_StripeSizesMask"><xsl:value-of select="//Controllers//DCStorageObject/StripeSizesMask"/></xsl:variable>
        
        

	<xsl:variable name="PARAM_SPANEDITMODE"><xsl:value-of select="/OMA/SpanEditMode"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_Length">
		<xsl:choose>
			<xsl:when test="$PARAM_SPANEDITMODE = 'true'">
				<xsl:value-of select="/OMA/ExpressResults/DCStorageObject/Length"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="/OMA/Length"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="PARAM_PREV_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_IDList"><xsl:value-of select="/OMA/IDList"/></xsl:variable>
        <xsl:variable name="PARAM_PREV_IMIDList"><xsl:value-of select="/OMA/IMIDList"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_SpanLength"><xsl:value-of select="/OMA/SpanLength"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_DiskProtocol"><xsl:value-of select="/OMA/DiskProtocol"/></xsl:variable>

	<xsl:variable name="PARAM_PREV_ReadPolicy">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/ReadPolicy != ''">
				<xsl:value-of select="/OMA/ExpressResults/DCStorageObject/ReadPolicy"/>
			</xsl:when>
			<xsl:otherwise>
        <xsl:value-of select="/OMA/ReadPolicy"/>
      </xsl:otherwise>
		</xsl:choose>
  </xsl:variable>

	<xsl:variable name="PARAM_PREV_WritePolicy">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/WritePolicy != ''">
				<xsl:value-of select="/OMA/ExpressResults/DCStorageObject/WritePolicy"/>
			</xsl:when>
			<xsl:otherwise>
        <xsl:value-of select="/OMA/WritePolicy"/>
      </xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="PARAM_PREV_CachePolicy"><xsl:value-of select="/OMA/CachePolicy"/></xsl:variable>
        <xsl:variable name="PARAM_PREV_DiskCachePolicy"><xsl:value-of select="/OMA/DiskCachePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_StripeSize"><xsl:value-of select="/OMA/StripeSize"/></xsl:variable>

	<xsl:variable name="PARAM_SPANMODE_DiskProtocol">
		<xsl:choose>
			<xsl:when test="$PARAM_PREV_DiskProtocol = '' or $PARAM_PREV_DiskProtocol = '0'">
				<xsl:value-of select="/OMA/SpanEditDiskProtocol"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>
			</xsl:otherwise>
		</xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="PARAM_STATE_UserSelectedAdiskArrayNumList"><xsl:value-of select="/OMA/UserSelectedAdiskArrayNumList"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"><xsl:value-of select="/OMA/UserSelectedAdiskContiguousFreeSpaceList"/>
</xsl:variable>
	<xsl:variable name="DSA_PARAMS">Rules=<xsl:value-of select="$PARAM_DSA_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$PARAM_DSA_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$PARAM_DSA_OutputFileName"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$PARAM_IsAnyAdiskForeign"/>&amp;DSARaidModeAndDiskCheck=<xsl:value-of select="$PARAM_DSARaidModeAndDiskCheck"/></xsl:variable>
	<xsl:variable name="REGULAR_PARAMS">ControllerOID=<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$PARAM_REGULAR_ControllerName"/>&amp;FILE=<xsl:value-of select="$PARAM_REGULAR_FILE"/>&amp;Minosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="CACHED_PARAMS">Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;IDList=<xsl:value-of select="$PARAM_PREV_IDList"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;Length=<xsl:value-of select="$PARAM_PREV_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_PREV_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_PREV_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_PREV_CachePolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_PREV_DiskCachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_PREV_StripeSize"/>&amp;IMIDList=<xsl:value-of select="$PARAM_PREV_IMIDList"/></xsl:variable>
	<xsl:variable name="STATE_PARAMS">UserSelectedAdiskArrayNumList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskArrayNumList"/>&amp;UserSelectedAdiskContiguousFreeSpaceList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_UseMaxSize"><xsl:value-of select="/OMA/UseMaxSize"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_IM"><xsl:value-of select="/OMA/IntMirror"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_SELECTALL"><xsl:value-of select="/OMA/SelectAll"/></xsl:variable>
      <xsl:variable name="PARAM_CURR_ENCLOSURESELECTEDLIST"><xsl:value-of select="/OMA/EnclosureSelectedList"/></xsl:variable>
      <xsl:variable name="PARAM_CURR_ENCLOSUREDISABLEDLIST"><xsl:value-of select="/OMA/EnclosureDisabledList"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Screen_Name">cvdasum_<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>_<xsl:value-of select="$PARAM_PREV_Layout"/>_<xsl:value-of select="$PARAM_PREV_IDList"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Prev_Page_URL">./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;Length=<xsl:value-of select="$PARAM_PREV_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_PREV_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_PREV_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_PREV_CachePolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_PREV_DiskCachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_PREV_StripeSize"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;UseCachedXMLData=true&amp;IntMirror=<xsl:value-of select="$PARAM_CURR_IM"/>&amp;SelectAllVal=<xsl:value-of select="$PARAM_CURR_SELECTALL"/>&amp;EnclosureSelectedList=<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>&amp;EnclosureDisabledList=<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Next_Page_URL">./SubmitForm?plugin=com.dell.sm.webplugins.SubmitCreateVDAdvancedSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;Length=<xsl:value-of select="$PARAM_PREV_Length"/>&amp;URL=<xsl:value-of select="$GLOBAL_VAR_ReturnUrlHREFValue"/>&amp;PercVersion=<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>&amp;SpanLengthList=<xsl:value-of select="$GLOBAL_VAR_SpanLengthList"/>&amp;SpanDepth=<xsl:value-of select="$GLOBAL_VAR_SpanDepth"/>&amp;VdPIEnabled=<xsl:value-of select="$VdPIEnabled"/>&amp;IMStatus=<xsl:value-of select="$IMStatus"/>&amp;Force=1</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules='1'">./DSASwitch?exitRAID=1&amp;IsFromAdvanced=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($PARAM_REGULAR_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        <xsl:variable name="GLOBAL_VAR_NUMBEROFENCLOSURELIST"><xsl:value-of select="count(/OMA/DHSAvailDisks/ArrayDisks)"/></xsl:variable>
		<!-- 24 Number is used to identify the count of Physical Disk of an enclosue is Zero. -->
        <xsl:variable name="GLOBAL_VAR_NumberofDisksonEnclosureOnZero">
            <xsl:choose>
                <xsl:when test="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='0' and Channel='0'])='0'">32</xsl:when>
                <xsl:otherwise><xsl:value-of select="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='0' and Channel='0'])"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_NumberofDisksonEnclosureOnOne">
            <xsl:choose>
                <xsl:when test="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='1' and Channel='0'])='0'">32</xsl:when>
                <xsl:otherwise><xsl:value-of select="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='1' and Channel='0'])"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_NumberofDisksonEnclosureOnTwo">
            <xsl:choose>
                <xsl:when test="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='2' and Channel='0'])='0'">32</xsl:when>
                <xsl:otherwise><xsl:value-of select="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='2' and Channel='0'])"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_NumberofDisksonEnclosureOnThree">
            <xsl:choose>
                <xsl:when test="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='0' and Channel='1'])='0'">32</xsl:when>
                <xsl:otherwise><xsl:value-of select="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='0' and Channel='1'])"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_NumberofDisksonEnclosureOnFour">
            <xsl:choose>
                <xsl:when test="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='1' and Channel='1'])='0'">32</xsl:when>
                <xsl:otherwise><xsl:value-of select="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='1' and Channel='1'])"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_NumberofDisksonEnclosureOnFive">
            <xsl:choose>
                <xsl:when test="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='2' and Channel='1'])='0'">32</xsl:when>
                <xsl:otherwise><xsl:value-of select="count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject[EnclosureID='2' and Channel='1'])"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
               
        <xsl:variable name="GLOBAL_VAR_Temp1NumberofDisksonEnclosure">
		<xsl:choose>
			<xsl:when test="($GLOBAL_VAR_NumberofDisksonEnclosureOnZero &lt; $GLOBAL_VAR_NumberofDisksonEnclosureOnTwo) and ($GLOBAL_VAR_NumberofDisksonEnclosureOnZero &lt; $GLOBAL_VAR_NumberofDisksonEnclosureOnOne)">
				<xsl:value-of select="$GLOBAL_VAR_NumberofDisksonEnclosureOnZero"/>
			</xsl:when>
			<xsl:when test="($GLOBAL_VAR_NumberofDisksonEnclosureOnTwo &lt;= $GLOBAL_VAR_NumberofDisksonEnclosureOnOne)">
				<xsl:value-of select="$GLOBAL_VAR_NumberofDisksonEnclosureOnTwo"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$GLOBAL_VAR_NumberofDisksonEnclosureOnOne"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        <xsl:variable name="GLOBAL_VAR_Temp2NumberofDisksonEnclosure">
		<xsl:choose>
			<xsl:when test="($GLOBAL_VAR_NumberofDisksonEnclosureOnThree &lt; $GLOBAL_VAR_NumberofDisksonEnclosureOnFive) and ($GLOBAL_VAR_NumberofDisksonEnclosureOnThree &lt; $GLOBAL_VAR_NumberofDisksonEnclosureOnFour)">
				<xsl:value-of select="$GLOBAL_VAR_NumberofDisksonEnclosureOnThree"/>
			</xsl:when>
			<xsl:when test="($GLOBAL_VAR_NumberofDisksonEnclosureOnFive &lt;= $GLOBAL_VAR_NumberofDisksonEnclosureOnFour)">
				<xsl:value-of select="$GLOBAL_VAR_NumberofDisksonEnclosureOnFive"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$GLOBAL_VAR_NumberofDisksonEnclosureOnFour"/>
			</xsl:otherwise>
        </xsl:choose>
	</xsl:variable>
        <xsl:variable name="Global_Var_Min_Disks_on_any_Enclosure">
               <xsl:choose>
                   <xsl:when test="$GLOBAL_VAR_Temp1NumberofDisksonEnclosure &lt; $GLOBAL_VAR_Temp2NumberofDisksonEnclosure">
				      <xsl:choose>
					     <xsl:when test="$GLOBAL_VAR_Temp1NumberofDisksonEnclosure &lt;='16'">
                            <xsl:value-of select="$GLOBAL_VAR_Temp1NumberofDisksonEnclosure"/>
						 </xsl:when>
						 <xsl:otherwise>16</xsl:otherwise>
					  </xsl:choose>	 
                   </xsl:when>
                   <xsl:otherwise>
				       <xsl:choose>
					      <xsl:when test="$GLOBAL_VAR_Temp2NumberofDisksonEnclosure &lt;='16'">
                             <xsl:value-of select="$GLOBAL_VAR_Temp2NumberofDisksonEnclosure"/>
					      </xsl:when>
						  <xsl:otherwise>16</xsl:otherwise>
					  </xsl:choose>	 
                   </xsl:otherwise>
               </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="Global_Var_Enclosure">
        
             <xsl:choose>
                    <xsl:when test="$Global_Var_Min_Disks_on_any_Enclosure &lt; floor(16 div $GLOBAL_VAR_NUMBEROFENCLOSURELIST)">
                       <xsl:value-of select="$Global_Var_Min_Disks_on_any_Enclosure"/>
                   </xsl:when>
                   <xsl:otherwise>
                       <xsl:value-of select="floor(16 div $GLOBAL_VAR_NUMBEROFENCLOSURELIST)"/>
                   </xsl:otherwise>
             </xsl:choose>      
        
        </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_EnhanceDHSMask" select="/OMA/Controllers/DCStorageObject/AttributesMask"/>
        <xsl:variable name="GLOBAL_VAR_SHOW_NAME_SUMMARY_ROW">
            <xsl:choose>
                    <xsl:when test="($PARAM_DSA_Rules != '1' and not(//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask)) or $GLOBAL_VAR_IsVdiskNameFieldAllowedForSelectedLayout = '1'">true</xsl:when>
                    <xsl:otherwise>false</xsl:otherwise>
            </xsl:choose>      
         </xsl:variable>
          <xsl:variable name="GLOBAL_VAR_GetCapsMinLength"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/MinimumLength"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_GetCapsMaxLength"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/Length"/></xsl:variable>
        <xsl:variable name="GLOBAL_PARAM_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Oslimit"><xsl:value-of select="//Controllers//DCStorageObject/MaxOsLimitForLogicalDriveSize"/></xsl:variable>

        
	<xsl:variable name="IMStatus">
        <xsl:choose>	
            <xsl:when test="$PARAM_CURR_IM = 'true'">1</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>    
	<xsl:template match="/">
		<!-- This page is rendered under two scenarios-->
		<!-- Page Load Scenario One: Page is loaded for first time.-->
		<!-- Page Load Scenario Two: Page is loaded when user does some selection on current page, goes back to a previous pages on wizard and then returns to current page-->
		<!-- Page error scenarios-->
		<!-- Error scenario One:
			Detection: User selected array disks do not belong to same disk group./User selected arraydisks do not have any free space.
						/User selected size not available on selected array disks - These errors will not be handled on this page.
			Cause: Free array disks unavailable to create any raid layout.
			User Scenario when this occurs: Can happen during  the two "Page Load Scenarios". Another user either thru CLI or browser could have used up all or some
			array disk space by the time current page is loaded -->
		<!-- When user comes to this page using "back button" on wizard, the variable below determines whether adisks selected by user is still valid-->
		<!-- Next render page depending if there is an error or not.-->
		<xsl:choose>
		<!--Devendra 7/20/06: CR12532-->
			<xsl:when test="$GLOBAL_VAR_GetCapsSMStatus = '-1' or //SMStatus = '-1' ">
				<DataArea exportdata="false" email="false" printable="false">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitleCfgChngDetectCVDAS"/></xsl:attribute>
					</PageTitle>
					<AlertMessage><xsl:attribute name="display"><xsl:value-of select="$strTitleFreeDisksUnavailableCVDAS"/></xsl:attribute></AlertMessage>
					<AlertMessage><xsl:attribute name="display"><xsl:value-of select="$strRaidSelectionInvalidCVDAS"/></xsl:attribute></AlertMessage>
                    <AlertMessage><xsl:attribute name="display"><xsl:value-of select="$strIMNotSupported"/></xsl:attribute></AlertMessage>
					<BottomCustomButton>
						<Data formSubmit="true">
							<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDAS"/></xsl:attribute>
							<xsl:attribute name="href"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
						</Data>
					</BottomCustomButton>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="OMA"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/OMA">
		<DataArea onLoad="true" nosubmitfordsa="true" validate="true" exportdata="false" email="false" printable="false" ignoreJumpBar="true">
			<!--Devendra 7/20/06: CR12532-->
                        
			<xsl:if test="$PARAM_DSA_Rules != '1'">
				<xsl:attribute name="cancel">true</xsl:attribute>
				<xsl:attribute name="canceltarget"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
				<xsl:attribute name="canceldisplay"><xsl:value-of select="$strCancelCVDAS"/></xsl:attribute>

				<xsl:attribute name="backpagedisplayfull"><xsl:choose><xsl:when test="$PARAM_SPANEDITMODE = 'true'"><xsl:value-of select="$strBackToCVDSizePage"/></xsl:when><xsl:otherwise><xsl:value-of select="$strBackPageButton"/></xsl:otherwise></xsl:choose></xsl:attribute>

				<xsl:attribute name="backpagetarget">javascript:BackPage()</xsl:attribute>
				<xsl:attribute name="submitdisplay"><xsl:value-of select="$strFinishCVDAS"/></xsl:attribute>
				<xsl:attribute name="submit"></xsl:attribute>
			</xsl:if>
                        
			<!--Devendra 7/20/06: CR12532-->
			<xsl:if test="$PARAM_DSA_Rules = '1'">
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
				<xsl:attribute name="custombackpagedisplay"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">javascript:goToPreviousPageInDSA();</xsl:attribute>
				<BottomCustomButton>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strContinueCVDAS"/></xsl:attribute>
						<xsl:attribute name="href">javascript:submitCreateVDAdvancedSummary();</xsl:attribute>
						<!-- DF111388 : Prevent DSA from disabling buttons on submit. We will do it ourselves if validation returns true. -->
						<xsl:attribute name="disablerestrictmulcall">true</xsl:attribute>
					</Data>
				</BottomCustomButton>
				<BottomCustomButton>
					<Data formSubmit="true">
						<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDAS"/></xsl:attribute>
						<xsl:attribute name="href">javascript:exitWizardInDSA();</xsl:attribute>
					</Data>
				</BottomCustomButton>
			</xsl:if>
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">IDList</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="$PARAM_PREV_IDList"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  

                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">IMIDList</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="$PARAM_PREV_IMIDList"/></xsl:attribute>
				</Data>
			</HiddenTable>
                
                   <HiddenTable>
				<Data>
					<xsl:attribute name="name">SingleSpanVD</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/SingleSpanVD"/></xsl:attribute>
				</Data>
			</HiddenTable>
                         <HiddenTable>
				<Data>
					<xsl:attribute name="name">CreateSecureVD</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/SecureVD"/></xsl:attribute>
				</Data>
			</HiddenTable>
                   
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">AdvancedWizard</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/AdvancedWizard"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                  <HiddenTable>
				<Data>
					<xsl:attribute name="name">ExpressWizard</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/ExpressWizard"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                  <HiddenTable>
				<Data>
					<xsl:attribute name="name">MediaType</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/MediaType"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                     <HiddenTable>
				<Data>
					<xsl:attribute name="name">BusProtocol</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/BusProtocol"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                   


			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:if test="$PARAM_DSA_Rules='1'">
					<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Prev_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Next_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
                                <xsl:call-template name="getScriptsForAdvanced"/>
			</script>

			<xsl:variable name="warnDHSMsg">
				<xsl:choose>
					<xsl:when test="($PARAM_PREV_Layout != '2') and (substring(/OMA/Controllers/DCStorageObject/AttributesMask,5,1) != '1') and (count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject) != 0)">yes</xsl:when>
					<xsl:otherwise>no</xsl:otherwise>
				</xsl:choose>				
			</xsl:variable>

			<script language="javascript">
                var JS_GLOBAL_MaxNumChannels=2;
				var JS_GLOBAL_MaxNumEnclosures = 4;
				var JS_GLOBAL_MaxNumTargets=32;
				var JS_GLOBAL_LayoutValue=<xsl:value-of select="$PARAM_PREV_Layout"/>;
                var ArrayDisks_Counter = 0;
                var enhanceDHSMask = "<xsl:value-of select="substring($GLOBAL_VAR_EnhanceDHSMask,10,1)"/>";
				function initializationRoutine() {
                                
                                 var minSizeInGB ="<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMinLength div (1024*1024*1024)),'###0.00')"/>";
						var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
						setValueForMinField(minSizeInGB );
						setValueForMaxField(maxSizeInGB );
						setInputVDSizeValue(maxSizeInGB );
						enableInputVDSizeField();  
                                
                    hideSelectionTable();
					<!-- DSA uses different function to append VID -->
					var rules = "<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (rules == "1")
					{
						top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
					}
                    if(document.getElementById("DiskPerEnclosure")!=null){
                    <!-- need to change this during implementation of caching for multiple DHS-->
                    document.getElementById("DiskPerEnclosure").disabled=false;
                    document.getElementById("NumberOfDisk").disabled=true; 
                    }
                    <!--get the first channel that has enclosure attached to it-->
				    var channelNum = getDefaultChannelSelectionRadioButtonIndex();
				    <!--show selection table with array disks attached to default channel identified-->
				    if(channelNum!=-1) 
                    {
					       showSelectionTable(channelNum);
                    }
				
				    <!--Below set the default channel selection radio button-->
				    setDefaultChannelSelectionRadioButton();

				    <!--Below disable the Channel radio buttons that do not contain ArrayDisks-->
				    disableChannelSelectionRadioButtonsWithNoArrayDisks();
                                
				}
				<!--
					CR69634 : Only one hotspare can be assigned at a time so checkboxes should allow only one to be
					checked at a time. -->
                                  
				function toggleUncheckedCheckboxes(checkbox)
				{
					var i = 0;
					var element;

					while (element = checkbox.form[i++])
					{
						if (element.type == "checkbox")
						{
							if (element != checkbox)
							{
								if (checkbox.checked == true)
								{
									element.disabled = true;
								}
								else
								{
									element.disabled = false;
								}
							}
						}
					}
				}
				function validate()
				{
					var rules = "<xsl:value-of select="$PARAM_DSA_Rules"/>";
					var dsaWarnMsg = "<xsl:value-of select="$strDSAWarnVdisksWillBeLostCVDAS"/>";
				<!-- AS: DF54548: Update pop-up mesg to indicate clearing the foreign configuration    -->
					var frgnFlag="<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>";
					var frgnconfigWarnMsg = "<xsl:value-of select="$strDSAWarnVdisksFrgnDriveWillBeLostCVDAS"/>";
                                        
                                         if(ValidateInputs()==false)
                                          {     var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
							  document.getElementById(getElementNameForVDSize()).value=maxSizeInGB ;



                                             return false;
                                         } 
					if (frgnFlag=="1")
					{
						if(rules=="1" &amp;&amp; !confirm(frgnconfigWarnMsg))
							return false;
					}
					else
					{
						if(rules=="1" &amp;&amp; !confirm(dsaWarnMsg))
							return false;
					}
					<!-- if( rules=="1" &amp;&amp; !confirm(dsaWarnMsg))
						return false; -->
					<!-- :Chethan 06/10/04 Fixed defect DFCT 129664: We are already displaying a pop-up message saying all the existing
					virtual disks will be deleted. We don't need an additional pop-up message-->
					<!--var isRaidIM = "<xsl:call-template name="IsRaidIntegratedMirror"><xsl:with-param name="AttributesMask" select="/OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:call-template>";
					var msg = "<xsl:value-of select="$strConfirmMsgForIMCreation"/>";
					if(isRaidIM==1 &amp;&amp; !confirm(msg)) if PERC 4 IM controller and user says no to reboot, return false
						return false;-->

					document.dataarea.action = top.gnv.appendVID("<xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/>" + "&amp;VDSize="+getVDSize());
						if ('<xsl:value-of select="$warnDHSMsg"/>' == 'yes')
					   {
                                             if((enhanceDHSMask == '1' &amp;&amp; getHSDIDList() == '' ) || (enhanceDHSMask != '1' &amp;&amp;(document.getElementById("HSDIDList") == null || document.getElementById("HSDIDList").checked == false)))
											 {
						                        return confirm("<xsl:value-of select="$strDHSNotAssignMsg"/>");
                                             } 
					   }
						 
					
					
					if( rules!="1") {
						disableButtons("submit","back" ,"cancel");
					} else {
						<!-- DF111388 : Disable buttons when validation is successful. -->
						setDisableFlag();
						disableSubmitButton()
					}

					return true;
				}
	    function getHSDIDList() {
                                
             var selectedHSDIDList = "";
             var counter =0;
             var resval="";
             for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
	     {
		 for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
		 {
			for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
			{
                              var elemName="Sel"+i.toString()+k.toString()+j.toString();
                              if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).checked == true)
                              {
                                  resval = document.getElementById(elemName).value;
                                  if(counter == 0)
	                          {
                                      selectedHSDIDList = resval;
				  }
                                  else
				  {
                                      selectedHSDIDList = selectedHSDIDList + ":"+resval;
			          }
				  counter++;
                               }
                          }
                   }
                }
                document.getElementById("HSDIDList").value = selectedHSDIDList;
                return selectedHSDIDList;
            }
            function ValidateInputs()
                                {
                                
                                   if(IsInputSizeForVDSpecified()==false)
					{
						HandleInputSizeNotSpecifiedError();
						RestoreInputSizeFieldToMaxValueInAdvWizard();
						return false;
					}
					if(IsInputSizeForVDNaN()==true)
					{
						HandleInputSizeNotANumberError();
						RestoreInputSizeFieldToMaxValueInAdvWizard();
						return false;
					}
					if(IsInputSizeForVDWithinRangeForAdvanced()==false)
					{
						HandleInputSizeRangeErrorForAdvanced();
						return false;
					}
                                       
					if( isValidNameValue(getInputVDNameValue())==false)
					{
						RestoreInputNameFieldToBlank();
						return false;
					}
					if ( HandleInputSizeGreaterThanOsLimitAdvanced() == false )
					{
						return false;
					}
                                        
					return true;
                                }
                                 function isValidNameValue(text)
			        {
				var validchars = /^[a-zA-Z0-9_ -]*$/;
				if( validchars.test(text))
				{

					// cannot start or end with a space.
					if(/^ /.test(text) || / $/.test(text))
					{
					   alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strStartSpace"/>");
					   return false
					}

					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidString"/>");
				return false;
			       }
                                function IsInputSizeForVDWithinRangeForAdvanced()
				{
					//var layoutValue = '<xsl:value-of select="$GLOBAL_PARAM_Layout"/>';
					
					var sizeValue=getInputVDSizeValue();
					
                                        //var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					//var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					
                                        var minSizeInGB ="<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMinLength div (1024*1024*1024)),'###0.00')"/>";
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					
					var sizeValueDecFormat =   parseFloat(ConvertToDecValString(sizeValue));
					var minSizeInGBDecFormat = parseFloat(ConvertToDecValString(minSizeInGB));
					var maxSizeInGBDecFormat = parseFloat(ConvertToDecValString(maxSizeInGB));
					
                                       
					<!--if(minSizeInBytes == maxSizeInBytes || maxSizeInGBDecFormat  == sizeValueDecFormat )
					{
                                                document.getElementById(getElementNameForVDSize()).value = maxSizeInBytes; //parseInt(sizeValueDecFormat *1024*1024*1024);
						return true;
					}
					else --> 
					if( minSizeInGBDecFormat &lt;= sizeValueDecFormat  &amp;&amp; sizeValueDecFormat  &lt;= maxSizeInGBDecFormat )
					{
						//document.getElementById(getElementNameForVDSize()).value = parseInt(sizeValueDecFormat *1024*1024*1024);
                                                return true;
					}
					else
					{
						return false;
					}
				}
                                function RestoreInputSizeFieldToMaxValueInAdvWizard()
				{
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					document.getElementById(getElementNameForVDSize()).value=maxSizeInGB ;
				}
                                
                                function HandleInputSizeRangeErrorForAdvanced()
				{
					var alertInvalidSizeMsg = "<xsl:value-of select="$strInvalidSizeCVDASS"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + alertInvalidSizeMsg);
					<!-- Next reset value of size field to max size value-->
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					document.getElementById(getElementNameForVDSize()).value=maxSizeInGB ;
				}
                                
                                function HandleInputSizeGreaterThanOsLimitAdvanced()
				{
					var sizeValue = getInputVDSizeValue();
					var osLimitValueinGB = "<xsl:value-of select="format-number($GLOBAL_PARAM_Oslimit div (1024*1024*1024), '###0.00')"/>";
					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var osLimitValueDecFormat = parseFloat(ConvertToDecValString(osLimitValueinGB));

					if ( sizeValueDecFormat &gt; osLimitValueDecFormat)
					{
						<!-- This means that the virtual disk size is greater than the os limit-->
						if (confirm ("<xsl:value-of select="$strOsLimitWarn"/>"))
						{
							return true;
						}
						else
						{
							return false;
						}
					}
					else
					{
						return true; 
					}
				}
            function submitCreateVDAdvancedSummary() {
        cachePageInDSA();
         
        if (validate()) {
            document.dataarea.action = top.gnv.appendVID("<xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/>");
						document.dataarea.submit();
					}
				}
				
	

	
	function getVDSize() {
		var vdSize;
		var layoutValue = '<xsl:value-of select="$GLOBAL_PARAM_Layout"/>';
					
		var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
		var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
				
		var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";			
		var sizeValueDecFormat = parseFloat(ConvertToDecValString(getInputVDSizeValue()));			
		var maxSizeInGBDecFormat = parseFloat(ConvertToDecValString(maxSizeInGB));
				   
		if(minSizeInBytes == maxSizeInBytes || maxSizeInGBDecFormat  == sizeValueDecFormat )
		{
			vdSize = maxSizeInBytes; 				
		}else{
			vdSize = parseInt(sizeValueDecFormat *1024*1024*1024);
		}
		
		return vdSize;
	}
                                
       function submitSpanEditMode()
       {
         document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_SPANMODE_DiskProtocol"/>&amp;Length=<xsl:value-of select="$PARAM_PREV_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_PREV_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_PREV_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_PREV_CachePolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_PREV_DiskCachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_PREV_StripeSize"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;UseCachedXMLData=false&amp;IntMirror=<xsl:value-of select="$PARAM_CURR_IM"/>&amp;SelectAllVal=<xsl:value-of select="$PARAM_CURR_SELECTALL"/>&amp;SpanEditMode=true&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;EnclosureDisabledList=<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>&amp;EnclosureSelectedList=<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>&amp;SectorSize=<xsl:value-of select="/OMA/SectorSize"/>&amp;SecureVD=<xsl:value-of select="/OMA/SecureVD"/>&amp;PercVersion=<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>&amp;SpanDepth=<xsl:value-of select="$GLOBAL_VAR_SpanDepth"/>&amp;VdPIEnabled=<xsl:value-of select="$VdPIEnabled"/>");
	 document.dataarea.submit();
        
	}
        
        function BackPage() 
        {
          var SpanEditDiskProtocol='<xsl:value-of select="/OMA/SpanEditDiskProtocol"/>';
          document.getElementById("IMIDList").value = '<xsl:value-of select="/OMA/IMIDList"/>';
          
          document.getElementById("SingleSpanVD").value = '<xsl:value-of select="/OMA/SingleSpanVD"/>'; 
     	    document.getElementById("IDList").value = '<xsl:value-of select="$PARAM_PREV_IDList"/>';
          document.dataarea.action = top.gnv.appendVID("<xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/>"+"&amp;SpanEditDiskProtocol="+SpanEditDiskProtocol);

	    document.dataarea.submit();
	
	}
                                 
                                 <!--This function is a handler that is called in response to a channel selection-->
				 function OnChannelSelected()
				 {
					hideSelectionTable();
                                       	var EnclosureArray = document.getElementsByName("EnclosureSelected");
                                        var currEnclosureSelected = -1;
					var RadioArray = document.getElementsByName("ChannelButton");
					for(var i=0;i&lt;EnclosureArray.length;i++)
					{
						if(EnclosureArray[i].checked==true)
						{
							currEnclosureSelected = (EnclosureArray[i]).value;
							break;
						} 
					}
					if (currEnclosureSelected != -1)
					{
						for(var i=0;i&lt;EnclosureArray.length;i++)
						{
							EnclosureArray[i].checked=true;
						} 
					}

					for(var i=0;i&lt;RadioArray.length;i++)
					{
						if(RadioArray [i].checked)
						{
							showSelectionTable(i);
							break;
						}
					}
		                 }
                
                                 <!--This function hides all the rows in the selection table-->
				 function hideSelectionTable()
				 {
					var elemName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						if(document.getElementById("parentrow_"+"Sel"+i.toString())!=null)
						{
                                                       
							document.getElementById("parentrow_"+"Sel"+i.toString()).style.display="none";
						}
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							elemName = "parentrow_"+"Sel"+i.toString()+k.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none";
							}
							for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
							{
								elemName = "parentrow_"+"Sel"+i.toString()+k.toString()+j.toString();
								if(document.getElementById(elemName) != null)
								{
									document.getElementById(elemName).style.display="none";
								}
							}
						}
					}
				 }
                                
                                 <!--This funtion displays all the rows associated with channel 'i'-->
				 function showSelectionTable(i)
				 {
					for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					{
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{
							elemName="parentrow_"+"Sel"+i.toString()+k.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{        
								document.getElementById("parentrow_"+"Sel"+i.toString()+k.toString()).style.display="";
								document.getElementById("parentrow_"+"Sel"+i.toString()+k.toString()+j.toString()).style.display="";
							}
						}
					}
				 }
                                
			         <!--This function returns the index of the default channel selected from the array of channels-->
			         function getDefaultChannelSelectionRadioButtonIndex()
			         {
				         var RadioArray = document.getElementsByName("ChannelButton");
				         for(var i=0;i&lt;RadioArray.length;i++)
				         {			
					        for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					        {
						     var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
						     if(document.getElementById(elemName) != null)
						     {
							return i;
						     }
					       }
				        }
				        return -1;<!--failure-->
			         }
                   
			         <!--This function selects and sets the default channel-->
			         function setDefaultChannelSelectionRadioButton()
			         {
				           var found=false;
				           var RadioArray = document.getElementsByName("ChannelButton");
				           for(var i=0;i&lt;RadioArray.length;i++)
				           {
					       if(found == false)
					       {
						    for(var e=0;e&lt;RadioArray.length;e++)
						    {							
							var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
							if(document.getElementById(elemName) != null)
							{							
								RadioArray[i].checked=true;
								found=true;
								break;
							}
						    }
					       }
				          }
			         }

			         <!--This function disables the channel radio buttons that do not have any array disks attached-->
			         function disableChannelSelectionRadioButtonsWithNoArrayDisks()
			         {
				        var RadioArray = document.getElementsByName("ChannelButton");
				        for(var i=0;i&lt;RadioArray.length;i++)
				        {
					    var ArrayDisks = 0;
					    for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					    {
						var elemName="parentrow_Sel"+i.toString()+e.toString();
						if(document.getElementById(elemName) != null)
						{
							ArrayDisks = 1;
						}
					   }
					   if (ArrayDisks == 0)
					   {
						RadioArray[i].disabled=true;
					   }
				        }
			         }
                        
                                 <!--  This functin is called when check and uncheck the "Number of the disk per enclosure "  -->              
	                         function OnDHSPerEnclosure()
                                 {   
                                    if(document.getElementById("DiskPerEnclosure")!=null &amp;&amp; 
                                          document.getElementById("DiskPerEnclosure").checked==true)
                                    { 
                                         document.getElementById("NumberOfDisk").disabled=false; 
                                         OnChangeNumberOfDisk();
                                    }
                                    else 
                                    {
                                        if(document.getElementById("NumberOfDisk")!=null)
                                       {
                                         var chkBxName="";
                                         document.getElementById("NumberOfDisk").disabled=true
                                         for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					 {
				            for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
					            for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
							{
							  chkBxName="Sel"+i.toString()+k.toString()+j.toString();
								if(document.getElementById(chkBxName) != null )
								{
								   document.getElementById(chkBxName).disabled=false; 
                                                                   document.getElementById(chkBxName).checked=false; 
                                                                         
								}
							}
                                                }
					     }
                                           }  
                                        }
                                 }
                               
                                 <!-- This function  is called  for selecting and de-selecting the entire array disks 
                                 and depending the combo box value it checks array disks and rest of them will be disabled.-->                  
                                 function OnChangeNumberOfDisk()
                                 {
                                     var chkBxName="";
                                     for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
				            for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{ var counter=0;
					            for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
							{
							  chkBxName="Sel"+i.toString()+k.toString()+j.toString();
                                                               
								if(document.getElementById(chkBxName) != null)
								{  
                                                                     counter++;
                                                                     document.getElementById(chkBxName).disabled=true;
                                                                     if(((document.getElementById("NumberOfDisk") != null) &amp;&amp; counter &lt;= document.getElementById("NumberOfDisk").value))
                                                                     {
                                                                     document.getElementById(chkBxName).checked =true;
                                                                     }
                                                                     else
                                                                     {
                                                                     document.getElementById(chkBxName).checked =false;
                                                                     }
                                                                        
								}
							}
						
                                                }
                                           
					}
                                 }
                                 
	                        <!-- ######################################################### -->
			         function OnArrayDiskSelected(channel,encl,target)
			         {
                       
                                       var chkBxName = "Sel"+channel.toString()+encl.toString()+target.toString();
                                       var JS_MaxNumberArrayDisks = 16;
                                       if(document.getElementById(chkBxName).checked==true)
                                       {
                                             ArrayDisks_Counter++;
                                             if(ArrayDisks_Counter == JS_MaxNumberArrayDisks)
                                             {
                                                    disableUnselectedCheckBoxes();
                                             }
                                       }
                                       else
                                       {
                                                    ArrayDisks_Counter--;
                                                    enableAllCheckBoxes();
                                       }
		                 }   
                        
                                 <!--This function disable all checkboxes that are not checked-->
				 function disableUnselectedCheckBoxes()
				 {
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
							{
								if( isArrayDiskSelected(i.toString(), k.toString(), j.toString()) == false )
								{
									disableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
								}
							}
						}
					}
				 }
                                 
                                 <!-- This function returns true if the given single array disk selection check box is checked, else returns false-->
				 function isArrayDiskSelected(channel, enclosureId, targetId)
				 {
					var elemName="Sel"+channel.toString()+enclosureId.toString()+targetId.toString();
					if(document.getElementById(elemName) != null)
					{
						return document.getElementById(elemName).checked;
					}
					return false;
				 }
                                 
                                 <!--This function disables a single array disk selection check box-->
				 function disableArrayDiskCheckBox(channel, enclosureId, targetId)
				 {
					var elemName="Sel"+channel.toString()+enclosureId.toString()+targetId.toString();
					if(document.getElementById(elemName) != null)
					{
						document.getElementById(elemName).disabled=true;
					}
				 }
                                 
                                 <!--This function enables all array disk selection check boxes-->
				 function enableAllCheckBoxes()
				 {
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
							{
								enableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
							}
						}
					}
				 }
                                 
                                 <!--This function enables a single array disk selection check box-->
				 function enableArrayDiskCheckBox(channel, enclosureId, targetId)
				 {
					var elemName="Sel"+channel.toString()+enclosureId.toString()+targetId.toString();
					if(document.getElementById(elemName) != null)
					{
						document.getElementById(elemName).disabled=false;
					}
				 }
				
			</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartCVDAS"/><xsl:value-of select="$PARAM_REGULAR_ControllerName"/><xsl:value-of select="$strTitleMainEndCVDAS"/></xsl:attribute>
			</PageTitle>

			<!-- Add span edit button only if Intelligent Mirroring option is selected -->
			<xsl:if test="$PARAM_CURR_IM = 'true' or $PARAM_SPANEDITMODE = 'true'">
			                          
                            <CustomButton align="left">
					<Data name="Edit" formSubmit="true">
						<xsl:attribute name="display"><xsl:value-of select="$strSpanEdit"/></xsl:attribute>
						<xsl:attribute name="href">javascript:submitSpanEditMode()</xsl:attribute>
					</Data>
				</CustomButton>
			</xsl:if>
                         
			
				
				<!--PERC 4 I/M does not have stripe size,-->
                                <!-- Create VD improvement changes -->
				<xsl:call-template name="RenderCreateVDTable">
				<xsl:with-param name="RAIDMask"><xsl:value-of select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:with-param>
				<xsl:with-param name="READMask"><xsl:value-of select="$GLOBAL_VAR_ReadPolicyMask"/></xsl:with-param>
				<xsl:with-param name="WRITEMask"><xsl:value-of select="$GLOBAL_VAR_WritePolicyMask"/></xsl:with-param>
				<xsl:with-param name="DEFAULTReadPolicy"><xsl:value-of select="$GLOBAL_VAR_Decimal_Read_Policy"/></xsl:with-param>
				<xsl:with-param name="DEFAULTWritePolicy"><xsl:value-of select="$GLOBAL_VAR_Decimal_Write_Policy"/></xsl:with-param>
				<xsl:with-param name="CACHEMask"><xsl:value-of select="$GLOBAL_VAR_CachePolicyMask"/></xsl:with-param>
                                <xsl:with-param name="DISKCACHEMask"><xsl:value-of select="$GLOBAL_VAR_DiskCachePolicyMask"/></xsl:with-param>
                                <xsl:with-param name="CntrlAttributesMask"><xsl:value-of select="$GLOBAL_PARAM_CntrlAttributesMask"/></xsl:with-param>
				<xsl:with-param name="STRIPESMask"><xsl:if test="$GLOBAL_VAR_IsStripeSizeFieldAllowedForSelectedLayout !='0' "><xsl:value-of select="$GLOBAL_VAR_StripeSizesMask"/></xsl:if></xsl:with-param>
				<xsl:with-param name="HIDE_RAID_DESC_ROW">true</xsl:with-param>
                                <xsl:with-param name="HIDE_SUMMARY_ATTRIBUTES_ROW">false</xsl:with-param>
				<xsl:with-param name="HIDE_NAME_ROW"><xsl:if test="$PARAM_DSA_Rules='1' or $GLOBAL_VAR_IsVdiskNameFieldAllowedForSelectedLayout ='0'">true</xsl:if></xsl:with-param>
				<xsl:with-param name="VD_NAME_LENGTH"><xsl:value-of select="$GLOBAL_VAR_MaxVirtualDiskNameLength"/></xsl:with-param>
				<xsl:with-param name="SELECT_RAID_HEADER"><xsl:value-of select="$strTblHeaderCVDASS"/><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType" select="$PARAM_PREV_Layout"/></xsl:call-template></xsl:with-param>
				<xsl:with-param name="SHOW_NAME_SUMMARY_ROW"><xsl:value-of select="$GLOBAL_VAR_SHOW_NAME_SUMMARY_ROW"/></xsl:with-param>
				<xsl:with-param name="HIDE_SIZE_ROW">false</xsl:with-param>
				<xsl:with-param name="HIDE_MIN_MAX_ROW">false</xsl:with-param>
				 <xsl:with-param name="HIDE_SectorSize_TYPE_ROW">true</xsl:with-param>
				 <!--Uncomment for PI feature--><!--xsl:with-param name="HIDE_PIEnabled_TYPE_ROW">true</xsl:with-param-->
                                
			</xsl:call-template>
			
			
			<xsl:choose>
				<xsl:when test="$PARAM_PREV_Layout='512' or $PARAM_PREV_Layout='2048' or $PARAM_PREV_Layout='4096' or $PARAM_PREV_Layout='262144'">
					<TableData name="T2" display="{$strArrayDisksCVDAS}">
						<SubHeader><xsl:attribute name="display"><xsl:value-of select="$strPromptTextAdisksSelectedCVDAS"/></xsl:attribute></SubHeader>
						<Header><Data value="{$strArrayDiskCVDAS}"/><Data value="{$strFreeSpaceCVDAS}"/>
						<xsl:if test="not($PARAM_PREV_Layout='512' and $GLOBAL_VAR_PercVersion = '9' )">
						<Data value="{$strSpanNumCVDAS}"/>
						</xsl:if>
						<xsl:choose>
						<xsl:when test="$PARAM_PREV_Layout='512'">
						   <Data value="{$strMirrorSetID}"/><Data></Data>
						</xsl:when>
						<xsl:otherwise>
							<Data></Data>
						</xsl:otherwise>
						</xsl:choose>
						
						</Header>
						<!--xsl:apply-templates select="//DCStorageObject" mode="SPAN"/-->
						<xsl:for-each select="//ArrayDisks">
							<xsl:call-template name="RenderArrayDisksWithSpanInfo">
								<xsl:with-param name="SpanNum" select="@span"/>
							</xsl:call-template>
						</xsl:for-each>
					</TableData>
				</xsl:when>
				<xsl:otherwise>
					<TableData name="T2" display="{$strArrayDisksCVDAS}">
						<SubHeader><xsl:attribute name="display"><xsl:value-of select="$strPromptTextAdisksSelectedCVDAS"/></xsl:attribute></SubHeader>
						<Header><Data value="{$strArrayDiskCVDAS}" width="400"/><Data value="{$strFreeSpaceCVDAS}" /><Data/></Header>
						<xsl:apply-templates select="//ArrayDisks/PassThruResponse/DCStorageObject" mode="NO_SPAN"/>
					</TableData>
				</xsl:otherwise>
			</xsl:choose>
			<!-- CR69634 : Hotspare selection in Create VD -->
			<!--
				DF95814 : Need to add mode="deploy" to ensure that HTMLData is processed correctly by
				          DSA's data area. This is ignored by OMSA's data area.
			-->
 <xsl:if test="$PARAM_PREV_Layout != '2' and substring(/OMA/Controllers/DCStorageObject/AttributesMask,13,1) != '1'">			
  <xsl:choose>
	        <xsl:when test="//DHSAvailDisks">        
              <xsl:choose>
	            <xsl:when test="substring($GLOBAL_VAR_EnhanceDHSMask,10,1)='1'">       
		<SelectionData multitable="false" image="none">
                     <SubHeader><xsl:attribute name="display"><xsl:value-of select="$strHSAssignHotspareCVDAS"/></xsl:attribute></SubHeader>
		     <xsl:if test="/OMA/ExpressResults/DCStorageObject/HSCountViolated and /OMA/ExpressResults/DCStorageObject/HSCountViolated != 0">
			<PromptText alert="true"><xsl:value-of select="$strCVDPolicyMsg"/><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/HSCountViolated"/></PromptText>
		     </xsl:if>
			  <xsl:choose>
                    <xsl:when test="$PARAM_CURR_IM = 'true'">   
                       <TableData name="T3" display="{$strHSDiskTableCVDAS}">
                              <Row>
                                    <xsl:call-template name="DisplayDiskPerEnclosure"/>  
                              </Row>  
                       </TableData> 
                    </xsl:when>
               </xsl:choose>
			<SelectionTable>
				<!-- The header for the selection table will be the channel radio buttons -->
				<Header>
					<xsl:for-each select="Channels/DCStorageObject">
						<xsl:call-template name="RenderChannelSelectionRadioButtons"/>
					</xsl:for-each>
				</Header>
				<!-- The list of available disks for dhs is divided by channel, so each channel will have a <DHSAvailDisks ChannelName=" " EnclosureName=" "> tag -->
				<xsl:for-each select="DHSAvailDisks/ArrayDisks">
				 <xsl:choose>
						<xsl:when test="DCStorageObject/EnclosureID">
									<!-- SAS: use channel and enclosure id -->
									<xsl:call-template name="RenderAvailArrayDisksRow">
										<!-- To render each channel's disks, we need to pass in some parameters
				                              These are used to give each row, etc a correct title to be used by the
				                              javascript when querying for the elements.  The KEY is used to sort
				                              the disks by channel for the radio buttons -->
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of  select="@EnclosureType"/></xsl:with-param>
                                                                                <xsl:with-param name="productid"><xsl:value-of  select="@ProductID"/></xsl:with-param></xsl:call-template>(<xsl:value-of  select="@ChannelName"/>)</xsl:otherwise></xsl:choose></xsl:with-param>
									</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
						<!-- Not SAS: use channel and 0 -->
									<xsl:call-template name="RenderAvailArrayDisksRow">
										<!-- To render each channel's disks, we need to pass in some parameters
				                              These are used to give each row, etc a correct title to be used by the
				                              javascript when querying for the elements.  The KEY is used to sort
				                              the disks by channel for the radio buttons -->
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/>0</xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of  select="@ProductID"/></xsl:with-param></xsl:call-template></xsl:otherwise></xsl:choose></xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>					
				</xsl:for-each>
			</SelectionTable>
		</SelectionData>
                 </xsl:when>
                        <xsl:otherwise>
                            <!-- Use for the NON SAS Controllers -->
                            <TableData name="T3" display="{$strHSDiskTableCVDAS}">
						 <SubHeader><xsl:attribute name="display"><xsl:value-of select="$strHSAssignHotspareCVDAS"/></xsl:attribute></SubHeader>
						<xsl:choose>
							<xsl:when test="//DHSAvailDisks">
								<Header>
									<Data value="{$strArrayDiskCVDAS}" width="400"/>
									<Data value="{$strFreeSpaceCVDAS}"/>
									<Data></Data>
								</Header>
								<xsl:apply-templates select="//DHSAvailDisks/ArrayDisks/DCStorageObject" mode="NO_SPAN">
									<xsl:with-param name="WithCheckbox">1</xsl:with-param>
									<xsl:sort select="Channel" data-type="number" order="ascending"/>
									<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
									<xsl:sort select="TargetID" data-type="number" order="ascending"/>
								</xsl:apply-templates>
							</xsl:when>
						</xsl:choose>
				</TableData>
                        </xsl:otherwise>
                      </xsl:choose>
                 </xsl:when>
				 <xsl:otherwise>
			                <AlertMessage>
							   <xsl:attribute name="display"><xsl:value-of select="$strHSNoneAvailable"/></xsl:attribute>
							</AlertMessage>
		       </xsl:otherwise>
		</xsl:choose>
	 </xsl:if> 	
                <HiddenTable>
		          <Data>
			          <xsl:attribute name="name">HSDIDList</xsl:attribute>
			          <xsl:attribute name="returnvalue"></xsl:attribute>
		          </Data>
		</HiddenTable>
                 <HiddenTable>
				<!--This creates a hidden table that maps a "raid layout type" to the "max size possible" for that layout/-->
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMaxSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMinSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMaxSizeInGBForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMinSizeInGBForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				
			</HiddenTable>
                
		</DataArea>
	</xsl:template>
          <xsl:template name="DisplayDiskPerEnclosure">
            <Data type="checkbox" width="250">
			<xsl:attribute name="name">DiskPerEnclosure</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strNumberDiskPerAdvanceEnclosure"/></xsl:attribute>
			<xsl:attribute name="returnvalue"/>
			<xsl:attribute name="event">onClick</xsl:attribute>
			<xsl:attribute name="handler">javascript:OnDHSPerEnclosure()</xsl:attribute>
                        
	    </Data>
	    <Data name="NumberOfDisk" type="select">
			<xsl:attribute name="returnvalue"/>
                        <xsl:attribute name="event">onChange</xsl:attribute>
			<xsl:attribute name="handler">javascript:OnChangeNumberOfDisk()</xsl:attribute>
                        <xsl:call-template name="RenderDHSnumberofDisks"/>
            </Data>
	</xsl:template>
         <xsl:template name="RenderDHSnumberofDisks">
		<xsl:param name="initial" select="0"/>
		<xsl:param name="terminal" select="$Global_Var_Enclosure"/>
		<xsl:param name="increment" select="1"/>
		<xsl:if test="$initial &lt;= $terminal">
			<Choice value="{$initial}" returnvalue="{$initial}"/>
			<xsl:call-template name="RenderDHSnumberofDisks">
				<xsl:with-param name="initial" select="$initial+$increment"/>
				<xsl:with-param name="terminal" select="$terminal"/>
				<xsl:with-param name="increment" select="$increment"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="RenderAvailArrayDisksRow">
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<!-- The Row is the enclosure -->
                
		<Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<Data value="{$DISPLAY_NAME}"/>
			</ColumnData>
			<!-- The children rows are the individual disks -->
			<ChildrenRows>
				<!-- For each disk that matches the channel we're trying to display -->
				<xsl:for-each select="DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					<xsl:call-template name="RenderArrayDiskSelection">
						<xsl:with-param name="ArrayDiskSpace">
							<xsl:value-of select="Length"/>
						</xsl:with-param>
						<xsl:with-param name="PrefixName">
							<xsl:value-of select="$CHILD_NAME_PREFIX"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the each disk under the enclosure row                -->
	<xsl:template name="RenderArrayDiskSelection">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		<Row>
			<xsl:variable name="enclNum">
				<xsl:choose>
					<xsl:when test="EnclosureID"><xsl:value-of select="EnclosureID"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:value-of select="TargetID"/></xsl:attribute>
			<SelectDataItem>
			    <!--xsl:if test="PDPowerState != ''">
			    <Data type="icon" name="PowerState" columnspacing="true" align="center">
					<xsl:attribute name="value"><xsl:call-template name="GetPowerStatusIcon"><xsl:with-param name="powerstatus"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					<xsl:attribute name="alt"><xsl:call-template name="GetPowerStatusToolTip"><xsl:with-param name="psicon"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
			   </xsl:if-->
				<Data type="checkbox" width="150" columnspacing="true">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:text/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!-- Different name depending on SAS or SATA -->
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="EnclosureID">
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:attribute>

					<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="$enclNum"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data columnspacing="true">
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00 GB')"/></xsl:attribute>
				</Data>
			</ColumnData>
                                       <ColumnData>
				<Data columnspacing="true" width="150" align="center">
					<xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
				</Data>
		              </ColumnData>
		</Row>
	</xsl:template>
        
        
        <!-- ################################################### -->
	<!-- This dispays the channel radio buttons on the top of the table  -->
	<xsl:template name="RenderChannelSelectionRadioButtons">
		<Data name="ChannelButton" type="radio" state="0" event="onclick" handler="OnChannelSelected()">
			<xsl:attribute name="value"><xsl:value-of select="$strChannel"/><xsl:value-of select="Channel"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Channel"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="RenderArrayDisksWithSpanInfo">
		<xsl:param name="SpanNum"/>
		<xsl:for-each select="PassThruResponse/DCStorageObject">
			<xsl:variable name="SASorSATA">
				<xsl:call-template name="IsSASorSATA">
					<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="DiskInEnclosure">
				<xsl:call-template name="IsDiskInEnclosure">
					<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<Row>
				<xsl:choose>
					<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
						<Data>
							<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDAS"/>&#160;<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data>
							<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDAS"/>&#160;<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
				<Data>
					<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="$PARAM_DSA_Rules=1"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="format-number((ContiguousFree div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<xsl:if test="not($PARAM_PREV_Layout='512' and $GLOBAL_VAR_PercVersion = '9')">
				<Data>
					<xsl:attribute name="name">AdiskSpanNum<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$SpanNum"/></xsl:attribute>
				</Data>
				</xsl:if>
                <xsl:if test="$PARAM_PREV_Layout='512'">
                    <Data>
                        <xsl:choose>
                            <xsl:when test="$GLOBAL_VAR_PercVersion = '9' and $PARAM_CURR_IM = 'true'"> 
                                <xsl:attribute name="value"><xsl:call-template name="SetMirrorIDonIM"><xsl:with-param name="ObjID" select="ObjID"/></xsl:call-template></xsl:attribute>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:attribute name="value"><xsl:value-of select="floor((position()-1) div 2)"/></xsl:attribute>
                            </xsl:otherwise>
                        </xsl:choose>
                    </Data>
                </xsl:if>
                <Data columnspacing="true" width="150" align="center">
                    <xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
                </Data>
        	</Row>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="DCStorageObject" mode="NO_SPAN">
		<xsl:param name="WithCheckbox">0</xsl:param>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="AdiskTitle">
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
			<xsl:choose>
				<xsl:when test="$WithCheckbox='1'">
					<Data editable="true" type="checkbox" align="left">
						<xsl:attribute name="name">
							<xsl:choose>
								<xsl:when test="$PARAM_DSA_Rules = '1'">HSDID_<xsl:value-of select="$AdiskTitle"/></xsl:when>
								<xsl:otherwise>HSDIDList</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="returnvalue">
							<xsl:choose>
								<xsl:when test="$PARAM_DSA_Rules = '1'">
									<!-- Send hotspare disk nexus in case of OMSS-Lite -->
									<xsl:value-of select="$AdiskTitle"/>
								</xsl:when>
								<xsl:otherwise>
									<!-- Send hotspare disk OID in case of OMSS -->
									<xsl:value-of select="ObjID"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDAS"/>&#160;<xsl:value-of select="$AdiskTitle"/></xsl:attribute>
						<xsl:attribute name="event">onclick</xsl:attribute>
						<xsl:attribute name="handler">javascript:toggleUncheckedCheckboxes(this);</xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$AdiskTitle"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<Data>
				<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="$PARAM_DSA_Rules=1"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="format-number((ContiguousFree div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
            <Data columnspacing="true" width="150" align="center">
					<xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
		    </Data>
		           
		</Row>
	</xsl:template>
</xsl:stylesheet>



