<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the xsl page to set controller rate attributes.  The associated web plugin is the ControllerExecWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>

	<xsl:template match="OMA">
		<!--xsl:call-template name="scripts"/-->
		<DataArea printable="false" email="false" validate="true" Refresh="false" exportdata="false" onLoad="false">
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=<xsl:value-of select="Action"/>&amp;help=cnprin&amp;</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApply"/></xsl:attribute>

			<xsl:variable name="dfltBkPg">./DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cnprin</xsl:variable >
			<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="BackPage"><xsl:with-param name="defaultBackPage" select="$dfltBkPg"/></xsl:call-template></xsl:attribute>

			<PageTitle>
				<xsl:attribute name="display">
					<xsl:value-of select="$strTitlePart1"/>
					<xsl:value-of select="$strFor"/>
					<xsl:value-of select="ControllerName"/>
					<xsl:value-of select="$strTitlePart2"/>
				</xsl:attribute>
			</PageTitle>

			<xsl:call-template name="CtrlPatReadMode"/>
		</DataArea>
	</xsl:template>
	<xsl:template name="CtrlPatReadMode">
		<ComboData>
			<ListData>
				<Data name="currentmode" editable="false" type="ustring" align="right">
					<xsl:attribute name="display">
						<xsl:value-of select="$strCurrentMode"/>
					</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="GetPatrolReadMode"><xsl:with-param name="mode"><xsl:value-of select="PatrolReadMode"/></xsl:with-param></xsl:call-template>
					</xsl:attribute>
				</Data>
			</ListData>
			<TableData>
				<SubHeader>
					<xsl:attribute name="display">
						<xsl:value-of select="$strHdrPatrolReadMode"/>
					</xsl:attribute>
				</SubHeader>
				<xsl:if test="substring(PatrolReadModeMask, 32, 1) = '1'">
					<Row>
						<Data name="Mode" type="radio" align="left">
								<xsl:attribute name="value">
									<xsl:value-of select="$strAuto"/>
								</xsl:attribute>
								<xsl:attribute name="returnvalue">
									<xsl:value-of select="$strRetValAuto"/>
								</xsl:attribute>
							</Data>
						</Row>
					</xsl:if>
					<xsl:if test="substring(PatrolReadModeMask, 31, 1) = '1'">
						<Row>
							<Data name="Mode" type="radio" align="left">
								<xsl:attribute name="value">
									<xsl:value-of select="$strManual"/>
								</xsl:attribute>
								<xsl:attribute name="returnvalue">
									<xsl:value-of select="$strRetValManual"/>
								</xsl:attribute>
							</Data>
						</Row>
					</xsl:if>
					<xsl:if test="substring(PatrolReadModeMask, 30, 1) = '1'">
						<Row>
							<Data name="Mode" type="radio" align="left">
								<xsl:attribute name="value">
									<xsl:value-of select="$strDisable"/>
								</xsl:attribute>
								<xsl:attribute name="returnvalue">
									<xsl:value-of select="$strRetValDisable"/>
								</xsl:attribute>
							</Data>
						</Row>
					</xsl:if>
				</TableData>
			</ComboData>

		<script language="javascript">
			function validate()
			{
				var RadioArray = document.getElementsByName("Mode");
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					if(RadioArray [i].checked)
					{
						disableButtons("submit","back" ,"");
						return true;
					}
				}

				alert("<xsl:value-of select="$strNoSelectionError"/>");
				return false;
			}
		</script>

	</xsl:template>
</xsl:stylesheet>
