<!-- This is the XSL to confirm rescan operation on the system -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:import href="Utils.xsl"/>
	<!-- Include some common templates created by SS -->
	<xsl:template match="OMA">
		<DataArea export="false" exportdata="false" printable="false" email="false" validate="true">
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=<xsl:value-of select="Action"/>&amp;help=cnprin";</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strCtrlRescan"/></xsl:attribute>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
			
			<AlertMessage alert="true" status="3">
				<xsl:attribute name="display">
					<xsl:value-of select="$strRescanWarn"/>
					<xsl:value-of select="$strRescanWarn1"/>
					<xsl:value-of select="$strRescanWarn2"/>
					<xsl:value-of select="$strRescanWarn3"/>
					<xsl:value-of select="$strRescanWarn4"/>&#160;<xsl:value-of select="/OMA/ControllerName"/><xsl:value-of select="$strQuestionMark"/>
				</xsl:attribute>
			</AlertMessage>

		<script language="javascript">
			function validate() 
			{
				msg = "<xsl:value-of select="$strRUSure"/>";
				Confirm = confirm(msg);
				if(Confirm)
				{
					disableButtons("submit","back" ,"");
				}					
				return Confirm;
			}
		</script>
			
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
