<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Controller Property  page.  The associated web plugin is the ChangeControllerWebPlugin.java -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<xsl:call-template name="scripts"/>
		<DataArea backpagetarget="./DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin" printable="false" email="false" validate="true" Refresh="false" exportdata="false" onLoad="true">
                  <xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=67108864&amp;help=cnprin&amp;</xsl:attribute>
		  <xsl:attribute name="submitdisplay"><xsl:value-of select="$strApply"/></xsl:attribute>
                  <xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
                  <xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
 			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>
                  <xsl:call-template name="ControllerProps"/>
		</DataArea>
	</xsl:template>
	
       <xsl:template name="ControllerProps">
	         <TableData name="T" display="">
                      <xsl:variable name="showtasks">false</xsl:variable>
                           <Row><Data><xsl:attribute name="value"><xsl:value-of select="$strRbuild"/></xsl:attribute></Data>
                              <Data name="rbldrate" type="editbox" maxlength="3" size="3" align="left" >
					<xsl:attribute name="value"><xsl:value-of select="/OMA/Controllers/DCStorageObject/RebuildRate"/></xsl:attribute>
					<xsl:attribute name="unit">%</xsl:attribute>
			      	</Data>
                           </Row>
                           <Row> <Data><xsl:attribute name="value"><xsl:value-of select="$strBGI"/></xsl:attribute></Data>
                              <Data name="bgirate" type="editbox" maxlength="3" size="3" align="left">
					<xsl:attribute name="value"><xsl:value-of select="/OMA/Controllers/DCStorageObject/BGIRate"/></xsl:attribute>
                              <xsl:attribute name="unit"> %</xsl:attribute>
                			</Data>
                           </Row>
                           <Row><Data><xsl:attribute name="value"><xsl:value-of select="$strConsistency"/></xsl:attribute></Data>
                              <Data name="checkconsistencyrate" type="editbox" maxlength="3" size="3" align="left" >
					<xsl:attribute name="value"><xsl:value-of select="/OMA/Controllers/DCStorageObject/CheckConsistencyRate"/></xsl:attribute>
					<xsl:attribute name="unit"> %</xsl:attribute>
			      	</Data>
                           </Row>
 
                          <Row><Data><xsl:attribute name="value"><xsl:value-of select="$strReconstruct"/></xsl:attribute></Data>
                              <Data name="reconstructrate" type="editbox" maxlength="3" size="3" align="left">
					<xsl:attribute name="value"><xsl:value-of select="/OMA/Controllers/DCStorageObject/ReconstructRate"/></xsl:attribute>
					<xsl:attribute name="unit"> %</xsl:attribute>
			            </Data>
                          </Row>
                          
<xsl:if test="//ChangeControllerPropertyMask">
 <Row>
       <Data><xsl:attribute name="value"><xsl:value-of select="$strAbortCConError"/></xsl:attribute></Data>
       <Data name="abortcc" type="select">
	<Choice>
	  <xsl:attribute name="value">
           <xsl:call-template name="GetControllerProperty">
                 <xsl:with-param name="PropertyMode">
                     <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,20,1)='1'">4096</xsl:when>
                            <xsl:when test="substring(//ChangeControllerPropertyMask,12,1)='1'">1048576</xsl:when>
                            
                     </xsl:choose>
                  </xsl:with-param>
             </xsl:call-template>
          </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,20,1)='1'">1</xsl:when>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,12,1)='1'">2</xsl:when>
                         
                    </xsl:choose>
                  </xsl:attribute>
       </Choice>
					      
         <xsl:call-template name="for-loop-list-box">
		<xsl:with-param name="Mask" select="//ChangeControllerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,20,1)='1'">4096</xsl:when>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,12,1)='1'">1048576</xsl:when>
                          
                    </xsl:choose>
                 </xsl:with-param> 
                 <xsl:with-param name="templateName" select="19"/>
	 </xsl:call-template>
</Data>
</Row>
</xsl:if>

<xsl:if test="//ChangeControllerPropertyMask and //PersonalityState='1'">
 <Row>
       <Data><xsl:attribute name="value" ><xsl:value-of select="$strCopyback"/></xsl:attribute></Data>
       <Data name="copyback" type="select" handler="javascript:Onselect()" event="onChange">
	<Choice>
	  <xsl:attribute name="value">
           <xsl:call-template name="GetControllerProperty">
                 <xsl:with-param name="PropertyMode">
                     <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,17,1)='1'">32768</xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,15,1)='1'">131072</xsl:when>
                     </xsl:choose>
                  </xsl:with-param>
             </xsl:call-template>
          </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,17,1)='1'">1</xsl:when>
                          
                         <xsl:when test="substring(//ChangeControllerPropertyMask,15,1)='1'">2</xsl:when>
                    </xsl:choose>
                  </xsl:attribute>
          </Choice>
	   <xsl:call-template name="for-loop-list-box">
		<xsl:with-param name="Mask" select="//ChangeControllerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,17,1)='1'">32768</xsl:when>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,15,1)='1'">131072</xsl:when>
                    </xsl:choose>
                 </xsl:with-param> 
                 <xsl:with-param name="templateName" select="16"/>
	 </xsl:call-template>

</Data>
</Row>
</xsl:if>


<xsl:if test="//ChangeControllerPropertyMask and (substring(//ChangeControllerPropertyMask,14,1) = '1' or substring(//ChangeControllerPropertyMask,13,1) = '1')">
 <Row>
       <Data><xsl:attribute name="value"><xsl:value-of select="$strLoadBalancing"/></xsl:attribute></Data>
       <Data name="loadbalance" type="select">
	<Choice>
	  <xsl:attribute name="value">
           <xsl:call-template name="GetControllerProperty">
                 <xsl:with-param name="PropertyMode">
                     <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,14,1)='1'">262144</xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,13,1)='1'">524288</xsl:when>
                     </xsl:choose>
                  </xsl:with-param>
             </xsl:call-template>

          </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,14,1)='1'">1</xsl:when>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,13,1)='1'">2</xsl:when>
                    </xsl:choose>
                  </xsl:attribute>
       </Choice>
					      
         <xsl:call-template name="for-loop-list-box">
		<xsl:with-param name="Mask" select="//ChangeControllerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,14,1)='1'">262144</xsl:when>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,13,1)='1'">524288</xsl:when>
                    </xsl:choose>
                 </xsl:with-param> 
                 <xsl:with-param name="templateName" select="17"/>
	 </xsl:call-template>

</Data>
</Row>
</xsl:if>




<xsl:if test="//ChangeControllerPropertyMask and //PersonalityState='1'">
 <Row>
       <Data><xsl:attribute name="value"><xsl:value-of select="$strSmarterErrorDisk"/></xsl:attribute></Data>
       <Data name="smarterrordisk" type="select">
	<Choice>
	  <xsl:attribute name="value">
           <xsl:call-template name="GetControllerProperty">
                 <xsl:with-param name="PropertyMode">
                     <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,30,1)='1'">4</xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,29,1)='1'">8</xsl:when>
                     </xsl:choose>
                  </xsl:with-param>
             </xsl:call-template>

          </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,30,1)='1'">1</xsl:when>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,29,1)='1'">2</xsl:when>
                    </xsl:choose>
                  </xsl:attribute>
       </Choice>
					      
         <xsl:call-template name="for-loop-list-box">
		<xsl:with-param name="Mask" select="//ChangeControllerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,30,1)='1'">4</xsl:when>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,29,1)='1'">8</xsl:when>
                    </xsl:choose>
                 </xsl:with-param> 
                 <xsl:with-param name="templateName" select="18"/>
	 </xsl:call-template>

</Data>
</Row>
</xsl:if>

<!-- including multipath in change Controller Properties-->
<xsl:if test="substring(/OMA/Channels/DCStorageObject[1]/AttributesMask,26,1)='1'">
 <Row>
       <Data><xsl:attribute name="value"><xsl:value-of select="$strClearMultipath"/></xsl:attribute></Data>
       <Data name="clearmultipath" type="select">
	<Choice>
	  <xsl:attribute name="value">
           <xsl:call-template name="GetControllerProperty">
                 <xsl:with-param name="PropertyMode">
                     <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,32,1)='1'">1</xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,31,1)='1'">2</xsl:when>
                     </xsl:choose>
                  </xsl:with-param>
             </xsl:call-template>

          </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,32,1)='1'">1</xsl:when>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,31,1)='1'">2</xsl:when>
                    </xsl:choose>
                  </xsl:attribute>
       </Choice>
					      
         <xsl:call-template name="for-loop-list-box">
		<xsl:with-param name="Mask" select="//ChangeControllerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,32,1)='1'">1</xsl:when>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,31,1)='1'">2</xsl:when>
                    </xsl:choose>
                 </xsl:with-param> 
                 <xsl:with-param name="templateName" select="21"/>
	 </xsl:call-template>

</Data>
</Row>
</xsl:if>

<xsl:if test="//ChangeControllerPropertyMask and  //PersonalityState='1' and (substring(//ChangeControllerPropertyMask,1,1)='1')">
 <Row>
       <Data><xsl:attribute name="value"><xsl:value-of select="$PersistentHotSpare"/></xsl:attribute></Data>
       <Data name="persistenths" type="select">
	<Choice>
	  <xsl:attribute name="value">
           <xsl:call-template name="GetControllerProperty">
                 <xsl:with-param name="PropertyMode">
                     <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,2,1)='1'">1073741824</xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,3,1)='1'">536870912</xsl:when>
                     </xsl:choose>
                  </xsl:with-param>
             </xsl:call-template>

          </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,2,1)='1'">1</xsl:when>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,3,1)='1'">2</xsl:when>
                    </xsl:choose>
                  </xsl:attribute>
       </Choice>
					      
         <xsl:call-template name="for-loop-list-box">
		<xsl:with-param name="Mask" select="//ChangeControllerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,2,1)='1'">1073741824</xsl:when>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,3,1)='1'">536870912</xsl:when>
                    </xsl:choose>
                 </xsl:with-param> 
                 <xsl:with-param name="templateName" select="23"/>
	 </xsl:call-template>

    </Data>
</Row>
</xsl:if>
</TableData>

    
    <script language="javascript">	
        function initializationRoutine()
        {
            if(document.getElementById("copyback") != null &amp;&amp; document.getElementById("copyback").value=='2')
            {
                if(document.getElementById("smarterrordisk") != null)
                {
                    document.getElementById("smarterrordisk").disabled=true;
                }
            }
            document.getElementById("rbldrate").focus();
            return;
        }
            

        function Onselect()
        {

            if(document.getElementById("copyback").value=='2' &amp;&amp; document.getElementById("smarterrordisk").value=='1')
            { 
                if(confirm("<xsl:value-of select="$strsmarterdisableoncopybackdisable"/>")==true)
                { 
                    document.getElementById("smarterrordisk").value=2;
                    document.getElementById("smarterrordisk").disabled=true;
                }
                else
                { 
                    document.getElementById("copyback").value=1;
                }
            }
            if(document.getElementById("copyback").value=='1')
            {
                document.getElementById("smarterrordisk").disabled=false;
            }
            if(document.getElementById("copyback").value=='2')
            {
                document.getElementById("smarterrordisk").disabled=true;    
            }
        }
        function validate() 
        {
            var i,errormessage,vaild=true;


            var oldval=new Array();
            oldval[0]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/RebuildRate"/>';                                           
            oldval[1]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/BGIRate"/>';
            oldval[2]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/CheckConsistencyRate"/>';
            oldval[3]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/ReconstructRate"/>';
            oldval[4]='<xsl:choose><xsl:when test="substring(//ChangeControllerPropertyMask,20,1)='1'">1</xsl:when><xsl:when test="substring(//ChangeControllerPropertyMask,12,1)='1'">2</xsl:when></xsl:choose>';
            oldval[5]='<xsl:choose><xsl:when test="substring(//ChangeControllerPropertyMask,17,1)='1'">1</xsl:when><xsl:when test="substring(//ChangeControllerPropertyMask,15,1)='1'">2</xsl:when></xsl:choose>';
            oldval[6]='<xsl:choose><xsl:when test="substring(//ChangeControllerPropertyMask,14,1)='1'">1</xsl:when><xsl:when test="substring(//ChangeControllerPropertyMask,13,1)='1'">2</xsl:when></xsl:choose>';
            oldval[7]='<xsl:choose><xsl:when test="substring(//ChangeControllerPropertyMask,30,1)='1'">1</xsl:when><xsl:when test="substring(//ChangeControllerPropertyMask,29,1)='1'">2</xsl:when></xsl:choose>';
            oldval[8]='<xsl:choose><xsl:when test="substring(//ChangeControllerPropertyMask,32,1)='1'">1</xsl:when><xsl:when test="substring(//ChangeControllerPropertyMask,31,1)='1'">2</xsl:when></xsl:choose>';
            oldval[9]='<xsl:choose><xsl:when test="substring(//ChangeControllerPropertyMask,2,1)='1'">1</xsl:when><xsl:when test="substring(//ChangeControllerPropertyMask,3,1)='1'">2</xsl:when></xsl:choose>';

            var text= new Array();
            text[0]=document.getElementById("rbldrate").value;   
            text[1]=document.getElementById("bgirate").value;
            text[2]=document.getElementById("checkconsistencyrate").value;
            text[3]=document.getElementById("reconstructrate").value;

            var inputval=new Array(); 
            inputval[0]=document.dataarea.rbldrate.value;inputval[0] = removeLeadingZeros(inputval[0]);			
            inputval[1]=document.dataarea.bgirate.value;inputval[1] = removeLeadingZeros(inputval[1]);
            inputval[2]=document.dataarea.checkconsistencyrate.value;inputval[2] = removeLeadingZeros(inputval[2]);                    
            inputval[3]=document.dataarea.reconstructrate.value;inputval[3] = removeLeadingZeros(inputval[3]);                    
            inputval[4]=document.dataarea.abortcc.value;inputval[4] = removeLeadingZeros(inputval[4]);
            if(document.getElementById("copyback") != null)
            {
                inputval[5]=document.dataarea.copyback.value;inputval[5] = removeLeadingZeros(inputval[5]);
            }
            else
            {
                inputval[5]=oldval[5];
            }
            if (document.getElementById("loadbalance")!= null)
            {
                inputval[6]=document.dataarea.loadbalance.value;inputval[6] = removeLeadingZeros(inputval[6]);
            }
            else
            {
                inputval[6]=oldval[6];
            }
            if(document.getElementById("smarterrordisk") != null)
            {
                inputval[7]=document.dataarea.smarterrordisk.value;inputval[7] = removeLeadingZeros(inputval[7]);
            }
            else
            {
                inputval[7]=oldval[7];
            }
            if(document.getElementById("clearmultipath")!=null)
            { 
                inputval[8]=document.dataarea.clearmultipath.value;inputval[8] = removeLeadingZeros(inputval[8]);
            }
            else
            {
                inputval[8]=oldval[8];
            }

            if(document.getElementById("persistenths")!=null)
            { 
                inputval[9]=document.dataarea.persistenths.value;inputval[9] = removeLeadingZeros(inputval[9]);
            }
            else
            {
                inputval[9]=oldval[9];
            }

            var i; 
            var elements=new Array();
            elements[0]="rbldrate";
            elements[1]="bgirate";
            elements[2]="checkconsistencyrate";
            elements[3]="reconstructrate";
            if(oldval[0]==inputval[0] &amp;&amp; oldval[1]==inputval[1] &amp;&amp; oldval[2]==inputval[2] &amp;&amp;  oldval[3]==inputval[3] &amp;&amp;  oldval[4]==inputval[4]  &amp;&amp;  oldval[5]==inputval[5] &amp;&amp;  oldval[6]==inputval[6] &amp;&amp;  oldval[7]==inputval[7]  &amp;&amp;  oldval[8]==inputval[8] &amp;&amp;  oldval[9]==inputval[9])
            {
                alert("<xsl:value-of select="$strNoChangeInValue"/>");
                return false;
            }
            else
            { 
                for(i=0; i &lt;4; i++)// there are four operations which needs to be validated 
                {  
                    if(!check(text[i],inputval[i],oldval[i],i))
                    { 
                        return false;
                    }
                    if(i==3)
                    {
                        if(document.getElementById("copyback") != null)
                        {
                            document.getElementById("copyback").disabled=false;
                        }
                        if(document.getElementById("smarterrordisk") != null)
                        {
                            document.getElementById("smarterrordisk").disabled=false;
                        }
                        return true;
                    }

                } 
            }
                  

		 }//end of function validate	
                   
                 function check(text,inputval,oldval,i) 			
		         {  
                            var operation,displayoperation;
                             switch(i)
                               {
                                   case 0:operation="rbldrate";
                                          displayoperation='<xsl:value-of select="$strRebuildRateMsg"/>';
                                          break;
                                   case 1:operation="bgirate";
                                          displayoperation="<xsl:value-of select="$strBGIRateMsg"/>";
                                          break;
                                   case 2:operation="checkconsistencyrate";
                                          displayoperation="<xsl:value-of select="$strCCRateMsg"/>";
                                          break;
                                   case 3:operation="reconstructrate";
                                          displayoperation="<xsl:value-of select="$strReconstructRateMsg"/>";
                                          break;
                               }  
                             

                          // check that this isn't zero.
                          if (text.length &lt; 1)
			       {
					alert("<xsl:value-of select="$strError"/>" + displayoperation + "<xsl:value-of select="$strvalidrange2"/>");
                                        return false;
			       }
			
			  if( /^[0-9]*$/.test(text))
			      {  //make sure it's a number you are dealing with	
				if( text > 100 || 0 > text )
				    {  //make sure the # is not greater than 100 or less than 0
					alert("<xsl:value-of select="$strError"/>" + displayoperation + "<xsl:value-of select="$strvalidrange2"/>");
					document.getElementById(operation).value = "";
					document.getElementById(operation).focus();
					return false;
				    } 
				  else 
				    {
	              			return true;
				    }
			        } 
			      else 
			        {
					alert("<xsl:value-of select="$strError"/>" + displayoperation + "<xsl:value-of select="$strvalidrange2"/>");
					document.getElementById(operation).value = "";
					document.getElementById(operation).focus();
					return false;
			         }
                     
                      }//end for function check

	</script>

	</xsl:template>
</xsl:stylesheet>


