<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Confirm Import/Clear foreign config page.  The associated web plugin is the ControllerExecWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>

	<xsl:variable name="opType">
		<xsl:choose>
			<xsl:when test="/OMA/Action = '8388608'">
				<xsl:value-of select="$strClear"/>
			</xsl:when>
			<xsl:when test="/OMA/Action = '16777216'">
				<xsl:value-of select="$strImport"/>
			</xsl:when>
			<xsl:when test="/OMA/Action = '33554432'">
				<xsl:value-of select="$strForcedImport"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="OMA">
		<DataArea printable="false" email="false" validate="true" Refresh="false" export="false" exportdata="false">
		
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=<xsl:value-of select="Action"/>&amp;help=cnprin</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$opType"/></xsl:attribute>

			
			<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
			<script language="javascript">
				function validate()
				{
					disableButtons("submit","back");
					return true;
				}
				</script>
			<PageTitle>
				<xsl:attribute name="display">
					<xsl:value-of select="ControllerName"/><xsl:value-of select="$strColon"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$opType"/>
				</xsl:attribute>
			</PageTitle>
				<xsl:choose>
					<xsl:when test="/OMA/Action = '8388608'">
					<PromptText ignoreoncli="true">
						<xsl:value-of select="$strSubClearCfgHeader1"/>
					</PromptText>
					</xsl:when>
					<xsl:when test="/OMA/Action = '16777216'">
					<PromptText ignoreoncli="true">
						<xsl:value-of select="$strSubImportCfgHeader1"/>
					</PromptText>
					</xsl:when>
					<xsl:when test="/OMA/Action = '33554432'">
					<PromptText>
						<xsl:value-of select="$strSubForcedImportCfgHeader1"/><xsl:call-template name="NewLine"/>
						<xsl:value-of select="$strSubForcedImportCfgHeader2"/><xsl:call-template name="NewLine"/>
						<xsl:value-of select="$strSubForcedImportCfgHeader3"/><xsl:call-template name="NewLine"/>
						<xsl:value-of select="$strSubForcedImportCfgHeader4"/>
					</PromptText>
					</xsl:when>
				</xsl:choose>
		</DataArea>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
		</xsl:text>
	</xsl:template>
</xsl:stylesheet>
