<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="vdtbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<DataArea printable="false" email="false" validate="false" Refresh="false" export="false" exportdata="false">
		<xsl:choose>
		<xsl:when test="Action = '67108864'">
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ADExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=<xsl:value-of select="Action"/>&amp;ADiskOID=<xsl:value-of select="ADiskOID"/>&amp;ADiskName=<xsl:value-of select="ADiskName"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;CurrentUrl=<xsl:value-of select="/OMA/CurrentUrl"/>&amp;help=adprin</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strExportLog"/></xsl:attribute>
        </xsl:when>
		<xsl:otherwise>
		     <xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=exportlog&amp;help=cnprin</xsl:attribute>
			 <xsl:attribute name="submitdisplay"><xsl:value-of select="$strExpLog"/></xsl:attribute>
		</xsl:otherwise>
		</xsl:choose>
			<PageTitle>
			  <xsl:choose>
		        <xsl:when test="Action = '67108864'">
				   <xsl:attribute name="display"><xsl:value-of select="$strExportLog"/><xsl:value-of select="/*/VirtualDisks/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
				    <xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="/*/VirtualDisks/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
				</xsl:otherwise>
				</xsl:choose>
				  
			</PageTitle>
			<!--PromptText ignoreoncli="true"-->
			<AlertMessage>
			     <xsl:choose>
		           <xsl:when test="Action = '67108864'">
						<xsl:choose>
							<xsl:when test="DeviceType = '101'">
								<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderNVME2"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="display"><xsl:value-of select="$strSubHeader2"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>	
					</xsl:when>	
				   <xsl:otherwise>
				     <xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
				   </xsl:otherwise>
				 </xsl:choose> 
			</AlertMessage>	 
			<!--/PromptText-->
			<ListData columnspacing="true">
			    
				<Data name="HostName" editable="false" type="ustring">
			        <xsl:attribute name="display"><xsl:value-of select="$strHostName"/></xsl:attribute>
			        <xsl:choose>
					   <xsl:when test="(RemoteHostName) and RemoteHostName != '' and ServerHostName != RemoteHostName">
					      <xsl:attribute name="value"><xsl:value-of select="RemoteHostName"/></xsl:attribute>
					   </xsl:when>
					   <xsl:otherwise>
					      <xsl:attribute name="value"><xsl:value-of select="ServerHostName"/></xsl:attribute>
					   </xsl:otherwise>
				    </xsl:choose>
		       </Data>
				<Data name="Path" editable="false" type="ustring">
				   <xsl:attribute name="display"><xsl:value-of select="$strPath"/></xsl:attribute>
				    <xsl:attribute name="value"><xsl:value-of select="LoggingPath/DCStorageObject/LoggingPath"/></xsl:attribute>
				</Data>
		    </ListData>	
			<xsl:call-template name="Export"/>

		</DataArea>

	</xsl:template>
	<xsl:template name="Export">
		<BottomCustomButton>
			<Data>
				<xsl:variable name="dfltBkPg">./DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cnprin</xsl:variable >
				<xsl:attribute name="href"><xsl:call-template name="BackPage"><xsl:with-param name="defaultBackPage" select="$dfltBkPg"/></xsl:call-template></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
			</Data>
		</BottomCustomButton>
	</xsl:template>
</xsl:stylesheet>
