<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<!-- The adtbl.xsl is used to display a table of array and hard disks with their associated properties. -->
	<!-- This should be used by all webpages which are required to display a table of arrayand hard disks.  -->
	<!-- Having this code in a common file allows for a central location to make updates and add new  -->
	<!-- new fields for array disks which will then be displayed by all web pages as well as the CLI. -->
	<!-- This file is broken down into two main xsl templates.  The TABLE HEADER and the TABLE ROWS. -->
	<!-- Array DISK TABLE HEADER -->

      <xsl:variable name="DisplayIsEncryptionCapablePDColumn">
			<xsl:call-template name="IsCoulmnApplicable">
				<xsl:with-param name="BitPosition">18</xsl:with-param>
                        <xsl:with-param name="ObjectRef" select="//ArrayDisks/DCStorageObject"/>
			</xsl:call-template>
      </xsl:variable>
       <xsl:variable name="DisplayISSecuredPDColumn">
			<xsl:call-template name="IsCoulmnApplicable">
				<xsl:with-param name="BitPosition">17</xsl:with-param>
                        <xsl:with-param name="ObjectRef" select="//ArrayDisks/DCStorageObject"/>
			</xsl:call-template>
      </xsl:variable>
      <xsl:variable name="DisplayISCertifiedPDColumn">
			<xsl:call-template name="IsCoulmnApplicable">
				<xsl:with-param name="BitPosition">19</xsl:with-param>
                        <xsl:with-param name="ObjectRef" select="//ArrayDisks/DCStorageObject"/>
			</xsl:call-template>
      </xsl:variable>
      
      <!--xsl:variable name="VAR_TAPE_LIBRARIES">
                <xsl:choose>
                      <xsl:when test="//MediaType= '4'">true</xsl:when>
                      <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose> 
        </xsl:variable-->
      <xsl:variable name="GLOBAL_VAR_LOCALE"><xsl:value-of select="/OMA/Locale"/></xsl:variable>
      <xsl:variable name="GLOBAL_VAR_CACHEPOOL"><xsl:value-of select="//CachePoolPage"/></xsl:variable>          
       <xsl:variable name="DisplayPredFailure">
			<xsl:call-template name="IsCoulmnApplicable">
				<xsl:with-param name="BitPosition">21</xsl:with-param>
                        <xsl:with-param name="ObjectRef" select="//ArrayDisks/DCStorageObject"/>
			</xsl:call-template>
      </xsl:variable>

     

	<xsl:template name="ArrayDiskTableHeader">
		<xsl:param name="tasks"/>
		<!-- tasks should be either 'true' or 'false' to indicate whether to display the drop-down menu of tasks-->
		<xsl:param name="expanded"/>
            <xsl:param name="IsDHS"/>
		<xsl:param name="changestatus"/>	
		<xsl:param name="GLOBAL_VAR_CACHEPOOL_CLI"/>	
		<xsl:param name="foreignConfig">false</xsl:param>
		<xsl:param name="VDMember">false</xsl:param>
		<xsl:param name="VAR_TAPE_LIBRARIES">false</xsl:param>
		<xsl:call-template name="scripts"/>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        
 
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
            <!-- Changed the call to SmartAlertDetected template as it was not taking all disks object into consideration -->
                             
		
	   
		<Data name="Id" columnspacing="true" editable="false" type="ustring" ignoreonweb="true">
		    <xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
                
                <xsl:if test="(/OMA/@cli = 'true' or //ObjStatus) and $VAR_TAPE_LIBRARIES = 'false'"> 
		<Data name="Status" columnspacing="true" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		</xsl:if>
		
		<Data name="Name" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<xsl:choose>
			<xsl:when test="$foreignConfig='true'">
				<Data name="State" columnspacing="true" editable="false" type="ustring" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strStateBeforeImport"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStateBeforeImport"/></xsl:attribute>
				</Data>
				<Data name="State" columnspacing="true" editable="false" type="ustring" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strStateAfterImport"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStateAfterImport"/></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:when test="(/OMA/@cli = 'true' or //ObjState) and $VAR_TAPE_LIBRARIES= 'false'">                            
		              <Data name="State" columnspacing="true" editable="false" type="ustring" align="left">
			           <xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			           <xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		              </Data>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="((//PDPowerState and $VDMember = 'false') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
		<Data name="PowerStatus" columnspacing="true" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strPowerStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPowerStatus"/></xsl:attribute>
		</Data>
		</xsl:if>
            <!--DeviceName field will be displayed only for PCIe-SSD devices-->
			<xsl:if test="//DeviceName and //BusProtocol='9'">
			<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
			<Data name="BusProtocol" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
			</Data>
		</xsl:if>
		 <xsl:if test="$tasks='true'">
				<Data name="taskslist" columnspacing="true" editable="false" type="ustring" ignoreoncli="true">
				   <!--xsl:if test="$changestatus = 1"-->
				    <xsl:attribute name="noborderright">true</xsl:attribute>
					<!--/xsl:if-->
					<xsl:attribute name="display"><xsl:value-of select="$strTasks"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strTasks"/></xsl:attribute>
				</Data>
				<!--xsl:if test="$changestatus != 1"-->
				<Data name="exbut" columnspacing="true" editable="false" type="ustring" ignoreoncli="true">
					<xsl:attribute name="display"><!--XLATESTART-->Execute<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART--><!--XLATESTOP--></xsl:attribute>
				</Data>
				<!--/xsl:if-->
	    </xsl:if>
		<xsl:if test="//BusProtocol or /OMA/@cli = 'true'">
			<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
			<Data name="BusProtocol" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strType"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//NVMeSpecVerSupported or (//NVMeSpecVerSupported and /OMA/@cli = 'true')">
			<!-- See ifany disk has NVMeSpecVerSupported populated.  If so, show the header for the table -->
			<Data name="NVMeSpecVerSupported" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strDeviceProtocol"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDeviceProtocol"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="($GLOBAL_VAR_CACHEPOOL != '1' and //MediaType) or /OMA/@cli = 'true'">
					<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
					<Data name="MediaType" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMediaType"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMediaType"/></xsl:attribute>
					</Data>
		</xsl:if>
		<xsl:if test="((//BusProtocol='9' and //PartOfCachePool)  or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES = 'false'"><!-- Bus protocl value for PCIe SSD is 9-->
					<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
					<Data name="PartOfCachePool" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strPartOfCachePool"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strPartOfCachePool"/></xsl:attribute>
					</Data>
			</xsl:if>
            <!--xsl:if test="(//DeviceLifeTimeRemaining or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
					< See ifany disk has BusProtocol populated.  If so, show the header for the table >
					<Data name="DeviceLifeTimeRemaining" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strDeviceLifeTimeRemaining"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strDeviceLifeTimeRemaining"/></xsl:attribute>
					</Data>
		</xsl:if!-->
		 <xsl:if test="(//RemainingRatedWriteEndurance  or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
					<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
					<Data name="RemainingRatedWriteEndurance " editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strRemainingRatedWriteEndurance"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strRemainingRatedWriteEndurance"/></xsl:attribute>
					</Data>
		</xsl:if>
             <xsl:if test="(/OMA/@cli = 'true' or contains($DisplayPredFailure,'1')) and $VAR_TAPE_LIBRARIES= 'false' "> 
            <Data name="PredFailure" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strPredFailure"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPredFailure"/></xsl:attribute>
		</Data>
             </xsl:if>		
             <xsl:if test="(/OMA/@cli = 'true' or //Revision) and $VAR_TAPE_LIBRARIES= 'false'"> 
				<xsl:choose>
					<xsl:when test="//BusProtocol and //BusProtocol='9'">
						<Data name="Rev" columnspacing="true" editable="false" type="ustring" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strFWRevision"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFWRevision"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Rev" columnspacing="true" editable="false" type="ustring" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strRevision"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strRevision"/></xsl:attribute>
						</Data>
				</xsl:otherwise>			
				</xsl:choose>
		    </xsl:if>   
            <xsl:if test="//CurrentDriverVersion or /OMA/@cli = 'true'">
					
					<Data name="CurrentDriverVersion" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strDvr"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strDvr"/></xsl:attribute>
					</Data>
		</xsl:if> 
             <!--xsl:if test="(//PCIeSSDDeviceWriteStatus or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
					
					<Data name="PCIeSSDDeviceStatus" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strPCIeSSDDevicesStatus"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strPCIeSSDDevicesStatus"/></xsl:attribute>
					</Data>
		</xsl:if--> 

            <xsl:if test="(//ModelNumber or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
					<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
					<Data name="ModelNumber" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strModelNumber"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strModelNumber"/></xsl:attribute>
					</Data>
		</xsl:if> 
        <xsl:if test="(//PdPICapable or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
					<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
					<Data name="PdPICapable" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strPdPICapable"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strPdPICapable"/></xsl:attribute>
					</Data>
		</xsl:if>     
			
		<xsl:if test="(contains($DisplayISCertifiedPDColumn,'1') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">

			<Data name="IsCertified" columnspacing="true" editable="false" type="ustring" align="left">
				<xsl:attribute name="display"><xsl:value-of select="$strIsCertified"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIsCertified"/></xsl:attribute>
			</Data>
		</xsl:if>
                <HiddenTable>
			<Data >
			<xsl:attribute name="name">BackTo</xsl:attribute>
			<xsl:attribute name="returnvalue"></xsl:attribute>
			</Data>
            	 
		</HiddenTable>
		<!-- isEmpty var used for hiding tasks menu option -->
		<xsl:variable name="isEmpty">
			<xsl:call-template name="IsCurrentMethodMaskEmpty">
				<xsl:with-param name="Mask">
					<xsl:value-of select="CurrentMethodMask"/>
				</xsl:with-param>
			</xsl:call-template>
		 </xsl:variable>
           
		
             <xsl:if test="(not(//IsVirtualDiskSecured= 'Yes') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
                 <xsl:if test="contains($DisplayIsEncryptionCapablePDColumn,'1') or /OMA/@cli = 'true'">
             	<Data name="EncryptionCapable" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strEncryptionCapable"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strEncryptionCapable"/></xsl:attribute>
			</Data>
		</xsl:if>
            <xsl:if test="(contains($DisplayISSecuredPDColumn,'1') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
			<Data name="Secured" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strSecured"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSecured"/></xsl:attribute>
			</Data>
		</xsl:if>      
            </xsl:if>             

		<xsl:if test="(//Progress or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- See if any VDisk has a progress.  If so, show the header for the table -->
			<Data name="Progress" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strProgress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strProgress"/></xsl:attribute>
			</Data>
		</xsl:if>
			 <!-- Mirror Set ID-->		
       	  <xsl:if test="((//MirrorSetID and $VDMember = 'true') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
			<Data name="MirrorSetID" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strMirrorSetID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strMirrorSetID"/></xsl:attribute>
			</Data>
		</xsl:if>		
		<xsl:if test="(//Length or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<!--xsl:if test="$expanded='true'"-->
			<Data name="Capacity" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strCapacity"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strCapacity"/></xsl:attribute>
			</Data>
			<!--/xsl:if-->
		</xsl:if>
		<!--xsl:if test="$nonRaid = '0'"-->
		<!-- Removed for DFCT129383 -->
		<xsl:if test="(//UsedSpace or $dynamicView = 'false')  and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="UsedSpace" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strUsedSpace"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strUsedSpace"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="(//FreeSpace or $dynamicView = 'false')  and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="FreeSpace" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strFreeSpace"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strFreeSpace"/></xsl:attribute>
			</Data>
		</xsl:if>
		<!--/xsl:if-->
		<!-- Loop through each array disk -->
                <xsl:variable name="showHotspareTitle">
                <xsl:choose>
                <xsl:when test="($IsDHS='true' and $foreignConfig='true')or //MediaType = '4' "></xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="//ArrayDisks/DCStorageObject">
				<!-- Just a sanity check to make sure the master method mask xml is there for this object before checking its value -->
				<xsl:if test="AttributesMask">
					<xsl:if test="substring(AttributesMask,23,1 )= '0' or $dynamicView = 'false' ">true</xsl:if>
					<!--xsl:if test="substring(MasterMethodMask, 27, 1) = '1' or substring(MasterMethodMask, 28, 1) = '1'  or $dynamicView = 'false' ">true</xsl:if-->
				</xsl:if>
			</xsl:for-each>
                </xsl:otherwise>
                </xsl:choose>
                </xsl:variable>
		
		<!-- Using the master method mask to determine if ANY disk is capable of being a hotspare. -->
		<!-- Check to see if either the set hotspare or unset hotspare bits are set (one should be set -->
		<!-- at all times if the disk is capable of being a hotspare). -->
		<xsl:if test="($showHotspareTitle != '' or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<Data name="Spare" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strSpare"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSpare"/></xsl:attribute>
			</Data>
		</xsl:if>
		<!--xsl:if test="$expanded='true'"-->
		<Data name="Vendor" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strVendorID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strVendorID"/></xsl:attribute>
		</Data>
		<Data name="ProductID" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strProductID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strProductID"/></xsl:attribute>
		</Data>
		<xsl:if test="//DeviceSerialNumber or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="Serial" columnspacing="true" editable="false" type="ustring" align="left">
				<xsl:attribute name="display"><xsl:value-of select="$strSerial"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSerial"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//PartNo or $dynamicView = 'false'">
			<Data name="PartNo" columnspacing="true" editable="false" type="ustring" align="left">
				<xsl:attribute name="display"><xsl:value-of select="$strPartNo"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPartNo"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="(//NegotiatedSpeed or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<xsl:choose>
				<xsl:when test="//BusProtocol and //BusProtocol='9'">
					<Data name="NegotiatedSpeed " columnspacing="true" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strPCIeNegotiatedLinkSpeed"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strPCIeNegotiatedLinkSpeed"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="NegotiatedSpeed " columnspacing="true" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strNegotiatedSpeed"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNegotiatedSpeed"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="(//CapableSpeed or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<xsl:choose>
				<xsl:when test="//BusProtocol and //BusProtocol='9'">
					<Data name="CapableSpeed " columnspacing="true" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strPCIeMaxLinkSpeed"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strPCIeMaxLinkSpeed"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="CapableSpeed " columnspacing="true" editable="false" type="ustring" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strCapableSpeed"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strCapableSpeed"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		
				
		<xsl:if test="(//NegotiatedLinkWidth or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="NegotiatedLinkWidth" columnspacing="true" editable="false" type="ustring" align="left">
				<xsl:attribute name="display"><xsl:value-of select="$strPCIeNegotiatedLinkWidth"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPCIeNegotiatedLinkWidth"/></xsl:attribute>
			</Data>
		</xsl:if>
		
		<xsl:if test="(//MaxLinkWidth or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="MaxLinkWidth" columnspacing="true" editable="false" type="ustring" align="left">
				<xsl:attribute name="display"><xsl:value-of select="$strPCIeMaxLinkWidth"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPCIeMaxLinkWidth"/></xsl:attribute>
			</Data>
		</xsl:if>
		
		<xsl:if test="(//PdSectorSize  or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="PdSectorSize" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strSectorSize"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSectorSize"/></xsl:attribute>
			</Data>
		</xsl:if>
		
		<!--Uncomment for PI feature--><!--xsl:if test="(//PdPICapable   or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
		
			<Data name="PdPICapable" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strT10Protection"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strT10Protection"/></xsl:attribute>
			</Data>
		</xsl:if-->
		
		<xsl:if test="(//DriveWriteCacheEnabled or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="WriteCache " columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strDiskWriteCache"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDiskWriteCache"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="(//ManufactureDay or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="ManufactureDay" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strManufactureDay"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strManufactureDay"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="(//ManufactureWeek or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="ManufactureWeek" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strManufactureWeek"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strManufactureWeek"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="(//ManufactureYear or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="ManufactureYear" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strManufactureYear"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strManufactureYear"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//SASAddress or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="SASAddress" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strSASAddress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSASAddress"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//DriveReadCache and $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="DriveReadCache" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strDriveReadCache"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDriveReadCache"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//DriveWriteCache and $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="DriveWriteCache" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strDriveWriteCache"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDriveWriteCache"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//SataBridgeVendor">
			<Data name="AltaVendor" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strAltaVendor"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAltaVendor"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//SataBridgeProductID">
			<Data name="AltaProductID" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strAltaProductID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAltaProductID"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//SataBridgeRevision">
			<Data name="AltaRevision" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strAltaRevision"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAltaRevision"/></xsl:attribute>
			</Data>
		</xsl:if>
            
            <xsl:if test="//DriverRevision">
			<Data name="DriverRevision" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strDriverRevision"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDriverRevision"/></xsl:attribute>
			</Data>
		</xsl:if>
            
        </xsl:template>
	<!-- ARRAY DISK TABLE ROWS -->
	<xsl:template name="ArrayDiskTableRows">  
		<xsl:param name="tasks"/>
		<xsl:param name="expanded"/>
		<xsl:param name="changestatus"/>
		<xsl:param name="GLOBAL_VAR_CACHEPOOL_CLI"/>		
		<xsl:param name="VDMember">false</xsl:param>
            <xsl:param name="VAR_TAPE_LIBRARIES">false</xsl:param>
		<xsl:param name="foreignConfig">false</xsl:param>
                 <xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
                <xsl:param name="IsDHS"/>
		<xsl:variable name="showHotspareTitle">
                <xsl:choose>
                <xsl:when test="($IsDHS='true' and $foreignConfig='true')or //MediaType = '4' "></xsl:when>
                <xsl:otherwise>
                        <xsl:for-each select="//ArrayDisks/DCStorageObject">
				        <xsl:if test="AttributesMask"><xsl:if test="substring(AttributesMask,23,1 )= '0'">true</xsl:if></xsl:if>
			</xsl:for-each>
                </xsl:otherwise>
                </xsl:choose>
                </xsl:variable>

		<!-- Check if we need to give a warning to assign GHS -->
		<xsl:variable name="isGHSWarning">
			<xsl:choose>
				<xsl:when test="substring(/OMA/ArrayDisks/@ControllerAttributeMask,13,1)='1'">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
				
		<xsl:call-template name="scripts"/>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
              to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="IsSASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol">
					<xsl:value-of select="BusProtocol"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="IsDiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="PredFailureValue">
			<xsl:call-template name="SmartAlertDetected">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="IsCertified">
			<xsl:call-template name="IsNonDellDriveDetected">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>		
		<xsl:variable name="ADID">
			<xsl:choose>
				<xsl:when test="$IsSASorSATA='1' and $IsDiskInEnclosure='1'">
					<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row height="30px">
			<Data type="ustring" columnspacing="true" align="center" ignoreonweb="true">
						<xsl:attribute name="value"><xsl:value-of select="$ADID"/></xsl:attribute>
			</Data>
                        <xsl:if test="(/OMA/@cli = 'true' or ObjStatus) and  $VAR_TAPE_LIBRARIES = 'false' "> 
                        
			<Data type="status" columnspacing="true" align="center">
                        <xsl:choose>
					<xsl:when test="$GLOBAL_VAR_CACHEPOOL = '1' or $GLOBAL_VAR_CACHEPOOL_CLI = '1'">
						<xsl:attribute name="value"><xsl:value-of select="CacheStoreStatus"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			</xsl:if>
			<Data name="Name" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:choose>
					<!-- check for ad vs hd -->
					<xsl:when test="MediaType='4'">
                                                 <xsl:attribute name="value"><xsl:value-of select="$strTapeLibrary"/><xsl:value-of select="$ADID"/></xsl:attribute>
                                        </xsl:when>
					<xsl:when test="$nonRaid = '1' ">
						<xsl:attribute name="value"><xsl:value-of select="$strDevice"/><xsl:value-of select="$ADID"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strADName"/><xsl:value-of select="$ADID"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			<xsl:choose>
				<xsl:when test="$foreignConfig = 'true'">
					<Data name="State" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
						<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
					<Data name="State" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
						<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="PDAfterImportState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:when test="(ObjState or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
			               <Data name="State" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
			   	             <xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
			               </Data>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="((//PDPowerState and $VDMember = 'false') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
			<xsl:choose>
			<xsl:when test="ObjState != '1024'">
			<Data type="ustring" name="PowerStatus" columnspacing="true" align="center">
				<!--xsl:attribute name="value"><xsl:call-template name="GetPowerStatusIcon"><xsl:with-param name="powerstatus"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute-->
				<xsl:attribute name="value"><xsl:call-template name="GetPowerStatus"><xsl:with-param name="psicon"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			</xsl:when>
			<xsl:otherwise>
			<Data type="ustring" align="center">
					<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
			</Data>
			</xsl:otherwise>
			</xsl:choose>
			</xsl:if>
            <xsl:if test="//DeviceName and //BusProtocol='9'">
				<xsl:choose>
					<xsl:when test="DeviceName">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="DeviceName"/></xsl:attribute>
						</Data>
					</xsl:when>
					<!--Otherwise is not required but left it as it was there in legacy -->
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- isEmpty var used for hiding tasks menu option 
			     2nd redefinition. The first definition above seems to not be picked up. -->
			<xsl:variable name="isEmpty">
				<xsl:call-template name="IsCurrentMethodMaskEmpty">
					<xsl:with-param name="Mask">
						<xsl:value-of select="CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
                        <xsl:variable name="IsPDEncryptionCapable"><xsl:call-template name="IsDiskSecured"><xsl:with-param name="Mask"><xsl:value-of select="AttributesMask"/></xsl:with-param></xsl:call-template></xsl:variable>
			<xsl:if test="$tasks='true'">
				<!--check to see if methods even exist -->
				<xsl:choose>
					<xsl:when test="$isEmpty='0'">
						<!-- currentmethod mask isn't empty -->
						<Data value="tasks" columnspacing="true" display="Array Disks Tasks" type="select" ignoreoncli="true">
							<xsl:attribute name="display"><xsl:value-of select="$strADTasks"/></xsl:attribute>
							<xsl:attribute name="name">ADtasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<!--xsl:if test="$changestatus = 1"-->
				                <xsl:attribute name="noborderright">true</xsl:attribute>
					        <!--/xsl:if-->
							<xsl:choose>
						       <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de')) or (starts-with($GLOBAL_VAR_LOCALE, 'ja'))">
							       <xsl:attribute name="width">width:300px</xsl:attribute>
							   </xsl:when>
						     <xsl:otherwise>
						           <xsl:attribute name="width">width:180px</xsl:attribute>
						     </xsl:otherwise>
					        </xsl:choose>	
							<Choice returnvalue="-" default="true">
								<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
							</Choice>
							<xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="CurrentMethodMask"/>
								<xsl:with-param name="templateName" select="10"/>
                                                <xsl:with-param name="BusProtocol" select="BusProtocol"/>
							</xsl:call-template>
							<!--xsl:if test="$changestatus != 1">
							  <ExtraItem type="button">
							      <xsl:attribute name="href">javascript:onExecute(\"Physical Disk <xsl:value-of select="$ADID"/>\",\"<xsl:value-of select="$ObjID"/>\",\"<xsl:value-of select="PDPowerState"/>\");</xsl:attribute>
							      <xsl:attribute name="display"><xsl:value-of select="$strExecute"/></xsl:attribute>
							      <xsl:attribute name="tablebutton">true</xsl:attribute> 
								 
								  
								   
								  
					          </ExtraItem>
							</xsl:if-->
						</Data>
						<!--xsl:if test="$changestatus = 1"-->
						<Data type="button">
							<xsl:attribute name="display"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="id"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="href">javascript:onExecute(\"Physical Disk <xsl:value-of select="$ADID"/>\",\"<xsl:value-of select="$ObjID"/>\",\"<xsl:value-of select="PDPowerState"/>\",\"<xsl:value-of select="$IsPDEncryptionCapable"/>\");</xsl:attribute>
							 <xsl:attribute name="tablebutton">true</xsl:attribute> 
							 
							<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
						</Data>	
						<!--/xsl:if-->
					</xsl:when>
					<xsl:otherwise>
						<!-- currentmethod mask is empty -->
						<Data value="tasks" columnspacing="true" type="select" ignoreoncli="true" noborderright="true">
							<xsl:attribute name="display"><xsl:value-of select="$strADTasks"/></xsl:attribute>
							<xsl:attribute name="name">ADtasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<xsl:choose>
						       <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de')) or (starts-with($GLOBAL_VAR_LOCALE, 'ja'))">
							       <xsl:attribute name="width">width:300px</xsl:attribute>
							   </xsl:when>
						     <xsl:otherwise>
						           <xsl:attribute name="width">width:180px</xsl:attribute>
						     </xsl:otherwise>
					        </xsl:choose>	
							<Choice returnvalue="" default="true">
								<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
							</Choice>
						</Data>
						<!--xsl:if test="$changestatus = 1"-->
						<!-- BITS040174: Introducing a new type 'skipSubtable'; for this type, sub table data will not be displayed. Note: sub table data appears on expanding Physical disks info by clicking on '+' -->
						<Data type="skipSubtable" columnspacing="true" name="execute" link="false">
							<xsl:attribute name="value"></xsl:attribute>
						</Data>
						<!--/xsl:if-->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//BusProtocol or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="BusProtocol">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:call-template name="GetBusProtocol"><xsl:with-param name="Bus"><xsl:value-of select="BusProtocol"/></xsl:with-param><xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//NVMeSpecVerSupported or (//NVMeSpecVerSupported and /OMA/@cli = 'true')">
				<Data type="ustring" align="center">
					<xsl:attribute name="value"><xsl:value-of select="NVMeSpecVerSupported"/></xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="($GLOBAL_VAR_CACHEPOOL != '1' and //MediaType) or /OMA/@cli = 'true'">
							<xsl:choose>
								<xsl:when test="MediaType">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:call-template name="GetMediaType"><xsl:with-param name="MediaType"><xsl:value-of select="MediaType"/></xsl:with-param></xsl:call-template></xsl:attribute>
									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>
			</xsl:if>
                    
                        <xsl:if test="((//BusProtocol='9' and //PartOfCachePool) or /OMA/@cli = 'true')and $VAR_TAPE_LIBRARIES= 'false'"> <!-- RNA -->
                                    <Data editable="false" type="ustring" display="Test" align="center">
                                         <xsl:attribute name="name"><xsl:value-of select="$strFluidCacheEnabled"/><xsl:value-of select="position()"/></xsl:attribute>
  					<xsl:attribute name="value"><xsl:choose><xsl:when test="PartOfCachePool"><xsl:call-template name="GetFluidCacheDeviceState"><xsl:with-param name="state"><xsl:value-of select="PartOfCachePool"/></xsl:with-param></xsl:call-template></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
		
            	                  </Data>

			</xsl:if>
                  <!--xsl:if test="(//DeviceLifeTimeRemaining or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
								<xsl:choose>
								<xsl:when test="DeviceLifeTimeRemaining">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="DeviceLifeTimeRemaining"/>%</xsl:attribute>

									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>
							
			</xsl:if-->
			  <xsl:if test="(//RemainingRatedWriteEndurance or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
								<xsl:choose>
								<xsl:when test="RemainingRatedWriteEndurance">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="RemainingRatedWriteEndurance"/>%</xsl:attribute>

									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>
							
			</xsl:if>
                        
                        <xsl:if test="(/OMA/@cli = 'true' or contains($DisplayPredFailure,'1'))  and $VAR_TAPE_LIBRARIES= 'false'"> 
			<Data name="PredFailure" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:choose>
					<!-- check for ad vs hd -->
					<xsl:when test="$PredFailureValue= '1' ">
						<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			     </Data>
                            </xsl:if> 
                           <xsl:if test="(/OMA/@cli = 'true' or //Revision)and $VAR_TAPE_LIBRARIES= 'false'"> 
			   <Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
			  	   <xsl:attribute name="value"><xsl:value-of select="Revision"/></xsl:attribute>
			    </Data>
                           </xsl:if> 
                  <xsl:if test="//CurrentDriverVersion or /OMA/@cli = 'true'">
								<xsl:choose>
								<xsl:when test="CurrentDriverVersion">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="CurrentDriverVersion"/></xsl:attribute>

									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>							
			</xsl:if>
                 
                  <!--xsl:if test="(//PCIeSSDDeviceWriteStatus or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
								<xsl:choose>
								<xsl:when test="PCIeSSDDeviceWriteStatus">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:call-template name="PCIeSSDDevicesStatusDesc"><xsl:with-param name="PCIeSSDDeviceWriteStatus"><xsl:value-of select="PCIeSSDDeviceWriteStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>							
			</xsl:if-->


                  <xsl:if test="(//ModelNumber or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
								<xsl:choose>
								<xsl:when test="ModelNumber">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="ModelNumber"/></xsl:attribute>

									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>							
			</xsl:if>
			    
				  <xsl:if test="(//PdPICapable  or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
								<xsl:choose>
								<xsl:when test="PdPICapable = '1' ">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>

									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>							
			</xsl:if>
				
				
                 <xsl:if test="(contains($DisplayISCertifiedPDColumn,'1') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="substring(AttributesMask,19,1)='1'">
						<Data name="IsCertified" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
							<xsl:choose>
								<xsl:when test="$IsCertified = '1' ">
									<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
						    <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>  
					</xsl:otherwise>
                        </xsl:choose>
			</xsl:if>			
			
			
               <xsl:if test="(not(//IsVirtualDiskSecured= 'Yes') or VDMember='False' or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
                   <xsl:if test="contains($DisplayIsEncryptionCapablePDColumn,'1') or /OMA/@cli = 'true'">
				<Data type="ustring" align="center">
                        <xsl:attribute name="value">
                        <xsl:choose>
                           <xsl:when test="contains($DisplayIsEncryptionCapablePDColumn,'1')">
                            <xsl:call-template name="IsDiskEncryptionCapable"><xsl:with-param name="Mask"><xsl:value-of select="AttributesMask"/></xsl:with-param></xsl:call-template>
                           </xsl:when>
                           <xsl:otherwise>
                           <xsl:value-of select="$strNo"/>
                           </xsl:otherwise>
                         </xsl:choose>
                         </xsl:attribute> 
                        </Data>			
			</xsl:if>
                  <xsl:if test="(contains($DisplayISSecuredPDColumn,'1') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<Data type="ustring" align="center">
				<xsl:attribute name="value"><xsl:call-template name="IsDiskSecured"><xsl:with-param name="Mask"><xsl:value-of select="AttributesMask"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
			</xsl:if>
                  </xsl:if>
			<xsl:if test="(//Progress or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="Progress">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="Progress"/><xsl:value-of select="$strPercComp"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:when test="/OMA/@cli = 'true'">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"/>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
                        
						<!--Mirror Set ID-->
			<xsl:if test="((//MirrorSetID and $VDMember = 'true') or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="MirrorSetID">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="MirrorSetID"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- ************************************* -->
			<!-- CAPACITY (LENGTH) COLUMN -->
			<xsl:if test="(//Length or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false' ">
				<!-- Check to see if ANY of the objects have the XML tag.  If so, then the header will be displayed, so populate the value here -->
				<xsl:choose>
					<!-- The column will be displayed so check to see if THIS object has the XML tag. -->
					<xsl:when test="Length">
						<!-- The tag exists, so display the value -->
						<!--xsl:if test="$expanded='true'"-->
						<xsl:choose>
							<xsl:when test="/OMA/@cli='true'">
								<!-- CLI Versions of the length data (displays bytes as well as GB)  -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="Length"/> bytes)</xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<!-- Web Versions of the length data (ONLY displays GB) -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- ***************************** -->
			<!-- USED SPACE COLUMN -->
			<xsl:if test="(//UsedSpace or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false' ">
				<xsl:choose>
					<xsl:when test="/OMA/@cli='true'">
						<!-- CLI Versions of the length data (displays bytes as well as GB)  -->
						<xsl:choose>
							<xsl:when test="UsedSpace">
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="UsedSpace"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="UsedSpace"/> bytes)</xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="$nonRaid != '0'">
							<!-- Changed for DFCT129383 -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
							</xsl:when>							
							<xsl:otherwise>
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Web Versions of the length data (ONLY displays GB) -->
						<xsl:choose>
							<xsl:when test="UsedSpace">
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="UsedSpace"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="$nonRaid != '0'">
							<!-- Changed for DFCT129383 -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!--/xsl:if-->
			<!-- ***************************** -->
			<!-- FREE SPACE COLUMN -->
			<xsl:if test="(//FreeSpace or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="/OMA/@cli='true'">
						<!-- CLI Versions of the length data (displays bytes as well as GB)  -->
						<xsl:choose>
							<xsl:when test="FreeSpace">
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="FreeSpace"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="FreeSpace"/> bytes)</xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="$nonRaid != '0'">
								<!-- Changed for DFCT129383 -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Web Versions of the length data (ONLY displays GB) -->
						<xsl:choose>
							<xsl:when test="FreeSpace">
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="FreeSpace"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="$nonRaid != '0'">
								<!-- Changed for DFCT129383 -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="($showHotspareTitle != ''  or $dynamicView = 'false') and $VAR_TAPE_LIBRARIES= 'false'">
				<!-- Using the attributes mask to determine if THIS disk is capable of being a hotspare. -->
				<xsl:choose>
					<xsl:when test=" $nonRaid = '1' ">
						<!-- This takes care of the case when the disk is not capable of being a hotspare at any time.  i.e. Non-RAID -->
						<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:call-template name="GetSpareInfoForArrayDisk"><xsl:with-param name="AttribsMask"><xsl:value-of select="AttributesMask"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:value-of select="Vendor"/></xsl:attribute>
			</Data>
			<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:value-of select="ProductID"/></xsl:attribute>
			</Data>
			
			<xsl:if test="//DeviceSerialNumber or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="DeviceSerialNumber">
						<Data type="ustring" align="left">
							<xsl:attribute name="value"><xsl:value-of select="DeviceSerialNumber"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//PartNo or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="PartNo">
						<Data type="ustring" align="left">
							<xsl:attribute name="value"><xsl:value-of select="PartNo"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="(//NegotiatedSpeed or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="NegotiatedSpeed and NegotiatedSpeed>0">
						<xsl:choose>
							<xsl:when test="//BusProtocol and //BusProtocol='9' and /OMA/ArrayDisks/DCStorageObject/IsDeviceNVME and /OMA/ArrayDisks/DCStorageObject/IsDeviceNVME = '1'">
								<Data type="ustring" align="center">
									<xsl:attribute name="value"><xsl:value-of select="format-number((NegotiatedSpeed div (10)),'#,##0.0')"/>
										<xsl:text> </xsl:text><xsl:value-of select="$strGTPerSec"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data type="ustring" align="center">
									<xsl:attribute name="value"><xsl:value-of select="format-number((NegotiatedSpeed div (1024)),'#,##0.00')"/>
										<xsl:text> </xsl:text><xsl:value-of select="$strGbps"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="NegotiatedSpeed and NegotiatedSpeed = '0'">
						<Data type="ustring" align="center">
							<xsl:attribute name="value">0</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="(//CapableSpeed or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="CapableSpeed and CapableSpeed>0">
						<xsl:choose>
							<xsl:when test="//BusProtocol and //BusProtocol='9' and /OMA/ArrayDisks/DCStorageObject/IsDeviceNVME and /OMA/ArrayDisks/DCStorageObject/IsDeviceNVME = '1'">
								<Data type="ustring" align="center">
									<xsl:attribute name="value"><xsl:value-of select="format-number((CapableSpeed div (10)),'#,##0.0')"/>
										<xsl:text> </xsl:text><xsl:value-of select="$strGTPerSec"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data type="ustring" align="center">
									<xsl:attribute name="value"><xsl:value-of select="format-number((CapableSpeed div (1024)),'#,##0.00')"/>
										<xsl:text> </xsl:text><xsl:value-of select="$strGbps"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="CapableSpeed and CapableSpeed = '0'">
						<Data type="ustring" align="center">
							<xsl:attribute name="value">0</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="(//NegotiatedLinkWidth or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="NegotiatedLinkWidth">
						<Data type="ustring" align="left">
							<xsl:attribute name="value"><xsl:value-of select="$strX"/><xsl:value-of select="NegotiatedLinkWidth"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="(//MaxLinkWidth or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="MaxLinkWidth">
						<Data type="ustring" align="left">
							<xsl:attribute name="value"><xsl:value-of select="$strX"/><xsl:value-of select="MaxLinkWidth"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="(//PdSectorSize  or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
								<xsl:when test="PdSectorSize">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:call-template name="GetSectorSize"><xsl:with-param name="SectorSize"><xsl:value-of select="PdSectorSize"/></xsl:with-param></xsl:call-template></xsl:attribute>
									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>
			
			</xsl:if>
			<!--Uncomment for PI feature--><!--xsl:if test="(//PdPICapable  or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
								<xsl:when test="PdPICapable">
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:call-template name="GetPIData"><xsl:with-param name="PICapable"><xsl:value-of select="PdPICapable"/></xsl:with-param></xsl:call-template></xsl:attribute>
									</Data>
								</xsl:when>
								<xsl:otherwise>
									<Data type="ustring" align="center">
										<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
									</Data>
								</xsl:otherwise>
							</xsl:choose>
			
			</xsl:if-->
		
			<xsl:if test="(//DriveWriteCacheEnabled or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="DriveWriteCacheEnabled">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:call-template name="GetDiskWriteCache"><xsl:with-param name="DiskWriteCache"><xsl:value-of select="DriveWriteCacheEnabled"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="(//ManufactureDay or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="ManufactureDay">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="ManufactureDay"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="(//ManufactureWeek or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="ManufactureWeek">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="ManufactureWeek"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="(//ManufactureYear or /OMA/@cli = 'true') and $VAR_TAPE_LIBRARIES= 'false'">
				<xsl:choose>
					<xsl:when test="ManufactureYear">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="ManufactureYear"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//SASAddress or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="SASAddress">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="SASAddress"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//DriveReadCache and /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="DriveReadCache">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:call-template name="GetDiskCachePolicy"><xsl:with-param name="DiskCachePolicy"><xsl:value-of select="DriveReadCache"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//DriveWriteCache and /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="DriveWriteCache">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:call-template name="GetDiskCachePolicy"><xsl:with-param name="DiskCachePolicy"><xsl:value-of select="DriveWriteCache"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//SataBridgeVendor">
				<xsl:choose>
					<xsl:when test="SataBridgeVendor">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="SataBridgeVendor"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//SataBridgeProductID">
				<xsl:choose>
					<xsl:when test="SataBridgeProductID">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="SataBridgeProductID"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//SataBridgeRevision">
				<xsl:choose>
					<xsl:when test="SataBridgeRevision">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="SataBridgeRevision"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
                 
                  <xsl:if test="//DriverRevision">
				<xsl:choose>
					<xsl:when test="DriverRevision">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="DriverRevision"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>

			</Row>
             
		<script language="javascript">
			function onExecute(name, oid, pwrstate, IsPDEncryptionCapable) {
                        
                                var help_Topic="";
                                <xsl:if test="//BusProtocol =  '9'">
                                    helpTopic="";
                                </xsl:if>
				var ADtasks = "ADtasks" + oid;
				var action = document.getElementById(ADtasks).value;
				var fromVDpage = '<xsl:value-of select="$VDMember"/>';
				var ADExecuteUrl = "./SubmitForm?plugin=com.dell.sm.webplugins.ADExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=" + oid + "&amp;ADiskName=" + name + "&amp;Action="+ action + "&amp;help=adprin";
				var ADConfirmUrl = "./DataArea?plugin=com.dell.sm.webplugins.ConfirmADActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=" + oid + "&amp;ADiskName=" + name + "&amp;Action="+ action;
				var ADExecuteLogUrl = "./DataArea?plugin=com.dell.sm.webplugins.CtrlExportLogWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=" + oid + "&amp;ADiskName=" + name + "&amp;Action="+ action;

      // Actions
      // 1 - blink
      // 2 - unblink
      // 4 - diagnostics
      // 8 - cancel diags
      // 16 - assign global hotspare
      // 32 - unassign global hotspare
      // 64 - online
      // 128 - offline
      // 256 - prepare to remove
      // 512 - format
      // 1024 - rebuild
      // 2048 - cancel rebuild
      // 4096 - initialize
      // 8192 - verify
      // 16384 - cancel verify
      // 32768 - recover
      // 524288 - cancel copyback
      // 2097152 - Erase a Secure Disk
      // 33554432 - Disable Disk Write Cache
      // 16777216 - Enable Disk Write Cache
      // 67108864  - Export Disk Reliability Log
      // 134217728 RNA Task 1 - Add to Cache Pool
      // 268435456 RNA Task 2 - Remove from Cache Pool
      // 536870912 RNA Tasks 3 -  Reactivate 
      var CurrentUrl=GetLocalUrl();

      if (fromVDpage == 'true')
      {
      ADExecuteUrl = ADExecuteUrl + "&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VirtualDiskName=<xsl:value-of select="/OMA/VirtualDiskName"/>&amp;RaidLayout=<xsl:value-of select="/OMA/RaidLayout"/>&amp;VDMemberPage=true";

					ADConfirmUrl = ADConfirmUrl + "&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VirtualDiskName=<xsl:value-of select="/OMA/VirtualDiskName"/>&amp;RaidLayout=<xsl:value-of select="/OMA/RaidLayout"/>&amp;VDMemberPage=true";
				}
				else
				{      
                                        
					ADExecuteUrl = ADExecuteUrl + "&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>";
					ADConfirmUrl = ADConfirmUrl + "&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>";
					ADExecuteLogUrl = ADExecuteLogUrl + "&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>";
				}

				if (action == "-") { 
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
      }
      else if ((action =="1") || (action =="2") || (action =="4") || (action =="8") || (action =="32")  || (action =="512") || (action =="1024") || (action =="2048") || (action =="4096") || (action =="8192") || (action =="16384") || (action =="32768") || (action =="524288") || (action =="4194304") || (action =="8388608") || (action =="16777216") || (action =="33554432") || (action == "134217728") || (action == "268435456") || (action == "536870912")) 
      {
           var Temp_ADExecuteUrl = "./SubmitForm?plugin=com.dell.sm.webplugins.ADExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=" + oid + "&amp;ADiskName=" + name + "&amp;Action="+ action;
  
           if( (action == "134217728") &amp;&amp; (confirm("<xsl:value-of select="$strConfirmAddToCachePool"/>") == false))
           {
              return;
           }
           if( action == "268435456" ) // remove from cache pool 
           {         
               <xsl:choose>
                  <xsl:when test="(count(//ArrayDisks/DCStorageObject[PartOfCachePool = '1'])= 2)">
                          message = "<xsl:value-of select="$strHighAvailablityWarning"/>";
                  </xsl:when>
                  <xsl:otherwise>
                          message = "<xsl:value-of select="$strConfirmRemoveFromCachePool"/>";
                  </xsl:otherwise> 
              </xsl:choose>
                if(confirm(message)== false)
                {
                    return;
                }
           }
          
           var Temp_ADExecuteUrl = "./SubmitForm?plugin=com.dell.sm.webplugins.ADExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=" + oid + "&amp;ADiskName=" + name + "&amp;Action="+ action;
  
           if(document.getElementById("BackTo")!=null)
           {
               document.getElementById("BackTo").value='<xsl:value-of select="/OMA/BackTo"/>';
           }
            if(((action =="4194304") || (action =="8388608")) &amp;&amp; pwrstate == '1')
               { 
				   alert("<xsl:value-of select="$strDataWarningLevel4"/>");
               }
            helpTopic="adprin";
            <xsl:if test="//BusProtocol =  '9'">
              if((action =="1") || (action =="2"))
              {
                 helpTopic="adpcitkbu";
              }
              
            </xsl:if>
        
             document.dataarea.action = top.gnv.appendVID(Temp_ADExecuteUrl+"&amp;help="+helpTopic+"&amp;CurrentUrl="+CurrentUrl);
					document.dataarea.submit();
	}
	else if(action =="67108864")
	{ 
				  if(document.getElementById("BackTo")!=null)
                  {
                        document.getElementById("BackTo").value='<xsl:value-of select="/OMA/BackTo"/>';
                  }
                                helpTopic="adprin";
                                <xsl:if test="//BusProtocol =  '9'">
                                    helpTopic="adpcitkel";
                                </xsl:if>
                     
					// NVME - 101
					// PCIeSSD - 102
					var DeviceType=0;
                    			<xsl:choose>
						<xsl:when test="(/OMA/ArrayDisks/DCStorageObject/IsDeviceNVME and /OMA/ArrayDisks/DCStorageObject/IsDeviceNVME = '1')">
							DeviceType=101;
						</xsl:when>
						<xsl:otherwise> 
							DeviceType=102;
						</xsl:otherwise>
					</xsl:choose>             
					document.dataarea.action = top.gnv.appendVID(ADExecuteLogUrl+"&amp;help="+helpTopic+"&amp;DeviceType="+DeviceType+"&amp;CurrentUrl="+CurrentUrl);
					document.dataarea.submit();
	}
	else if (action =="16")
      {

				  //assign global hotspare

          if (fromVDpage == 'true')
          { 
             if (document.getElementById("BackTo")!=null)
             {
                document.getElementById("BackTo").value='<xsl:value-of select="/OMA/BackTo"/>';
             }
             document.dataarea.action = top.gnv.appendVID(ADExecuteUrl + "&amp;Force=true&amp;FromVD=true&amp;CurrentUrl="+CurrentUrl); 
             document.dataarea.submit();
          }
          else
          {
					    //do a check for controllers that needs extra confirm page
              var giveghswarning = <xsl:value-of select="$isGHSWarning"/>;
              
              if(giveghswarning == 0)
              {
                 if(document.getElementById("BackTo")!=null)
                 {
                    document.getElementById("BackTo").value=CurrentUrl;
                 }
				 
				 if((pwrstate == '1'))
				 { 
				   alert("<xsl:value-of select="$strDataWarningLevel4"/>");
				   document.dataarea.action = top.gnv.appendVID(ADExecuteUrl + "&amp;Force=false&amp;CurrentUrl="+CurrentUrl); 
                   document.dataarea.submit();
				  
				 }
				 else
				 {
				   document.dataarea.action = top.gnv.appendVID(ADExecuteUrl + "&amp;Force=false&amp;CurrentUrl="+CurrentUrl); 
                   document.dataarea.submit();
				 }
              }
              else
              { 
                 document.location.href = top.gnv.appendVID(ADConfirmUrl + "&amp;help=adtkghs"+"&amp;BackTo="+CurrentUrl+"&amp;CurrentUrl="+CurrentUrl);
              }
          }
      }
      else if ((action =="64") || (action =="128")) {
        // online or offline
          
              var CurrentUrl=GetLocalUrl(); 
               if(document.getElementById("BackTo")!=null)
                        {
                        document.getElementById("BackTo").value=CurrentUrl;
                        }
                        
            document.dataarea.action = top.gnv.appendVID(ADConfirmUrl + "&amp;help=adtkonl&amp;BackTo="+CurrentUrl);
            document.dataarea.submit();
      }
      else if (action =="256") {
      // prepare to remove
         var CurrentUrl=GetLocalUrl(); 
         helpTopic="adprin";
         <xsl:if test="//BusProtocol =  '9'">
               helpTopic="adpcitkptr";
         </xsl:if>
               document.location.href = top.gnv.appendVID(ADConfirmUrl + "&amp;help="+helpTopic+"&amp;BackTo="+CurrentUrl);
      }
       else if ( (action =="65536") || (action =="131072") || (action =="2097152") ) 
       { 
			// Erase a Secure Disk (bus protocol =9) or full initialization - 2097152
                                 helpTopic="adtkclr";
                                                            
                                if( action == "2097152")
                                {
				 if(IsPDEncryptionCapable != "Not Applicable")
					{
					   helpTopic="adtkiee";
					}
                    <xsl:if test="//BusProtocol =  '9'">
				       <xsl:choose>
					      <xsl:when test="(/OMA/ArrayDisks/DCStorageObject/IsDeviceNVME and /OMA/ArrayDisks/DCStorageObject/IsDeviceNVME = '1')">
						     helpTopic="cryptersnvm";
					      </xsl:when>
					      <xsl:otherwise>
						     helpTopic="adpcitkfi";
					      </xsl:otherwise>
				       </xsl:choose>
                    </xsl:if>
                                 }
                                 var CurrentUrl=GetLocalUrl(); 
					//clear or cancelclear or Secure Erase a Disk
          				document.location.href = top.gnv.appendVID(ADConfirmUrl + "&amp;help="+helpTopic+"&amp;BackTo="+CurrentUrl);	
                                        
				}

				else {
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
				}
			}
		</script>
	</xsl:template>
       
</xsl:stylesheet>
