<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Array Disks Information page.  The associated web plugin is the ADInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
      <xsl:import href="fluidcachetbl.xsl"/>
       <xsl:variable name="GLOBAL_VAR_CACHEPOOL"><xsl:value-of select="//CachePoolPage"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_TAPE_LIBRARIES">
                <xsl:choose>
                      <xsl:when test="//MediaType= '4'">true</xsl:when>
                      <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose> 
		</xsl:variable>		
      <xsl:variable name="GLOBAL_VAR_BUSPROTOCOL"><xsl:value-of select="//BusProtocol"/></xsl:variable>
	<xsl:template match="OMA">
		<!-- check to see if AD or HD should be visible -->
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="ArrayDisks/DCStorageObject/AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		 
                
                 <!-- CachePoolPage =1 is yes -->
		<script language="javascript">
		var changeStatus = 0;
	  function initializationRoutine()
	  { 
	    
	  }	  	
		
      function reloadPage()
      {
          document.location.href = top.gnv.appendVID(document.URL);
      }
	  
	  function OnOperationBasicSelected()
      {  var TapeLibraries =false;
         var HelpTopic = "adprin"; 
		<xsl:if test="//MediaType= '4'">
               TapeLibraries =true;
               HelpTopic = "tapelib";
         </xsl:if> 
		 changeStatus = 0;
                <xsl:choose>
                    <xsl:when test="$GLOBAL_VAR_CACHEPOOL = '1'">
                        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.FluidCachePoolInfoWebPlugin&amp;CachePoolPage=1&amp;ChangeStatus="+changeStatus+"&amp;Return=true&amp;help=fldcpol");       
                    </xsl:when>
					<xsl:when test="//MediaType= '4'">
                        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ChangeStatus="+changeStatus+"&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;Return=true&amp;TapeLibraries="+TapeLibraries+"&amp;help="+HelpTopic);       
                    </xsl:when>                    
                    <xsl:otherwise>
                        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ChangeStatus="+changeStatus+"&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;Return=true&amp;help=adprin");       
                    </xsl:otherwise>
                </xsl:choose>
           
              
           
		
	  }	
	  
	  function OnOperationAdvanceSelected()
	  {
	     var TapeLibraries =false;
         var HelpTopic = "adprin"; 
		<xsl:if test="//MediaType= '4'">
               TapeLibraries =true;
               HelpTopic = "tapelib";
         </xsl:if> 
	   	changeStatus = 1;
                <xsl:choose>
                    <xsl:when test="$GLOBAL_VAR_CACHEPOOL = '1'">
                        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.FluidCachePoolInfoWebPlugin&amp;CachePoolPage=1&amp;ChangeStatus="+changeStatus+"&amp;Return=true&amp;help=adprin");       
                    </xsl:when>
					<xsl:when test="//MediaType= '4'">
                        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ChangeStatus="+changeStatus+"&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;Return=true&amp;TapeLibraries="+TapeLibraries+"&amp;help="+HelpTopic);       
                    </xsl:when> 
                    <xsl:otherwise>
                        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ChangeStatus="+changeStatus+"&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;Return=true&amp;help=adprin");              
                    </xsl:otherwise>
                </xsl:choose>
		
	  }
    </script>
		
		<DataArea backpagetarget="./DataArea?plugin=com.dell.sm.webplugins.ControllerWebPlugin" onLoad="true" ignoreJumpBar="true">
			<PageTitle>
				<xsl:choose>
					<xsl:when test="$nonRaid = '1' ">
						<xsl:choose>
							<xsl:when test="ArrayDisks/@ControllerName=''">
								<xsl:choose>
									<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
										<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle1a"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ArrayDisks/@ControllerName!=''">							
								<xsl:choose>
									<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
											<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
								 <xsl:choose>
								  <xsl:when test="$GLOBAL_VAR_TAPE_LIBRARIES = 'true'">								
								     <xsl:attribute name="display"><xsl:value-of select="$strTapeTitlePart1"/><xsl:value-of select="ArrayDisks/@ControllerName"/><xsl:value-of select="$strTapeTitlePart2"/></xsl:attribute>
								  </xsl:when>
								  
								  <xsl:when test="$GLOBAL_VAR_BUSPROTOCOL != '9'">								
								     <xsl:attribute name="display"><xsl:value-of select="$strTitle2aPart1"/><xsl:value-of select="ArrayDisks/@ControllerName"/><xsl:value-of select="$strTitle2aPart2"/></xsl:attribute>
								  </xsl:when>
                                                                          
								  <xsl:otherwise>
                                      <xsl:attribute name="display"><xsl:value-of select="$strPCIeSSDTitle2Part1"/><xsl:value-of select="ArrayDisks/@ControllerName"/><xsl:value-of select="$strPCIeSSDTitle2Part2"/></xsl:attribute>
        						  </xsl:otherwise>
								</xsl:choose>
			
							</xsl:when>
							<xsl:when test="$GLOBAL_VAR_CACHEPOOL = '1'">								
                                                                             <xsl:attribute name="display"><xsl:value-of select="$strFluidCachePoolTitle"/></xsl:attribute>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="ArrayDisks/@ControllerName=''">
								<xsl:choose>
									<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
											<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ArrayDisks/@ControllerName!=''">
								<xsl:choose>
									<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
											<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>					
                                <xsl:choose>
                                                                  <xsl:when test="$GLOBAL_VAR_TAPE_LIBRARIES = 'true'">								
								     <xsl:attribute name="display"><xsl:value-of select="$strTapeTitlePart1"/><xsl:value-of select="ArrayDisks/@ControllerName"/><xsl:value-of select="$strTapeTitlePart2"/></xsl:attribute>
								  </xsl:when>
								  
								  <xsl:when test="$GLOBAL_VAR_BUSPROTOCOL != '9'">								
								     <xsl:attribute name="display"><xsl:value-of select="$strTitle2aPart1"/><xsl:value-of select="ArrayDisks/@ControllerName"/><xsl:value-of select="$strTitle2aPart2"/></xsl:attribute>
								  </xsl:when>
                                                                  <xsl:when test="$GLOBAL_VAR_BUSPROTOCOL = '1'">								
								     <xsl:attribute name="display"><xsl:value-of select="$strFluidCachePoolTitle"/></xsl:attribute>
								  </xsl:when>
								  <xsl:otherwise>
                                      <xsl:attribute name="display"><xsl:value-of select="$strPCIeSSDTitle2Part1"/><xsl:value-of select="ArrayDisks/@ControllerName"/><xsl:value-of select="$strPCIeSSDTitle2Part2"/></xsl:attribute>
        						  </xsl:otherwise>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
                                        <xsl:choose>
                                            <xsl:when test="$GLOBAL_VAR_CACHEPOOL = '1'">
                                                     <xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.FluidCachePoolInfoWebPlugin&amp;CachePoolPage=1&amp;Return=true&amp;help=fldcpol</xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
													<xsl:choose>
															<xsl:when test="$GLOBAL_VAR_TAPE_LIBRARIES = 'true'"><xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;TapeLibraries=<xsl:value-of select="$GLOBAL_VAR_TAPE_LIBRARIES"/>&amp;Return=true&amp;help=tapelib</xsl:attribute></xsl:when>
															<xsl:otherwise><xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;TapeLibraries=<xsl:value-of select="$GLOBAL_VAR_TAPE_LIBRARIES"/>&amp;Return=true&amp;help=adprin</xsl:attribute></xsl:otherwise>
													</xsl:choose>
                                            </xsl:otherwise>
                                        </xsl:choose>
					
				</Data>
			</CustomButton>
			 <!--xsl:if test="(count(ArrayDisks/DCStorageObject[PartOfCachePool = '0']) > 0) and $GLOBAL_VAR_CACHEPOOL = '1'">
                            <CustomButton>
                               
                                        <Data type="button" formSubmit="true">
							 <xsl:attribute name="display"><xsl:value-of select="$strAddDevicesToCachePool"/></xsl:attribute>
							 <xsl:attribute name="href">javascript:onAddDevicesToCachePool();</xsl:attribute>
                                        </Data>
                            </CustomButton>
                          </xsl:if-->      
                       
                        <CustomButton align="left">
						<Data formSubmit="true">
							<xsl:attribute name="display"><xsl:value-of select="$strBasicView"/></xsl:attribute>
							<xsl:attribute name="href">javascript:OnOperationBasicSelected()</xsl:attribute>
						</Data>
			</CustomButton>
            <CustomButton align="left">
						<Data formSubmit="true"><xsl:attribute name="display"><xsl:value-of select="$strFullView"/></xsl:attribute>
							<xsl:attribute name="href">javascript:OnOperationAdvanceSelected()</xsl:attribute>
						</Data>
			</CustomButton>			
                     <xsl:choose>
                        <xsl:when test = "/OMA/FluidCacheSuccess = '268435456'"> <!-- remove from cache pool -->
                                             <xsl:choose>
                                                     <xsl:when test="(count(ArrayDisks/DCStorageObject[PartOfCachePool = '1'])= 0) and $GLOBAL_VAR_CACHEPOOL = '1'" >
                                                            <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strCachePoolEmptyCachePool"/></xsl:attribute>
                                                             </AlertMessage>
                                                     </xsl:when>
                                                     <xsl:otherwise>
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strRemoveFromCachePoolSuccess"/></xsl:attribute>
                                                                     <xsl:attribute name="status">2</xsl:attribute>
                                                             </AlertMessage>
                                                     </xsl:otherwise>
                                             </xsl:choose>
                         </xsl:when>
						 <xsl:when test = "/OMA/FluidCacheSuccess = '134217728'"> <!-- Add to cache Pool -->
                                             
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strAddToCachePoolSuccess"/></xsl:attribute>
                                                                     <xsl:attribute name="status">2</xsl:attribute>
                                                             </AlertMessage>
                                             
                         </xsl:when>
					     <xsl:when test = "/OMA/FluidCacheSuccess = '2147483648'"> <!-- Re activate PCI e SSD-->
                                             
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strReactivateSuccess"/></xsl:attribute>
                                                                     <xsl:attribute name="status">2</xsl:attribute>
                                                             </AlertMessage>
                                             
                         </xsl:when>
                     </xsl:choose>
                     <xsl:if test= "$GLOBAL_VAR_CACHEPOOL = '1' ">
                                   <ListData columnspacing="true">
                                            <xsl:call-template name="CachePoolPropertiesTableInfo"/>
                                   </ListData> 
                     </xsl:if>
                         <xsl:choose>
                               <xsl:when test="(count(ArrayDisks/DCStorageObject[PartOfCachePool = '1'])= 0) and $GLOBAL_VAR_CACHEPOOL = '1'">
                                        <xsl:if test="/OMA/FluidCacheSuccess != '1'">
                                            <AlertMessage>
                                                 <xsl:attribute name="display"><xsl:value-of select="$ADNoADs"/></xsl:attribute>
                                            </AlertMessage>
                                        </xsl:if>
                             </xsl:when>
                             <xsl:otherwise>
										<xsl:call-template name="ArrayDiskTable"/>
                              </xsl:otherwise>
                         </xsl:choose>
                         
			
		</DataArea>
	</xsl:template>
	<xsl:template name="ArrayDiskTable">
		<!-- check to see if AD or HD should be visible -->
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="ArrayDisks/DCStorageObject/AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--CR49916 - auto refresh code -->
		<xsl:if test="ArrayDisks/DCStorageObject/Progress or ArrayDisks/DCStorageObject/PDPowerState='255' or (ArrayDisks/DCStorageObject/BusProtocol = '9' and ArrayDisks/DCStorageObject/ObjState = '256')">
                      <HTMLData>
                               <script language="Javascript">
                               		<!--refresh page every 30 secs when atleast one adisk object has Progress property asscoiated with it-->
                                       setTimeout("reloadPage()",30000) ;
                               </script>
                      </HTMLData>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="count(ArrayDisks/DCStorageObject) &lt;= 0">
				<AlertMessage status="3" ignoreoncli="true">
					<xsl:attribute name="display"><xsl:value-of select="$ADNoADs"/></xsl:attribute>
				</AlertMessage>		
			</xsl:when>
			<xsl:otherwise>
				<TableData columnspacing="true">
				   <xsl:if test="ChangeStatus != 1">
									<xsl:attribute name="staticcols">
									  <xsl:choose>
										   <xsl:when test="$GLOBAL_VAR_TAPE_LIBRARIES = 'true'">7</xsl:when>
										   <!--xsl:when test="$GLOBAL_VAR_BUSPROTOCOL != '9'">10</xsl:when-->
										   <xsl:otherwise>10</xsl:otherwise>
									  </xsl:choose>
								   
								   </xsl:attribute>
					   <xsl:attribute name="expandableheader">
									   <xsl:choose>
												<xsl:when test="$GLOBAL_VAR_CACHEPOOL = '1'">
								<xsl:attribute name="display"><xsl:value-of select="$strPCIeSSDDevices"/></xsl:attribute>
							</xsl:when>
									  <xsl:when test="$GLOBAL_VAR_BUSPROTOCOL! = '9'">
										<xsl:value-of select="$strTitle1"/>
									</xsl:when>					
									  <xsl:otherwise>
								<xsl:value-of select="$strDevices"/>
									  </xsl:otherwise>
								</xsl:choose>
								   </xsl:attribute>
					   <xsl:attribute name="expandable">true</xsl:attribute>
				   </xsl:if>	
				   
					<SubHeader>
						<xsl:choose>
									   <xsl:when test="$GLOBAL_VAR_CACHEPOOL = '1' or //BusProtocol = '9'">
								<xsl:attribute name="display"><xsl:value-of select="$strPCIeSSDDevices"/></xsl:attribute>
							</xsl:when>					
				  
									  <xsl:otherwise>
													<xsl:choose>
													   <xsl:when test="$nonRaid = '1' and $GLOBAL_VAR_CACHEPOOL! = '1'">
								<xsl:attribute name="display"><xsl:value-of select="$strTitle1a"/></xsl:attribute>
									</xsl:when>
														<xsl:otherwise>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
														</xsl:otherwise>
														</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</SubHeader>
						  
					<xsl:choose>
										<xsl:when test="count(ArrayDisks/DCStorageObject[PartOfCachePool = '1' or PartOfCachePool = '2' or PartOfCachePool = '3'])> 0 and $GLOBAL_VAR_CACHEPOOL = '1'">
										
							<PromptText><xsl:value-of select="$strFluidCachePoolPCIeSSDsInfoMessage"/></PromptText>

							<Header>
								<xsl:call-template name="ArrayDiskTableHeader">
									<xsl:with-param name="tasks">
										<xsl:value-of select="$checkAdmin"/>
									</xsl:with-param>
									<xsl:with-param name="expanded">true</xsl:with-param>
									<xsl:with-param name="changestatus"><xsl:value-of select="/OMA/ChangeStatus"/></xsl:with-param>
								</xsl:call-template>
							</Header>

							<xsl:for-each select="ArrayDisks/DCStorageObject[PartOfCachePool = '1' or PartOfCachePool = '2' or PartOfCachePool = '3']">
								<xsl:sort select="Channel" data-type="number" order="ascending"/>
								<xsl:sort select="TargetID" data-type="number" order="ascending"/>
								<xsl:call-template name="ArrayDiskTableRows">
									<xsl:with-param name="tasks">
										<xsl:value-of select="$checkAdmin"/>
									</xsl:with-param>
									<xsl:with-param name="expanded">true</xsl:with-param>
									<xsl:with-param name="changestatus"><xsl:value-of select="/OMA/ChangeStatus"/></xsl:with-param>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
										
						<xsl:when test="count(ArrayDisks/DCStorageObject)>0 and $GLOBAL_VAR_CACHEPOOL != '1'">
							<Header>
								<xsl:call-template name="ArrayDiskTableHeader">
									<xsl:with-param name="tasks">
										
										<xsl:choose>
													  <xsl:when test="//MediaType='4'">false</xsl:when>
													  <xsl:otherwise><xsl:value-of select="$checkAdmin"/></xsl:otherwise>
										</xsl:choose>
										
									</xsl:with-param>
									<xsl:with-param name="expanded">true</xsl:with-param>
									<xsl:with-param name="changestatus"><xsl:value-of select="/OMA/ChangeStatus"/></xsl:with-param>
																		
									
									<xsl:with-param name="expanded">true</xsl:with-param>
									<xsl:with-param name="changestatus"><xsl:value-of select="/OMA/ChangeStatus"/></xsl:with-param>
												  <xsl:with-param name="VAR_TAPE_LIBRARIES"><xsl:choose><xsl:when test="ArrayDisks/DCStorageObject/MediaType= '4'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>
		 
								</xsl:call-template>
							</Header>

							<xsl:for-each select="ArrayDisks/DCStorageObject">
								<xsl:sort select="Channel" data-type="number" order="ascending"/>
								<xsl:sort select="TargetID" data-type="number" order="ascending"/>
								<xsl:call-template name="ArrayDiskTableRows">
									<xsl:with-param name="tasks">
										  <xsl:choose><!-- Media Type 4 is Tape -->
																 <xsl:when test="MediaType = '4'">false</xsl:when>
																 <xsl:otherwise><xsl:value-of select="$checkAdmin"/></xsl:otherwise>
														 </xsl:choose>
									</xsl:with-param>
									<xsl:with-param name="expanded">true</xsl:with-param>
									<xsl:with-param name="changestatus"><xsl:value-of select="/OMA/ChangeStatus"/></xsl:with-param>
									  <xsl:with-param name="VAR_TAPE_LIBRARIES"><xsl:choose><xsl:when test="MediaType= '4'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>

								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
					</xsl:choose>
				</TableData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
