<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
 <xsl:output method="xml" omit-xml-declaration="yes"/>
 	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/encltbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<Summary>
			<Section name="Storage Services">
				<xsl:attribute name="display"><xsl:value-of select="$strStorEncl"/></xsl:attribute>
				<xsl:apply-templates/>

			</Section>

		</Summary>

	</xsl:template>	

	<xsl:template match="DCStorageObject">
		<ListData>
			<xsl:attribute name="display"><xsl:value-of select="$strStorEncl"/></xsl:attribute>			
			<xsl:choose>
				<xsl:when test="AssetName">
					<Data columnspacing="true" name="AssetName" editable="false" type="ustring">
						<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetName"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strProductID"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="EnclosureType"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="EnclosureType"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="normalize-space(ServiceTag)">
					<Data columnspacing="true" name="ServiceTag" editable="false" type="ustring">
						<xsl:attribute name="display"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
					</Data>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="normalize-space(ServiceTag)">
					<Data columnspacing="true" name="ExpressServiceCode" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strExpressServiceCode"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetExpressServiceCode"><xsl:with-param name="ServiceTag"><xsl:value-of select="normalize-space(ServiceTag)"/></xsl:with-param></xsl:call-template></xsl:attribute>
  				    </Data>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="AssetTag">
					<Data columnspacing="true" name="AssetTag" editable="false" type="ustring">
						<xsl:attribute name="display"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
					</Data>
				</xsl:when>
			</xsl:choose>
	
		</ListData>
	</xsl:template>


</xsl:stylesheet>
