<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:include href="../common/adtbl.xsl"/>

  	
  <xsl:template match="/">
		<DataArea>
                    
                   <xsl:choose>
                       <xsl:when test="/*/FluidCacheProperties/DCStorageObject[CachePoolLicenseState = 'Not Licensed' or not(CachePoolLicenseState)]">
                               <ListData type="custom">
                                         <SubHeader>
                                             <xsl:attribute name="display">Instructions: <xsl:call-template name="NewLine"/><xsl:value-of select="$strFluidCacheNotLicensed"/><xsl:call-template name="NewLine"/>Or <xsl:value-of select="$strFluidCacheNotConnectedError"/>

                                            </xsl:attribute>
                                         </SubHeader>                                                                
                           </ListData> 

                       </xsl:when> 
				<xsl:when test="/*/FluidCacheProperties/DCStorageObject[CachePoolLicenseState != 'Unknown']">
                             <PageTitle>
                                    <xsl:attribute name="display">
                                           <xsl:value-of select="$strFluidCachePool"/>
                                    </xsl:attribute>
                            </PageTitle>
                           <xsl:call-template name ="CachePoolProperties"/>    
                       </xsl:when> 
                       <xsl:otherwise>
                            <ListData type="custom">
                                         <SubHeader>
                                             <xsl:attribute name="display">Instructions: <xsl:call-template name="NewLine"/><xsl:value-of select="$strFluidCacheNotConnectedError"/><xsl:call-template name="NewLine"/>Or <xsl:value-of select="$strFluidCacheNotLicensed"/>

                                            </xsl:attribute>
                                         </SubHeader>                                                                
                           </ListData> 
                       </xsl:otherwise>
                   </xsl:choose>
			
                    <xsl:if test="/*/FluidCacheProperties/DCStorageObject[CachePoolLicenseState != 'Unknown']">   
                    <TableData>
			<xsl:choose>
			<xsl:when test="count(/*/ArrayDisks/DCStorageObject[PartOfCachePool = '1' or PartOfCachePool = '2' or PartOfCachePool = '3'])> 0 ">
                            <SubHeader display="PCIe Solid-State Devices in Fluid Cache Pool"/>
            			<Header>
                			<xsl:call-template name="ArrayDiskTableHeader">
                                            <xsl:with-param name="tasks">false</xsl:with-param>
					</xsl:call-template>
                                </Header>
                                <xsl:for-each select="/*/ArrayDisks/DCStorageObject[PartOfCachePool = '1' or PartOfCachePool = '2' or PartOfCachePool = '3']">
				<xsl:sort select="GlobalNo" data-type="number" order="ascending"/>
					<xsl:call-template name="ArrayDiskTableRows">
						<xsl:with-param name="tasks">false</xsl:with-param>
						<xsl:with-param name="GLOBAL_VAR_CACHEPOOL_CLI">1</xsl:with-param>					
                                        </xsl:call-template>
				</xsl:for-each>
                    	</xsl:when>
			<xsl:otherwise>
				 <SubHeader display="No PCIe Solid-State Devices found in Fluid Cache Pool"/>
			</xsl:otherwise>
                    </xsl:choose>
                    </TableData>
                  </xsl:if>
    </DataArea>
</xsl:template>  
<xsl:template name="CachePoolProperties">
     <TableData>
       <!--<SubHeader display="Fluid Cache Pool Properties"/>-->
       <Header><xsl:call-template name="CachePoolPropertiesHeader"/></Header>
       <xsl:call-template name="CachePoolPropertiesRows"/>
     </TableData>
  </xsl:template>
  <xsl:template match="OMAUserRights"/>
  <xsl:template match="*"/>
  <xsl:template name="CachePoolPropertiesHeader">
  <Data name="Status" editable="false" type="">
        <xsl:attribute name="display">
                <xsl:value-of select="$strStatus"/>
        </xsl:attribute>
        <xsl:attribute name="value">
                <xsl:value-of select="$strStatus"/>
        </xsl:attribute>
  </Data>
  
  <Data name="CachePoolSize" editable="false" type="ustring" ignoreonweb="true">
         <xsl:attribute name="display">
                <xsl:value-of select="$strCachePoolSize"/>
         </xsl:attribute>
         <xsl:attribute name="value">
                <xsl:value-of select="$strCachePoolSize"/>
         </xsl:attribute>
  </Data>
   <Data name="CachePoolHighAvailability" editable="false" type="">
         <xsl:attribute name="display">
                <xsl:value-of select="$strCachePoolHighAvailability"/>
         </xsl:attribute>
         <xsl:attribute name="value">
                <xsl:value-of select="$strCachePoolHighAvailability"/>
         </xsl:attribute>
   </Data>
   <Data name="CacheStoreCount" editable="false" type="">
         <xsl:attribute name="display">
              <xsl:value-of select="$strCacheStoreCount"/>
         </xsl:attribute>
         <xsl:attribute name="value">
                <xsl:value-of select="$strCacheStoreCount"/>
         </xsl:attribute>
   </Data>  
  </xsl:template>  
  <xsl:template name="CachePoolPropertiesRows">
    <Row>
      <Data type="status" align="center">
        <xsl:attribute name="value"><xsl:value-of select="//CachePoolProperties/DCStorageObject/ObjStatus"/></xsl:attribute>
      </Data>
      <Data type="ustring" align="center">
        <xsl:attribute name="value"><xsl:value-of select="format-number(//CachePoolProperties/DCStorageObject/CachePoolSize div 1024, '0.00')"/> GiB</xsl:attribute>
      </Data>
      <Data type="ustring" align="center">
        <xsl:attribute name="value">
                            <xsl:choose>
                                        <xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'False' and //CachePoolProperties/DCStorageObject/CacheStoreCount = '0'">
                                                <xsl:value-of select="$strCachePoolHighAvailabilityFalsePassThrough"/>
                                        </xsl:when>
                                        <xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'False'">
                                                <xsl:value-of select="$strCachePoolHighAvailabilityFalse"/>
                                        </xsl:when>
                                        <xsl:when test="//CachePoolProperties/DCStorageObject/CachePoolISHA = 'True'">
                                                <xsl:value-of select="$strCachePoolHighAvailabilityTrue"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                                <xsl:value-of select="$strNotApplicable"/>
                                        </xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
      </Data>
      <Data type="ustring" align="center">
        <xsl:attribute name="value"><xsl:value-of select="//CachePoolProperties/DCStorageObject/CacheStoreCount"/></xsl:attribute>
      </Data>      
    </Row>
  </xsl:template>
<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>
	
</xsl:stylesheet>

