<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea onLoad="true" exportdata="false" backpagetarget="./DataArea?plugin=security.X509.webplugins.CertoptionWebPlugin&amp;help=Certificate&amp;app=oma" validate="true">			
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCertificateManagement"/></xsl:attribute>
			<xsl:attribute name="submit">./SubmitForm?plugin=security.X509.webplugins.GenerateWebPlugin&amp;generated=true</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strGenerate"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strX509CertificateGeneration"/></xsl:attribute>
			</PageTitle>
			<script language="javascript">
				function setSignAlgorithmValue()
				{
					var algo = document.getElementById("setSignAlgo").value;
					var warnmsg = "";
					if( algo == "MD5" || algo == "md5" )
					{
						warnmsg = "<xsl:value-of select="$strMD5Warning"/>";
					}
					else if( algo == "SHA256" || algo == "sha256" || algo == "SHA512" || algo == "sha512" )
					{
						warnmsg = "<xsl:value-of select="$strSHA256Warning"/>";
					}
					
					if(warnmsg != "" )
					{
						document.getElementById("warnMessage").innerHTML = "[<xsl:value-of select="$strWarning"/>  " + warnmsg + "]";
						document.getElementById("warnMessage").className = "data-area-error";
					}
					else
						document.getElementById("warnMessage").innerHTML ="<xsl:value-of select="$str"/>";
				}
				
				function initializationRoutine()
				{
					setSignAlgorithmValue();
				}
			
			</script>


			<xsl:choose>
				<xsl:when test="Generator/@status">
					<xsl:choose>
						<xsl:when test="Generator/@status='duplicate'">
							<PromptText status="3"><xsl:value-of select="$strAlias"/><xsl:value-of select="Generator/@aliasused"/><xsl:value-of select="$strAlreadyExistsFill"/></PromptText>
						</xsl:when>
						<xsl:otherwise>
							<PromptText status="4"><xsl:value-of select="$strFailedToGenerate"/><xsl:value-of select="Generator/@aliasused"/><xsl:value-of select="$strFillInAll"/></PromptText>
						</xsl:otherwise>
					</xsl:choose>
					<TableData type="custom">
				
					
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strAlias1"/></xsl:attribute></Data>
							<Data name="alias" value="" editable="true" type="editbox" align="left" maxlength="10">	</Data>
							<Data></Data>
						</Row>
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strSignAlgorithm"/></xsl:attribute></Data>
							<Data name="setSignAlgo" editable="false" type="select" event="onChange" handler="javascript:setSignAlgorithmValue()">
							<xsl:variable name="currentAlgo"><xsl:value-of select="Generator/setSignAlgo/keysignalgorithm"/></xsl:variable>
							<xsl:for-each select="Generator/supportSignAlgo/supportedkeysignalgorithm">
							<xsl:variable name="supportAlgo"><xsl:value-of select="."/></xsl:variable>
							<Choice>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$supportAlgo"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$supportAlgo"/></xsl:attribute>
								<xsl:if test="$currentAlgo = $supportAlgo">
									<xsl:attribute name="default">true</xsl:attribute>
								</xsl:if>
							</Choice>
							</xsl:for-each>
							</Data>
							<Data  name="warnMessage">	
								<xsl:attribute name="value"><xsl:value-of select="$str"/></xsl:attribute>
							</Data>
						</Row>

						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strKeyGenerationAlgorithm"/></xsl:attribute></Data>
							<Data><xsl:attribute name="value"><xsl:value-of select="Generator/KeyAlg/Keypair"/></xsl:attribute></Data>
							<Data></Data>
						</Row>
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strKeySize"/></xsl:attribute></Data>
							<Data name="keysize" editable="true" type="editbox" align="left" size="10">
								<xsl:attribute name="unit"><xsl:value-of select="$strBits"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Generator/@keysize"/></xsl:attribute>
							</Data>
							<Data></Data>
						</Row>	
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strValidityPeriod"/></xsl:attribute></Data>
							<Data name="validity" editable="true" type="editbox" align="left" size="10" >
								<xsl:attribute name="unit"><xsl:value-of select="$strDays"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Generator/@validity"/></xsl:attribute>
							</Data>
							<Data></Data>
						</Row>
						<Row>
							<Data>
								<xsl:attribute name="value"><xsl:value-of select="$strCommonNameCN"/></xsl:attribute>
							</Data>	
							<Data name="comname" editable="true" type="editbox" align="left" size="45">
								<xsl:attribute name="value"><xsl:value-of select="Generator/@comname"/></xsl:attribute>
							</Data>
							<Data></Data>
						</Row>	
						<Row>
							<Data>
								<xsl:attribute name="value"><xsl:value-of select="$strOrganizationO"/></xsl:attribute>
							</Data>		
							<Data name="org" editable="true" type="editbox" align="left" size="45">
								<xsl:attribute name="value"><xsl:value-of select="Generator/@org"/></xsl:attribute>
							</Data>
							<Data></Data>
						</Row>
						<Row>
							<Data>
								<xsl:attribute name="value"><xsl:value-of select="$strOrganizationUnitOU"/></xsl:attribute>
							</Data>	
							<Data name="orgunit"  value="" editable="true" type="editbox" align="left" size="45">
								<xsl:attribute name="value"><xsl:value-of select="Generator/@orgunit"/></xsl:attribute>
							</Data>
							<Data></Data>
						</Row>
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strLocalityL"/></xsl:attribute></Data>						
							<Data name="locality" editable="true" type="editbox" align="left" size="45">
								<xsl:attribute name="value"><xsl:value-of select="Generator/@locality"/></xsl:attribute>
							</Data>
							<Data></Data>
						</Row>
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strStateST"/></xsl:attribute></Data>
							<Data name="state" editable="true" type="editbox" align="left" size="45">
								<xsl:attribute name="value"><xsl:value-of select="Generator/@state"/></xsl:attribute>
							</Data>
							<Data></Data>
						</Row>
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strCountryC1"/></xsl:attribute></Data>
							<Data name="country" editable="true" type="select" align="left">
								<xsl:call-template name="showcountry">
									<xsl:with-param name="country"><xsl:value-of select="@value"/></xsl:with-param>
								</xsl:call-template> 
							</Data>
							<Data></Data>
						</Row>
					</TableData>
				</xsl:when>
				<xsl:otherwise>
					<PromptText><xsl:value-of select="$strFillInAll1"/></PromptText>
					<TableData type="custom">

						<Row><Data><xsl:attribute name="value"><xsl:value-of select="$strAlias2"/></xsl:attribute></Data>
						<Data name="alias"  value="" editable="true" type="editbox" align="left" maxlength="10"></Data>
						<Data></Data></Row>
						<Row><Data><xsl:attribute name="value"><xsl:value-of select="$strSignAlgorithm"/></xsl:attribute></Data>
						<Data name="setSignAlgo" editable="false" type="select" event="onChange" handler="javascript:setSignAlgorithmValue()">
						<xsl:variable name="currentAlgo"><xsl:value-of select="Generator/setSignAlgo/keysignalgorithm"/></xsl:variable>
						<xsl:for-each select="Generator/supportSignAlgo/supportedkeysignalgorithm">
						<xsl:variable name="supportAlgo"><xsl:value-of select="."/></xsl:variable>
						<Choice>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$supportAlgo"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$supportAlgo"/></xsl:attribute>
							<xsl:if test="$currentAlgo = $supportAlgo">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						</xsl:for-each>
						</Data>
						<Data  name="warnMessage">	
							<xsl:attribute name="value"><xsl:value-of select="$str"/></xsl:attribute>
						</Data>
						
						</Row>
						<Row>
						<Data>	<xsl:attribute name="value"><xsl:value-of select="$strKeyGenerationAlgorithm1"/></xsl:attribute></Data>
						<Data>	<xsl:attribute name="value"><xsl:value-of select="Generator/KeyAlg/Keypair"/></xsl:attribute></Data>
						<Data></Data></Row>
						
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strKeySize1"/></xsl:attribute></Data>
							<Data name="keysize"   value="2048" editable="true" type="editbox" align="left" size="10">
								<xsl:attribute name="unit"><xsl:value-of select="$strBits"/></xsl:attribute>
							</Data>
						<Data></Data></Row>
						
						<Row>
							<Data>
								<xsl:attribute name="value"><xsl:value-of select="$strValidityPeriod1"/></xsl:attribute>
							</Data>	
							<Data name="validity"  value="" editable="true" type="editbox" align="left" size="10">
								<xsl:attribute name="unit"><xsl:value-of select="$strDays"/></xsl:attribute>
							</Data>
						<Data></Data></Row>	
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strCommonNameCN1"/></xsl:attribute></Data>
							<Data name="comname"  value="" editable="true" type="editbox" align="left" size="45"></Data>
						<Data></Data></Row>
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strOrganizationO1"/></xsl:attribute></Data>
							<Data name="org"  value="" editable="true" type="editbox" align="left" size="45"></Data>
						<Data></Data></Row>
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strOrganizationUnitOU1"/></xsl:attribute></Data>
							<Data name="orgunit"  value="" editable="true" type="editbox" align="left" size="45"></Data>
						<Data></Data></Row>	
						<Row>	
							<Data><xsl:attribute name="value"><xsl:value-of select="$strLocalityL1"/></xsl:attribute></Data>
							<Data name="locality"  value="" editable="true" type="editbox" align="left" size="45"></Data>
						<Data></Data></Row>
						<Row>
							<Data><xsl:attribute name="value"><xsl:value-of select="$strStateST1"/></xsl:attribute></Data>
							<Data name="state"  value="" editable="true" type="editbox" align="left" size="45"></Data>
						<Data></Data></Row>
						<Row>
						<Data><xsl:attribute name="value"><xsl:value-of select="$strCountryC1"/></xsl:attribute></Data>
						<Data name="country" editable="true" type="select" align="left">
														
							<xsl:call-template name="showcountry">
								<xsl:with-param name="country"><xsl:value-of select="@value"/></xsl:with-param>
							
							</xsl:call-template> 
							
						</Data>
						<Data></Data></Row>
					</TableData>
				</xsl:otherwise>
			</xsl:choose>
			<script language="javascript">
				var keysize ; 
				var validity ;	
				
				function isAlphaNumeric(text, varname)
				{
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-.";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' '){
						text = text.substring(0,text.length-1);
					}
					
					for (var i=0; i&lt;text.length; i++){
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == "-1"){
							if(temp != " "){
								ok = "no";
							}
						}
					}
					if (ok == "no"){
						alert(<xsl:value-of select="$strInvalidValueFor"/>);
						return false;
					}
					return true;
				}
				
				function isAlphaNumericsp(text, varname)
				{
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'*$,.!%():[]=/?+~@";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' '){
						text = text.substring(0,text.length-1);
					}
					
					for (var i=0; i&lt;text.length; i++){
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == "-1"){
							if(temp != " "){
								ok = "no";
							}
						}
					}
					if (ok == "no"){
						alert(<xsl:value-of select="$strInvalidValueFor1"/>);
						return false;
					}
					return true;
				}
				
				function is_valid(validity)
				{
					var isValid=true;
					var validValues="0123456789";
					var indx;
					for (indx=0; indx &lt; validity.length; indx++)
					{
						if (validValues.indexOf(validity.charAt(indx)) &lt; 0)
						{	
							isValid=false;
							break;
						}
					}
					return isValid;
				}
				
				function validate()
				{
					keysize = document.dataarea.keysize.value;
					validity = document.dataarea.validity.value;
					logresult = new Number(Math.log(parseInt(keysize))/Math.log(2));
					logresStr = logresult.toString();
					
					if (document.dataarea.alias.value== "" ){
						alert("<xsl:value-of select="$strAliasIsRequired"/>");
						document.dataarea.alias.focus();
					}
					else if(document.dataarea.keysize.value== "" ){
						alert("<xsl:value-of select="$strKeysizeIsRequired"/>");
						document.dataarea.keysize.focus();
					}
					else if(document.dataarea.validity.value== ""){
						alert("<xsl:value-of select="$strValidityPeriodIs"/>");
						document.dataarea.validity.focus();
					}
					else if(document.dataarea.comname.value== "" ){
						alert("<xsl:value-of select="$strCommonNameCNIs"/>");
						document.dataarea.comname.focus();
					}
					else if(document.dataarea.org.value== "" ){
						alert("<xsl:value-of select="$strOrganizationOIsRequired"/>");
						document.dataarea.org.focus();
					}
					else if(document.dataarea.orgunit.value== "" ){
						alert("<xsl:value-of select="$strOrganizationUnitOUIs"/>");
						document.dataarea.orgunit.focus();
					}
					else if(document.dataarea.locality.value== "" ){
						alert("<xsl:value-of select="$strLocalityLIsRequired"/>");
						document.dataarea.locality.focus();
					}
					else if(document.dataarea.state.value== "" ){
						alert("<xsl:value-of select="$strStateSTIsRequired"/>");
						document.dataarea.state.focus();
					}
					else{
						if(isNaN(keysize) == true){
							alert("<xsl:value-of select="$strKeysizeIsNot"/>");
							document.dataarea.keysize.value = "";
							document.dataarea.keysize.focus();
						}
						else if((parseInt(keysize) &lt; 512) || (parseInt(keysize) &gt; 2048)){
							alert("<xsl:value-of select="$strKeysizeShouldBe"/>");
							document.dataarea.keysize.value = "";
							document.dataarea.keysize.focus();
						}
						else if(logresStr.indexOf(".") != -1){
							alert("<xsl:value-of select="$strKeysizeShouldBe1"/>");
							document.dataarea.keysize.value = "";
							document.dataarea.keysize.focus();
						}
						else if(isNaN(validity) == true){
							alert("<xsl:value-of select="$strValidityPeriodIs1"/>");
							document.dataarea.validity.value = "";
							document.dataarea.validity.focus();
						}
						else if((parseInt(validity) &lt;= 0) || (parseInt(validity) &gt;= 3651)){
							alert("<xsl:value-of select="$strValidityPeriodFalls"/>");
							document.dataarea.validity.value = "";
							document.dataarea.validity.focus();
						}
						else if (keysize.indexOf('.')!= -1)
						{
						alert("<xsl:value-of select="$strKeysizeCanHave"/>");
						}
						else if(is_valid(validity) == false)
						{
						alert("<xsl:value-of select="$strValidityCanHave"/>");
        }
        else if( ! isAlphaNumeric(document.dataarea.comname.value, "<xsl:value-of select="$strCommonNameCN2"/>")){
							document.dataarea.comname.value = "";
							document.dataarea.comname.focus();
						}
						
						else {
								var newalias = document.getElementById("alias").value;
								var aliasname = newalias.toLowerCase();
								var curalias = "<xsl:value-of select="Generator/@currentalias"/>";

							if (aliasname == curalias){
								alert(<xsl:value-of select="$strAliasNewaliasAlready"/>);
								document.dataarea.alias.value ="";
								document.dataarea.alias.focus();
							}
							else {
													
								if (confirm("<xsl:value-of select="$strGeneratingANew"/>")){
									return true;
								}
								else{
									return false;
								}
							}
							return false;
						}
						return false;
					}
					return false;				
				}			
			</script>
		</DataArea>
	</xsl:template>

	
	<xsl:template name="showcountry">
		<xsl:for-each select="Generator/CountryGroup/Country">
			<xsl:sort select="." order="ascending"/>
				<Choice>
					<xsl:choose>
						<xsl:when test="@value='TK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TJ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTJ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TF'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTF"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TD'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTD"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TC'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTC"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GS'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGS"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GQ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGQ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GP'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGP"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GL'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGL"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SV'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSV"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ST'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strST"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GF'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGF"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GD'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGD"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GB'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGB"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SL'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSL"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='GA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SJ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSJ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SD'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSD"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='FX'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFX"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SC'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSC"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SB'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSB"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='SA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='FR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='FO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='FM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='RW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strRW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='FK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='RU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strRU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='FJ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFJ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='FI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='RO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strRO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='RE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strRE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ET'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strET"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ES'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strES"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ER'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strER"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='EH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strEH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='EG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strEG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='EE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strEE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='EC'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strEC"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='DZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strDZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='QA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strQA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='DO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strDO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='DM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strDM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='DK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strDK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='DJ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strDJ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PS'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPS"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='DE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strDE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PL'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPL"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PF'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPF"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CX'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCX"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CV'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCV"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='PA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CL'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCL"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CF'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCF"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CD'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCD"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CC'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCC"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='OM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strOM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='CA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BV'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBV"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BS'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBS"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BJ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBJ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BF'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBF"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NP'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNP"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BD'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBD"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BB'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBB"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ZW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strZW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='BA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strBA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NF'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNF"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NC'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNC"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ZM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strZM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='NA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AS'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAS"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AQ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAQ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MX'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMX"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AL'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAL"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MV'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMV"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ZA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strZA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MS'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMS"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AF'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAF"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MQ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMQ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MP'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMP"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='AD'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAD"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ML'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strML"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='YU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strYU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='YT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strYT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MD'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMD"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MC'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMC"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='MA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='YE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strYE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LV'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLV"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LS'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLS"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LC'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLC"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LB'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLB"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='LA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strLA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KP'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKP"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='WS'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strWS"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KH'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKH"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='KE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strKE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='WF'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strWF"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='JP'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strJP"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='JO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strJO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='JM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strJM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='VU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strVU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='VN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strVN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='VI'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strVI"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='VG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strVG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='VE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strVE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='VC'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strVC"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='VA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strVA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='IT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='IS'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIS"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='IR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='IQ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIQ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='UZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strUZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='IO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='UY'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strUY"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='IN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='IL'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIL"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='US'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strUS"/></xsl:attribute>
							<xsl:attribute name="default">true</xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='IE'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIE"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='ID'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='UM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strUM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='UG'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strUG"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='UA'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strUA"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='HU'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strHU"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='HT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strHT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='HR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strHR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TZ'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTZ"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='HN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strHN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='HM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strHM"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TW'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTW"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TV'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTV"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='HK'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strHK"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TT'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTT"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TR'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTR"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TP'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTP"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TO'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTO"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TN'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTN"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="@value='TM'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strTM"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="Generator/@status">
									<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
									<xsl:attribute name="default"><xsl:if test="@value = /OMA/Generator/@country">true</xsl:if></xsl:attribute>
								</xsl:when>	
								<xsl:otherwise>
									<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
									<xsl:attribute name="default"><xsl:if test=".='UNITED STATES'">true</xsl:if></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
						
					</xsl:choose>

					<xsl:if test="@value = /OMA/Generator/@country">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
		</xsl:for-each>
		
		
	</xsl:template>

	<xsl:template match="*"/>	
</xsl:stylesheet>
