<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea validate="true" backpagetarget="./DataArea?plugin=security.X509.webplugins.CertoptionWebPlugin&amp;help=Certificate&amp;app=oma" enctype="true" exportdata="false">			
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCertificateManagement"/></xsl:attribute>
			<xsl:attribute name="submit">./UploadCertServlet</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strUpdateAndProceed"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strCACertificateAuthorityRoot"/></xsl:attribute>
			</PageTitle>
			<PromptText><xsl:value-of select="$strSelectTheCA"/></PromptText>
			<ListData type="custom">
				<Data name="file" editable="true" type="file">
					<xsl:attribute name="display"><xsl:value-of select="$strSelectCertificateFrom"/></xsl:attribute>
				</Data>
				<Data name="root" display=" "  type="hidden" returnvalue="true"/>
			</ListData>
			<script language="javascript">
			
				function validate()
				{
					var temp = document.getElementById("file");
					if(temp.value == "")
					{
						alert("<xsl:value-of select="$strCARootCertificate"/>");
						document.getElementById("file").focus();
						return false;
					}
					else if (!isValid(temp.value)){
						alert("<xsl:value-of select="$strCertificateFilenameIs"/>");
						document.getElementById("file").select();
						document.getElementById("file").focus();
						return false;					
					}
					return true;
				}
				
				function isValid(text){
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'*$,.!():[]+/~\\";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' ')
					{
						text = text.substring(0,text.length-1);
					}

					for (var i=0; i&lt;text.length; i++)
					{
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == -1)
						{
							if(temp != " ")
							{
								ok = "no";
								break;
							}
						}
					}
					if (ok == "no")
					{
						return false;
					}
					return true;
				}
				
			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
