<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea validate="true" backpagetarget="./DataArea?plugin=security.X509.webplugins.CertoptionWebPlugin&amp;help=Certificate&amp;app=oma" enctype="true" exportdata="false">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCertificateManagement"/></xsl:attribute>
			<xsl:attribute name="submit">./UploadCertServlet</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strImport"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strCertificateImport"/></xsl:attribute>
			</PageTitle>
			<PromptText><xsl:value-of select="$strSelectTheCertificate"/></PromptText>
			<ListData type="custom">	
				
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strAlias"/></xsl:attribute>					
					<xsl:choose>
						<xsl:when test="count(Import/.) =  '1'">							
								<xsl:attribute name="value"><xsl:value-of select="Import/Alias"/></xsl:attribute>							
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="Import/*">							
									<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>								
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
           </Data>
					<Data name="root"  type="hidden" returnvalue="false"/>
				
				
				<Data name="file" type="file">
						<xsl:attribute name="display"><xsl:value-of select="$strSelectCertificateFrom"/></xsl:attribute>
					</Data>					
					<xsl:choose>
						<xsl:when test="count(Import/.) =  '1'">
							<Data  type="hidden">
								<xsl:attribute name="name">alias</xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="Import/Alias"/></xsl:attribute>
							</Data>
						</xsl:when>
					</xsl:choose>
				
			</ListData>
			<script language="javascript">
			
				function validate()
				{
					var certtemp = document.getElementById("file");
					var certalias = document.getElementById("alias");
					if(certtemp.value == "")
					{
						alert("<xsl:value-of select="$strCertificateResponseFilename"/>");
						document.getElementById("file").focus();
						return false;
					}
					else if(certalias.value == "")
					{
						alert("<xsl:value-of select="$strAliasIsRequired"/>");
						document.getElementById("alias").focus();
						return false;					
					}
					else if (!isValid(certtemp.value)){
						alert("<xsl:value-of select="$strCertificateFilenameIs"/>");
						document.getElementById("file").select();
						document.getElementById("file").focus();
						return false;					
					}

					return true;
				}
				
				function isValid(text){
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'*$,.!():[]+/~\\";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' ')
					{
						text = text.substring(0,text.length-1);
					}

					for (var i=0; i&lt;text.length; i++)
					{
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == -1)
						{
							if(temp != " ")
							{
								ok = "no";
								break;
							}
						}
					}
					if (ok == "no")
					{
						return false;
					}
					return true;
				}


			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
