<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea exportdata="false">
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strNext"/></xsl:attribute>
			<xsl:attribute name="submit">./SubmitForm?plugin=security.X509.webplugins.GetoptionWebPlugin</xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strX509CertificateManagement"/></xsl:attribute>
			</PageTitle>
			
			<ListData columnspacing="true" type="custom">
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strX509CertificateOption"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strX509CertificateOption1"/></xsl:attribute>
					</Data>
				</Header>
				<PromptText>
				<xsl:choose>
					<xsl:when test="Selection/@reuse='true'">
						<xsl:choose>
							<xsl:when test="WriteAccess">
								<xsl:attribute name="status">4</xsl:attribute>
								<xsl:choose>
									<xsl:when test="WriteAccess/@mode='generate'"><xsl:value-of select="$strKeystoredbIsWriteprotected"/>
									</xsl:when>
									<xsl:otherwise><xsl:value-of select="$strKeystoredbIsWriteprotected1"/></xsl:otherwise>
								</xsl:choose>							
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strSelectOneOf"/>
							</xsl:otherwise>
						</xsl:choose>						
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="WriteAccess">
								<xsl:attribute name="status">4</xsl:attribute>
								<xsl:choose>
									<xsl:when test="WriteAccess/@mode='generate'"><xsl:value-of select="$strKeystoredbIsWriteprotected2"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$strKeystoredbIsWriteprotected3"/></xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strThereIsNo"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</PromptText>
				<xsl:choose>
					<xsl:when test="WriteAccess"></xsl:when>
					<xsl:otherwise>
							<Data name="option" returnvalue ="gen" editable="true" type="radio" state="1" align="left">
								<xsl:attribute name="display"><xsl:value-of select="$strGenerateANew"/></xsl:attribute>
								<xsl:attribute name="returnvalue">gen</xsl:attribute>
								<xsl:attribute name="state">1</xsl:attribute>
							</Data>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="Selection/@reuse='true'">
						<Data name="option" returnvalue ="reuse" editable="true" type="radio" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strReuseAnExisting"/></xsl:attribute>
							<xsl:attribute name="state"><xsl:if test="WriteAccess">1</xsl:if></xsl:attribute>
						</Data>
						<!-- Removing import root certificate option to fix the defect BITS072405.
						<Data name="option" returnvalue ="importroot" editable="true" type="radio" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strImportARoot"/></xsl:attribute>
							<xsl:attribute name="returnvalue">importroot</xsl:attribute>
						</Data>-->
					<xsl:choose>
						<xsl:when test="WriteAccess"></xsl:when>
						<xsl:otherwise>
								<Data name="option" returnvalue ="importchain" editable="true" type="radio" align="left">
									<xsl:attribute name="display"><xsl:value-of select="$strImportACertificate"/></xsl:attribute>
									<xsl:attribute name="returnvalue">importchain</xsl:attribute>
								</Data>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</ListData>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>

