/*This javascript file has functions to create the plot data and plot the graph(Pie chart/Line Chart/Bar Graph) using highcharts
*/
var xmlObjectArray = new Array(new Array());
var xAxisArray = new Array();
var avgArray=new Array();
var CacheLunPath= new Array(new Array());
var xAxisObjectArray = new Array();
var startValue;
var endValue;
var steps;
var rows;
var cols;
var lblDay,lblTime,lblAvg;
var KB = 1024;
var MegaBytes = 1024*1024;
var GigaBytes	=MegaBytes*1024;
var legendEntry = new Array();
var legendEntry_Pie = new Array();
var diskEntry = new Array();
var totalcachepoolsize;
var graphtype;
var metaDataArray= new Array();
var maxValArray=new Array();

function setStringsForGraphLabel(lbl_day,lbl_time,lbl_Avg)
{
lblDay=lbl_day;lblTime=lbl_time;lblAvg=lbl_Avg;
}
function metaDataObject(graphtype,metaStartVal,metaEndVal,metaSteps,metaRows,metaCols)
{

	this.startValue		= metaStartVal;
	this.endValue		= metaEndVal;
	this.steps			= metaSteps;
	this.rows			= metaRows;
	this.cols			= metaCols;
	this.graphtype		= graphtype;

}

function storeMetaData(graphindex,graphtype,metaStartVal,metaEndVal,metaSteps,metaRows,metaCols)
{
	metaDataArray[graphindex]	= new metaDataObject(graphtype,metaStartVal,metaEndVal,metaSteps,metaRows,metaCols);
	
}

function storeAggregateBytes(aggregate_stats)
{
	totalcachepoolsize=aggregate_stats;


}
function roundNumber(num, dec) {
	var result = Math.round(num*Math.pow(10,dec))/Math.pow(10,dec);
	return result;
}
function isNotWholeNumber( str )
{   
	var isNotWholeNum = false;
	var numStr =  str;
	var validValues="0123456789";

	for ( var charId=0; charId < numStr.length; charId++ )
	{
		if ( validValues.indexOf( numStr.charAt( charId ) ) < 0 )
		{
			isNotWholeNum = true;
			break;
		}
	}
	return isNotWholeNum;
}

function xmlObject(x_axis, y_axis) {

    this.x_axisVal = x_axis;
    this.y_axisVal = y_axis;

}
function legend(legend_entry) {

        this.legend_entry = legend_entry;

}


function createLegendEntriesArray(graphindex,entryindex, legend_entry) {
   
        legendEntry[graphindex][entryindex] = new legend(legend_entry);

}

function createLegendObjectArray(graphindex)
{
	 legendEntry[graphindex] = new Array();

}

function disk(disk_entry) {

    this.disk_entry = disk_entry;

}
function createCacheLunBackEndPath(CacheLunBackendPath,cacheLunName,partitionWWN,lunRowIndex) {
	 CacheLunPath[lunRowIndex] = new Array();
     	 CacheLunPath[lunRowIndex][0] = CacheLunBackendPath;
	  CacheLunPath[lunRowIndex][1] = cacheLunName;
	 CacheLunPath[lunRowIndex][2] = partitionWWN;
	



}
function createxmlObjectArray(graphindex,rowindex, colindex, x_axis, y_axis) {

    xAxisObjectArray[graphindex][x_axis][colindex] = y_axis;

}

function createXAxisObjectArray(graphindex,rowindex, x_axisVal) {
    xAxisObjectArray[graphindex][x_axisVal] = new Array();

}
function createXAxisObject(graphindex)
{	
	 xAxisObjectArray[graphindex] = new Array();

}

function createLegendEntriesArray_Pie(index, legend_entry) {
    legendEntry_Pie[index] = new legend(legend_entry);

}


function cacheDiskArray(diskIndex,node)
{
	diskEntry[diskIndex] = new disk(node);
}

function computeAverageForAllLegend(graphindex,rowNANCount)
{	
  var totalRows=0;
  avgArray[graphindex]=new Array();
  for (var entry = 0; entry < (legendEntry[graphindex].length); entry++) {
	
		var sum=0;
		for (var i = parseInt(metaDataArray[graphindex].startValue); i < parseInt(metaDataArray[graphindex].endValue); i += parseInt(metaDataArray[graphindex].steps)) {
			if(!isNaN(parseFloat(xAxisObjectArray[graphindex][i][entry])))
			{   sum=parseFloat(sum)+parseFloat(xAxisObjectArray[graphindex][i][entry]);
				
			}
		
		}
		totalRows=metaDataArray[graphindex].rows-rowNANCount;
		avgArray[graphindex][entry]=bytesToSize((parseFloat(sum/totalRows)),graphindex);
		
	}
			
}

function computeMaxForAllLegend(graphindex)
{	
 maxValArray[graphindex]=new Array();
 for (var entry = 0; entry < (legendEntry[graphindex].length); entry++) {
    var maxVal=0;
	for (var i = parseInt(metaDataArray[graphindex].startValue); i < parseInt(metaDataArray[graphindex].endValue); i += parseInt(metaDataArray[graphindex].steps)) 
	{
		if(parseFloat(xAxisObjectArray[graphindex][i][entry])> maxVal)
			maxVal=parseFloat(xAxisObjectArray[graphindex][i][entry]);

		
	}
	maxValArray[graphindex][entry]=bytesToSize(maxVal,graphindex);

	}
			
}

 function bytesToSize(bytes, graphindex)
{ 
		if( isNaN( bytes ) ){ return 'NA'; }
    var KBValue,MBValue,GBValue,TBValue,PBValue;
    var precision=3,prefix=1024;
	
    if(graphindex==0)
		{units = [ ' bps', ' kbps', ' mbps', ' gbps', ' tbps', ' pbps'];
		 
		}
    else if(graphindex==1)
		{units = [' iops', 'K iops', 'M iops', 'G iops', 'T iops', 'P iops'];
		 prefix=1000;
		}
   
  
	  KBValue= prefix;
   	  MBValue= KBValue * prefix;
   	  GBValue= MBValue * prefix;
   	  TBValue= GBValue * prefix;
	  PBValue= TBValue * prefix;
   
    if ((bytes > 0) && (bytes < KBValue)) {
        return bytes.toFixed(precision) +units[0];
 
    } else if ((bytes >= KBValue) && (bytes < MBValue)) {
        return (bytes / KBValue).toFixed(precision) +units[1];
 
    } else if ((bytes >= MBValue) && (bytes < GBValue)) {
        return (bytes / MBValue).toFixed(precision) +units[2];
 
    } else if ((bytes >= GBValue) && (bytes < TBValue)) {
        return (bytes / GBValue).toFixed(precision) +units[3];
 
    } else if (bytes >= TBValue && (bytes < PBValue)) {
        return (bytes / TBValue).toFixed(precision) +units[4];
 
    } 
    else if (bytes >= PBValue) {
        return (bytes / PBValue).toFixed(precision) +units[5];
 
    } 
	else {
        return bytes +units[0];
    }
}

function plotGraph(graphindex,expandgraph,titleheader,title_part1,title_part2,container,avgString)
{
	// Construct a object(options) and create the structure for plotdata
	//that highchart expects and invoke the highchart constructor with this object as a parameter
    var options = new Object();
    options.chart = new Object();
	options.title = new Object();
	options.subtitle= new Object();
	options.title.align="center";
	options.credits = new Object();
	options.tooltip = new Object();
	options.legend = new Object();
	options.legend.verticalAlign='bottom';
	options.legend.layout='horizontal';
	options.legend.borderWidth=1;
	options.legend.labelFormatter=function() {
									return this.name;     
										}
	options.credits.enabled = false;
	options.title.text='<b>'+titleheader+title_part1+'</b>';
	options.subtitle.text=title_part2;
	options.title.style=new Object();
	options.subtitle.style=new Object();
	options.title.style.font='14px "arial"';
	options.subtitle.style.font='14px "arial"';
	options.subtitle.style.color='#3E576F';
	
	options.chart.renderTo = container;
	

	options.chart.plotBackgroundColor ='#D8E3E9';
    options.chart.type = 'line';
    options.chart.borderWidth = 1;
	options.chart.plotArea=new Object();
	options.chart.size = new Array();
	options.yAxis = new Object();
	options.yAxis.title = new Object();
	options.yAxis.title.text='';
	options.min= 0;
	options.xAxis = new Object();
	options.xAxis.title = new Object();
	options.xAxis.title.text='<br/>';
	options.xAxis.type="datetime";
	options.yAxis.min=0;
	options.xAxis.labels=new Object();
	options.xAxis.labels.overflow='justify';
	options.xAxis.dateTimeLabelFormats = new Object();;
	options.xAxis.dateTimeLabelFormats.hour='%H:%M';

	options.series = new Array();
	
	for (var entry = 0; entry < (legendEntry[graphindex].length); entry++) {
        options.series[entry] = new Object();
	var avgValue="<b>"+lblAvg+"</b>"+(avgArray[graphindex][entry]);
		options.series[entry].name = "<b>"+legendEntry[graphindex][entry].legend_entry+"</b>" + '<br/>' +avgValue;
        options.series[entry].data = new Array();
	    options.tooltip.formatter=function() {
		var d= new Date((this.x)*1000);
		var t= (this.x)*1000;
		var seriesname=this.series.name;
		seriesName=seriesname.substring(0, seriesname.indexOf(lblAvg)) ;
		         return '<b>'+ seriesName +'</b>'+ bytesToSize(this.y,graphindex)+'<br/>'+lblDay+" "+Highcharts.dateFormat('%e %b %Y', this.x)+'<br/>'+
                        lblTime+" "+Highcharts.dateFormat('%H:%M:%S', this.x);
		             };
        var dataindex = 0;
        for (var xaxisval = parseInt(metaDataArray[graphindex].startValue); xaxisval <= parseInt(metaDataArray[graphindex].endValue); xaxisval += parseInt(metaDataArray[graphindex].steps)) 
		{
		var time=parseInt(xaxisval)*1000;
		
		if (!isNaN(parseFloat(xAxisObjectArray[graphindex][xaxisval][entry]))) {
             	  options.series[entry].data[dataindex] = new Array(parseFloat(time), parseFloat(xAxisObjectArray[graphindex][xaxisval][entry]));
				  dataindex++;
            }
		
        }
		
    }
	Highcharts.setOptions({   
                global: {   
                    useUTC: false  
                 }               }); 

	var chart = new Highcharts.Chart(options);

}



function plotBarGraph(title)
{
	var options = new Object();

		options.chart = new Object();
		options.title = new Object();
		options.credits = new Object();
		options.credits.enabled = false;
		options.chart.plotBackgroundColor ='#D8E3E9';
		options.chart.borderWidth = 1;
		options.chart.renderTo = 'container3';
		options.chart.type = 'bar';
		options.title.text=title;
		options.title.align="center";
		options.series = new Array();
		options.yAxis = new Object();
		options.yAxis.title = new Object();
		options.yAxis.title.text="Bytes/Sec";
		options.legend = new Object();
		options.tooltip =new Object();
		options.legend.borderWidth=1;
		options.xAxis=new Object();
		options.xAxis.categories=new Array();
		options.xAxis.categories[0]='Reads';
		options.xAxis.categories[1]='Writes';
		options.plotOptions=new Object();
		options.plotOptions.column=new Object();
		options.plotOptions.bar=new Object();
		options.plotOptions.bar.dataLabels=new Object();
		options.plotOptions.bar.dataLabels.enabled=false;
		options.series[0] = new Object();
		options.series[1] = new Object();
		options.series[0].name=new Array();
		options.series[0].data=new Array();
		options.series[0].name[0] = "Cache";
		options.series[0].data[0]=parseInt(avgArray[0]);//cache read
		options.series[0].data[1]=parseInt(avgArray[2]);//Disk read

		options.series[1].name=new Array();
		options.series[1].data=new Array();
		options.series[1].name[0] = "Disk";
		options.series[1].data[0]=parseInt(avgArray[1]);//Cache Write
		options.series[1].data[1]=parseInt(avgArray[3]);//Disk Write

		options.tooltip.formatter=function() {
							var bytesInKB = parseFloat(this.y/KB);
						    bytesInKB =roundNumber(bytesInKB ,2);

						   return '<b>'+ this.series.name +":"+'</b>'+bytesInKB+' KB/sec';
		             };

	
	 var chart = new Highcharts.Chart(options);

}
function plotPieChart(expandgraph)
{
    var options = new Object();
    options.chart = new Object();
	options.title = new Object();
	options.credits = new Object();
	options.credits.enabled = false;
	options.tooltip = new Object();
	options.title.text="";
	options.chart.renderTo = 'container1';
	options.chart.align='center';
	if(expandgraph=="true")
		options.chart.renderTo = 'piecontainer';
     options.chart.type = 'pie';
 	options.chart.borderWidth = 1;
	options.chart.plotShadow=true;
	options.legend = new Object();
	options.legend.borderWidth=1;

    options.plotOptions=new Object();
    options.plotOptions.pie=new Object();
    options.plotOptions.pie.allowPointSelect=true;
    options.plotOptions.pie.cursor='pointer';
	
    options.legend.layout='vertical';
    options.legend.align='right';
    options.legend.verticalAlign='top';
    options.plotOptions.pie.showInLegend=true;
    options.plotOptions.pie.dataLabels=new Object();
    options.plotOptions.pie.dataLabels.enabled=false;
	options.plotOptions.pie.dataLabels.formatter=function() {
                            return '<b>'+ this.point.name +'</b>: '+'<br/>'+ Highcharts.numberFormat(this.percentage) +' %';
                        }
;
	options.plotOptions.pie.events=new Object();
	 options.series = new Array();
	 options.series.type = 'pie';
	 options.series = new Array();
	 options.series.data = new Array();
   
	options.series[0] = new Object();
	options.series[1] = new Object();
	options.series[0].data = new Array();
	options.series[1].data = new Array();
	
	for (var entry = 0; entry < (legendEntry_Pie.length); entry++) 
	{
		if(diskEntry[entry] != null)
		{
				var percentageval=roundNumber((parseFloat(diskEntry[entry].disk_entry)*100),2);
				var valueInGB=parseFloat((diskEntry[entry].disk_entry*totalcachepoolsize)/GigaBytes);
				
				if(valueInGB < 1)
					valueInGB= roundNumber(valueInGB,6);
				else
						 valueInGB= roundNumber(valueInGB,2);

				var legendName="<b>"+legendEntry_Pie[entry].legend_entry+":"+"</b>"+" "+valueInGB +"GiB";
				
				options.series[0].data.push( [legendName, parseFloat(diskEntry[entry].disk_entry)]); 
			 
				options.tooltip.formatter=function() {
						var valueInGB=parseFloat((this.point.y*totalcachepoolsize)/GigaBytes);
						if(valueInGB < 1)
							valueInGB= roundNumber(valueInGB,6);
						else
						 valueInGB= roundNumber(valueInGB,2);
							return '<b>'+ this.point.name +'</b>';//+ valueInGB+"GB";//+Highcharts.numberFormat(this.percentage, 1) +' %';
						}
		}
		
	   }

	var chart = new Highcharts.Chart(options);
  
 }
 


