﻿var tree = parent.treelist.tree;
function select_treenode(module) {
  expandall();
  parent.treelist.f_select(module, '', '');
}
function expandall() {
  for (var i = 0; i < tree.length; i++) {
    if (tree[i].Expandable == 'true') {
      if (!parent.treelist.f_expanded(tree[i].Index)) parent.treelist.f_expand(tree[i].Index);
    }
  }
}
function createTableHeader() {
  var html = '<table class="container autolayout">';
  html += '<thead><tr><td class="topleft"></td>';
  html += '<td class="top width50">Component</td>';
  html += '<td class="top">Status</td>';
  html += '<td class="topright"></td></tr>';
  html += '<tr><td class="left"></td><td class="instructions" colspan="2">';
  html += '<span>Instructions:</span> Click the component to view its details.';
  html += '</td><td class="right"></td></tr></thead><tbody><tr><td class="left"></td><td colspan="2"><div style="padding:8px;"><table class="infolist">';
  return html;
}
function createTableFooter() {
  var html = '</table></div></td><td class="right"></td></tr></tbody><tfoot><tr>';
  html += '<td class="bottomleft"></td>';
  html += '<td class="bottom" colspan="2"></td>';
  html += '<td class="bottomright"></td></tr></tfoot></table>';
  return html;
}
function createTable(treenode, div) {
  var html = createTableHeader();
  var framework = getFirstandLastinTree(treenode);
  var startpos = framework[0];
  var lastpos = framework[1];
  for (var i = startpos; i <= lastpos; i++) {
    html += '<tr>';
    html += '<td class="item"><span>';
    html += '<a href="javascript:select_treenode(\'' + tree[i].Index + '\');">' + tree[i].Text + '</a></span></td>';
    html += '<td class="desc"><span>' + tree[i].Status + '</span></td>';
    html += '</tr>';
  }
  html += createTableFooter();
  //alert(html);
  div.innerHTML = html;
}
function getFirstandLastinTree(name) {
  var lastindex;
  var startpos;
  var lastpos;
  for (var i = 0; i < tree.length; i++) {
    if (tree[i].Text == name) {
      lastindex = tree[i].LastChild;
      startpos = i + 1;
    }
    if (lastindex != 'undefined' && tree[i].Index == lastindex) {
      lastpos = i;
      return [startpos, lastpos];
    }
  }
}
function fillContentTable() {
  var controldiv = document.getElementById("contenttable");
  createTable('Content', controldiv);
}

function fillFrameworkTable() {
  var frameworkdiv = document.getElementById("frameworktable");
  createTable('Framework', frameworkdiv);
}
function fillExampleTable() {
  var examplediv = document.getElementById("exampletable");
  createTable('Unique Examples', examplediv);
}
