//-------------------------------------------------------------------------
//
//          DELL INC. PROPRIETARY INFORMATION
//
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Dell Computer Corporation and may not
//  be copied or disclosed except in accordance with the terms of that
//  agreement.
//
//  Copyright (c) 1995-2008 Dell Inc. All Rights Reserved.
// 
//  Abstract/Purpose:
//	Common Utility functions
//
//  Environment:
//    Windows, Linux
//
//  Created/Version:
//    2008 Jan 10 / $Revision: $
//
//  Author:
//   Mahaveer M
//
//  Last Modified By/On:
//    $Author: $ / $Date: $
//
//-------------------------------------------------------------------------

// NOTE : ENSURE FILE SIZE IS NOT LARGE TO AVOID ANY PERFORMANCE ISSUES
var g_WattBTUConversion=3.413;

// convert Watt to BTU/hr
function convertFromWattToBTUhr(wattValue)
{
    var btuVal = Math.round(wattValue * g_WattBTUConversion);
    return btuVal;
}

// convert BTU/hr to Watt
function convertFromBTUhrToWatt(btuhrValue)
{
    var wattVal = Math.round(btuhrValue / g_WattBTUConversion);
    return wattVal;
}

// checks if the value is a non-number and remove it
function validateAndAllowNumbers(component)
{
    var value = component.value;
    for (var i = 0; i < value.length; i++)
    {
      var testChar = value.charAt(i);
      if ( isNaN(testChar) == true)
      {
        var valueArray = value.split(value.charAt(i));
        document.getElementById(component.name).value = valueArray[0].concat(valueArray[1]);
        return;
      }
    }
}
