﻿var popUp = {
  initialize: function () {
    popUp.setHeight();
    addEvent.add(window, "scroll", function () { popUp.setHeight(); });
    addEvent.add(window, "resize", function () { popUp.setHeight(); });
  },
  setHeight: function () {
    var viewheight = document.documentElement.clientHeight;
    var popupoverflow = document.getElementById('popup_overflow');
    if (popupoverflow) {
      var offset = popUp.findPos(popupoverflow)[1];
      popupoverflow.style.height = viewheight - offset + 'px';
    }
  },
  findPos: function (obj) {
    var curleft = curtop = 0;
    if (obj.offsetParent) {
      do {
        curleft += obj.offsetLeft;
        curtop += obj.offsetTop;
      } while (obj = obj.offsetParent);
      return [curleft, curtop];
    }
  },
  openWindow: function (url, windowtitle, popwidth, popheight) {
    if (windowtitle == null) {
      var windowtitle = 'popup';
    }
    if (popwidth == null) {
      popwidth = 700;
    }
    if (popheight == null) {
      popheight = 400;
    }
    if (url != null) {
      window.open(url, windowtitle, 'width=' + popwidth + ',height=' + popheight + ',toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,copyhistory=no,resizable=yes');
    }
  },
  closeWindow: function () {
    window.close();
  },
  scrolltoTop: function () {
    var popupoverflow = document.getElementById('popup_overflow');
    if (popupoverflow) { popupoverflow.scrollTop = 0; }
  }
};