#!/bin/bash

if [ "$1" == "" ]
then
	echo "usage is finddev -v/-q [FILENAME if -q]"
	exit 2
else if [ "$1" == "-q" ]
then
	if [ "$2" == "" ]
	then
		echo "usage is finddev -v/-q [FILENAME if -q]"
		exit 3	
	fi
fi
fi 

for i in `ls /sys/bus/scsi/devices`
do
		MODEL=`cat /sys/bus/scsi/devices/$i/model`
		STRIPMODEL=`echo $MODEL`
		if [ "$STRIPMODEL" == "Virtual CDROM" ]
		then
			if [ ! -e /sys/bus/scsi/devices/$i/scsi_generic ]
			then
				SGDEV=`ls -l /sys/bus/scsi/devices/$i/generic* | grep -o sg[0-9]*`
			else
				SGDEV=`ls -l /sys/bus/scsi/devices/$i/scsi_generic* | grep -o sg[0-9]*`
			fi
#			echo $SGDEV
			if [ $1 == -v ]
			then
			echo "SGDEVICE for Virtual CD is :" $SGDEV
			else
			echo $SGDEV > $2
			fi
			exit 0
		fi
done
exit 1
