#!/bin/sh

[ -e /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh ] || exit 0

source /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh
DCECFG=$(GetRegVal /opt/dell/srvadmin/etc/omreg.cfg OMDataEngine.configtool)
DCICFG=$(GetRegVal /opt/dell/srvadmin/etc/omreg.cfg Instrumentation.configtool)

if [ -z "$DCECFG" -o -z "$DCICFG" ]; then
    # data engine, isvc already uninstalled, no need to unreg
    exit 0
fi

# de-configure RAC's OM Data Populator
$DCECFG command=removepopalias aliasname=ral

# de-configure Storage Services OM and MIB Implementor
# $DCECFG command=removempialias aliasname=ssimp

# de-configure event logging
$DCECFG command=removeepialias aliasname=dcsipe

DCICFG_CODES="2050 2051 2060 2061 2070 2071 2080 2081 2090 2091 2100 2101"
for code in $DCICFG_CODES
do
    $DCICFG command=removelrarespconfig type=$code
done

